/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.View;
import java.beans.PropertyVetoException;
import java.util.List;

public class ExtendedView
extends View {
    private boolean extended = false;

    public ExtendedView(View base) {
        try {
            this.setExtending(base);
        }
        catch (PropertyVetoException e) {
            throw new Ili2cSemanticException(this.getSourceLine(), (Throwable)e);
        }
    }

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public boolean isExtended() {
        return this.extended;
    }

    @Override
    public void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) throws IllegalStateException {
        super.checkTranslationOf(errs, name, baseName);
        ExtendedView baseElement = (ExtendedView)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        if (this.isExtended() != baseElement.isExtended()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), ExtendedView.formatMessage("err_diff_mismatchInExtended", this.getScopedName(), baseElement.getScopedName())));
        }
        Ili2cSemanticException err = null;
        err = ExtendedView.checkElementRef(this.getExtending(), baseElement.getExtending(), this.getSourceLine(), "err_diff_baseViewMismatch");
        if (err != null) {
            errs.add(err);
        }
    }
}

