/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractPatternDef;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TranslatedElementNameComparator;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Topic
extends AbstractPatternDef<Element> {
    private boolean viewTopic = false;
    protected String name = "";
    private Domain oid = null;
    private Domain basketOid = null;
    private ArrayList<Domain> deferredGenerics = new ArrayList();
    protected List<Topic> dependsOn = new LinkedList<Topic>();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getScopedName(Container<?> scope) {
        Model enclosingModel = (Model)this.getContainer(Model.class);
        if (enclosingModel == null) {
            return this.getName();
        }
        Model scopeModel = scope != null ? (Model)scope.getContainerOrSame(Model.class) : null;
        if (enclosingModel == scopeModel) {
            return this.getName();
        }
        return enclosingModel.getName() + "." + this.getName();
    }

    public String toString() {
        return "TOPIC " + this.getScopedName(null);
    }

    public void setName(String name) throws PropertyVetoException {
        String oldValue = this.name;
        String newValue = name;
        Topic.checkNameSanity(name, false);
        this.checkNameUniqueness(newValue, Topic.class, this.getRealExtending(), "err_topic_duplicateName");
        if (newValue.equals(oldValue)) {
            return;
        }
        this.fireVetoableChange("name", oldValue, newValue);
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    @Override
    public void setExtending(Element extending) throws PropertyVetoException {
        super.setExtending(extending);
    }

    public void makeDependentOn(Topic dependee) {
        if (dependee == this) {
            throw new IllegalArgumentException(Topic.formatMessage("err_topic_dependentOnSelf", this.toString()));
        }
        if (dependee == null) {
            throw new IllegalArgumentException();
        }
        this.dependsOn.add(dependee);
    }

    public Iterator<Topic> getDependentOn() {
        return this.dependsOn.iterator();
    }

    @Override
    public boolean isDependentOn(Element other) {
        if (other instanceof Topic && this.dependsOn.contains(other)) {
            return true;
        }
        return super.isDependentOn(other);
    }

    boolean containsConcreteExtensionOfTable(Table abstractTable) {
        for (Element element : this.getViewables()) {
            Table tab;
            if (!(element instanceof Table) || (tab = (Table)element).isAbstract() || !tab.isExtending(abstractTable)) continue;
            return true;
        }
        return false;
    }

    public void setViewTopic(boolean v) {
        this.viewTopic = v;
    }

    public boolean isViewTopic() {
        return this.viewTopic;
    }

    public void setOid(Domain type) {
        this.oid = type;
    }

    public Domain getOid() {
        return this.oid;
    }

    public void setBasketOid(Domain type) {
        this.basketOid = type;
    }

    public Domain getBasketOid() {
        return this.basketOid;
    }

    public void addDeferredGeneric(Domain generic) {
        this.deferredGenerics.add(generic);
    }

    public Domain[] getDefferedGenerics() {
        return this.deferredGenerics.toArray(new Domain[this.deferredGenerics.size()]);
    }

    @Override
    public void checkIntegrity(List<Ili2cSemanticException> errs) throws IllegalStateException {
        super.checkIntegrity(errs);
        this.checkIntegrityAbstract(errs);
    }

    private void checkIntegrityAbstract(List<Ili2cSemanticException> errs) {
        if (this.isAbstract()) {
            return;
        }
        for (Element element : this.getViewables()) {
            Table tab;
            if (!(element instanceof Table) || !(tab = (Table)element).isIdentifiable() || !tab.isAbstract() || this.containsConcreteExtensionOfTable(tab)) continue;
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Topic.formatMessage("err_topic_abstractElement", this.getScopedName(), tab.getName())));
        }
    }

    @Override
    public void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) throws IllegalStateException {
        super.checkTranslationOf(errs, name, baseName);
        Topic baseElement = (Topic)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        if (this.isAbstract() != baseElement.isAbstract()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Topic.formatMessage("err_diff_mismatchInAbstractness", this.getScopedName(), baseElement.getScopedName())));
        }
        if (this.isFinal() != baseElement.isFinal()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Topic.formatMessage("err_diff_mismatchInFinality", this.getScopedName(), baseElement.getScopedName())));
        }
        if (this.isViewTopic() != baseElement.isViewTopic()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Topic.formatMessage("err_diff_mismatchViewTopic", this.getScopedName(), baseElement.getScopedName())));
        }
        Ili2cSemanticException err = null;
        err = Topic.checkElementRef(this.getBasketOid(), baseElement.getBasketOid(), this.getSourceLine(), "err_diff_bidMismatch");
        if (err != null) {
            errs.add(err);
        }
        if ((err = Topic.checkElementRef(this.getOid(), baseElement.getOid(), this.getSourceLine(), "err_diff_oidMismatch")) != null) {
            errs.add(err);
        }
        if ((err = Topic.checkElementRef(this.getExtending(), baseElement.getExtending(), this.getSourceLine(), "err_diff_baseTopicMismatch")) != null) {
            errs.add(err);
        }
        if (this.dependsOn.size() != baseElement.dependsOn.size()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Topic.formatMessage("err_diff_dependencyTopicMismatch")));
        }
        ArrayList<Topic> depTopics = new ArrayList<Topic>(this.dependsOn);
        Collections.sort(depTopics, new TranslatedElementNameComparator());
        ArrayList<Topic> baseDepTopics = new ArrayList<Topic>(baseElement.dependsOn);
        Collections.sort(baseDepTopics, new TranslatedElementNameComparator());
        for (int depi = 0; depi < depTopics.size(); ++depi) {
            Topic baseDep;
            Topic dep = depTopics.get(depi);
            err = Topic.checkElementRef(dep, baseDep = baseDepTopics.get(depi), this.getSourceLine(), "err_diff_dependencyTopicMismatch");
            if (err == null) continue;
            errs.add(err);
        }
    }
}

