/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Type;
import java.beans.PropertyVetoException;
import java.util.List;

public class LocalAttribute
extends AttributeDef {
    protected Evaluable[] basePaths;
    private boolean subdivision = false;
    private boolean continuous = false;
    private boolean generatedByAllOf = false;
    private boolean typeProxy = false;

    @Override
    public void setDomain(Type domain) throws PropertyVetoException {
        if (domain == null) {
            throw new IllegalArgumentException(rsrc.getString("err_nullNotAcceptable"));
        }
        super.setDomain(domain);
    }

    public void setBasePaths(Evaluable[] basePaths) {
        if (basePaths != null && this.domain != null) {
            for (int i = 0; i < basePaths.length; ++i) {
                Type typ = null;
                if (basePaths[i] != null) {
                    // empty if block
                }
                if (typ == null) continue;
                if (typ.isAbstract()) {
                    throw new IllegalArgumentException(LocalAttribute.formatMessage("err_projectionAttribute_abstractBase", this.toString(), basePaths[i].toString()));
                }
                typ.checkTypeExtension(this.domain);
            }
        }
        this.basePaths = basePaths;
    }

    public Evaluable[] getBasePaths() {
        return this.basePaths;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public boolean isSubdivision() {
        return this.subdivision;
    }

    public void setContinuous(boolean b) {
        this.continuous = b;
    }

    public void setSubdivision(boolean b) {
        this.subdivision = b;
    }

    public boolean isGeneratedByAllOf() {
        return this.generatedByAllOf;
    }

    public void setGeneratedByAllOf(boolean generatedByAllOf) {
        this.generatedByAllOf = generatedByAllOf;
    }

    public boolean isTypeProxy() {
        return this.typeProxy;
    }

    public void setTypeProxy(boolean typeProxy) {
        this.typeProxy = typeProxy;
    }

    @Override
    protected void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) {
        super.checkTranslationOf(errs, name, baseName);
        LocalAttribute baseElement = (LocalAttribute)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        if (this.isSubdivision() != baseElement.isSubdivision()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), LocalAttribute.formatMessage("err_diff_mismatchInSubdivision", this.getScopedName(), baseElement.getScopedName())));
        }
        if (this.isContinuous() != baseElement.isContinuous()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), LocalAttribute.formatMessage("err_diff_mismatchInContinuous", this.getScopedName(), baseElement.getScopedName())));
        }
    }
}

