/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NoOid;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.Viewable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class AbstractClassDef<E extends Element>
extends Viewable<E> {
    private Domain oid = null;
    private final Set<RoleDef> targetForRoles = new HashSet<RoleDef>(2);
    private final Set<RoleDef> nonNavigableTargetForRoles = new HashSet<RoleDef>(2);

    public void addTargetForRole(RoleDef role) {
        AssociationDef assoc = (AssociationDef)role.getContainer();
        AbstractClassDef targetClass = this;
        Iterator<Element> iter = assoc.getAttributesAndRoles();
        while (iter.hasNext()) {
            RoleDef otherRole;
            Element obj = iter.next();
            if (!(obj instanceof RoleDef) || (otherRole = (RoleDef)obj) == role) continue;
            Iterator<Element> attri = targetClass.getAttributesAndRoles();
            while (attri.hasNext()) {
                Element attrOrRole = attri.next();
                if (!attrOrRole.getName().equals(otherRole.getName())) continue;
                throw new Ili2cSemanticException(role.getSourceLine(), AbstractClassDef.formatMessage("err_abstractClassDef_nameConflictInOtherRoleTarget", otherRole.getName(), role.getName(), targetClass.getName()));
            }
            Iterator<RoleDef> rolei = targetClass.getOpposideRoles();
            while (rolei.hasNext()) {
                RoleDef otherRoleRoot;
                RoleDef targetClassOutgoingRole = rolei.next();
                RoleDef tragetClassOutgoingRoleRoot = targetClassOutgoingRole.getRootExtending();
                if (tragetClassOutgoingRoleRoot == null) {
                    tragetClassOutgoingRoleRoot = targetClassOutgoingRole;
                }
                if ((otherRoleRoot = otherRole.getRootExtending()) == null) {
                    otherRoleRoot = role;
                }
                if (!targetClassOutgoingRole.getName().equals(otherRole.getName()) || otherRoleRoot == tragetClassOutgoingRoleRoot) continue;
                throw new Ili2cSemanticException(role.getSourceLine(), AbstractClassDef.formatMessage("err_abstractClassDef_nameConflictInOtherRoleTarget", otherRole.getName(), role.getName(), targetClass.getName()));
            }
        }
        this.targetForRoles.add(role);
    }

    public Iterator<RoleDef> getDefinedTargetForRoles() {
        return this.targetForRoles.iterator();
    }

    public Iterator<RoleDef> getDefinedTargetForNonNavigableRoles() {
        return this.nonNavigableTargetForRoles.iterator();
    }

    public Iterator<RoleDef> getTargetForRoles() {
        LinkedList result = new LinkedList();
        HashMap<RoleDef, RoleDef> mostDerived = new HashMap<RoleDef, RoleDef>();
        for (AbstractClassDef v = this; v != null; v = (AbstractClassDef)v.getRealExtending()) {
            LinkedList attrsOfV_reversed = new LinkedList();
            Iterator<RoleDef> iter = v.getDefinedTargetForRoles();
            while (iter.hasNext()) {
                RoleDef role;
                Extendable leastDerived = role = iter.next();
                Extendable leastDerivedParent = null;
                while ((leastDerivedParent = (Extendable)((Object)leastDerived.getRealExtending())) != null) {
                    leastDerived = leastDerivedParent;
                }
                if (!mostDerived.containsKey(leastDerived)) {
                    mostDerived.put((RoleDef)leastDerived, role);
                }
                if (role != leastDerived) continue;
                attrsOfV_reversed.add(0, mostDerived.get(role));
            }
            Iterator attrsOfV_iter = attrsOfV_reversed.iterator();
            while (attrsOfV_iter.hasNext()) {
                result.add(0, attrsOfV_iter.next());
            }
        }
        return result.iterator();
    }

    public Iterator<RoleDef> getTargetForNonNavigableRoles() {
        LinkedList result = new LinkedList();
        HashMap<RoleDef, RoleDef> mostDerived = new HashMap<RoleDef, RoleDef>();
        for (AbstractClassDef v = this; v != null; v = (AbstractClassDef)v.getRealExtending()) {
            LinkedList attrsOfV_reversed = new LinkedList();
            Iterator<RoleDef> iter = v.getDefinedTargetForNonNavigableRoles();
            while (iter.hasNext()) {
                RoleDef role;
                Extendable leastDerived = role = iter.next();
                Extendable leastDerivedParent = null;
                while ((leastDerivedParent = (Extendable)((Object)leastDerived.getRealExtending())) != null) {
                    leastDerived = leastDerivedParent;
                }
                if (!mostDerived.containsKey(leastDerived)) {
                    mostDerived.put((RoleDef)leastDerived, role);
                }
                if (role != leastDerived) continue;
                attrsOfV_reversed.add(0, mostDerived.get(role));
            }
            Iterator attrsOfV_iter = attrsOfV_reversed.iterator();
            while (attrsOfV_iter.hasNext()) {
                result.add(0, attrsOfV_iter.next());
            }
        }
        return result.iterator();
    }

    public void addNonNavigableTargetForRole(RoleDef role) {
        this.nonNavigableTargetForRoles.add(role);
    }

    public Iterator<RoleDef> getOpposideRoles() {
        ArrayList<RoleDef> result = new ArrayList<RoleDef>();
        Iterator<RoleDef> rolei = this.getTargetForRoles();
        while (rolei.hasNext()) {
            RoleDef role = rolei.next();
            AssociationDef assoc = (AssociationDef)role.getContainer();
            Iterator<Element> iter = assoc.getAttributesAndRoles();
            while (iter.hasNext()) {
                Element oppRole = iter.next();
                if (!(oppRole instanceof RoleDef) || oppRole == role) continue;
                result.add((RoleDef)oppRole);
            }
        }
        return result.iterator();
    }

    public Iterator<RoleDef> getOpposideForNonNavigableRoles() {
        ArrayList<RoleDef> result = new ArrayList<RoleDef>();
        Iterator<RoleDef> rolei = this.getTargetForNonNavigableRoles();
        while (rolei.hasNext()) {
            RoleDef role = rolei.next();
            AssociationDef assoc = (AssociationDef)role.getContainer();
            Iterator<Element> iter = assoc.getAttributesAndRoles();
            while (iter.hasNext()) {
                Element oppRole = iter.next();
                if (!(oppRole instanceof RoleDef) || oppRole == role) continue;
                result.add((RoleDef)oppRole);
            }
        }
        return result.iterator();
    }

    public RoleDef findOpposideRole(Container context, String roleName) {
        RoleDef ret = this.findOpposideRole(roleName);
        if (ret != null) {
            return ret;
        }
        if (context instanceof Viewable) {
            context = context.getContainer();
        }
        if (!(context instanceof Topic) && !(context instanceof Model)) {
            throw new IllegalArgumentException("illegal context " + context.getScopedName());
        }
        Iterator<RoleDef> rolei = this.getTargetForNonNavigableRoles();
        while (rolei.hasNext()) {
            RoleDef role = rolei.next();
            AssociationDef assoc = (AssociationDef)role.getContainer();
            if (assoc.getContainer() != context && (!(context instanceof Extendable) || !((Extendable)((Object)context)).isExtending(assoc.getContainer()))) continue;
            Iterator<Element> iter = assoc.getAttributesAndRoles();
            while (iter.hasNext()) {
                Element oppRole = iter.next();
                if (!(oppRole instanceof RoleDef) || oppRole == role || !oppRole.getName().equals(roleName)) continue;
                return (RoleDef)oppRole;
            }
        }
        return null;
    }

    public RoleDef findOpposideRole(String roleName) {
        if (roleName == null) {
            return null;
        }
        Iterator<RoleDef> it = this.getOpposideRoles();
        while (it.hasNext()) {
            RoleDef e = it.next();
            if (!roleName.equals(e.getName())) continue;
            return e;
        }
        return null;
    }

    public List<RoleDef> getDefinedLightweightAssociations() {
        ArrayList<RoleDef> assocv = new ArrayList<RoleDef>();
        Iterator<RoleDef> it = this.getDefinedTargetForRoles();
        while (it.hasNext()) {
            RoleDef e = it.next();
            if (!e.isAssociationEmbedded() || e.isExtended()) continue;
            assocv.add(e);
        }
        return assocv;
    }

    public List<RoleDef> getLightweightAssociations() {
        ArrayList<RoleDef> assocv = new ArrayList<RoleDef>();
        Iterator<RoleDef> it = this.getTargetForRoles();
        while (it.hasNext()) {
            RoleDef e = it.next();
            if (!e.isAssociationEmbedded()) continue;
            assocv.add(e);
        }
        return assocv;
    }

    public Domain getOid() {
        for (AbstractClassDef def = this; def != null; def = (AbstractClassDef)def.getExtending()) {
            Topic topic;
            Domain oidDomain = def.getDefinedOid();
            if (oidDomain == null && (topic = (Topic)def.getContainer(Topic.class)) != null) {
                oidDomain = topic.getOid();
            }
            if (oidDomain == null || oidDomain instanceof NoOid) continue;
            return oidDomain;
        }
        return null;
    }

    public Domain getDefinedOid() {
        return this.oid;
    }

    public void setOid(Domain oid) {
        this.oid = oid;
    }

    @Override
    public void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) throws IllegalStateException {
        super.checkTranslationOf(errs, name, baseName);
        AbstractClassDef baseElement = (AbstractClassDef)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        if (this.isAbstract() != baseElement.isAbstract()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), AbstractClassDef.formatMessage("err_diff_mismatchInAbstractness", this.getScopedName(), baseElement.getScopedName())));
        }
        if (this.isFinal() != baseElement.isFinal()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), AbstractClassDef.formatMessage("err_diff_mismatchInFinality", this.getScopedName(), baseElement.getScopedName())));
        }
        Ili2cSemanticException err = null;
        err = AbstractClassDef.checkElementRef(this.getDefinedOid(), baseElement.getDefinedOid(), this.getSourceLine(), "err_diff_oidMismatch");
        if (err != null) {
            errs.add(err);
        }
        if ((err = AbstractClassDef.checkElementRef(this.getExtending(), baseElement.getExtending(), this.getSourceLine(), "err_diff_baseClassMismatch")) != null) {
            errs.add(err);
        }
    }
}

