/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.fromili;

import ch.ehi.ili2db.gui.Config;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.Viewable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ModelElementSelector {
    private TransferDescription td = null;
    private boolean createItfLineTables = false;
    private boolean includeEnums = false;

    public List<Element> getModelElements(List<String> modelNames, TransferDescription td, boolean createItfLineTables, boolean includeEnums, Config config) {
        this.td = td;
        this.createItfLineTables = createItfLineTables;
        this.includeEnums = includeEnums;
        ArrayList<Object> models = new ArrayList<Object>();
        if (modelNames == null || modelNames.isEmpty()) {
            Model lastModel = td.getLastModel();
            models.add(lastModel);
        } else {
            for (String modelName : modelNames) {
                Model model = (Model)td.getElement(Model.class, modelName);
                if (model == null) {
                    throw new IllegalArgumentException("unknown model <" + modelName + ">");
                }
                models.add(model);
            }
        }
        HashSet<Element> accu = new HashSet<Element>();
        HashSet<Model> accuScope = new HashSet<Model>();
        for (Model model : models) {
            if (!config.isVer3_translation() || config.getIli1Translation() != null) {
                this.visitModel(accu, accuScope, (Model)model.getTranslationOfOrSame());
                continue;
            }
            this.visitModel(accu, accuScope, model);
        }
        this.visitStructsInScope(accu, accuScope, config);
        ArrayList<Element> ret = new ArrayList<Element>(accu);
        Collections.sort(ret, new Comparator<Element>(){

            @Override
            public int compare(Element arg0, Element arg1) {
                if (arg0.getDefidx() < arg1.getDefidx()) {
                    return -1;
                }
                if (arg0.getDefidx() > arg1.getDefidx()) {
                    return 1;
                }
                return 0;
            }
        });
        return ret;
    }

    private void visitStructsInScope(HashSet<Element> accu, HashSet<Model> accuScope, Config config) {
        for (Model scope : accuScope) {
            if (!config.isVer3_translation() || config.getIli1Translation() != null) {
                scope = (Model)scope.getTranslationOfOrSame();
            }
            for (Object tObj : scope) {
                Table root;
                if (!(tObj instanceof Table) || ((Table)tObj).isIdentifiable() || (root = (Table)((Table)tObj).getRootExtending()) == null || !accu.contains(root)) continue;
                this.visitViewable(accu, accuScope, (Viewable)((Table)tObj));
            }
        }
    }

    private void visitModel(HashSet<Element> accu, HashSet<Model> accuScope, Model model) {
        if (model.equals(this.td.INTERLIS)) {
            this.visitDomain(accu, accuScope, this.td.INTERLIS.BOOLEAN);
            this.visitDomain(accu, accuScope, this.td.INTERLIS.HALIGNMENT);
            this.visitDomain(accu, accuScope, this.td.INTERLIS.VALIGNMENT);
            return;
        }
        for (Object tObj : model) {
            if (tObj instanceof Topic) {
                Topic topic = (Topic)tObj;
                this.visitTopic(accu, accuScope, topic);
                continue;
            }
            if (tObj instanceof Viewable) {
                this.visitViewable(accu, accuScope, (Viewable)tObj);
                continue;
            }
            if (!(tObj instanceof Domain)) continue;
            this.visitDomain(accu, accuScope, (Domain)tObj);
        }
    }

    private void visitTopic(HashSet<Element> visitedElements, HashSet<Model> accuScope, Topic def) {
        if (visitedElements.contains(def)) {
            return;
        }
        visitedElements.add((Element)def);
        for (Object classo : def) {
            if (classo instanceof Viewable) {
                this.visitViewable(visitedElements, accuScope, (Viewable)classo);
                continue;
            }
            if (!(classo instanceof Domain)) continue;
            this.visitDomain(visitedElements, accuScope, (Domain)classo);
        }
        Topic base = (Topic)def.getExtending();
        if (base != null) {
            this.visitTopic(visitedElements, accuScope, base);
        }
        Iterator depi = def.getDependentOn();
        while (depi.hasNext()) {
            Topic dep = (Topic)depi.next();
            this.visitTopic(visitedElements, accuScope, dep);
        }
        Model model = (Model)def.getContainer(Model.class);
        if (!accuScope.contains(model)) {
            accuScope.add(model);
        }
    }

    private void visitViewable(HashSet<Element> visitedElements, HashSet<Model> accuScope, Viewable def) {
        if (visitedElements.contains(def)) {
            return;
        }
        visitedElements.add((Element)def);
        for (Object attro : def) {
            AbstractClassDef targetClass;
            ReferenceType refType;
            if (attro instanceof AttributeDef) {
                AttributeDef attr = (AttributeDef)attro;
                Type type = attr.getDomain();
                if (type instanceof CompositionType) {
                    CompositionType compType = (CompositionType)type;
                    this.visitViewable(visitedElements, accuScope, (Viewable)compType.getComponentType());
                    Iterator resti = compType.iteratorRestrictedTo();
                    while (resti.hasNext()) {
                        Viewable rest = (Viewable)resti.next();
                        this.visitViewable(visitedElements, accuScope, rest);
                    }
                } else if (type instanceof ReferenceType) {
                    refType = (ReferenceType)type;
                    targetClass = refType.getReferred();
                    this.visitTopic(visitedElements, accuScope, (Topic)targetClass.getContainer(Topic.class));
                } else if (this.createItfLineTables && attr.getDomainResolvingAll() instanceof SurfaceOrAreaType) {
                    this.visitItfLineTable(visitedElements, accuScope, attr);
                } else if (this.includeEnums && attr.getDomainResolvingAll() instanceof EnumerationType) {
                    this.visitAttributeDef(visitedElements, accuScope, attr);
                }
                if (!(type instanceof TypeAlias)) continue;
                this.visitDomain(visitedElements, accuScope, ((TypeAlias)type).getAliasing());
                continue;
            }
            if (!(attro instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)attro;
            Iterator refTypeIt = role.iteratorReference();
            while (refTypeIt.hasNext()) {
                refType = (ReferenceType)refTypeIt.next();
                targetClass = refType.getReferred();
                this.visitTopic(visitedElements, accuScope, (Topic)targetClass.getContainer(Topic.class));
            }
        }
        Viewable base = (Viewable)def.getExtending();
        if (base != null) {
            this.visitViewable(visitedElements, accuScope, base);
        }
    }

    private void visitDomain(HashSet<Element> visitedElements, HashSet<Model> accuScope, Domain def) {
        Domain base;
        if (def == this.td.INTERLIS.BOOLEAN) {
            return;
        }
        if (visitedElements.contains(def)) {
            return;
        }
        visitedElements.add((Element)def);
        if (def.getType() instanceof TypeAlias) {
            this.visitDomain(visitedElements, accuScope, ((TypeAlias)def.getType()).getAliasing());
        }
        if ((base = def.getExtending()) != null) {
            this.visitDomain(visitedElements, accuScope, base);
        }
    }

    private void visitItfLineTable(HashSet<Element> visitedElements, HashSet<Model> accuScope, AttributeDef def) {
        if (visitedElements.contains(def)) {
            return;
        }
        visitedElements.add((Element)def);
    }

    private void visitAttributeDef(HashSet<Element> visitedElements, HashSet<Model> accuScope, AttributeDef def) {
        if (visitedElements.contains(def)) {
            return;
        }
        visitedElements.add((Element)def);
    }
}

