/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.ili2db.base.DbUrlConverter;
import ch.ehi.ili2db.base.Ili2db;
import ch.ehi.ili2db.base.TableBasedIdGen;
import ch.ehi.ili2db.gui.AbstractDbPanelDescriptor;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2db.gui.MainWizard;
import ch.ehi.ili2db.mapping.NameMapping;
import java.io.File;

public abstract class AbstractMain {
    private String version = null;

    public abstract String getAPP_NAME();

    public abstract String getDB_PRODUCT_NAME();

    public abstract String getJAR_NAME();

    public abstract AbstractDbPanelDescriptor getDbPanelDescriptor();

    protected abstract void printConnectOptions();

    protected abstract void printSpecificOptions();

    protected abstract int doArgs(String[] var1, int var2, Config var3);

    public void initConfig(Config config) {
        config.setSender(this.getAPP_NAME() + "-" + this.getVersion());
        config.setModeldir("%ILI_FROM_DB;%XTF_DIR;http://models.interlis.ch/;%JAR_DIR");
        config.setModels("%XTF");
        config.setDefaultSrsAuthority("EPSG");
        config.setMaxSqlNameLength(Integer.toString(NameMapping.DEFAULT_NAME_LENGTH));
        config.setIdGenerator(TableBasedIdGen.class.getName());
        config.setInheritanceTrafo("smart1");
        config.setCatalogueRefTrafo("coalesce");
        config.setMultiSurfaceTrafo("coalesce");
        config.setMultiLineTrafo("coalesce");
        config.setMultiPointTrafo("coalesce");
        config.setArrayTrafo("coalesce");
        config.setJsonTrafo("coalesce");
        config.setMultilingualTrafo("expand");
        config.setLocalisedTrafo("expand");
        config.setValidation(true);
    }

    protected abstract DbUrlConverter getDbUrlConverter();

    public void domain(String[] args) {
        int argi;
        Config config = new Config();
        this.initConfig(config);
        Settings settings = new Settings();
        config.setAppSettings(settings);
        if (args.length == 0) {
            Ili2db.readAppSettings(settings);
            MainWizard.main(config, this.getAPP_HOME(), this.getAPP_NAME(), this.getDbPanelDescriptor(), this.getDbUrlConverter());
            Ili2db.writeAppSettings(settings);
            return;
        }
        for (argi = 0; argi < args.length; ++argi) {
            String arg = args[argi];
            if (!arg.equals("--gui")) continue;
            Ili2db.readAppSettings(settings);
            break;
        }
        argi = 0;
        boolean doGui = false;
        while (argi < args.length) {
            while (argi < args.length) {
                int oldargi = argi;
                if ((argi = this.doArgs(args, argi, config)) != oldargi) continue;
                break;
            }
            if (argi >= args.length) break;
            String arg = args[argi];
            if (arg.equals("--modeldir")) {
                config.setModeldir(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--models")) {
                config.setModels(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--exportModels")) {
                config.setExportModels(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--exportCrsModels")) {
                config.setCrsExportModels(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--nameLang")) {
                config.setNameLanguage(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--dataset")) {
                config.setDatasetName(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--baskets")) {
                config.setBaskets(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--topics")) {
                config.setTopics(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--gui")) {
                doGui = true;
                ++argi;
                continue;
            }
            if (arg.equals("--validate")) {
                config.setFunction(8);
                ++argi;
                continue;
            }
            if (arg.equals("--import")) {
                config.setFunction(1);
                ++argi;
                continue;
            }
            if (arg.equals("--update")) {
                config.setFunction(4);
                ++argi;
                continue;
            }
            if (arg.equals("--delete")) {
                config.setFunction(5);
                ++argi;
                continue;
            }
            if (arg.equals("--replace")) {
                config.setFunction(6);
                ++argi;
                continue;
            }
            if (arg.equals("--export")) {
                config.setFunction(3);
                ++argi;
                continue;
            }
            if (arg.equals("--export3")) {
                config.setFunction(3);
                config.setVer3_export(true);
                ++argi;
                continue;
            }
            if (arg.equals("--schemaimport")) {
                config.setFunction(2);
                ++argi;
                continue;
            }
            if (arg.equals("--preScript")) {
                config.setPreScript(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--postScript")) {
                config.setPostScript(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--deleteData")) {
                ++argi;
                config.setDeleteMode("data");
                continue;
            }
            if (arg.equals("--trace")) {
                EhiLogger.getInstance().setTraceFilter(false);
                ++argi;
                continue;
            }
            if (arg.equals("--dbparams")) {
                config.setDbParams(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--dropscript")) {
                config.setDropscript(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--createscript")) {
                config.setCreatescript(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--log")) {
                config.setLogfile(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--xtflog")) {
                config.setXtfLogfile(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--defaultSrsAuth")) {
                String auth;
                if ((auth = args[++argi]).equalsIgnoreCase("NULL")) {
                    auth = null;
                }
                config.setDefaultSrsAuthority(auth);
                ++argi;
                continue;
            }
            if (arg.equals("--defaultSrsCode")) {
                config.setDefaultSrsCode(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--modelSrsCode")) {
                config.setModelSrsCode(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--multiSrs")) {
                ++argi;
                config.setUseEpsgInNames(true);
                continue;
            }
            if (arg.equals("--domains")) {
                config.setDomainAssignments(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--altSrsModel")) {
                config.setSrsModelAssignment(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--attachmentsPath")) {
                config.setAttachmentsPath(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--validConfig")) {
                config.setValidConfigFile(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--disableValidation")) {
                ++argi;
                config.setValidation(false);
                continue;
            }
            if (arg.equals("--disableAreaValidation")) {
                ++argi;
                config.setDisableAreaValidation(true);
                continue;
            }
            if (arg.equals("--disableRounding")) {
                ++argi;
                config.setDisableRounding(true);
                continue;
            }
            if (arg.equals("--forceTypeValidation")) {
                ++argi;
                config.setOnlyMultiplicityReduction(true);
                continue;
            }
            if (arg.equals("--createSingleEnumTab")) {
                ++argi;
                config.setCreateEnumDefs("singleTable");
                continue;
            }
            if (arg.equals("--createEnumTabs")) {
                ++argi;
                config.setCreateEnumDefs("multiTable");
                continue;
            }
            if (arg.equals("--createEnumTabsWithId")) {
                ++argi;
                config.setCreateEnumDefs("multiTableWithId");
                continue;
            }
            if (arg.equals("--createEnumTxtCol")) {
                ++argi;
                config.setCreateEnumCols("addTxtCol");
                continue;
            }
            if (arg.equals("--createEnumColAsItfCode")) {
                ++argi;
                config.setValue("ch.ehi.ili2db.createEnumColAsItfCode", "yes");
                continue;
            }
            if (arg.equals("--beautifyEnumDispName")) {
                ++argi;
                config.setBeautifyEnumDispName("underscore");
                continue;
            }
            if (arg.equals("--noSmartMapping")) {
                ++argi;
                Ili2db.setNoSmartMapping(config);
                continue;
            }
            if (arg.equals("--smart1Inheritance")) {
                ++argi;
                config.setInheritanceTrafo("smart1");
                continue;
            }
            if (arg.equals("--smart2Inheritance")) {
                ++argi;
                config.setInheritanceTrafo("smart2");
                continue;
            }
            if (arg.equals("--coalesceCatalogueRef")) {
                ++argi;
                config.setCatalogueRefTrafo("coalesce");
                continue;
            }
            if (arg.equals("--coalesceMultiSurface")) {
                ++argi;
                config.setMultiSurfaceTrafo("coalesce");
                continue;
            }
            if (arg.equals("--coalesceMultiLine")) {
                ++argi;
                config.setMultiLineTrafo("coalesce");
                continue;
            }
            if (arg.equals("--coalesceMultiPoint")) {
                ++argi;
                config.setMultiPointTrafo("coalesce");
                continue;
            }
            if (arg.equals("--coalesceArray")) {
                ++argi;
                config.setArrayTrafo("coalesce");
                continue;
            }
            if (arg.equals("--coalesceJson")) {
                ++argi;
                config.setJsonTrafo("coalesce");
                continue;
            }
            if (arg.equals("--expandMultilingual")) {
                ++argi;
                config.setMultilingualTrafo("expand");
                continue;
            }
            if (arg.equals("--expandLocalised")) {
                ++argi;
                config.setLocalisedTrafo("expand");
                continue;
            }
            if (arg.equals("--createFk")) {
                ++argi;
                config.setCreateFk("yes");
                continue;
            }
            if (arg.equals("--createFkIdx")) {
                ++argi;
                config.setCreateFkIdx("yes");
                continue;
            }
            if (arg.equals("--createUnique")) {
                ++argi;
                config.setCreateUniqueConstraints(true);
                continue;
            }
            if (arg.equals("--createNumChecks")) {
                ++argi;
                config.setCreateNumChecks(true);
                continue;
            }
            if (arg.equals("--createTextChecks")) {
                ++argi;
                config.setCreateTextChecks(true);
                continue;
            }
            if (arg.equals("--createDateTimeChecks")) {
                ++argi;
                config.setCreateDateTimeChecks(true);
                continue;
            }
            if (arg.equals("--createImportTabs")) {
                ++argi;
                config.setCreateImportTabs(true);
                continue;
            }
            if (arg.equals("--createStdCols")) {
                ++argi;
                config.setCreateStdCols("all");
                continue;
            }
            if (arg.equals("--t_id_Name")) {
                config.setColT_ID(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--idSeqMin")) {
                config.setMinIdSeqValue(Long.parseLong(args[++argi]));
                ++argi;
                continue;
            }
            if (arg.equals("--idSeqMax")) {
                config.setMaxIdSeqValue(Long.parseLong(args[++argi]));
                ++argi;
                continue;
            }
            if (arg.equals("--createTypeDiscriminator")) {
                ++argi;
                config.setCreateTypeDiscriminator("always");
                continue;
            }
            if (arg.equals("--createGeomIdx")) {
                ++argi;
                config.setValue("ch.ehi.sqlgen.createGeomIndex", "True");
                continue;
            }
            if (arg.equals("--disableNameOptimization")) {
                ++argi;
                config.setNameOptimization("disable");
                continue;
            }
            if (arg.equals("--nameByTopic")) {
                ++argi;
                config.setNameOptimization("topic");
                continue;
            }
            if (arg.equals("--maxNameLength")) {
                config.setMaxSqlNameLength(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--structWithGenericRef")) {
                ++argi;
                config.setStructMapping("genericRef");
                continue;
            }
            if (arg.equals("--sqlEnableNull")) {
                ++argi;
                config.setSqlNull("enable");
                continue;
            }
            if (arg.equals("--strokeArcs")) {
                ++argi;
                Config.setStrokeArcs(config, "enable");
                continue;
            }
            if (arg.equals("--skipPolygonBuilding")) {
                ++argi;
                Ili2db.setSkipPolygonBuilding(config);
                continue;
            }
            if (arg.equals("--skipPolygonBuildingErrors")) {
                ++argi;
                config.setSkipGeometryErrors(true);
                continue;
            }
            if (arg.equals("--skipReferenceErrors")) {
                ++argi;
                config.setSkipReferenceErrors(true);
                continue;
            }
            if (arg.equals("--skipGeometryErrors")) {
                ++argi;
                config.setSkipGeometryErrors(true);
                continue;
            }
            if (arg.equals("--keepAreaRef")) {
                ++argi;
                config.setAreaRef("keep");
                continue;
            }
            if (arg.equals("--createTidCol")) {
                ++argi;
                config.setTidHandling("property");
                continue;
            }
            if (arg.equals("--importTid")) {
                ++argi;
                config.setImportTid(true);
                continue;
            }
            if (arg.equals("--exportTid")) {
                ++argi;
                config.setExportTid(true);
                continue;
            }
            if (arg.equals("--importBid")) {
                ++argi;
                config.setImportBid(true);
                continue;
            }
            if (arg.equals("--createBasketCol")) {
                ++argi;
                config.setBasketHandling("readWrite");
                continue;
            }
            if (arg.equals("--createDatasetCol")) {
                ++argi;
                config.setCreateDatasetCols("addDatasetCol");
                continue;
            }
            if (arg.equals("--ILIGML20")) {
                ++argi;
                config.setTransferFileFormat("ILIGML20");
                continue;
            }
            if (arg.equals("--ver4-noSchemaImport")) {
                ++argi;
                config.setDoImplicitSchemaImport(false);
                EhiLogger.logAdaption((String)"--ver4-noSchemaImport is a deprecated option");
                continue;
            }
            if (arg.equals("--doSchemaImport")) {
                ++argi;
                config.setDoImplicitSchemaImport(true);
                continue;
            }
            if (arg.equals("--ver4-translation")) {
                ++argi;
                config.setVer3_translation(false);
                EhiLogger.logAdaption((String)"--ver4-translation is a deprecated option");
                continue;
            }
            if (arg.equals("--ver3-translation")) {
                ++argi;
                config.setVer3_translation(true);
                continue;
            }
            if (arg.equals("--translation")) {
                config.setIli1Translation(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--proxy")) {
                config.setValue("ch.interlis.ili2c.http_proxy_host", args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--proxyPort")) {
                config.setValue("ch.interlis.ili2c.http_proxy_port", args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--createMetaInfo")) {
                ++argi;
                config.setCreateMetaInfo(true);
                continue;
            }
            if (arg.equals("--version")) {
                this.printVersion();
                return;
            }
            if (arg.equals("--iliMetaAttrs")) {
                config.setIliMetaAttrsFile(args[++argi]);
                ++argi;
                continue;
            }
            if (arg.equals("--createTypeConstraint")) {
                ++argi;
                config.setCreateTypeConstraint(true);
                continue;
            }
            if (arg.equals("--help")) {
                this.printVersion();
                System.err.println();
                this.printDescription();
                System.err.println();
                this.printUsage();
                System.err.println();
                System.err.println("OPTIONS");
                System.err.println();
                System.err.println("--import               do an import.");
                System.err.println("--update               do an update.");
                System.err.println("--replace              do a replace.");
                System.err.println("--delete               do a delete.");
                System.err.println("--export               do an export.");
                System.err.println("--schemaimport         do an schema import.");
                System.err.println("--preScript file       before running a function, run a script.");
                System.err.println("--postScript file      after running a function, run a script.");
                System.err.println("--dbparams file        config file with connection parameters.");
                this.printConnectOptions();
                System.err.println("--validConfig file     Config file for validation.");
                System.err.println("--disableValidation    Disable validation of data.");
                System.err.println("--disableAreaValidation Disable AREA validation.");
                System.err.println("--forceTypeValidation  restrict customization of validation related to \"multiplicity\"");
                System.err.println("--disableRounding      Disable rounding of import/export data.");
                System.err.println("--deleteData           on schema/data import, delete existing data from existing tables.");
                System.err.println("--defaultSrsAuth  auth Default SRS authority " + config.getDefaultSrsAuthority());
                System.err.println("--defaultSrsCode  code Default SRS code");
                System.err.println("--modelSrsCode  model=code SRS code per model");
                System.err.println("--multiSrs             create a DB schema that supports multiple SRS codes");
                System.err.println("--domains genericDomain=concreteDomain overrides the generic domain assignments on export");
                System.err.println("--altSrsModel originalSrsModel=alternativeSrsModel assigns a model with an alternative SRS (but same structure as orinal model)");
                System.err.println("--modeldir  path       Path(s) of directories containing ili-files.");
                System.err.println("--models modelname     Name(s) of ili-models to generate an db schema for.");
                System.err.println("--dataset name         Name of dataset.");
                System.err.println("--baskets BID          Basket-Id(s) of ili-baskets to export.");
                System.err.println("--topics topicname     Name(s) of ili-topics to export.");
                System.err.println("--createscript filename  Generate a sql script that creates the db schema.");
                System.err.println("--dropscript filename  Generate a sql script that drops the generated db schema.");
                System.err.println("--noSmartMapping       disable all smart mappings");
                System.err.println("--smart1Inheritance     enable smart1 mapping of class/structure inheritance");
                System.err.println("--smart2Inheritance     enable smart2 mapping of class/structure inheritance");
                System.err.println("--coalesceCatalogueRef enable smart mapping of CHBase:CatalogueReference");
                System.err.println("--coalesceMultiSurface enable smart mapping of CHBase:MultiSurface");
                System.err.println("--coalesceMultiLine    enable smart mapping of CHBase:MultiLine");
                System.err.println("--coalesceMultiPoint   enable smart mapping of MultiPoint structures");
                System.err.println("--coalesceArray        enable smart mapping of ARRAY structures");
                System.err.println("--coalesceJson         enable smart mapping of JSON structures");
                System.err.println("--expandMultilingual   enable smart mapping of CHBase:MultilingualText");
                System.err.println("--expandLocalised      enable smart mapping of CHBase:LocalisedText");
                System.err.println("--createGeomIdx        create a spatial index on geometry columns.");
                System.err.println("--createEnumColAsItfCode create enum type column with value according to ITF (instead of XTF).");
                System.err.println("--createEnumTxtCol     create an additional column with the text of the enumeration value.");
                System.err.println("--createEnumTabs       generate tables for enum definitions and use xtfcode to reference entries in generated enum tables.");
                System.err.println("--createEnumTabsWithId generate tables with T_Id for enum definitions and use ids to reference entries in generated enum tables.");
                System.err.println("--createSingleEnumTab  generate all enum definitions in a single table.");
                System.err.println("--beautifyEnumDispName replace underscore with space in dispName of enum table entries");
                System.err.println("--createStdCols        generate T_User, T_CreateDate, T_LastChange columns.");
                System.err.println("--t_id_Name name       change name of t_id column (T_Id)");
                System.err.println("--idSeqMin minValue    sets the minimum value of the id sequence generator.");
                System.err.println("--idSeqMax maxValue    sets the maximum value of the id sequence generator.");
                System.err.println("--createTypeDiscriminator  generate always a type discriminator column.");
                System.err.println("--structWithGenericRef  generate one generic reference to parent in struct tables.");
                System.err.println("--disableNameOptimization disable use of unqualified class name as table name.");
                System.err.println("--nameByTopic          use topic+class name as table name.");
                System.err.println("--nameLang lang        use names of ili model in given language as table/column name.");
                System.err.println("--maxNameLength length max length of sql names (" + config.getMaxSqlNameLength() + ")");
                System.err.println("--sqlEnableNull        create no NOT NULL constraints in db schema.");
                System.err.println("--strokeArcs           stroke ARCS on import.");
                System.err.println("--skipPolygonBuilding  keep linetables; don't build polygons on import.");
                System.err.println("--skipReferenceErrors  ignore/do not report reference errors.");
                System.err.println("--skipGeometryErrors   ignore/do not report geometry errors.");
                System.err.println("--keepAreaRef          keep arreaRef as additional column on import.");
                System.err.println("--createTidCol         create an additional column T_Ili_Tid");
                System.err.println("--importTid            read transient TIDs into column T_Ili_Tid");
                System.err.println("--exportTid            write transient TIDs from column T_Ili_Tid");
                System.err.println("--importBid            read transient BIDs into T_ILI2DB_BASKET.T_Ili_Tid");
                System.err.println("--createImportTabs     create tables with import statistics. (T_ILI2DB_IMPORT)");
                System.err.println("--createBasketCol      generate T_basket column.");
                System.err.println("--createDatasetCol     generate T_datasetname column (Requires --dataset)");
                System.err.println("--createFk             generate foreign key constraints.");
                System.err.println("--createFkIdx          create an index on foreign key columns.");
                System.err.println("--createUnique         create UNIQUE db constraints.");
                System.err.println("--createNumChecks      create CHECK db constraints for numeric data types.");
                System.err.println("--createTextChecks     create CHECK db constraints for text data types.");
                System.err.println("--createDateTimeChecks create CHECK db constraints for date/time data types.");
                System.err.println("--ILIGML20             use eCH-0118-2.0 as transferformat");
                System.err.println("--exportModels modelname  export data according to the given base ili-models");
                System.err.println("--exportCrsModels modelname  export data according to the given ili-model (with alternate CRS)");
                System.err.println("--ver4-noSchemaImport  do no implicit schema import during data import");
                System.err.println("--doSchemaImport       do implicit schema import during data import");
                System.err.println("--ver4-translation     supports TRANSLATION OF in ili2db 4.x mode (incompatible with ili2db 3.x versions).");
                System.err.println("--ver3-translation     supports TRANSLATION OF in ili2db 3.x mode (incompatible with ili2db 4.x versions).");
                System.err.println("--translation translatedModel=originModel assigns a translated model to its orginal language equivalent.");
                System.err.println("--createMetaInfo       Create aditional ili-model information.");
                System.err.println("--iliMetaAttrs file    Import meta-attributes from a .toml file (Requires --createMetaInfo)");
                System.err.println("--createTypeConstraints   Create CHECK constraint on t_type columns.");
                this.printSpecificOptions();
                System.err.println("--proxy host           proxy server to access model repositories.");
                System.err.println("--proxyPort port       proxy port to access model repositories.");
                System.err.println("--log filename         log messages to given file.");
                System.err.println("--xtflog filename      log messages to given XTF file.");
                System.err.println("--gui                  start GUI.");
                System.err.println("--trace                enable trace messages.");
                System.err.println("--help                 Display this help text.");
                System.err.println("--version              Display the version of " + this.getAPP_NAME());
                System.err.println();
                return;
            }
            if (arg.startsWith("-")) {
                EhiLogger.logError((String)(arg + ": unknown option"));
                System.exit(1);
                continue;
            }
            if (argi + 1 >= args.length) break;
            EhiLogger.logError((String)(arg + ": invalid placed argument"));
            System.exit(1);
        }
        if (config.getFunction() == 0 && (config.getCreatescript() != null || config.getDropscript() != null)) {
            config.setFunction(7);
        }
        if (argi + 1 == args.length) {
            String xtfFilename = args[argi];
            config.setXtffile(xtfFilename);
            if (Ili2db.isItfFilename(xtfFilename)) {
                config.setItfTransferfile(true);
            }
        }
        if (doGui) {
            MainWizard.main(config, this.getAPP_HOME(), this.getAPP_NAME(), this.getDbPanelDescriptor(), this.getDbUrlConverter());
            Ili2db.writeAppSettings(settings);
        } else {
            if (config.getFunction() != 7) {
                config.setDburl(this.getDbUrlConverter().makeUrl(config));
            }
            try {
                if (config.getFunction() != 7) {
                    Ili2db.readSettingsFromDb(config);
                }
                Ili2db.run(config, this.getAPP_HOME());
            }
            catch (Exception ex) {
                EhiLogger.logError((Throwable)ex);
                System.exit(1);
            }
        }
    }

    private void printVersion() {
        System.err.println("INTERLIS 2-loader for " + this.getDB_PRODUCT_NAME() + ", Version " + this.getVersion());
        System.err.println("  Developed by Eisenhut Informatik AG, CH-3401 Burgdorf");
        System.err.println("  See http://www.interlis.ch for information about INTERLIS");
        System.err.println("  Parts of this program have been generated by ANTLR; see http://www.antlr.org");
        System.err.println("  This product includes software developed by the");
        System.err.println("  Apache Software Foundation (http://www.apache.org/).");
    }

    private void printDescription() {
        System.err.println("DESCRIPTION");
        System.err.println("  Translates INTERLIS 2 data model definitions to a " + this.getDB_PRODUCT_NAME() + " schema.");
        System.err.println("  Loads INTERLIS 2 data into a " + this.getDB_PRODUCT_NAME() + " database.");
        System.err.println("  Unloads INTERLIS 2 data from a " + this.getDB_PRODUCT_NAME() + " database.");
    }

    private void printUsage() {
        System.err.println("USAGE");
        System.err.println("  java -jar " + this.getJAR_NAME() + " [Options] [file.xtf]");
    }

    public String getVersion() {
        if (this.version == null) {
            java.util.ResourceBundle resVersion = java.util.ResourceBundle.getBundle(ResourceBundle.class2qpackageName(AbstractMain.class) + ".Version");
            StringBuffer ret = new StringBuffer(20);
            ret.append(resVersion.getString("version"));
            ret.append('-');
            ret.append(resVersion.getString("versionCommit"));
            this.version = ret.toString();
        }
        return this.version;
    }

    public String getAPP_HOME() {
        int start;
        String classpath = System.getProperty("java.class.path");
        int index = classpath.toLowerCase().indexOf(this.getJAR_NAME());
        if (index > (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            return classpath.substring(start, index - 1);
        }
        return null;
    }
}

