/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.logging;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.LogEvent;
import ch.ehi.basics.logging.LogListener;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;

public abstract class AbstractStdListener
implements LogListener {
    private boolean errors = false;

    @Override
    public void logEvent(LogEvent event) {
        if (event.getEventKind() == 7) {
            this.errors = true;
        }
        if (this.skipEvent(event)) {
            return;
        }
        ArrayList msgv = AbstractStdListener.formatOutput(event, true, !EhiLogger.getInstance().getTraceFilter());
        this.outputEvent(event, msgv);
    }

    public void outputEvent(LogEvent event, ArrayList msgv) {
        String msgTag = this.getMessageTag(event);
        msgTag = msgTag == null ? "" : msgTag + ": ";
        String msgTimestamp = this.getTimestamp();
        msgTimestamp = msgTimestamp == null ? "" : msgTimestamp + ": ";
        for (String msg : msgv) {
            this.outputMsgLine(event.getEventKind(), event.getCustomLevel(), msgTimestamp + msgTag + msg);
        }
    }

    public boolean skipEvent(LogEvent event) {
        return false;
    }

    public abstract void outputMsgLine(int var1, int var2, String var3);

    public String getMessageTag(LogEvent event) {
        return event.getEventKind() == 7 ? null : "Info";
    }

    public String getTimestamp() {
        return null;
    }

    public static String fmtOriginMsg(StackTraceElement st, String msg) {
        StringBuffer ret = new StringBuffer();
        ret.append(st.getMethodName());
        ret.append("(): ");
        ret.append(msg);
        ret.append(" (");
        String filename = st.getFileName();
        if (filename != null) {
            ret.append(filename);
            int line = st.getLineNumber();
            if (line >= 0) {
                ret.append(":");
                ret.append(Integer.toString(line));
            }
        } else {
            ret.append(st.getClassName());
        }
        ret.append(")");
        return ret.toString();
    }

    public static ArrayList formatOutput(LogEvent event, boolean doOrigin, boolean doStacktrace) {
        Throwable ex;
        ArrayList<String> out = new ArrayList<String>();
        String msg = event.getEventMsg();
        if (msg != null && (msg = msg.trim()).length() == 0) {
            msg = null;
        }
        String sep = "";
        if (msg != null) {
            StackTraceElement origin;
            int kind;
            if (doOrigin && ((kind = event.getEventKind()) == 1 || kind == 2 || kind == 3 || kind == 4) && (origin = event.getOrigin()) != null) {
                msg = AbstractStdListener.fmtOriginMsg(origin, msg);
            }
            out.add(msg);
            sep = "  ";
        }
        if ((ex = event.getException()) != null) {
            AbstractStdListener.logThrowable(out, sep, ex, doStacktrace);
        }
        return out;
    }

    private static void logThrowable(ArrayList out, String ind, Throwable ex, boolean doStacktrace) {
        SQLException exTarget;
        Throwable exTarget2;
        Throwable ex2;
        String msg = ex.getLocalizedMessage();
        if (msg != null && (msg = msg.trim()).length() == 0) {
            msg = null;
        }
        if (msg == null) {
            msg = ex.getClass().getName();
        }
        out.add(ind + msg);
        if (doStacktrace) {
            StackTraceElement[] stackv = ex.getStackTrace();
            for (int i = 0; i < stackv.length; ++i) {
                out.add(ind + "    " + stackv[i].toString());
            }
        }
        if ((ex2 = ex.getCause()) != null) {
            AbstractStdListener.logThrowable(out, ind + "  ", ex2, doStacktrace);
        }
        if (ex instanceof SQLException && (exTarget2 = (exTarget = (SQLException)ex).getNextException()) != null) {
            AbstractStdListener.logThrowable(out, ind + "  ", exTarget2, doStacktrace);
        }
        if (ex instanceof InvocationTargetException && (exTarget2 = (exTarget = (InvocationTargetException)ex).getTargetException()) != null) {
            AbstractStdListener.logThrowable(out, ind + "  ", exTarget2, doStacktrace);
        }
    }

    public boolean hasSeenErrors() {
        return this.errors;
    }

    public void clearErrors() {
        this.errors = false;
    }
}

