/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.Main;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.gui.UserSettings;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.modelscan.IliFile;
import ch.interlis.ili2c.modelscan.IliModel;
import ch.interlis.ilirepository.IliFiles;
import ch.interlis.ilirepository.impl.ModelMetadata;
import ch.interlis.ilirepository.impl.RepositoryAccess;
import ch.interlis.ilirepository.impl.RepositoryAccessException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class CheckReposIlis {
    private boolean validationErrors = false;

    public boolean checkRepoIlis(Configuration config, UserSettings settings) {
        Main.setHttpProxySystemProperties((Settings)settings);
        HashSet<IliFile> failedFiles = new HashSet<IliFile>();
        ArrayList<MetaEntryProblem> inconsistentMetaEntry = new ArrayList<MetaEntryProblem>();
        Iterator reposi = config.iteratorFileEntry();
        while (reposi.hasNext()) {
            File ilimodelsFile;
            FileEntry e = (FileEntry)reposi.next();
            if (e.getKind() != 1) continue;
            String repos = e.getFilename();
            RepositoryAccess reposAccess = new RepositoryAccess();
            try {
                ilimodelsFile = reposAccess.getLocalFileLocation(repos, "ilimodels.xml", 0L, null);
            }
            catch (RepositoryAccessException e2) {
                EhiLogger.logError((Throwable)e2);
                continue;
            }
            if (ilimodelsFile == null) {
                EhiLogger.logAdaption((String)("URL <" + repos + "> contains no " + "ilimodels.xml" + "; ignored"));
                continue;
            }
            Source[] schemaFiles = null;
            try {
                Source[] schemaFiles2;
                schemaFiles = schemaFiles2 = new Source[]{new StreamSource(this.getClass().getResource("/IliRepository.xsd").toString())};
            }
            catch (NullPointerException ex) {
                EhiLogger.logError((String)"failed to create schema", (Throwable)ex);
            }
            Schema schema = null;
            if (schemaFiles != null) {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                try {
                    schema = factory.newSchema(schemaFiles);
                }
                catch (SAXException ex) {
                    EhiLogger.logError((String)"failed to read schema", (Throwable)ex);
                }
            }
            if (schema != null) {
                ValidatorHandler validator = schema.newValidatorHandler();
                validator.setErrorHandler(new ErrorHandler(){

                    @Override
                    public void error(SAXParseException ex) throws SAXException {
                        EhiLogger.logError((String)("ilimodels.xml:" + ex.getLineNumber() + ":" + ex.getColumnNumber() + ":" + ex.getMessage()));
                        CheckReposIlis.this.validationErrors = true;
                    }

                    @Override
                    public void fatalError(SAXParseException ex) throws SAXException {
                        EhiLogger.logError((Throwable)ex);
                    }

                    @Override
                    public void warning(SAXParseException ex) throws SAXException {
                        EhiLogger.logError((Throwable)ex);
                    }
                });
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                try {
                    XMLReader parser = XMLReaderFactory.createXMLReader();
                    parser.setErrorHandler(validator.getErrorHandler());
                    parser.setContentHandler(validator);
                    parser.parse(ilimodelsFile.getAbsolutePath());
                }
                catch (Exception ex) {
                    EhiLogger.logError((String)"failed to validate ilimodels.xml", (Throwable)ex);
                }
            }
            IliFiles files = null;
            List<ModelMetadata> modelMetadatav = null;
            try {
                modelMetadatav = RepositoryAccess.readIliModelsXml2(ilimodelsFile);
                modelMetadatav = RepositoryAccess.getLatestVersions2(modelMetadatav);
                files = RepositoryAccess.createIliFiles2(repos, modelMetadatav);
            }
            catch (RepositoryAccessException e2) {
                EhiLogger.logError((Throwable)e2);
                continue;
            }
            Iterator<IliFile> filei = files.iteratorFile();
            while (filei.hasNext()) {
                IliFile file = filei.next();
                ArrayList<String> ilimodels = new ArrayList<String>();
                Iterator modeli = file.iteratorModel();
                while (modeli.hasNext()) {
                    IliModel model = (IliModel)modeli.next();
                    ilimodels.add(model.getName());
                }
                Configuration fileconfig = new Configuration();
                try {
                    File iliFile = reposAccess.getLocalFileLocation(file.getRepositoryUri(), file.getPath(), 0L, file.getMd5());
                    if (iliFile == null) {
                        EhiLogger.logError((String)("File <" + file.getPath() + "> not found"));
                        failedFiles.add(file);
                        continue;
                    }
                    fileconfig.addFileEntry(new FileEntry(iliFile.getPath(), 1));
                    fileconfig.setAutoCompleteModelList(true);
                    fileconfig.setGenerateWarnings(false);
                    TransferDescription td = Main.runCompiler(fileconfig, (Settings)settings);
                    if (td == null) {
                        failedFiles.add(file);
                        continue;
                    }
                    String md5 = RepositoryAccess.calcMD5(iliFile);
                    for (Model model : td) {
                        if (model == td.INTERLIS || model.getFileName() == null || !model.getFileName().equals(iliFile.getAbsolutePath())) continue;
                        EhiLogger.logState((String)("check model " + model.getFileName()));
                        String csl = null;
                        if (model.getIliVersion().equals("1")) {
                            csl = "ili1";
                        } else if (model.getIliVersion().equals("2.2")) {
                            csl = "ili2_2";
                        } else if (model.getIliVersion().equals("2.3")) {
                            csl = "ili2_3";
                        } else if (model.getIliVersion().equals("2.4")) {
                            csl = "ili2_4";
                        } else {
                            throw new IllegalStateException("unexpected ili version");
                        }
                        ModelMetadata modelMetadata = RepositoryAccess.findModelMetadata2(modelMetadatav, model.getName(), csl);
                        if (modelMetadata == null) {
                            inconsistentMetaEntry.add(new MetaEntryProblem(null, model.getName(), "entry missing or wrong model name in ilimodels.xml for " + file.getPath()));
                            continue;
                        }
                        if (modelMetadata.getMd5() != null && !modelMetadata.getMd5().equalsIgnoreCase(md5)) {
                            inconsistentMetaEntry.add(new MetaEntryProblem(modelMetadata.getOid(), model.getName(), "wrong md5 value; correct would be " + md5));
                        }
                        if (model.getIliVersion().equals("2.3") || model.getIliVersion().equals("2.4")) {
                            if (modelMetadata.getVersion() != null && !modelMetadata.getVersion().equals(model.getModelVersion())) {
                                inconsistentMetaEntry.add(new MetaEntryProblem(modelMetadata.getOid(), model.getName(), "wrong version value; correct would be " + model.getModelVersion()));
                            }
                            if (modelMetadata.getVersionComment() != null && !modelMetadata.getVersionComment().equals(model.getModelVersionExpl())) {
                                inconsistentMetaEntry.add(new MetaEntryProblem(modelMetadata.getOid(), model.getName(), "wrong versionComment value; correct would be " + model.getModelVersionExpl()));
                            }
                            if (modelMetadata.getIssuer() != null && !modelMetadata.getIssuer().equals(model.getIssuer())) {
                                inconsistentMetaEntry.add(new MetaEntryProblem(modelMetadata.getOid(), model.getName(), "wrong issuer value; correct would be " + model.getIssuer()));
                            }
                        }
                        HashSet<String> depsMeta = new HashSet<String>();
                        HashSet<String> depsIli = new HashSet<String>();
                        for (String dep : modelMetadata.getDependsOnModel()) {
                            depsMeta.add(dep);
                        }
                        String sep = "";
                        StringBuilder missingDeps = new StringBuilder();
                        for (Model dep : model.getImporting()) {
                            String depIli = dep.getName();
                            depsIli.add(depIli);
                            if (depIli.equals("INTERLIS") || depsMeta.contains(depIli)) continue;
                            missingDeps.append(sep);
                            missingDeps.append(depIli);
                            sep = ",";
                        }
                        if (missingDeps.length() <= 0) continue;
                        inconsistentMetaEntry.add(new MetaEntryProblem(modelMetadata.getOid(), model.getName(), "wrong depends list; misssing models " + missingDeps.toString()));
                    }
                }
                catch (RepositoryAccessException e1) {
                    EhiLogger.logError((Throwable)e1);
                    failedFiles.add(file);
                }
            }
        }
        if (inconsistentMetaEntry.size() > 0) {
            Collections.sort(inconsistentMetaEntry, new Comparator<MetaEntryProblem>(){

                @Override
                public int compare(MetaEntryProblem arg0, MetaEntryProblem arg1) {
                    int c1 = arg0.getModelName().compareTo(arg1.getModelName());
                    if (c1 == 0) {
                        if (arg0.getTid() == null) {
                            if (arg1.getTid() == null) {
                                return 0;
                            }
                            return -1;
                        }
                        if (arg1.getTid() == null) {
                            return 1;
                        }
                        return arg0.getTid().compareTo(arg1.getTid());
                    }
                    return c1;
                }
            });
            for (MetaEntryProblem prb : inconsistentMetaEntry) {
                if (prb.getTid() == null) {
                    EhiLogger.logError((String)(prb.getModelName() + ": " + prb.getMsg()));
                    continue;
                }
                EhiLogger.logError((String)(prb.getModelName() + "(TID=\"" + prb.getTid() + "\"): " + prb.getMsg()));
            }
        }
        if (failedFiles.size() != 0) {
            StringBuilder failed = new StringBuilder();
            String sep = "";
            for (IliFile f : failedFiles) {
                failed.append(sep);
                failed.append(f.getPath());
                sep = ", ";
            }
            EhiLogger.logError((String)("compile failed with files: " + failed));
            if (this.validationErrors) {
                EhiLogger.logError((String)"syntax errors in ilimodels.xml");
            }
        }
        return failedFiles.size() != 0;
    }

    private class MetaEntryProblem {
        private String modelName = null;
        private String tid = null;
        private String msg = null;

        public MetaEntryProblem(String tid1, String modelName1, String msg1) {
            this.modelName = modelName1;
            this.tid = tid1;
            this.msg = msg1;
        }

        public String getModelName() {
            return this.modelName;
        }

        public String getTid() {
            return this.tid;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

