/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2ora;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.LogListener;
import ch.ehi.basics.logging.TextAreaListener;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.ili2db.base.DbUrlConverter;
import ch.ehi.ili2db.converter.ConverterException;
import ch.ehi.ili2db.gui.Config;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class OraDbPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private TextAreaListener errlog = null;
    private JTextField dbhostUi = null;
    private JLabel dbhostLabel = null;
    private JLabel dbusrLabel = null;
    private JLabel dbpwdLabel = null;
    private JButton testConnectionButton = null;
    private JTextField dbusrUi = null;
    private JPasswordField dbpwdUi = null;
    private JLabel dbnameLabel = null;
    private JLabel dbportLabel = null;
    private JTextField dbnameUi = null;
    private JTextField dbportUi = null;
    private DbUrlConverter dbUrlConverter;
    private String jdbcDriver = null;
    private JScrollPane logScrollPane = null;
    private JTextArea logUi = null;

    public OraDbPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
        gridBagConstraints33.fill = 1;
        gridBagConstraints33.gridy = 5;
        gridBagConstraints33.weightx = 1.0;
        gridBagConstraints33.weighty = 1.0;
        gridBagConstraints33.gridwidth = 2;
        gridBagConstraints33.gridx = 0;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 3;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridx = 1;
        GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
        gridBagConstraints32.fill = 3;
        gridBagConstraints32.gridy = 0;
        gridBagConstraints32.weightx = 1.0;
        gridBagConstraints32.gridx = 1;
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 0;
        gridBagConstraints21.gridy = 2;
        this.dbportLabel = new JLabel();
        this.dbportLabel.setText("dbport");
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 0;
        gridBagConstraints13.gridy = 0;
        this.dbnameLabel = new JLabel();
        this.dbnameLabel.setText("dbname");
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.fill = 3;
        gridBagConstraints31.gridy = 4;
        gridBagConstraints31.weightx = 1.0;
        gridBagConstraints31.gridx = 1;
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.fill = 3;
        gridBagConstraints12.gridy = 3;
        gridBagConstraints12.weightx = 1.0;
        gridBagConstraints12.gridx = 1;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.anchor = 16;
        gridBagConstraints3.gridy = 0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 4;
        this.dbpwdLabel = new JLabel();
        this.dbpwdLabel.setText("dbpwd");
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 3;
        this.dbusrLabel = new JLabel();
        this.dbusrLabel.setText("dbusr");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        this.dbhostLabel = new JLabel();
        this.dbhostLabel.setText("dbhost");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        this.setSize(300, 200);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getDbhostUi(), gridBagConstraints);
        this.add((Component)this.dbhostLabel, gridBagConstraints1);
        this.add((Component)this.dbusrLabel, gridBagConstraints11);
        this.add((Component)this.dbpwdLabel, gridBagConstraints2);
        this.add((Component)this.getTestConnectionButton(), gridBagConstraints3);
        this.add((Component)this.getDbusrUi(), gridBagConstraints12);
        this.add((Component)this.getDbpwdUi(), gridBagConstraints31);
        this.add((Component)this.dbnameLabel, gridBagConstraints13);
        this.add((Component)this.dbportLabel, gridBagConstraints21);
        this.add((Component)this.getDbnameUi(), gridBagConstraints32);
        this.add((Component)this.getDbportUi(), gridBagConstraints4);
        this.add((Component)this.getLogScrollPane(), gridBagConstraints33);
        if (this.errlog == null) {
            this.errlog = new TextAreaListener();
            this.errlog.setOutputArea(this.getLogUi());
            EhiLogger.getInstance().addListener((LogListener)this.errlog);
        }
    }

    private JTextField getDbhostUi() {
        if (this.dbhostUi == null) {
            this.dbhostUi = new JTextField();
            this.dbhostUi.setColumns(40);
        }
        return this.dbhostUi;
    }

    private JButton getTestConnectionButton() {
        if (this.testConnectionButton == null) {
            this.testConnectionButton = new JButton();
            this.testConnectionButton.setText("test connection");
            this.testConnectionButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    OraDbPanel.this.getLogUi().setText("");
                    Config config = new Config();
                    config.setDbdatabase(OraDbPanel.this.getDbname());
                    config.setDbhost(OraDbPanel.this.getDbhost());
                    config.setDbport(OraDbPanel.this.getDbport());
                    String dbusr = OraDbPanel.this.getDbusr();
                    String dbpwd = OraDbPanel.this.getDbpwd();
                    String dburl = OraDbPanel.this.dbUrlConverter.makeUrl(config);
                    try {
                        Class.forName(OraDbPanel.this.jdbcDriver);
                    }
                    catch (Exception ex) {
                        EhiLogger.logError((String)"failed to load JDBC driver", (Throwable)ex);
                        return;
                    }
                    Connection conn = null;
                    try {
                        conn = DriverManager.getConnection(dburl, dbusr, dbpwd);
                        try {
                            String version = null;
                            Statement stmt = conn.createStatement();
                            ResultSet ret = stmt.executeQuery("SELECT SDO_VERSION FROM DUAL");
                            ret.next();
                            version = ret.getString("SDO_VERSION");
                            EhiLogger.logState((String)("oracle spatial version <" + version + ">"));
                        }
                        catch (SQLException ex) {
                            throw new ConverterException("failed to query SDO_VERSION from database", ex);
                        }
                    }
                    catch (Exception ex) {
                        EhiLogger.logError((Throwable)ex);
                        return;
                    }
                    finally {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException ex) {
                                EhiLogger.logError((Throwable)ex);
                            }
                        }
                    }
                    JOptionPane.showMessageDialog(null, "Successfully connected", "test connection", 1);
                }
            });
        }
        return this.testConnectionButton;
    }

    private JTextField getDbusrUi() {
        if (this.dbusrUi == null) {
            this.dbusrUi = new JTextField();
            this.dbusrUi.setColumns(40);
        }
        return this.dbusrUi;
    }

    private JPasswordField getDbpwdUi() {
        if (this.dbpwdUi == null) {
            this.dbpwdUi = new JPasswordField();
            this.dbpwdUi.setColumns(40);
        }
        return this.dbpwdUi;
    }

    public String getDbname() {
        return OraDbPanel.purgeString(this.getDbnameUi().getText());
    }

    public void setDbname(String dbname) {
        this.getDbnameUi().setText(dbname);
    }

    public String getDbhost() {
        return OraDbPanel.purgeString(this.getDbhostUi().getText());
    }

    public void setDbhost(String dbhost) {
        this.getDbhostUi().setText(dbhost);
    }

    public String getDbport() {
        return OraDbPanel.purgeString(this.getDbportUi().getText());
    }

    public void setDbport(String dbport) {
        this.getDbportUi().setText(dbport);
    }

    public String getDbusr() {
        return OraDbPanel.purgeString(this.getDbusrUi().getText());
    }

    public void setDbusr(String dbusr) {
        this.getDbusrUi().setText(dbusr);
    }

    public String getDbpwd() {
        return OraDbPanel.purgeString(this.getDbpwdUi().getText());
    }

    public void setDbpwd(String dbpwd) {
        this.getDbpwdUi().setText(dbpwd);
    }

    private static String purgeString(String value) {
        return StringUtility.purge((String)value);
    }

    private JTextField getDbnameUi() {
        if (this.dbnameUi == null) {
            this.dbnameUi = new JTextField();
            this.dbnameUi.setColumns(40);
        }
        return this.dbnameUi;
    }

    private JTextField getDbportUi() {
        if (this.dbportUi == null) {
            this.dbportUi = new JTextField();
            this.dbportUi.setColumns(40);
        }
        return this.dbportUi;
    }

    public DbUrlConverter getDbUrlConverter() {
        return this.dbUrlConverter;
    }

    public void setDbUrlConverter(DbUrlConverter dbUrlConverter) {
        this.dbUrlConverter = dbUrlConverter;
    }

    public void setJdbcDriver(String driver) {
        this.jdbcDriver = driver;
    }

    private JScrollPane getLogScrollPane() {
        if (this.logScrollPane == null) {
            this.logScrollPane = new JScrollPane();
            this.logScrollPane.setViewportView(this.getLogUi());
        }
        return this.logScrollPane;
    }

    private JTextArea getLogUi() {
        if (this.logUi == null) {
            this.logUi = new JTextArea();
            this.logUi.setEditable(false);
            this.logUi.setRows(10);
            this.logUi.setColumns(40);
        }
        return this.logUi;
    }
}

