/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.toxtf;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.types.OutParam;
import ch.ehi.ili2db.base.DbIdGen;
import ch.ehi.ili2db.base.DbNames;
import ch.ehi.ili2db.base.Ili2cUtility;
import ch.ehi.ili2db.converter.AbstractRecordConverter;
import ch.ehi.ili2db.converter.ConverterException;
import ch.ehi.ili2db.converter.SqlColumnConverter;
import ch.ehi.ili2db.fromili.TransferFromIli;
import ch.ehi.ili2db.fromxtf.EnumValueMap;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2db.mapping.ArrayMapping;
import ch.ehi.ili2db.mapping.ColumnWrapper;
import ch.ehi.ili2db.mapping.MultiLineMapping;
import ch.ehi.ili2db.mapping.MultiPointMapping;
import ch.ehi.ili2db.mapping.MultiSurfaceMapping;
import ch.ehi.ili2db.mapping.NameMapping;
import ch.ehi.ili2db.mapping.TrafoConfig;
import ch.ehi.ili2db.mapping.Viewable2TableMapping;
import ch.ehi.ili2db.mapping.ViewableWrapper;
import ch.ehi.ili2db.toxtf.AbstractStructWrapper;
import ch.ehi.ili2db.toxtf.EmbeddedLinkWrapper;
import ch.ehi.ili2db.toxtf.FixIomObjectRefs;
import ch.ehi.ili2db.toxtf.SqlidPool;
import ch.ehi.ili2db.toxtf.StructWrapper;
import ch.ehi.sqlgen.repository.DbTableName;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.BlackboxType;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ToXtfRecordConverter
extends AbstractRecordConverter {
    private boolean isMsAccess = false;
    private Connection conn = null;
    private SqlColumnConverter geomConv = null;
    private SqlidPool sqlid2xtfid = null;
    private Integer defaultEpsgCode = null;
    private HashMap<AttributeDef, EnumValueMap> enumCache = new HashMap();
    private boolean exportTid = false;
    public static final java.util.Date PURE_GREGORIAN_CALENDAR = new java.util.Date(Long.MIN_VALUE);
    private final int LEN_LANG_PREFIX = "_".length();
    private String dbSchema;

    public ToXtfRecordConverter(TransferDescription td1, NameMapping ili2sqlName, Config config, DbIdGen idGen1, SqlColumnConverter geomConv1, Connection conn1, SqlidPool sqlidPool, TrafoConfig trafoConfig, Viewable2TableMapping class2wrapper1, String dbSchema) {
        super(td1, ili2sqlName, config, idGen1, trafoConfig, class2wrapper1);
        this.conn = conn1;
        this.geomConv = geomConv1;
        this.sqlid2xtfid = sqlidPool;
        this.dbSchema = dbSchema;
        this.exportTid = config.isExportTid();
        try {
            if (this.conn.getMetaData().getURL().startsWith("jdbc:odbc:DRIVER={Microsoft Access Driver (*.mdb)}")) {
                this.isMsAccess = true;
            }
        }
        catch (SQLException e) {
            EhiLogger.logError((Throwable)e);
        }
        if (this.defaultCrsAuthority != null && this.defaultCrsCode != null) {
            this.defaultEpsgCode = TransferFromIli.parseEpsgCode(this.defaultCrsAuthority + ":" + this.defaultCrsCode);
        }
    }

    public String createQueryStmt(Viewable aclass1, Long basketSqlId, AbstractStructWrapper structWrapper0) {
        ViewableWrapper classWrapper = this.class2wrapper.get(aclass1);
        ViewableWrapper rootWrapper = classWrapper.getWrappers().get(0);
        StringBuffer ret = new StringBuffer();
        ret.append("SELECT r0." + this.colT_ID);
        if (this.createTypeDiscriminator || classWrapper.includesMultipleTypes()) {
            ret.append(", r0.T_Type");
        }
        if (structWrapper0 == null && (this.exportTid && !(classWrapper.getViewable() instanceof AssociationDef) || classWrapper.hasOid())) {
            ret.append(", r0.T_Ili_Tid");
        }
        if (structWrapper0 != null && structWrapper0 instanceof StructWrapper) {
            StructWrapper structWrapper = (StructWrapper)structWrapper0;
            if (this.createGenericStructRef) {
                ret.append(", r0.T_ParentId");
                ret.append(", r0.T_ParentType");
                ret.append(", r0.T_ParentAttr");
            } else {
                ret.append(", r0." + this.ili2sqlName.mapIliAttributeDefReverse(structWrapper.getParentAttr(), this.getSqlType(classWrapper.getViewable()).getName(), this.getSqlType(structWrapper.getParentTable().getViewable()).getName()));
            }
            ret.append(", r0.T_Seq");
        }
        String sep = ",";
        int tableAliasIdx = 0;
        for (ViewableWrapper table : classWrapper.getWrappers()) {
            String tableAlias = "r" + tableAliasIdx;
            String sqlTableName = table.getSqlTablename();
            Iterator<ColumnWrapper> iter = table.getAttrIterator();
            while (iter.hasNext()) {
                Type proxyType;
                AttributeDef attr;
                ColumnWrapper columnWrapper = iter.next();
                ViewableTransferElement obj = columnWrapper.getViewableTransferElement();
                if (!(!(obj.obj instanceof AttributeDef) || (attr = (AttributeDef)obj.obj).isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType)) {
                    sep = this.addAttrToQueryStmt(ret, sep, tableAlias, attr, columnWrapper.getEpsgCode(), sqlTableName);
                }
                if (!(obj.obj instanceof RoleDef)) continue;
                RoleDef role = (RoleDef)obj.obj;
                ArrayList<ViewableWrapper> targetTables = this.getTargetTables((Viewable)role.getDestination());
                for (ViewableWrapper targetTable : targetTables) {
                    String roleSqlName = this.ili2sqlName.mapIliRoleDef(role, sqlTableName, targetTable.getSqlTablename(), targetTables.size() > 1);
                    if (obj.embedded) {
                        AssociationDef roleOwner = (AssociationDef)role.getContainer();
                        if (roleOwner.getDerivedFrom() != null) continue;
                        ret.append(sep);
                        sep = ",";
                        ret.append(this.makeColumnRef(tableAlias, roleSqlName));
                        continue;
                    }
                    ret.append(sep);
                    sep = ",";
                    ret.append(this.makeColumnRef(tableAlias, roleSqlName));
                }
            }
            ++tableAliasIdx;
        }
        if (this.createStdCols) {
            ret.append(sep);
            sep = ",";
            ret.append("r0.T_LastChange");
            ret.append(sep);
            sep = ",";
            ret.append("r0.T_CreateDate");
            ret.append(sep);
            sep = ",";
            ret.append("r0.T_User");
        }
        ret.append(" FROM ");
        ArrayList<ViewableWrapper> tablev = new ArrayList<ViewableWrapper>(10);
        tablev.addAll(classWrapper.getWrappers());
        sep = "";
        int tablec = tablev.size();
        if (this.isMsAccess) {
            for (int i = 0; i < tablec; ++i) {
                ret.append("(");
            }
        }
        for (int i = 0; i < tablec; ++i) {
            ret.append(sep);
            ret.append(((ViewableWrapper)tablev.get(i)).getSqlTableQName());
            ret.append(" r" + Integer.toString(i));
            if (i > 0) {
                ret.append(" ON r0." + this.colT_ID + "=r" + Integer.toString(i) + "." + this.colT_ID);
            }
            if (this.isMsAccess) {
                ret.append(")");
            }
            sep = " LEFT JOIN ";
        }
        sep = " WHERE";
        if (this.createTypeDiscriminator || rootWrapper.includesMultipleTypes()) {
            ret.append(sep + " r0." + "T_Type" + "='" + this.getSqlType(aclass1).getName() + "'");
            sep = " AND";
        }
        if (structWrapper0 != null) {
            if (structWrapper0 instanceof StructWrapper) {
                StructWrapper structWrapper = (StructWrapper)structWrapper0;
                if (this.createGenericStructRef) {
                    ret.append(sep + " r0." + "T_ParentId" + "=? AND r0." + "T_ParentAttr" + "=?");
                } else {
                    ret.append(sep + " r0." + this.ili2sqlName.mapIliAttributeDefReverse(structWrapper.getParentAttr(), this.getSqlType(classWrapper.getViewable()).getName(), this.getSqlType(structWrapper.getParentTable().getViewable()).getName()) + "=?");
                }
                sep = " AND";
            } else if (structWrapper0 instanceof EmbeddedLinkWrapper) {
                EmbeddedLinkWrapper structWrapper = (EmbeddedLinkWrapper)structWrapper0;
                RoleDef role = structWrapper.getRole().getOppEnd();
                ArrayList<ViewableWrapper> targetTables = this.getTargetTables((Viewable)role.getDestination());
                String roleSqlName = this.ili2sqlName.mapIliRoleDef(role, rootWrapper.getSqlTablename(), structWrapper.getParentTable().getSqlTablename(), targetTables.size() > 1);
                ret.append(sep + " r0." + roleSqlName + "=?");
            }
        }
        if (basketSqlId != null) {
            ret.append(sep + " r0." + "T_basket" + "=?");
        }
        if (structWrapper0 != null && structWrapper0 instanceof StructWrapper) {
            ret.append(" ORDER BY r0.T_Seq ASC");
        }
        return ret.toString();
    }

    private String makeColumnRef(String tableAlias, String columnName) {
        if (tableAlias == null) {
            return columnName;
        }
        return tableAlias + "." + columnName;
    }

    public String addAttrToQueryStmt(StringBuffer ret, String sep, String tableAlias, AttributeDef attr, Integer epsgCode, String sqlTableName) {
        Type type = attr.getDomainResolvingAliases();
        String attrSqlName = this.ili2sqlName.mapIliAttributeDef(attr, epsgCode, sqlTableName, null);
        if (attr.isDomainIli1Date()) {
            ret.append(sep);
            sep = ",";
            ret.append(this.geomConv.getSelectValueWrapperDate(this.makeColumnRef(tableAlias, attrSqlName)));
        } else if (attr.isDomainIli2Date()) {
            ret.append(sep);
            sep = ",";
            ret.append(this.geomConv.getSelectValueWrapperDate(this.makeColumnRef(tableAlias, attrSqlName)));
        } else if (attr.isDomainIli2Time()) {
            ret.append(sep);
            sep = ",";
            ret.append(this.geomConv.getSelectValueWrapperTime(this.makeColumnRef(tableAlias, attrSqlName)));
        } else if (attr.isDomainIli2DateTime()) {
            ret.append(sep);
            sep = ",";
            ret.append(this.geomConv.getSelectValueWrapperDateTime(this.makeColumnRef(tableAlias, attrSqlName)));
        } else if (type instanceof CompositionType) {
            if ("coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.catalogueRefTrafo"))) {
                ArrayList<ViewableWrapper> targetTables = this.getTargetTables((Viewable)ToXtfRecordConverter.getCatalogueRefTarget(type));
                for (ViewableWrapper targetTable : targetTables) {
                    attrSqlName = this.ili2sqlName.mapIliAttributeDef(attr, sqlTableName, targetTable.getSqlTablename(), targetTables.size() > 1);
                    ret.append(sep);
                    sep = ",";
                    ret.append(this.makeColumnRef(tableAlias, attrSqlName));
                }
            } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multiSurfaceTrafo"))) {
                ret.append(sep);
                sep = ",";
                ret.append(this.geomConv.getSelectValueWrapperMultiSurface(this.makeColumnRef(tableAlias, attrSqlName)));
                this.multiSurfaceAttrs.addMultiSurfaceAttr(attr);
            } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multiLineTrafo"))) {
                ret.append(sep);
                sep = ",";
                ret.append(this.geomConv.getSelectValueWrapperMultiPolyline(this.makeColumnRef(tableAlias, attrSqlName)));
                this.multiLineAttrs.addMultiLineAttr(attr);
            } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multiPointTrafo"))) {
                ret.append(sep);
                sep = ",";
                ret.append(this.geomConv.getSelectValueWrapperMultiCoord(this.makeColumnRef(tableAlias, attrSqlName)));
                this.multiPointAttrs.addMultiPointAttr(attr);
            } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.arrayTrafo"))) {
                ret.append(sep);
                sep = ",";
                ret.append(this.geomConv.getSelectValueWrapperArray(this.makeColumnRef(tableAlias, attrSqlName)));
                this.arrayAttrs.addArrayAttr(attr);
            } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.jsonTrafo"))) {
                ret.append(sep);
                sep = ",";
                ret.append(this.geomConv.getSelectValueWrapperJson(this.makeColumnRef(tableAlias, attrSqlName)));
            } else if ("expand".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multilingualTrafo"))) {
                for (String sfx : DbNames.MULTILINGUAL_TXT_COL_SUFFIXS) {
                    ret.append(sep);
                    sep = ",";
                    ret.append(this.makeColumnRef(tableAlias, attrSqlName + sfx));
                }
            } else if ("expand".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.localisedTrafo"))) {
                ret.append(sep);
                sep = ",";
                ret.append(this.makeColumnRef(tableAlias, attrSqlName));
                ret.append(sep);
                sep = ",";
                ret.append(this.makeColumnRef(tableAlias, attrSqlName + "_lang"));
            }
        } else if (type instanceof PolylineType) {
            ret.append(sep);
            sep = ",";
            ret.append(this.geomConv.getSelectValueWrapperPolyline(this.makeColumnRef(tableAlias, attrSqlName)));
        } else if (type instanceof SurfaceOrAreaType) {
            if (!this.createItfLineTables) {
                ret.append(sep);
                sep = ",";
                ret.append(this.geomConv.getSelectValueWrapperSurface(this.makeColumnRef(tableAlias, attrSqlName)));
            }
            if (this.createItfAreaRef && type instanceof AreaType) {
                ret.append(sep);
                sep = ",";
                ret.append(this.geomConv.getSelectValueWrapperCoord(this.makeColumnRef(tableAlias, attrSqlName + "_ref")));
            }
        } else if (type instanceof CoordType) {
            ret.append(sep);
            sep = ",";
            ret.append(this.geomConv.getSelectValueWrapperCoord(this.makeColumnRef(tableAlias, attrSqlName)));
        } else if (type instanceof ReferenceType) {
            ArrayList<ViewableWrapper> targetTables = this.getTargetTables((Viewable)((ReferenceType)type).getReferred());
            for (ViewableWrapper targetTable : targetTables) {
                attrSqlName = this.ili2sqlName.mapIliAttributeDef(attr, sqlTableName, targetTable.getSqlTablename(), targetTables.size() > 1);
                ret.append(sep);
                sep = ",";
                ret.append(this.makeColumnRef(tableAlias, attrSqlName));
            }
        } else {
            ret.append(sep);
            sep = ",";
            ret.append(this.makeColumnRef(tableAlias, attrSqlName));
        }
        return sep;
    }

    public void setStmtParams(PreparedStatement dbstmt, Long basketSqlId, FixIomObjectRefs fixref, AbstractStructWrapper structWrapper0) throws SQLException {
        dbstmt.clearParameters();
        int paramIdx = 1;
        if (structWrapper0 != null) {
            if (structWrapper0 instanceof StructWrapper) {
                StructWrapper structWrapper = (StructWrapper)structWrapper0;
                dbstmt.setLong(paramIdx++, structWrapper.getParentSqlId());
                if (this.createGenericStructRef) {
                    dbstmt.setString(paramIdx++, this.ili2sqlName.mapIliAttributeDef(structWrapper.getParentAttr(), null, this.getSqlType(structWrapper.getParentTable().getViewable()).getName(), null));
                }
            } else if (structWrapper0 instanceof EmbeddedLinkWrapper) {
                EmbeddedLinkWrapper structWrapper = (EmbeddedLinkWrapper)structWrapper0;
                dbstmt.setLong(paramIdx++, structWrapper.getParentSqlId());
            }
        } else if (fixref != null) {
            throw new IllegalArgumentException("fixref!=null");
        }
        if (basketSqlId != null) {
            dbstmt.setLong(paramIdx++, basketSqlId);
        }
    }

    public long getT_ID(ResultSet rs) throws SQLException {
        long sqlid = rs.getLong(1);
        return sqlid;
    }

    public Iom_jObject convertRecord(ResultSet rs, ViewableWrapper aclass, Viewable iliClassForSelect, FixIomObjectRefs fixref, AbstractStructWrapper structWrapper, HashMap structelev, ArrayList<AbstractStructWrapper> structQueue, long sqlid, Map<String, String> genericDomains, Viewable iliClassForXtf) throws SQLException {
        Iom_jObject iomObj;
        int valuei = 1;
        ++valuei;
        if (this.createTypeDiscriminator || aclass.includesMultipleTypes()) {
            ++valuei;
        }
        String sqlIliTid = null;
        if (structWrapper == null) {
            if (this.exportTid && !(aclass.getViewable() instanceof AssociationDef) || aclass.hasOid()) {
                if (!(iliClassForSelect instanceof AssociationDef) || ((AssociationDef)iliClassForXtf).isIdentifiable()) {
                    sqlIliTid = rs.getString(valuei);
                    this.sqlid2xtfid.putSqlid2Xtfid(aclass.getSqlTablename(), sqlid, sqlIliTid);
                }
                ++valuei;
            } else if (!(iliClassForSelect instanceof AssociationDef) || ((AssociationDef)iliClassForXtf).isIdentifiable()) {
                sqlIliTid = Long.toString(sqlid);
                this.sqlid2xtfid.putSqlid2Xtfid(aclass.getSqlTablename(), sqlid, sqlIliTid);
            }
        }
        if (structWrapper == null) {
            iomObj = !(iliClassForSelect instanceof AssociationDef) || ((AssociationDef)iliClassForXtf).isIdentifiable() ? new Iom_jObject(iliClassForXtf.getScopedName(null), sqlIliTid) : new Iom_jObject(iliClassForXtf.getScopedName(null), null);
            iomObj.setattrvalue("_t_id", Long.toString(sqlid));
            fixref.setRoot((IomObject)iomObj);
        } else if (structWrapper instanceof StructWrapper) {
            iomObj = (Iom_jObject)structelev.get(Long.toString(sqlid));
            valuei = this.createGenericStructRef ? (valuei += 4) : (valuei += 2);
        } else {
            iomObj = (Iom_jObject)structelev.get(Long.toString(sqlid));
        }
        HashMap attrs = this.getIomObjectAttrs(iliClassForSelect);
        HashSet visitedAttrs = new HashSet();
        for (ViewableWrapper table : aclass.getWrappers()) {
            Iterator<ColumnWrapper> iter = table.getAttrIterator();
            while (iter.hasNext()) {
                Type proxyType;
                AttributeDef attr;
                ColumnWrapper columnWrapper = iter.next();
                ViewableTransferElement obj = columnWrapper.getViewableTransferElement();
                if (!(!(obj.obj instanceof AttributeDef) || (attr = (AttributeDef)obj.obj).isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType)) {
                    valuei = this.addAttrValue(rs, valuei, sqlid, iomObj, attr, (AttributeDef)attrs.get(Ili2cUtility.getRootBaseAttr(attr)), columnWrapper.getEpsgCode(), structQueue, table, fixref, genericDomains, iliClassForXtf);
                }
                if (!(obj.obj instanceof RoleDef)) continue;
                RoleDef role = (RoleDef)obj.obj;
                String roleName = role.getName();
                ArrayList<ViewableWrapper> targetTables = this.getTargetTables((Viewable)role.getDestination());
                boolean refAlreadyDefined = false;
                for (ViewableWrapper targetTable : targetTables) {
                    String sqlRoleName = this.ili2sqlName.mapIliRoleDef(role, this.getSqlType(table.getViewable()).getName(), targetTable.getSqlTablename(), targetTables.size() > 1);
                    if (structWrapper == null) {
                        if (obj.embedded) {
                            AssociationDef roleOwner = (AssociationDef)role.getContainer();
                            if (roleOwner.getDerivedFrom() != null) continue;
                            long value = rs.getLong(valuei);
                            ++valuei;
                            if (rs.wasNull()) continue;
                            if (refAlreadyDefined) {
                                EhiLogger.logAdaption((String)("Table " + table.getSqlTablename() + "(id " + sqlid + ") more than one value for role " + roleName + "; value of " + sqlRoleName + " ignored"));
                                continue;
                            }
                            IomObject ref = iomObj.addattrobj(roleName, roleOwner.getScopedName(null));
                            this.mapSqlid2Xtfid(fixref, value, ref, (Viewable)role.getDestination(), targetTable.getSqlTablename());
                            refAlreadyDefined = true;
                            continue;
                        }
                        long value = rs.getLong(valuei);
                        ++valuei;
                        if (rs.wasNull()) continue;
                        if (refAlreadyDefined) {
                            EhiLogger.logAdaption((String)("Table " + table.getSqlTablename() + "(id " + sqlid + ") more than one value for role " + roleName + "; value of " + sqlRoleName + " ignored"));
                            continue;
                        }
                        IomObject ref = iomObj.addattrobj(roleName, "REF");
                        this.mapSqlid2Xtfid(fixref, value, ref, (Viewable)role.getDestination(), targetTable.getSqlTablename());
                        refAlreadyDefined = true;
                        continue;
                    }
                    long value = rs.getLong(valuei);
                    ++valuei;
                    if (rs.wasNull()) continue;
                    if (refAlreadyDefined) {
                        EhiLogger.logAdaption((String)("Table " + table.getSqlTablename() + "(id " + sqlid + ") more than one value for role " + roleName + "; value of " + sqlRoleName + " ignored"));
                        continue;
                    }
                    if (role == ((EmbeddedLinkWrapper)structWrapper).getRole()) {
                        this.mapSqlid2Xtfid(fixref, value, (IomObject)iomObj, (Viewable)role.getDestination(), targetTable.getSqlTablename());
                    }
                    refAlreadyDefined = true;
                }
            }
        }
        return iomObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int addAttrValue(ResultSet rs, int valuei, long sqlid, Iom_jObject iomObj, AttributeDef tableAttr, AttributeDef classAttr, Integer epsgCode, ArrayList<AbstractStructWrapper> structQueue, ViewableWrapper table, FixIomObjectRefs fixref, Map<String, String> genericDomains, Viewable iliClassForXtf) throws SQLException {
        String attrName = tableAttr.getName();
        String sqlAttrName = this.ili2sqlName.mapIliAttributeDef(tableAttr, epsgCode, table.getSqlTablename(), null);
        if (tableAttr.isDomainBoolean()) {
            if (classAttr == null) {
                ++valuei;
                return valuei;
            } else {
                boolean value = rs.getBoolean(valuei);
                ++valuei;
                if (rs.wasNull()) return valuei;
                if (value) {
                    iomObj.setattrvalue(attrName, "true");
                    return valuei;
                } else {
                    iomObj.setattrvalue(attrName, "false");
                }
            }
            return valuei;
        }
        if (tableAttr.isDomainIli1Date()) {
            if (classAttr == null) {
                ++valuei;
                return valuei;
            } else {
                Date value = rs.getDate(valuei);
                ++valuei;
                if (rs.wasNull()) return valuei;
                SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
                GregorianCalendar date = new GregorianCalendar();
                date.setGregorianChange(PURE_GREGORIAN_CALENDAR);
                fmt.setCalendar(date);
                iomObj.setattrvalue(attrName, fmt.format(value));
            }
            return valuei;
        }
        if (tableAttr.isDomainIli2Date()) {
            if (classAttr == null) {
                ++valuei;
                return valuei;
            } else {
                Date value = rs.getDate(valuei);
                ++valuei;
                if (rs.wasNull()) return valuei;
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                GregorianCalendar date = new GregorianCalendar();
                date.setGregorianChange(PURE_GREGORIAN_CALENDAR);
                fmt.setCalendar(date);
                iomObj.setattrvalue(attrName, fmt.format(value));
            }
            return valuei;
        }
        if (tableAttr.isDomainIli2Time()) {
            if (classAttr == null) {
                ++valuei;
                return valuei;
            } else {
                Time value = rs.getTime(valuei);
                ++valuei;
                if (rs.wasNull()) return valuei;
                SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss.SSS");
                iomObj.setattrvalue(attrName, fmt.format(value));
            }
            return valuei;
        }
        if (tableAttr.isDomainIli2DateTime()) {
            if (classAttr == null) {
                ++valuei;
                return valuei;
            } else {
                Timestamp value = rs.getTimestamp(valuei);
                ++valuei;
                if (rs.wasNull()) return valuei;
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                GregorianCalendar date = new GregorianCalendar();
                date.setGregorianChange(PURE_GREGORIAN_CALENDAR);
                fmt.setCalendar(date);
                iomObj.setattrvalue(attrName, fmt.format(value));
            }
            return valuei;
        }
        Type type = tableAttr.getDomainResolvingAliases();
        if (type instanceof CompositionType) {
            if ("coalesce".equals(this.trafoConfig.getAttrConfig(tableAttr, "ch.ehi.ili2db.catalogueRefTrafo"))) {
                ArrayList<ViewableWrapper> targetTables = this.getTargetTables((Viewable)ToXtfRecordConverter.getCatalogueRefTarget(type));
                boolean refAlreadyDefined = false;
                for (ViewableWrapper targetTable : targetTables) {
                    if (classAttr == null) {
                        ++valuei;
                        continue;
                    }
                    long value = rs.getLong(valuei);
                    ++valuei;
                    if (rs.wasNull()) continue;
                    if (refAlreadyDefined) {
                        sqlAttrName = this.ili2sqlName.mapIliAttributeDef(tableAttr, table.getSqlTablename(), targetTable.getSqlTablename(), targetTables.size() > 1);
                        EhiLogger.logAdaption((String)("Table " + table.getSqlTablename() + "(id " + sqlid + ") more than one value for refattr " + attrName + "; value of " + sqlAttrName + " ignored"));
                        continue;
                    }
                    Table catalogueReferenceTyp = ((CompositionType)type).getComponentType();
                    IomObject catref = iomObj.addattrobj(attrName, catalogueReferenceTyp.getScopedName(null));
                    IomObject ref = catref.addattrobj("Reference", "REF");
                    this.mapSqlid2Xtfid(fixref, value, ref, (Viewable)ToXtfRecordConverter.getCatalogueRefTarget(type), targetTable.getSqlTablename());
                    refAlreadyDefined = true;
                }
                return valuei;
            } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(tableAttr, "ch.ehi.ili2db.multiSurfaceTrafo"))) {
                if (classAttr == null) {
                    ++valuei;
                    return valuei;
                } else {
                    MultiSurfaceMapping attrMapping = this.multiSurfaceAttrs.getMapping(tableAttr);
                    Table multiSurfaceType = ((CompositionType)type).getComponentType();
                    Table surfaceStructureType = ((CompositionType)((AttributeDef)multiSurfaceType.getElement(AttributeDef.class, attrMapping.getBagOfSurfacesAttrName())).getDomain()).getComponentType();
                    String multiSurfaceQname = multiSurfaceType.getScopedName(null);
                    String surfaceStructureQname = surfaceStructureType.getScopedName(null);
                    SurfaceType surface = (SurfaceType)((AttributeDef)surfaceStructureType.getElement(AttributeDef.class, attrMapping.getSurfaceAttrName())).getDomainResolvingAliases();
                    CoordType coord = (CoordType)surface.getControlPointDomain().getType();
                    boolean is3D = coord.getDimensions().length == 3;
                    Object geomobj = rs.getObject(valuei);
                    ++valuei;
                    if (rs.wasNull()) return valuei;
                    try {
                        IomObject iomMultiSurface = this.geomConv.toIomMultiSurface(geomobj, sqlAttrName, is3D);
                        if (iomMultiSurface == null) return valuei;
                        Iom_jObject iomChbaseMultiSurface = new Iom_jObject(multiSurfaceQname, null);
                        int surfacec = iomMultiSurface.getattrvaluecount("surface");
                        for (int surfacei = 0; surfacei < surfacec; ++surfacei) {
                            IomObject iomSurface = iomMultiSurface.getattrobj("surface", surfacei);
                            IomObject iomChbaseSurfaceStructure = iomChbaseMultiSurface.addattrobj(attrMapping.getBagOfSurfacesAttrName(), surfaceStructureQname);
                            Iom_jObject iomSurfaceClone = new Iom_jObject("MULTISURFACE", null);
                            iomSurfaceClone.addattrobj("surface", iomSurface);
                            iomChbaseSurfaceStructure.addattrobj(attrMapping.getSurfaceAttrName(), (IomObject)iomSurfaceClone);
                        }
                        iomObj.addattrobj(attrName, (IomObject)iomChbaseMultiSurface);
                        return valuei;
                    }
                    catch (ConverterException ex) {
                        EhiLogger.logError((String)("Object " + sqlid + ": failed to convert surface/area"), (Throwable)ex);
                    }
                }
                return valuei;
            } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(tableAttr, "ch.ehi.ili2db.multiLineTrafo"))) {
                if (classAttr == null) {
                    ++valuei;
                    return valuei;
                } else {
                    MultiLineMapping attrMapping = this.multiLineAttrs.getMapping(tableAttr);
                    Table multiLineType = ((CompositionType)type).getComponentType();
                    Table lineStructureType = ((CompositionType)((AttributeDef)multiLineType.getElement(AttributeDef.class, attrMapping.getBagOfLinesAttrName())).getDomain()).getComponentType();
                    String multiLineQname = multiLineType.getScopedName(null);
                    String lineStructureQname = lineStructureType.getScopedName(null);
                    PolylineType surface = (PolylineType)((AttributeDef)lineStructureType.getElement(AttributeDef.class, attrMapping.getLineAttrName())).getDomainResolvingAliases();
                    CoordType coord = (CoordType)surface.getControlPointDomain().getType();
                    boolean is3D = coord.getDimensions().length == 3;
                    Object geomobj = rs.getObject(valuei);
                    ++valuei;
                    if (rs.wasNull()) return valuei;
                    try {
                        IomObject iomMultiPolygon = this.geomConv.toIomMultiPolyline(geomobj, sqlAttrName, is3D);
                        if (iomMultiPolygon == null) return valuei;
                        Iom_jObject iomChbaseMultiLine = new Iom_jObject(multiLineQname, null);
                        int linec = iomMultiPolygon.getattrvaluecount("polyline");
                        for (int linei = 0; linei < linec; ++linei) {
                            IomObject iomPolygon = iomMultiPolygon.getattrobj("polyline", linei);
                            IomObject iomChbaseSurfaceStructure = iomChbaseMultiLine.addattrobj(attrMapping.getBagOfLinesAttrName(), lineStructureQname);
                            iomChbaseSurfaceStructure.addattrobj(attrMapping.getLineAttrName(), iomPolygon);
                        }
                        iomObj.addattrobj(attrName, (IomObject)iomChbaseMultiLine);
                        return valuei;
                    }
                    catch (ConverterException ex) {
                        EhiLogger.logError((String)("Object " + sqlid + ": failed to convert polyline"), (Throwable)ex);
                    }
                }
                return valuei;
            } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(tableAttr, "ch.ehi.ili2db.multiPointTrafo"))) {
                if (classAttr == null) {
                    ++valuei;
                    return valuei;
                } else {
                    MultiPointMapping attrMapping = this.multiPointAttrs.getMapping(tableAttr);
                    Table multiPointType = ((CompositionType)type).getComponentType();
                    Table pointStructureType = ((CompositionType)((AttributeDef)multiPointType.getElement(AttributeDef.class, attrMapping.getBagOfPointsAttrName())).getDomain()).getComponentType();
                    String multiPointQname = multiPointType.getScopedName(null);
                    String pointStructureQname = pointStructureType.getScopedName(null);
                    CoordType coord = (CoordType)((AttributeDef)pointStructureType.getElement(AttributeDef.class, attrMapping.getPointAttrName())).getDomainResolvingAliases();
                    boolean is3D = coord.getDimensions().length == 3;
                    Object geomobj = rs.getObject(valuei);
                    ++valuei;
                    if (rs.wasNull()) return valuei;
                    try {
                        IomObject iomMultiPoint = this.geomConv.toIomMultiCoord(geomobj, sqlAttrName, is3D);
                        if (iomMultiPoint == null) return valuei;
                        Iom_jObject iomChbaseMultiPoint = new Iom_jObject(multiPointQname, null);
                        int pointc = iomMultiPoint.getattrvaluecount("coord");
                        for (int pointi = 0; pointi < pointc; ++pointi) {
                            IomObject iomPoint = iomMultiPoint.getattrobj("coord", pointi);
                            IomObject iomChbasePointStructure = iomChbaseMultiPoint.addattrobj(attrMapping.getBagOfPointsAttrName(), pointStructureQname);
                            iomChbasePointStructure.addattrobj(attrMapping.getPointAttrName(), iomPoint);
                        }
                        iomObj.addattrobj(attrName, (IomObject)iomChbaseMultiPoint);
                        return valuei;
                    }
                    catch (ConverterException ex) {
                        EhiLogger.logError((String)("Object " + sqlid + ": failed to convert coord"), (Throwable)ex);
                    }
                }
                return valuei;
            } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(tableAttr, "ch.ehi.ili2db.arrayTrafo"))) {
                if (classAttr == null) {
                    ++valuei;
                    return valuei;
                } else {
                    ArrayMapping attrMapping = this.arrayAttrs.getMapping(tableAttr);
                    Object dbValue = rs.getObject(valuei);
                    ++valuei;
                    if (rs.wasNull()) return valuei;
                    try {
                        Type arrayElementType;
                        Table valueStructType = ((CompositionType)type).getComponentType();
                        String valueStructQname = valueStructType.getScopedName(null);
                        String[] iomArray = this.geomConv.toIomArray(attrMapping.getValueAttr(), dbValue, this.createEnumColAsItfCode || "multiTableWithId".equals(this.createEnumTable));
                        if (iomArray != null && (arrayElementType = attrMapping.getValueAttr().getDomainResolvingAliases()) instanceof EnumerationType && !attrMapping.getValueAttr().isDomainBoolean()) {
                            int i;
                            String[] xtfCode;
                            if (this.createEnumColAsItfCode) {
                                xtfCode = new String[iomArray.length];
                                for (i = 0; i < iomArray.length; ++i) {
                                    xtfCode[i] = this.enumTypes.mapItfCode2XtfCode((EnumerationType)arrayElementType, iomArray[i]);
                                }
                                iomArray = xtfCode;
                            } else if ("multiTableWithId".equals(this.createEnumTable)) {
                                xtfCode = new String[iomArray.length];
                                for (i = 0; i < iomArray.length; ++i) {
                                    xtfCode[i] = this.mapEnumValue(attrMapping.getValueAttr(), Long.parseLong(iomArray[i]));
                                }
                                iomArray = xtfCode;
                            }
                        }
                        if (iomArray == null) return valuei;
                        for (int elei = 0; elei < iomArray.length; ++elei) {
                            Iom_jObject iomValueStruct = new Iom_jObject(valueStructQname, null);
                            iomValueStruct.setattrvalue(attrMapping.getValueAttr().getName(), iomArray[elei]);
                            iomObj.addattrobj(attrName, (IomObject)iomValueStruct);
                        }
                        return valuei;
                    }
                    catch (ConverterException ex) {
                        EhiLogger.logError((String)("Object " + sqlid + ": failed to convert array"), (Throwable)ex);
                        return valuei;
                    }
                }
            } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(tableAttr, "ch.ehi.ili2db.jsonTrafo"))) {
                if (classAttr == null) {
                    ++valuei;
                    return valuei;
                } else {
                    Object dbValue = rs.getObject(valuei);
                    ++valuei;
                    if (rs.wasNull()) return valuei;
                    try {
                        IomObject[] iomArray = this.geomConv.toIomStructureFromJson(tableAttr, dbValue);
                        if (iomArray == null) return valuei;
                        for (int elei = 0; elei < iomArray.length; ++elei) {
                            iomObj.addattrobj(attrName, iomArray[elei]);
                        }
                        return valuei;
                    }
                    catch (ConverterException ex) {
                        EhiLogger.logError((String)("Object " + sqlid + ": failed to convert JSON"), (Throwable)ex);
                        return valuei;
                    }
                }
            } else if ("expand".equals(this.trafoConfig.getAttrConfig(tableAttr, "ch.ehi.ili2db.multilingualTrafo"))) {
                Iom_jObject iomMulti = null;
                Table multilingualTextType = ((CompositionType)type).getComponentType();
                String multilingualTextQname = multilingualTextType.getScopedName(null);
                String localizedTextQname = ((CompositionType)((AttributeDef)multilingualTextType.getAttributes().next()).getDomain()).getComponentType().getScopedName(null);
                for (String sfx : DbNames.MULTILINGUAL_TXT_COL_SUFFIXS) {
                    if (classAttr == null) {
                        ++valuei;
                        continue;
                    }
                    String value = rs.getString(valuei);
                    ++valuei;
                    if (rs.wasNull()) continue;
                    if (iomMulti == null) {
                        iomMulti = new Iom_jObject(multilingualTextQname, null);
                    }
                    IomObject iomTxt = iomMulti.addattrobj("LocalisedText", localizedTextQname);
                    if (sfx.length() == 0) {
                        iomTxt.setattrundefined("Language");
                    } else {
                        iomTxt.setattrvalue("Language", sfx.substring(this.LEN_LANG_PREFIX));
                    }
                    iomTxt.setattrvalue("Text", value);
                }
                if (iomMulti == null) return valuei;
                iomObj.addattrobj(attrName, iomMulti);
                return valuei;
            } else if ("expand".equals(this.trafoConfig.getAttrConfig(tableAttr, "ch.ehi.ili2db.localisedTrafo"))) {
                Iom_jObject iomTxt = null;
                Table localisedTextType = ((CompositionType)type).getComponentType();
                String localisedTextQname = localisedTextType.getScopedName(null);
                if (classAttr == null) {
                    ++valuei;
                    ++valuei;
                } else {
                    String text = rs.getString(valuei);
                    ++valuei;
                    if (!rs.wasNull()) {
                        iomTxt = new Iom_jObject(localisedTextQname, null);
                        iomTxt.setattrvalue("Text", text);
                        String lang = rs.getString(valuei);
                        if (!rs.wasNull()) {
                            iomTxt.setattrvalue("Language", lang);
                        }
                    }
                    ++valuei;
                }
                if (iomTxt == null) return valuei;
                iomObj.addattrobj(attrName, iomTxt);
                return valuei;
            } else {
                if (classAttr == null) return valuei;
                structQueue.add(new StructWrapper(sqlid, tableAttr, (IomObject)iomObj, table));
            }
            return valuei;
        }
        if (type instanceof PolylineType) {
            if (classAttr == null) {
                ++valuei;
                return valuei;
            } else {
                Object geomobj = rs.getObject(valuei);
                ++valuei;
                if (rs.wasNull()) return valuei;
                try {
                    boolean is3D = ((CoordType)((PolylineType)type).getControlPointDomain().getType()).getDimensions().length == 3;
                    IomObject polyline = this.geomConv.toIomPolyline(geomobj, sqlAttrName, is3D);
                    if (polyline == null) return valuei;
                    iomObj.addattrobj(attrName, polyline);
                    return valuei;
                }
                catch (ConverterException ex) {
                    EhiLogger.logError((String)("Object " + sqlid + ": failed to convert polyline"), (Throwable)ex);
                }
            }
            return valuei;
        }
        if (type instanceof SurfaceOrAreaType) {
            Object geomobj;
            if (!this.createItfLineTables) {
                if (classAttr == null) {
                    ++valuei;
                } else {
                    geomobj = rs.getObject(valuei);
                    ++valuei;
                    if (!rs.wasNull()) {
                        try {
                            boolean is3D = ((CoordType)((SurfaceOrAreaType)type).getControlPointDomain().getType()).getDimensions().length == 3;
                            IomObject surface = this.geomConv.toIomSurface(geomobj, sqlAttrName, is3D);
                            if (surface != null) {
                                iomObj.addattrobj(attrName, surface);
                            }
                        }
                        catch (ConverterException ex) {
                            EhiLogger.logError((String)("Object " + sqlid + ": failed to convert surface/area"), (Throwable)ex);
                        }
                    }
                }
            }
            if (!this.createItfAreaRef || !(type instanceof AreaType)) return valuei;
            if (classAttr == null) {
                ++valuei;
                return valuei;
            } else {
                geomobj = rs.getObject(valuei);
                ++valuei;
                if (rs.wasNull()) return valuei;
                try {
                    boolean is3D = false;
                    IomObject coord = this.geomConv.toIomCoord(geomobj, sqlAttrName, is3D);
                    if (coord == null) return valuei;
                    iomObj.addattrobj(attrName, coord);
                    return valuei;
                }
                catch (ConverterException ex) {
                    EhiLogger.logError((String)("Object " + sqlid + ": failed to convert coord"), (Throwable)ex);
                }
            }
            return valuei;
        }
        if (type instanceof CoordType) {
            if (classAttr == null) {
                ++valuei;
                return valuei;
            } else {
                Object geomobj = rs.getObject(valuei);
                ++valuei;
                int actualEpsgCode = TransferFromIli.getEpsgCode(iliClassForXtf, tableAttr, genericDomains, this.defaultEpsgCode);
                if (rs.wasNull() || epsgCode != actualEpsgCode) return valuei;
                try {
                    boolean is3D = ((CoordType)type).getDimensions().length == 3;
                    IomObject coord = this.geomConv.toIomCoord(geomobj, sqlAttrName, is3D);
                    if (coord == null) return valuei;
                    iomObj.addattrobj(attrName, coord);
                    return valuei;
                }
                catch (ConverterException ex) {
                    EhiLogger.logError((String)("Object " + sqlid + ": failed to convert coord"), (Throwable)ex);
                }
            }
            return valuei;
        } else if (type instanceof EnumerationType) {
            if (this.createEnumColAsItfCode) {
                if (classAttr == null) {
                    ++valuei;
                    return valuei;
                } else {
                    int value = rs.getInt(valuei);
                    ++valuei;
                    if (rs.wasNull()) return valuei;
                    iomObj.setattrvalue(attrName, this.mapItfCode2XtfCode((EnumerationType)type, value));
                }
                return valuei;
            } else if ("multiTableWithId".equals(this.createEnumTable)) {
                if (classAttr == null) {
                    ++valuei;
                    return valuei;
                } else {
                    long value = rs.getLong(valuei);
                    ++valuei;
                    if (rs.wasNull()) return valuei;
                    String xtfValue = this.mapEnumValue(classAttr, value);
                    if (xtfValue == null) {
                        EhiLogger.logError((String)("Object " + sqlid + ": failed to map id " + value + " for enum attribute " + classAttr));
                        return valuei;
                    } else {
                        iomObj.setattrvalue(attrName, xtfValue);
                    }
                }
                return valuei;
            } else if (classAttr == null) {
                ++valuei;
                return valuei;
            } else {
                String value = rs.getString(valuei);
                ++valuei;
                if (rs.wasNull()) return valuei;
                iomObj.setattrvalue(attrName, value);
            }
            return valuei;
        } else if (type instanceof ReferenceType) {
            ArrayList<ViewableWrapper> targetTables = this.getTargetTables((Viewable)((ReferenceType)type).getReferred());
            boolean refAlreadyDefined = false;
            for (ViewableWrapper targetTable : targetTables) {
                if (classAttr == null) {
                    ++valuei;
                    continue;
                }
                long value = rs.getLong(valuei);
                ++valuei;
                if (rs.wasNull()) continue;
                if (refAlreadyDefined) {
                    sqlAttrName = this.ili2sqlName.mapIliAttributeDef(tableAttr, table.getSqlTablename(), targetTable.getSqlTablename(), targetTables.size() > 1);
                    EhiLogger.logAdaption((String)("Table " + table.getSqlTablename() + "(id " + sqlid + ") more than one value for refattr " + attrName + "; value of " + sqlAttrName + " ignored"));
                    continue;
                }
                IomObject ref = iomObj.addattrobj(attrName, "REF");
                this.mapSqlid2Xtfid(fixref, value, ref, (Viewable)((ReferenceType)type).getReferred(), targetTable.getSqlTablename());
                refAlreadyDefined = true;
            }
            return valuei;
        } else if (type instanceof BlackboxType) {
            if (((BlackboxType)type).getKind() == 1) {
                if (classAttr == null) {
                    ++valuei;
                    return valuei;
                } else {
                    Object obj = rs.getObject(valuei);
                    ++valuei;
                    if (rs.wasNull()) return valuei;
                    try {
                        String xml = this.geomConv.toIomXml(obj);
                        if (xml == null) return valuei;
                        iomObj.setattrvalue(attrName, xml);
                        return valuei;
                    }
                    catch (ConverterException ex) {
                        EhiLogger.logError((String)("Object " + sqlid + ": failed to convert blackbox xml"), (Throwable)ex);
                    }
                }
                return valuei;
            } else if (classAttr == null) {
                ++valuei;
                return valuei;
            } else {
                Object obj = rs.getObject(valuei);
                ++valuei;
                if (rs.wasNull()) return valuei;
                try {
                    String blob = this.geomConv.toIomBlob(obj);
                    if (blob == null) return valuei;
                    iomObj.setattrvalue(attrName, blob);
                    return valuei;
                }
                catch (ConverterException ex) {
                    EhiLogger.logError((String)("Object " + sqlid + ": failed to convert blackbox binary"), (Throwable)ex);
                }
            }
            return valuei;
        } else if (classAttr == null) {
            ++valuei;
            return valuei;
        } else {
            String value = rs.getString(valuei);
            ++valuei;
            if (rs.wasNull()) return valuei;
            iomObj.setattrvalue(attrName, value);
        }
        return valuei;
    }

    private String mapEnumValue(AttributeDef attr, long value) throws SQLException {
        EnumValueMap map = null;
        if (this.enumCache.containsKey(attr)) {
            map = this.enumCache.get(attr);
        } else {
            OutParam qualifiedIliName = new OutParam();
            DbTableName sqlDbName = this.getEnumTargetTableName(attr, (OutParam<String>)qualifiedIliName, this.dbSchema);
            map = EnumValueMap.createEnumValueMap(this.conn, this.colT_ID, true, (String)qualifiedIliName.value, sqlDbName);
            this.enumCache.put(attr, map);
        }
        return map.mapIdValue(value);
    }

    private String mapSqlid2Xtfid(FixIomObjectRefs fixref, long sqlid, IomObject refobj, Viewable targetClass, String targetSqlTable) {
        if (this.sqlid2xtfid.containsSqlid(targetSqlTable, sqlid)) {
            refobj.setobjectrefoid(this.sqlid2xtfid.getXtfid(targetSqlTable, sqlid));
        } else {
            fixref.addFix(refobj, sqlid, targetClass.getScopedName(), targetSqlTable);
        }
        return null;
    }
}

