/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2gpkg;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.ili2db.base.Ili2db;
import ch.ehi.ili2db.base.Ili2dbException;
import ch.ehi.ili2db.gui.AbstractDbPanelDescriptor;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2db.gui.Ili2dbWizard;
import ch.ehi.ili2gpkg.GpkgDbPanel;
import javax.swing.JPanel;

public class GpkgDbPanelDescriptor
extends AbstractDbPanelDescriptor {
    @Override
    public JPanel createPanel() {
        return new GpkgDbPanel();
    }

    @Override
    public void aboutToDisplayPanel() {
        super.aboutToDisplayPanel();
        Config config = ((Ili2dbWizard)this.getWizard()).getIli2dbConfig();
        GpkgDbPanel panel = (GpkgDbPanel)this.getPanelComponent();
        panel.setDbname(config.getDbdatabase());
        panel.setDbhost(config.getDbhost());
        panel.setDbport(config.getDbport());
        panel.setDbusr(config.getDbusr());
        panel.setDbpwd(config.getDbpwd());
        panel.setDbUrlConverter(((Ili2dbWizard)this.getWizard()).getDbUrlConverter());
        panel.setJdbcDriver(config.getJdbcDriver());
    }

    @Override
    public void aboutToHidePanel() {
        Config config = ((Ili2dbWizard)this.getWizard()).getIli2dbConfig();
        GpkgDbPanel panel = (GpkgDbPanel)this.getPanelComponent();
        config.setDbdatabase(panel.getDbname());
        config.setDbhost(panel.getDbhost());
        config.setDbport(panel.getDbport());
        config.setDbusr(panel.getDbusr());
        config.setDbpwd(panel.getDbpwd());
        try {
            config.setDburl(panel.getDbUrlConverter().makeUrl(config));
            Ili2db.readSettingsFromDb(config);
        }
        catch (Ili2dbException e) {
            EhiLogger.logError((Throwable)e);
        }
        super.aboutToHidePanel();
    }
}

