/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.metaattr;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.ili2db.base.Ili2dbException;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTable;
import ch.ehi.sqlgen.repository.DbTableName;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.DataModel;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.iox_j.inifile.IniFileReader;
import ch.interlis.iox_j.validator.ValidationConfig;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;

public class MetaAttrUtility {
    public static final String METAATTRVALUE_ASSOC_KIND_ASSOCIATE = "ASSOCIATE";
    public static final String METAATTRVALUE_ASSOC_KIND_COMPOSITE = "COMPOSITE";
    public static final String METAATTRVALUE_ASSOC_KIND_AGGREGATE = "AGGREGATE";
    public static final String ILI2DB_ILI_PREFIX = "ili2db.ili.";
    public static final String ILI2DB_ILI_ATTR_CARDINALITY_MAX = "ili2db.ili.attrCardinalityMax";
    public static final String ILI2DB_ILI_ATTR_CARDINALITY_MIN = "ili2db.ili.attrCardinalityMin";
    public static final String ILI2DB_ILI_ASSOC_CARDINALITY_MAX = "ili2db.ili.assocCardinalityMax";
    public static final String ILI2DB_ILI_ASSOC_CARDINALITY_MIN = "ili2db.ili.assocCardinalityMin";
    public static final String ILI2DB_ILI_ASSOC_KIND = "ili2db.ili.assocKind";

    public static void addMetaAttrsFromConfigFile(TransferDescription td, File configFile) throws IOException {
        ValidationConfig config = IniFileReader.readFile((File)configFile);
        for (String iliQName : config.getIliQnames()) {
            Element element = td.getElement(iliQName);
            if (element == null) continue;
            for (String paramName : config.getConfigParams(iliQName)) {
                String paramValue = config.getConfigValue(iliQName, paramName);
                if (element.getMetaValue(paramName) != null) continue;
                element.setMetaValue(paramName, paramValue);
            }
        }
    }

    public static void addMetaAttrsFromDb(TransferDescription td, Connection conn, String schema) throws Ili2dbException {
        String sqlName = "T_ILI2DB_META_ATTRS";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        try {
            String stmt = "SELECT ilielement, attr_name, attr_value FROM " + sqlName;
            EhiLogger.traceBackendCmd((String)stmt);
            Statement dbstmt = conn.createStatement();
            ResultSet rs = dbstmt.executeQuery(stmt);
            while (rs.next()) {
                String ilielement = rs.getString("ilielement");
                String attrname = rs.getString("attr_name");
                String attrvalue = rs.getString("attr_value");
                Element element = td.getElement(ilielement);
                if (element == null || attrname.startsWith(ILI2DB_ILI_PREFIX) || element.getMetaValue(attrname) != null) continue;
                element.setMetaValue(attrname, attrvalue);
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to read meta-attributes table", ex);
        }
    }

    public static void addMetaAttributesTable(DbSchema schema) {
        DbTable tab = new DbTable();
        tab.setName(new DbTableName(schema.getName(), "T_ILI2DB_META_ATTRS"));
        DbColVarchar ilielementCol = new DbColVarchar();
        ilielementCol.setName("ilielement");
        ilielementCol.setNotNull(true);
        ilielementCol.setSize(255);
        tab.addColumn((DbColumn)ilielementCol);
        DbColVarchar attrnameCol = new DbColVarchar();
        attrnameCol.setName("attr_name");
        attrnameCol.setNotNull(true);
        attrnameCol.setSize(1024);
        tab.addColumn((DbColumn)attrnameCol);
        DbColVarchar attrvalueCol = new DbColVarchar();
        attrvalueCol.setName("attr_value");
        attrvalueCol.setNotNull(true);
        attrvalueCol.setSize(8000);
        tab.addColumn((DbColumn)attrvalueCol);
        schema.addTable(tab);
    }

    public static void updateMetaAttributesTable(GeneratorJdbc gen, Connection conn, String schema, TransferDescription td) throws Ili2dbException {
        HashMap<String, HashMap<String, String>> entries = new HashMap<String, HashMap<String, String>>();
        for (Object transElem : td) {
            if (transElem instanceof PredefinedModel || !(transElem instanceof DataModel)) continue;
            MetaAttrUtility.visitElement(entries, (Element)transElem);
        }
        MetaAttrUtility.saveTableTab(gen, conn, schema, entries);
    }

    private static void visitElement(HashMap<String, HashMap<String, String>> entries, Element el) throws Ili2dbException {
        Settings metaValues = el.getMetaValues();
        try {
            HashMap<String, String> exstValues;
            if (metaValues.getValues().size() > 0) {
                for (String attr : metaValues.getValues()) {
                    HashMap<String, String> exstValues2 = MetaAttrUtility.getMetaValues(entries, el);
                    exstValues2.put(attr, metaValues.getValue(attr));
                }
            }
            if (el instanceof RoleDef) {
                RoleDef role = (RoleDef)el;
                exstValues = MetaAttrUtility.getMetaValues(entries, el);
                exstValues.put(ILI2DB_ILI_ASSOC_KIND, MetaAttrUtility.mapRoleKind(role.getKind()));
                exstValues.put(ILI2DB_ILI_ASSOC_CARDINALITY_MIN, MetaAttrUtility.mapCardinality(role.getCardinality().getMinimum()));
                exstValues.put(ILI2DB_ILI_ASSOC_CARDINALITY_MAX, MetaAttrUtility.mapCardinality(role.getCardinality().getMaximum()));
            }
            if (el instanceof AttributeDef) {
                AttributeDef attr = (AttributeDef)el;
                exstValues = MetaAttrUtility.getMetaValues(entries, el);
                exstValues.put(ILI2DB_ILI_ATTR_CARDINALITY_MIN, MetaAttrUtility.mapCardinality(MetaAttrUtility.getDomain(attr).getCardinality().getMinimum()));
                exstValues.put(ILI2DB_ILI_ATTR_CARDINALITY_MAX, MetaAttrUtility.mapCardinality(MetaAttrUtility.getDomain(attr).getCardinality().getMaximum()));
            }
        }
        catch (RuntimeException e) {
            EhiLogger.traceUnusualState((String)(el.getScopedName() + ": " + e.getMessage()));
            throw e;
        }
        if (el instanceof Container) {
            Container e = (Container)el;
            Iterator it = e.iterator();
            while (it.hasNext()) {
                MetaAttrUtility.visitElement(entries, (Element)it.next());
            }
        }
    }

    private static Type getDomain(AttributeDef attr) {
        Type type = attr.getDomain();
        if (type == null && attr instanceof LocalAttribute) {
            Evaluable[] ev = ((LocalAttribute)attr).getBasePaths();
            type = ((ObjectPath)ev[0]).getType();
        }
        return type;
    }

    private static String mapCardinality(long val) {
        if (val == Long.MAX_VALUE) {
            return "*";
        }
        return Long.toString(val);
    }

    private static String mapRoleKind(int kind) {
        if (kind == 2) {
            return METAATTRVALUE_ASSOC_KIND_AGGREGATE;
        }
        if (kind == 3) {
            return METAATTRVALUE_ASSOC_KIND_COMPOSITE;
        }
        return METAATTRVALUE_ASSOC_KIND_ASSOCIATE;
    }

    private static HashMap<String, String> getMetaValues(HashMap<String, HashMap<String, String>> entries, Element el) {
        HashMap<String, String> exstValues = entries.get(el.getScopedName());
        if (exstValues == null) {
            exstValues = new HashMap();
            entries.put(el.getScopedName(), exstValues);
        }
        return exstValues;
    }

    private static void saveTableTab(GeneratorJdbc gen, Connection conn, String schemaName, HashMap<String, HashMap<String, String>> tabInfo) throws Ili2dbException {
        DbTableName tabName = new DbTableName(schemaName, "T_ILI2DB_META_ATTRS");
        String sqlName = tabName.getQName();
        if (conn != null) {
            HashMap<String, HashMap<String, String>> exstEntries = MetaAttrUtility.readTableTab(conn, sqlName);
            try {
                String insStmt = "INSERT INTO " + sqlName + " (" + "ilielement" + "," + "attr_name" + "," + "attr_value" + ") VALUES (?,?,?)";
                EhiLogger.traceBackendCmd((String)insStmt);
                PreparedStatement insPrepStmt = conn.prepareStatement(insStmt);
                try {
                    for (String table : tabInfo.keySet()) {
                        HashMap<String, String> exstValues = exstEntries.get(table);
                        if (exstValues == null) {
                            exstValues = new HashMap();
                        }
                        HashMap<String, String> newValues = tabInfo.get(table);
                        for (String tag : newValues.keySet()) {
                            if (exstValues.containsKey(tag)) continue;
                            String value = newValues.get(tag);
                            insPrepStmt.setString(1, table);
                            insPrepStmt.setString(2, tag);
                            insPrepStmt.setString(3, value);
                            insPrepStmt.executeUpdate();
                        }
                    }
                }
                catch (SQLException ex) {
                    throw new Ili2dbException("failed to insert meta info values to " + sqlName, ex);
                }
                finally {
                    insPrepStmt.close();
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to update meta-info table " + sqlName, ex);
            }
        }
        if (gen != null) {
            for (String table : tabInfo.keySet()) {
                HashMap<String, String> newValues = tabInfo.get(table);
                for (String tag : newValues.keySet()) {
                    String value = newValues.get(tag);
                    String insStmt = "INSERT INTO " + sqlName + " (" + "ilielement" + "," + "attr_name" + "," + "attr_value" + ") VALUES ('" + table + "','" + tag + "','" + value + "')";
                    GeneratorJdbc generatorJdbc = gen;
                    generatorJdbc.getClass();
                    gen.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt(generatorJdbc, insStmt));
                }
            }
        }
    }

    private static HashMap<String, HashMap<String, String>> readTableTab(Connection conn, String sqlName) throws Ili2dbException {
        HashMap<String, HashMap<String, String>> exstEntries = new HashMap<String, HashMap<String, String>>();
        try {
            String selStmt = "SELECT ilielement,attr_name,attr_value FROM " + sqlName;
            EhiLogger.traceBackendCmd((String)selStmt);
            PreparedStatement selPrepStmt = conn.prepareStatement(selStmt);
            ResultSet rs = selPrepStmt.executeQuery();
            try {
                while (rs.next()) {
                    String table = rs.getString(1);
                    String tag = rs.getString(2);
                    String value = rs.getString(3);
                    HashMap<String, String> exstValues = exstEntries.get(table);
                    if (exstValues == null) {
                        exstValues = new HashMap();
                        exstEntries.put(table, exstValues);
                    }
                    exstValues.put(tag, value);
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to read meta info values from " + sqlName, ex);
            }
            finally {
                rs.close();
                selPrepStmt.close();
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to read meta-info table " + sqlName, ex);
        }
        return exstEntries;
    }
}

