/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.fromili;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.ili2db.base.DbIdGen;
import ch.ehi.ili2db.base.Ili2cUtility;
import ch.ehi.ili2db.base.Ili2db;
import ch.ehi.ili2db.base.Ili2dbException;
import ch.ehi.ili2db.converter.AbstractRecordConverter;
import ch.ehi.ili2db.dbmetainfo.DbExtMetaInfo;
import ch.ehi.ili2db.fromili.CustomMapping;
import ch.ehi.ili2db.fromili.FromIliRecordConverter;
import ch.ehi.ili2db.fromili.IliImportsUtility;
import ch.ehi.ili2db.fromxtf.EnumValueMap;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2db.mapping.MultiLineMappings;
import ch.ehi.ili2db.mapping.MultiPointMappings;
import ch.ehi.ili2db.mapping.MultiSurfaceMappings;
import ch.ehi.ili2db.mapping.NameMapping;
import ch.ehi.ili2db.mapping.TrafoConfig;
import ch.ehi.ili2db.mapping.Viewable2TableMapping;
import ch.ehi.ili2db.mapping.ViewableWrapper;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import ch.ehi.sqlgen.repository.DbColBoolean;
import ch.ehi.sqlgen.repository.DbColDateTime;
import ch.ehi.sqlgen.repository.DbColGeometry;
import ch.ehi.sqlgen.repository.DbColId;
import ch.ehi.sqlgen.repository.DbColNumber;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbIndex;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTable;
import ch.ehi.sqlgen.repository.DbTableName;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.AttributeRef;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.ExtendableContainer;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.View;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.ili2c.modelscan.IliFile;
import ch.interlis.ili2c.modelscan.IliModel;
import ch.interlis.ilirepository.IliFiles;
import ch.interlis.iom_j.itf.ModelUtilities;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TransferFromIli {
    public static final String EPSG = "EPSG";
    private static final String SRS_MAPPING_TO_ORIGINAL = "ch.ehi.ili2db.fromili.SrsMapping2Original";
    private static final String SRS_MAPPING_TO_ALTERNATE = "ch.ehi.ili2db.fromili.SrsMapping2Alternate";
    private DbSchema schema = null;
    private HashSet<Element> visitedElements = null;
    private Viewable2TableMapping class2wrapper = null;
    private HashSet<ViewableWrapper> visitedWrapper = null;
    private HashSet visitedEnums = null;
    private TransferDescription td = null;
    private NameMapping ili2sqlName = null;
    private String createEnumTable = null;
    private boolean createStdCols = false;
    private boolean createIliTidCol = false;
    private boolean createBasketCol = false;
    private boolean createDatasetCol = false;
    private CustomMapping customMapping = null;
    private boolean createItfLineTables = false;
    private boolean createFk = false;
    private boolean createFkIdx = false;
    private boolean isIli1Model = false;
    private String colT_ID = null;
    private String nl = System.getProperty("line.separator");
    private FromIliRecordConverter recConv = null;
    private DbExtMetaInfo metaInfo = new DbExtMetaInfo();
    private Integer defaultCrsCode = null;
    private String srsModelAssignment = null;

    public DbSchema doit(TransferDescription td1, List<Element> modelEles, NameMapping ili2sqlName, Config config, DbIdGen idGen, TrafoConfig trafoConfig, Viewable2TableMapping class2wrapper1, CustomMapping customMapping1) throws Ili2dbException {
        this.ili2sqlName = ili2sqlName;
        this.createEnumTable = config.getCreateEnumDefs();
        this.createStdCols = "all".equals(config.getCreateStdCols());
        this.createFk = "yes".equals(config.getCreateFk());
        this.createFkIdx = "yes".equals(config.getCreateFkIdx());
        this.colT_ID = config.getColT_ID();
        if (this.colT_ID == null) {
            this.colT_ID = "T_Id";
        }
        this.createIliTidCol = "property".equals(config.getTidHandling());
        this.createBasketCol = "readWrite".equals(config.getBasketHandling());
        this.createDatasetCol = "addDatasetCol".equals(config.getCreateDatasetCols());
        if (config.getDefaultSrsCode() != null) {
            this.defaultCrsCode = Integer.parseInt(config.getDefaultSrsCode());
        }
        this.srsModelAssignment = config.getSrsModelAssignment();
        this.isIli1Model = td1.getIli1Format() != null;
        this.createItfLineTables = this.isIli1Model && config.getDoItfLineTables();
        this.customMapping = customMapping1;
        this.customMapping.fromIliInit(config);
        this.schema = new DbSchema();
        this.schema.setName(config.getDbschema());
        this.visitedElements = new HashSet();
        this.class2wrapper = class2wrapper1;
        this.visitedEnums = new HashSet();
        this.td = td1;
        this.recConv = new FromIliRecordConverter(this.td, ili2sqlName, config, this.schema, this.customMapping, idGen, this.visitedEnums, trafoConfig, this.class2wrapper, this.metaInfo);
        this.visitedWrapper = new HashSet();
        this.generatModelEles(modelEles, 1);
        this.visitedWrapper = new HashSet();
        this.generatModelEles(modelEles, 2);
        this.customMapping.fromIliEnd(config);
        return this.schema;
    }

    private void generatModelEles(List<Element> modelEles, int pass) throws Ili2dbException {
        for (Element modelo : modelEles) {
            if (modelo instanceof Model) {
                Model model = (Model)modelo;
                continue;
            }
            if (modelo instanceof Topic) continue;
            if (modelo instanceof Domain) {
                if (pass != 2) continue;
                this.generateDomain((Domain)modelo);
                this.visitedElements.add((Element)((Domain)modelo));
                continue;
            }
            if (modelo instanceof Viewable) {
                if (modelo instanceof Table && ((Table)modelo).isIli1LineAttrStruct() || modelo instanceof View && !TransferFromIli.isTransferableView(modelo)) continue;
                try {
                    ViewableWrapper wrapper = this.class2wrapper.get((Viewable)modelo);
                    if (wrapper != null) {
                        this.generateViewable(wrapper, pass);
                    }
                    if (pass != 2) continue;
                    this.visitedElements.add((Element)((Viewable)modelo));
                    continue;
                }
                catch (Ili2dbException ex) {
                    throw new Ili2dbException("mapping of " + ((Viewable)modelo).getScopedName(null) + " failed", ex);
                }
            }
            if (!(modelo instanceof AttributeDef)) continue;
            AttributeDef attr = (AttributeDef)modelo;
            if (attr.getDomainResolvingAll() instanceof SurfaceOrAreaType) {
                for (int epsgCode : TransferFromIli.getEpsgCodes(attr, this.srsModelAssignment, this.defaultCrsCode)) {
                    this.generateItfLineTable(attr, epsgCode, pass);
                }
                continue;
            }
            if (!(attr.getDomainResolvingAll() instanceof EnumerationType) || pass != 2) continue;
            this.visitedEnums.add(attr);
        }
    }

    public static boolean isTransferableView(Object modelo) {
        if (!(modelo instanceof View)) {
            return false;
        }
        View view = (View)modelo;
        Topic parent = (Topic)view.getContainer();
        if (!parent.isViewTopic()) {
            return false;
        }
        return !view.isTransient();
    }

    private void generateDomain(Domain def) throws Ili2dbException {
        if (def.getType() instanceof EnumerationType) {
            this.visitedEnums.add(def);
        }
    }

    private void generateViewable(ViewableWrapper def, int pass) throws Ili2dbException {
        if (def.getViewable() instanceof AssociationDef) {
            AssociationDef assoc = (AssociationDef)def.getViewable();
            if (assoc.getDerivedFrom() != null) {
                return;
            }
            if (TransferFromIli.isLightweightAssociation(assoc)) {
                if (pass == 1) {
                    this.customMapping.fixupViewable(null, def.getViewable());
                }
                return;
            }
        }
        EhiLogger.traceState((String)("wrapper of viewable " + def.getViewable()));
        if (!this.visitedWrapper.contains(def)) {
            this.visitedWrapper.add(def);
            this.recConv.generateTable(def, pass);
            for (ViewableWrapper secondary : def.getSecondaryTables()) {
                this.recConv.generateTable(secondary, pass);
            }
        }
    }

    private void generateItfLineTable(AttributeDef attr, Integer epsgCode, int pass) throws Ili2dbException {
        Table lineAttrTable;
        if (pass == 1) {
            DbTableName sqlName = this.getSqlTableNameItfLineTable(attr, epsgCode);
            DbTable dbTable = new DbTable();
            dbTable.setName(sqlName);
            dbTable.setIliName(attr.getContainer().getScopedName(null) + "." + attr.getName());
            this.schema.addTable(dbTable);
            return;
        }
        DbTableName sqlName = this.getSqlTableNameItfLineTable(attr, epsgCode);
        DbTable dbTable = this.schema.findTable(sqlName);
        StringBuffer cmt = new StringBuffer();
        String cmtSep = "";
        if (attr.getDocumentation() != null) {
            cmt.append(cmtSep + attr.getDocumentation());
            cmtSep = this.nl;
        }
        if (cmt.length() > 0) {
            dbTable.setComment(cmt.toString());
        }
        dbTable.setRequiresSequence(true);
        DbColId dbColId = this.recConv.addKeyCol(dbTable);
        if (this.createIliTidCol) {
            this.recConv.addIliTidCol(dbTable, null);
        }
        if (this.createBasketCol) {
            DbColId t_basket = new DbColId();
            t_basket.setName("T_basket");
            t_basket.setNotNull(true);
            t_basket.setScriptComment("REFERENCES T_ILI2DB_BASKET");
            if (this.createFk) {
                t_basket.setReferencedTable(new DbTableName(this.schema.getName(), "T_ILI2DB_BASKET"));
            }
            if (this.createFkIdx) {
                t_basket.setIndex(true);
            }
            dbTable.addColumn((DbColumn)t_basket);
        }
        if (this.createDatasetCol) {
            DbColVarchar t_dsName = new DbColVarchar();
            t_dsName.setName("T_datasetname");
            t_dsName.setSize(200);
            t_dsName.setNotNull(true);
            t_dsName.setIndex(true);
            dbTable.addColumn((DbColumn)t_dsName);
        }
        SurfaceOrAreaType type = (SurfaceOrAreaType)attr.getDomainResolvingAll();
        DbColGeometry dbCol = this.recConv.generatePolylineType((LineType)type, attr.getContainer().getScopedName(null) + "." + attr.getName());
        this.recConv.setCrs(dbCol, epsgCode);
        dbCol.setName(this.ili2sqlName.getSqlColNameItfLineTableGeomAttr(attr, sqlName.getName()));
        dbCol.setNotNull(true);
        dbTable.addColumn((DbColumn)dbCol);
        if (type instanceof SurfaceType) {
            dbColId = new DbColId();
            dbColId.setName(this.ili2sqlName.getSqlColNameItfLineTableRefAttr(attr, sqlName.getName()));
            dbColId.setNotNull(true);
            dbColId.setPrimaryKey(false);
            dbColId.setScriptComment("REFERENCES " + this.recConv.getSqlType((Viewable)attr.getContainer()));
            if (this.createFk) {
                dbColId.setReferencedTable(this.recConv.getSqlType((Viewable)attr.getContainer()));
            }
            if (this.createFkIdx) {
                dbColId.setIndex(true);
            }
            dbTable.addColumn((DbColumn)dbColId);
        }
        if ((lineAttrTable = type.getLineAttributeStructure()) != null) {
            Iterator attri = lineAttrTable.getAttributes();
            while (attri.hasNext()) {
                AttributeDef lineattr = (AttributeDef)attri.next();
                this.recConv.generateAttr(dbTable, (Viewable)lineAttrTable, lineattr, null);
            }
        }
        if (this.createStdCols) {
            AbstractRecordConverter.addStdCol(dbTable);
        }
    }

    private HashMap setupTopicTagMap(TransferDescription td) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Object mObj : td) {
            if (!(mObj instanceof Model)) continue;
            Model model = (Model)mObj;
            ret.put(model.getScopedName(null), model);
            for (Object tObj : model) {
                if (!(tObj instanceof Topic)) continue;
                Topic topic = (Topic)tObj;
                ret.put(topic.getScopedName(null), topic);
            }
        }
        return ret;
    }

    private DbTableName getSqlTableName(Domain def) {
        String sqlname = this.ili2sqlName.mapIliDomainDef(def);
        return new DbTableName(this.schema.getName(), sqlname);
    }

    private DbTableName getSqlTableNameEnum(AttributeDef def) {
        String sqlname = this.ili2sqlName.mapIliEnumAttributeDefAsTable(def);
        return new DbTableName(this.schema.getName(), sqlname);
    }

    private DbTableName getSqlTableNameItfLineTable(AttributeDef def, Integer epsgCode) {
        String sqlname = this.ili2sqlName.mapItfGeometryAsTable((Viewable)def.getContainer(), def, epsgCode);
        return new DbTableName(this.schema.getName(), sqlname);
    }

    public static void addModelsTable(DbSchema schema, Settings config) {
        DbTable tab = new DbTable();
        tab.setName(new DbTableName(schema.getName(), "T_ILI2DB_MODEL"));
        DbColVarchar fileCol = new DbColVarchar();
        fileCol.setName("filename");
        fileCol.setNotNull(true);
        fileCol.setSize(250);
        tab.addColumn((DbColumn)fileCol);
        DbColVarchar iliversionCol = new DbColVarchar();
        iliversionCol.setName("iliversion");
        iliversionCol.setNotNull(true);
        iliversionCol.setSize(3);
        tab.addColumn((DbColumn)iliversionCol);
        DbColVarchar importsCol = new DbColVarchar();
        importsCol.setName("modelName");
        importsCol.setNotNull(true);
        int modelNameColSize = -1;
        String modelNameColSizeStr = config.getValue("ch.ehi.ili2db.modelsTabModelnameColSize");
        if (modelNameColSizeStr != null) {
            try {
                modelNameColSize = Integer.parseInt(modelNameColSizeStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        importsCol.setSize(modelNameColSize);
        tab.addColumn((DbColumn)importsCol);
        DbColVarchar contentCol = new DbColVarchar();
        contentCol.setName("content");
        contentCol.setNotNull(true);
        contentCol.setSize(-1);
        tab.addColumn((DbColumn)contentCol);
        DbColDateTime importDateCol = new DbColDateTime();
        importDateCol.setName("importDate");
        importDateCol.setNotNull(true);
        tab.addColumn((DbColumn)importDateCol);
        DbIndex pk = new DbIndex();
        pk.setPrimary(true);
        pk.addAttr((DbColumn)importsCol);
        pk.addAttr((DbColumn)iliversionCol);
        tab.addIndex(pk);
        schema.addTable(tab);
    }

    public static IliFiles readIliFiles(Connection conn, String schema, CustomMapping mapping, boolean isVer3_export) throws Ili2dbException {
        String sqlName = "T_ILI2DB_MODEL";
        if (!mapping.tableExists(conn, new DbTableName(schema, sqlName))) {
            return null;
        }
        IliFiles ret = new IliFiles();
        try {
            String reposUri = conn.getMetaData().getURL();
            reposUri = mapping.shortenConnectUrl4IliCache(reposUri);
            if (schema != null) {
                sqlName = schema + "." + sqlName;
                reposUri = reposUri + "/" + schema;
            }
            String insStmt = "SELECT filename,iliversion,modelName FROM " + sqlName;
            if (isVer3_export) {
                insStmt = "SELECT file,iliversion,modelName FROM " + sqlName;
                if (TransferFromIli.isMsSqlServer(conn) || TransferFromIli.isOracle(conn)) {
                    insStmt = "SELECT \"file\",iliversion,modelName FROM " + sqlName;
                }
            }
            EhiLogger.traceBackendCmd((String)insStmt);
            PreparedStatement insPrepStmt = conn.prepareStatement(insStmt);
            ResultSet rs = null;
            try {
                rs = insPrepStmt.executeQuery();
                while (rs.next()) {
                    String file = rs.getString(1);
                    double iliversion = Double.parseDouble(rs.getString(2));
                    String imports = rs.getString(3);
                    IliFile iliFile = IliImportsUtility.parseIliImports(iliversion, imports);
                    iliFile.setPath(file);
                    iliFile.setRepositoryUri(reposUri);
                    ret.addFile(iliFile);
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to read IliFiles from db", ex);
            }
            finally {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                insPrepStmt.close();
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to read models-table " + sqlName, ex);
        }
        return ret;
    }

    public static boolean isPostgresql(Connection conn) throws SQLException {
        return conn.getMetaData().getURL().startsWith("jdbc:postgresql:");
    }

    private static boolean isMsSqlServer(Connection conn) throws SQLException {
        return conn.getMetaData().getURL().startsWith("jdbc:sqlserver:");
    }

    private static boolean isOracle(Connection conn) throws SQLException {
        return conn.getMetaData().getURL().startsWith("jdbc:oracle:thin:@");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readIliFile(Connection conn, String schema, String filename, boolean isVer3_export) throws Ili2dbException {
        String sqlName = "T_ILI2DB_MODEL";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        try {
            String selStmt = "SELECT content FROM " + sqlName + " WHERE " + "filename" + "=?";
            if (isVer3_export) {
                selStmt = "SELECT content FROM " + sqlName + " WHERE " + "file" + "=?";
                if (TransferFromIli.isMsSqlServer(conn) || TransferFromIli.isOracle(conn)) {
                    selStmt = "SELECT content FROM " + sqlName + " WHERE \"" + "file" + "\"=?";
                }
            }
            EhiLogger.traceBackendCmd((String)selStmt);
            PreparedStatement selPrepStmt = conn.prepareStatement(selStmt);
            ResultSet rs = null;
            try {
                String file;
                selPrepStmt.clearParameters();
                selPrepStmt.setString(1, filename);
                rs = selPrepStmt.executeQuery();
                if (!rs.next()) return null;
                String string = file = rs.getString(1);
                return string;
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to read ili-file <" + filename + "> from db", ex);
            }
            finally {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                selPrepStmt.close();
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to read models-table " + sqlName, ex);
        }
    }

    public static void addModels(GeneratorJdbc gen, Connection conn, TransferDescription td, String schema, CustomMapping mapping, boolean isVer3_export) throws Ili2dbException {
        IliModel ilimodel;
        IliFiles iliModelsInDb = TransferFromIli.readIliFiles(conn, schema, mapping, isVer3_export);
        String sqlName = "T_ILI2DB_MODEL";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        Timestamp today = new Timestamp(System.currentTimeMillis());
        Iterator entri = td.iterator();
        HashMap<File, IliFile> ilifiles = new HashMap<File, IliFile>();
        while (entri.hasNext()) {
            Model[] imports;
            Object entro = entri.next();
            if (!(entro instanceof Model) || entro instanceof PredefinedModel) continue;
            Model model = (Model)entro;
            File file = new File(model.getFileName());
            IliFile ilifile = null;
            if (ilifiles.containsKey(file)) {
                ilifile = (IliFile)ilifiles.get(file);
            } else {
                ilifile = new IliFile();
                ilifile.setFilename(file);
                ilifiles.put(file, ilifile);
            }
            ilimodel = new IliModel();
            ilimodel.setIliVersion(Double.parseDouble(model.getIliVersion()));
            ilimodel.setName(model.getName());
            for (Model importm : imports = model.getImporting()) {
                ilimodel.addDepenedency(importm.getName());
            }
            Model translatedModel = (Model)model.getTranslationOf();
            if (translatedModel != null) {
                ilimodel.addDepenedency(translatedModel.getName());
            }
            ilifile.addModel(ilimodel);
        }
        if (conn != null) {
            try {
                String insStmt = "INSERT INTO " + sqlName + " (" + "filename" + "," + "iliversion" + "," + "modelName" + "," + "content" + "," + "importDate" + ") VALUES (?,?,?,?,?)";
                EhiLogger.traceBackendCmd((String)insStmt);
                PreparedStatement insPrepStmt = conn.prepareStatement(insStmt);
                try {
                    for (IliFile ilifile : ilifiles.values()) {
                        ilimodel = (IliModel)ilifile.iteratorModel().next();
                        if (iliModelsInDb != null && iliModelsInDb.getFileWithModel(ilimodel.getName(), ilimodel.getIliVersion()) != null) continue;
                        insPrepStmt.clearParameters();
                        insPrepStmt.setString(1, ilifile.getFilename().getName());
                        insPrepStmt.setString(2, Double.toString(ilifile.getIliVersion()));
                        insPrepStmt.setString(3, IliImportsUtility.getIliImports(ilifile));
                        insPrepStmt.setString(4, TransferFromIli.readFileAsString(ilifile.getFilename()));
                        insPrepStmt.setTimestamp(5, today);
                        insPrepStmt.executeUpdate();
                    }
                }
                catch (SQLException ex) {
                    throw new Ili2dbException("failed to insert model", ex);
                }
                catch (IOException e) {
                    throw new Ili2dbException("failed to update models-table " + sqlName, e);
                }
                finally {
                    insPrepStmt.close();
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to update models-table " + sqlName, ex);
            }
        }
        if (gen != null) {
            try {
                for (IliFile ilifile : ilifiles.values()) {
                    IliModel ilimodel2 = (IliModel)ilifile.iteratorModel().next();
                    if (iliModelsInDb != null && iliModelsInDb.getFileWithModel(ilimodel2.getName(), ilimodel2.getIliVersion()) != null) continue;
                    String insStmt = "INSERT INTO " + sqlName + " (" + "filename" + "," + "iliversion" + "," + "modelName" + "," + "content" + "," + "importDate" + ") VALUES (" + Ili2db.quoteSqlStringValue(ilifile.getFilename().getName()) + "," + Ili2db.quoteSqlStringValue(Double.toString(ilifile.getIliVersion())) + "," + Ili2db.quoteSqlStringValue(IliImportsUtility.getIliImports(ilifile)) + "," + Ili2db.quoteSqlStringValue(TransferFromIli.readFileAsString(ilifile.getFilename())) + ",'" + today + "')";
                    GeneratorJdbc generatorJdbc = gen;
                    generatorJdbc.getClass();
                    gen.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt(generatorJdbc, insStmt));
                }
            }
            catch (IOException e) {
                throw new Ili2dbException("failed to create inserts to models-table " + sqlName, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(File filePath) throws IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(filePath));
        try {
            long len = filePath.length();
            if (len > Integer.MAX_VALUE) {
                throw new IOException("File " + filePath + " too large, was " + len + " bytes.");
            }
            byte[] bytes = new byte[(int)len];
            dis.read(bytes);
            String string = new String(bytes, "UTF-8");
            return string;
        }
        finally {
            dis.close();
        }
    }

    public static void addTrafoConfigTable(DbSchema schema) {
        DbTable tab = new DbTable();
        tab.setName(new DbTableName(schema.getName(), "T_ILI2DB_TRAFO"));
        DbColVarchar iliName = new DbColVarchar();
        iliName.setName("iliname");
        iliName.setNotNull(true);
        iliName.setSize(1024);
        tab.addColumn((DbColumn)iliName);
        DbColVarchar configCol = new DbColVarchar();
        configCol.setName("tag");
        configCol.setNotNull(true);
        configCol.setSize(1024);
        tab.addColumn((DbColumn)configCol);
        DbColVarchar valCol = new DbColVarchar();
        valCol.setName("setting");
        valCol.setNotNull(true);
        valCol.setSize(1024);
        tab.addColumn((DbColumn)valCol);
        schema.addTable(tab);
    }

    public static void addSettingsTable(DbSchema schema) {
        DbTable tab = new DbTable();
        tab.setName(new DbTableName(schema.getName(), "T_ILI2DB_SETTINGS"));
        DbColVarchar tagCol = new DbColVarchar();
        tagCol.setName("tag");
        tagCol.setNotNull(true);
        tagCol.setPrimaryKey(true);
        tagCol.setSize(60);
        tab.addColumn((DbColumn)tagCol);
        DbColVarchar settingCol = new DbColVarchar();
        settingCol.setName("setting");
        settingCol.setNotNull(false);
        settingCol.setSize(8000);
        tab.addColumn((DbColumn)settingCol);
        schema.addTable(tab);
    }

    public static void readSettings(Connection conn, Config settings, String schema, CustomMapping customMapping) throws Ili2dbException {
        String sqlName = "T_ILI2DB_SETTINGS";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        if (customMapping.tableExists(conn, new DbTableName(schema, "T_ILI2DB_SETTINGS"))) {
            try {
                String insStmt = "SELECT tag,setting FROM " + sqlName;
                EhiLogger.traceBackendCmd((String)insStmt);
                PreparedStatement insPrepStmt = conn.prepareStatement(insStmt);
                ResultSet rs = null;
                boolean settingsExists = false;
                try {
                    rs = insPrepStmt.executeQuery();
                    while (rs.next()) {
                        String tag = rs.getString(1);
                        String value = rs.getString(2);
                        if (tag.equals("ch.ehi.ili2db.sender")) continue;
                        settings.setValue(tag, value);
                        settingsExists = true;
                    }
                    if (settingsExists) {
                        settings.setConfigReadFromDb(true);
                    }
                }
                catch (SQLException ex) {
                    throw new Ili2dbException("failed to read setting", ex);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    insPrepStmt.close();
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to read settings-table " + sqlName, ex);
            }
        }
    }

    public static void updateSettings(GeneratorJdbc gen, Connection conn, Config settings, String schema) throws Ili2dbException {
        String sqlName = "T_ILI2DB_SETTINGS";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        if (conn != null) {
            try {
                String insStmt = "INSERT INTO " + sqlName + " (" + "tag" + "," + "setting" + ") VALUES (?,?)";
                EhiLogger.traceBackendCmd((String)insStmt);
                PreparedStatement insPrepStmt = conn.prepareStatement(insStmt);
                try {
                    for (String tag : settings.getValues()) {
                        insPrepStmt.clearParameters();
                        insPrepStmt.setString(1, tag);
                        insPrepStmt.setString(2, settings.getValue(tag));
                        insPrepStmt.executeUpdate();
                    }
                }
                catch (SQLException ex) {
                    throw new Ili2dbException("failed to insert setting", ex);
                }
                finally {
                    insPrepStmt.close();
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to update settings-table " + sqlName, ex);
            }
        }
        if (gen != null) {
            for (String tag : settings.getValues()) {
                String insStmt = "INSERT INTO " + sqlName + " (" + "tag" + "," + "setting" + ") VALUES (" + Ili2db.quoteSqlStringValue(tag) + "," + Ili2db.quoteSqlStringValue(settings.getValue(tag)) + ")";
                GeneratorJdbc generatorJdbc = gen;
                generatorJdbc.getClass();
                gen.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt(generatorJdbc, insStmt));
            }
        }
    }

    public static void addInheritanceTable(DbSchema schema, Config config) {
        DbTable tab = new DbTable();
        tab.setName(new DbTableName(schema.getName(), "T_ILI2DB_INHERITANCE"));
        DbColVarchar thisClass = new DbColVarchar();
        thisClass.setName("thisClass");
        thisClass.setNotNull(true);
        thisClass.setPrimaryKey(true);
        int thisClassSize = 1024;
        try {
            thisClassSize = Integer.parseInt(config.getValue("ch.ehi.ili2db.inheritTabThisColSize"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        thisClass.setSize(thisClassSize);
        tab.addColumn((DbColumn)thisClass);
        DbColVarchar baseClass = new DbColVarchar();
        baseClass.setName("baseClass");
        baseClass.setNotNull(false);
        baseClass.setSize(1024);
        tab.addColumn((DbColumn)baseClass);
        schema.addTable(tab);
    }

    public void addBasketsTable(DbSchema schema) {
        DbTable tab = new DbTable();
        tab.setName(new DbTableName(schema.getName(), "T_ILI2DB_BASKET"));
        this.recConv.addKeyCol(tab);
        DbColId dbColDataset = new DbColId();
        dbColDataset.setName("dataset");
        dbColDataset.setNotNull(false);
        dbColDataset.setPrimaryKey(false);
        if (this.createFk) {
            dbColDataset.setReferencedTable(new DbTableName(schema.getName(), "T_ILI2DB_DATASET"));
        }
        if (this.createFkIdx) {
            dbColDataset.setIndex(true);
        }
        tab.addColumn((DbColumn)dbColDataset);
        DbColVarchar thisClass = new DbColVarchar();
        thisClass.setName("topic");
        thisClass.setNotNull(true);
        thisClass.setSize(200);
        tab.addColumn((DbColumn)thisClass);
        this.recConv.addIliTidCol(tab, null);
        DbColVarchar attkey = new DbColVarchar();
        attkey.setName("attachmentKey");
        attkey.setNotNull(true);
        attkey.setSize(200);
        tab.addColumn((DbColumn)attkey);
        DbColVarchar domains = new DbColVarchar();
        domains.setName("domains");
        domains.setNotNull(false);
        domains.setSize(1024);
        tab.addColumn((DbColumn)domains);
        schema.addTable(tab);
        tab = new DbTable();
        tab.setName(new DbTableName(schema.getName(), "T_ILI2DB_DATASET"));
        this.recConv.addKeyCol(tab);
        DbColVarchar dsNameCol = new DbColVarchar();
        dsNameCol.setName("datasetName");
        dsNameCol.setNotNull(false);
        dsNameCol.setSize(200);
        tab.addColumn((DbColumn)dsNameCol);
        DbIndex dbIndex = new DbIndex();
        dbIndex.setPrimary(false);
        dbIndex.setUnique(true);
        dbIndex.addAttr((DbColumn)dsNameCol);
        tab.addIndex(dbIndex);
        schema.addTable(tab);
    }

    public void addImportsTable(DbSchema schema) {
        DbTable tab = new DbTable();
        tab.setName(new DbTableName(schema.getName(), "T_ILI2DB_IMPORT"));
        this.recConv.addKeyCol(tab);
        DbColId dbColBasket = new DbColId();
        dbColBasket.setName("dataset");
        dbColBasket.setNotNull(true);
        dbColBasket.setScriptComment("REFERENCES T_ILI2DB_DATASET");
        if (this.createFkIdx) {
            dbColBasket.setIndex(true);
        }
        tab.addColumn((DbColumn)dbColBasket);
        DbColDateTime dbColImpDate = new DbColDateTime();
        dbColImpDate.setName("importDate");
        dbColImpDate.setNotNull(true);
        tab.addColumn((DbColumn)dbColImpDate);
        DbColVarchar dbColUsr = new DbColVarchar();
        dbColUsr.setName("importUser");
        dbColUsr.setNotNull(true);
        dbColUsr.setSize(40);
        tab.addColumn((DbColumn)dbColUsr);
        DbColVarchar dbColFile = new DbColVarchar();
        dbColFile.setName("importFile");
        dbColFile.setNotNull(false);
        dbColFile.setSize(200);
        tab.addColumn((DbColumn)dbColFile);
        schema.addTable(tab);
        tab = new DbTable();
        tab.setName(new DbTableName(schema.getName(), "T_ILI2DB_IMPORT_BASKET"));
        this.recConv.addKeyCol(tab);
        DbColId dbColImport = new DbColId();
        dbColImport.setName("importrun");
        dbColImport.setNotNull(true);
        dbColImport.setScriptComment("REFERENCES T_ILI2DB_IMPORT");
        if (this.createFk) {
            dbColImport.setReferencedTable(new DbTableName(schema.getName(), "T_ILI2DB_IMPORT"));
        }
        if (this.createFkIdx) {
            dbColImport.setIndex(true);
        }
        tab.addColumn((DbColumn)dbColImport);
        DbColId dbColBasket2 = new DbColId();
        dbColBasket2.setName("basket");
        dbColBasket2.setNotNull(true);
        dbColBasket2.setScriptComment("REFERENCES T_ILI2DB_BASKET");
        if (this.createFk) {
            dbColBasket2.setReferencedTable(new DbTableName(schema.getName(), "T_ILI2DB_BASKET"));
        }
        if (this.createFkIdx) {
            dbColBasket2.setIndex(true);
        }
        tab.addColumn((DbColumn)dbColBasket2);
        DbColNumber dbColObjc = new DbColNumber();
        dbColObjc.setName("objectCount");
        dbColObjc.setNotNull(false);
        tab.addColumn((DbColumn)dbColObjc);
        schema.addTable(tab);
    }

    public void addEnumTable(DbSchema schema) {
        block11: {
            block12: {
                block10: {
                    if (!"singleTable".equals(this.createEnumTable)) break block10;
                    DbTable tab = new DbTable();
                    DbColVarchar thisClass = new DbColVarchar();
                    thisClass.setName("thisClass");
                    thisClass.setNotNull(true);
                    thisClass.setSize(1024);
                    tab.addColumn((DbColumn)thisClass);
                    DbColVarchar baseClass = new DbColVarchar();
                    baseClass.setName("baseClass");
                    baseClass.setNotNull(false);
                    baseClass.setSize(1024);
                    tab.addColumn((DbColumn)baseClass);
                    DbColNumber seq = new DbColNumber();
                    seq.setName("seq");
                    seq.setNotNull(false);
                    seq.setSize(4);
                    tab.addColumn((DbColumn)seq);
                    DbColBoolean inactiveCol = new DbColBoolean();
                    inactiveCol.setName("inactive");
                    inactiveCol.setNotNull(true);
                    tab.addColumn((DbColumn)inactiveCol);
                    DbColVarchar iliCode = new DbColVarchar();
                    iliCode.setName("iliCode");
                    iliCode.setNotNull(true);
                    iliCode.setSize(1024);
                    tab.addColumn((DbColumn)iliCode);
                    tab.setName(new DbTableName(schema.getName(), "T_ILI2DB_ENUM"));
                    DbColNumber itfCode = new DbColNumber();
                    itfCode.setName("itfCode");
                    itfCode.setNotNull(true);
                    itfCode.setSize(4);
                    tab.addColumn((DbColumn)itfCode);
                    DbColVarchar dispName = new DbColVarchar();
                    dispName.setName("dispName");
                    dispName.setNotNull(true);
                    dispName.setSize(250);
                    tab.addColumn((DbColumn)dispName);
                    DbColVarchar description = new DbColVarchar();
                    description.setName("description");
                    description.setNotNull(false);
                    description.setSize(1024);
                    tab.addColumn((DbColumn)description);
                    schema.addTable(tab);
                    break block11;
                }
                if (!"multiTable".equals(this.createEnumTable)) break block12;
                this.addMissingEnumDomains(this.visitedEnums);
                for (Object entro : this.visitedEnums) {
                    DbTableName thisSqlName = null;
                    if (entro instanceof AttributeDef) {
                        AttributeDef attr = (AttributeDef)entro;
                        Type type = attr.getDomain();
                        if (type instanceof TypeAlias) continue;
                        thisSqlName = this.getSqlTableNameEnum(attr);
                    } else if (entro instanceof Domain) {
                        Domain domain = (Domain)entro;
                        if (domain == this.td.INTERLIS.BOOLEAN) continue;
                        thisSqlName = this.getSqlTableName(domain);
                    }
                    if (thisSqlName == null) continue;
                    DbTable tab = new DbTable();
                    tab.setName(thisSqlName);
                    DbColNumber itfCode = new DbColNumber();
                    itfCode.setName("itfCode");
                    itfCode.setNotNull(true);
                    itfCode.setSize(4);
                    itfCode.setPrimaryKey(true);
                    tab.addColumn((DbColumn)itfCode);
                    DbColVarchar iliCode = new DbColVarchar();
                    iliCode.setName("iliCode");
                    iliCode.setNotNull(true);
                    iliCode.setSize(1024);
                    tab.addColumn((DbColumn)iliCode);
                    DbColNumber seq = new DbColNumber();
                    seq.setName("seq");
                    seq.setNotNull(false);
                    seq.setSize(4);
                    tab.addColumn((DbColumn)seq);
                    DbColBoolean inactiveCol = new DbColBoolean();
                    inactiveCol.setName("inactive");
                    inactiveCol.setNotNull(true);
                    tab.addColumn((DbColumn)inactiveCol);
                    DbColVarchar dispName = new DbColVarchar();
                    dispName.setName("dispName");
                    dispName.setNotNull(true);
                    dispName.setSize(250);
                    tab.addColumn((DbColumn)dispName);
                    DbColVarchar description = new DbColVarchar();
                    description.setName("description");
                    description.setNotNull(false);
                    description.setSize(1024);
                    tab.addColumn((DbColumn)description);
                    schema.addTable(tab);
                    this.metaInfo.setTableInfo(tab.getName().getName(), "ch.ehi.ili2db.tableKind", "ENUM");
                }
                break block11;
            }
            if (!"multiTableWithId".equals(this.createEnumTable)) break block11;
            this.addMissingEnumDomains(this.visitedEnums);
            HashSet<Object> enumDefs = new HashSet<Object>();
            for (Object entro : this.visitedEnums) {
                DbTableName thisSqlName = null;
                if (entro instanceof AttributeDef) {
                    AttributeDef attr = (AttributeDef)entro;
                    Type type = attr.getDomain();
                    if (type instanceof TypeAlias) continue;
                    if (!enumDefs.contains(attr = Ili2cUtility.getRootBaseAttr(attr))) {
                        thisSqlName = this.getSqlTableNameEnum(attr);
                        enumDefs.add(attr);
                    }
                } else if (entro instanceof Domain) {
                    Domain domain = (Domain)entro;
                    if (domain == this.td.INTERLIS.BOOLEAN) continue;
                    if (!enumDefs.contains(domain = Ili2cUtility.getRootBaseDomain(domain))) {
                        thisSqlName = this.getSqlTableName(domain);
                        enumDefs.add(domain);
                    }
                }
                if (thisSqlName == null) continue;
                DbTable tab = new DbTable();
                tab.setRequiresSequence(true);
                tab.setName(thisSqlName);
                this.recConv.addKeyCol(tab);
                DbColVarchar thisClass = new DbColVarchar();
                thisClass.setName("thisClass");
                thisClass.setNotNull(true);
                thisClass.setSize(1024);
                tab.addColumn((DbColumn)thisClass);
                DbColVarchar baseClass = new DbColVarchar();
                baseClass.setName("baseClass");
                baseClass.setNotNull(false);
                baseClass.setSize(1024);
                tab.addColumn((DbColumn)baseClass);
                DbColNumber itfCode = new DbColNumber();
                itfCode.setName("itfCode");
                itfCode.setNotNull(true);
                itfCode.setSize(4);
                tab.addColumn((DbColumn)itfCode);
                DbColVarchar iliCode = new DbColVarchar();
                iliCode.setName("iliCode");
                iliCode.setNotNull(true);
                iliCode.setSize(1024);
                tab.addColumn((DbColumn)iliCode);
                DbColNumber seq = new DbColNumber();
                seq.setName("seq");
                seq.setNotNull(false);
                seq.setSize(4);
                tab.addColumn((DbColumn)seq);
                DbColBoolean inactiveCol = new DbColBoolean();
                inactiveCol.setName("inactive");
                inactiveCol.setNotNull(true);
                tab.addColumn((DbColumn)inactiveCol);
                DbColVarchar dispName = new DbColVarchar();
                dispName.setName("dispName");
                dispName.setNotNull(true);
                dispName.setSize(250);
                tab.addColumn((DbColumn)dispName);
                DbColVarchar description = new DbColVarchar();
                description.setName("description");
                description.setNotNull(false);
                description.setSize(1024);
                tab.addColumn((DbColumn)description);
                schema.addTable(tab);
                this.metaInfo.setTableInfo(tab.getName().getName(), "ch.ehi.ili2db.tableKind", "ENUM");
            }
        }
    }

    private void addMissingEnumDomains(HashSet enums) {
        Iterator entri = enums.iterator();
        HashSet<Domain> missingDomains = new HashSet<Domain>();
        while (entri.hasNext()) {
            Object entro = entri.next();
            if (entro instanceof AttributeDef) {
                Domain domain;
                AttributeDef attr = (AttributeDef)entro;
                Type type = attr.getDomain();
                if (!(type instanceof TypeAlias) || enums.contains(domain = ((TypeAlias)type).getAliasing())) continue;
                missingDomains.add(domain);
                continue;
            }
            if (!(entro instanceof Domain)) continue;
        }
        enums.addAll(missingDomains);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashSet<String> readInheritanceTable(Connection conn, String schema) throws Ili2dbException {
        HashSet<String> ret = new HashSet<String>();
        String sqlName = "T_ILI2DB_INHERITANCE";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        try {
            String exstStmt = null;
            exstStmt = "SELECT thisClass FROM " + sqlName;
            EhiLogger.traceBackendCmd((String)exstStmt);
            PreparedStatement exstPrepStmt = conn.prepareStatement(exstStmt);
            ResultSet rs = null;
            try {
                rs = exstPrepStmt.executeQuery();
                while (rs.next()) {
                    String iliClassQName = rs.getString(1);
                    ret.add(iliClassQName);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                exstPrepStmt.close();
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to read inheritance-table " + sqlName, ex);
        }
        return ret;
    }

    public void updateInheritanceTable(GeneratorJdbc gen, Connection conn, String schema) throws Ili2dbException {
        String sqlName = "T_ILI2DB_INHERITANCE";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        if (conn != null) {
            HashSet<String> exstEntries = TransferFromIli.readInheritanceTable(conn, schema);
            try {
                String stmt = "INSERT INTO " + sqlName + " (" + "thisClass" + "," + "baseClass" + ") VALUES (?,?)";
                EhiLogger.traceBackendCmd((String)stmt);
                PreparedStatement ps = conn.prepareStatement(stmt);
                String thisClass = null;
                try {
                    for (Element aclass : this.visitedElements) {
                        if (!(aclass instanceof Viewable) || exstEntries.contains(thisClass = ((Viewable)aclass).getScopedName(null))) continue;
                        Viewable base = (Viewable)((Viewable)aclass).getExtending();
                        ps.setString(1, thisClass);
                        if (base != null) {
                            ps.setString(2, base.getScopedName(null));
                        } else {
                            ps.setNull(2, 12);
                        }
                        ps.executeUpdate();
                    }
                }
                catch (SQLException ex) {
                    throw new Ili2dbException("failed to insert inheritance-relation for class " + thisClass, ex);
                }
                finally {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to update inheritance-table " + sqlName, ex);
            }
        }
        if (gen != null) {
            for (Element aclass : this.visitedElements) {
                if (!(aclass instanceof Viewable)) continue;
                String thisClass = ((Viewable)aclass).getScopedName(null);
                Viewable base = (Viewable)((Viewable)aclass).getExtending();
                String baseScopedName = base != null ? base.getScopedName() : null;
                String stmt = "INSERT INTO " + sqlName + " (" + "thisClass" + "," + "baseClass" + ") VALUES (" + Ili2db.quoteSqlStringValue(thisClass) + "," + Ili2db.quoteSqlStringValue(baseScopedName) + ")";
                GeneratorJdbc generatorJdbc = gen;
                generatorJdbc.getClass();
                gen.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt(generatorJdbc, stmt));
            }
        }
    }

    public void updateEnumTable(GeneratorJdbc gen, Connection conn) throws Ili2dbException {
        if ("singleTable".equals(this.createEnumTable)) {
            this.updateSingleEnumTable(gen, conn);
        } else if ("multiTable".equals(this.createEnumTable)) {
            this.updateMultiEnumTable(gen, conn);
        } else if ("multiTableWithId".equals(this.createEnumTable)) {
            this.updateMultiEnumTableWithId(gen, conn);
        }
    }

    public void updateSingleEnumTable(GeneratorJdbc gen, Connection conn) throws Ili2dbException {
        DbTableName tabName = new DbTableName(this.schema.getName(), "T_ILI2DB_ENUM");
        String sqlName = tabName.getName();
        if (tabName.getSchema() != null) {
            sqlName = tabName.getSchema() + "." + sqlName;
        }
        if (conn != null) {
            try {
                String insStmt = "INSERT INTO " + sqlName + " (" + "seq" + "," + "iliCode" + "," + "itfCode" + "," + "dispName" + "," + "inactive" + "," + "description" + "," + "thisClass" + "," + "baseClass" + ") VALUES (?,?,?,?,?,?,?,?)";
                EhiLogger.traceBackendCmd((String)insStmt);
                PreparedStatement insPrepStmt = conn.prepareStatement(insStmt);
                String thisClass = null;
                try {
                    this.addMissingEnumDomains(this.visitedEnums);
                    for (Object entro : this.visitedEnums) {
                        Domain domain;
                        HashSet<String> exstEntries;
                        String baseClass;
                        Domain base;
                        EnumerationType type;
                        if (entro instanceof AttributeDef) {
                            AttributeDef attr = (AttributeDef)entro;
                            if (attr.getDomain() instanceof TypeAlias) continue;
                            type = (EnumerationType)attr.getDomainResolvingAll();
                            thisClass = attr.getContainer().getScopedName(null) + "." + attr.getName();
                            base = (AttributeDef)attr.getExtending();
                            baseClass = null;
                            if (base != null) {
                                baseClass = base.getContainer().getScopedName(null) + "." + base.getName();
                            }
                            exstEntries = EnumValueMap.readEnumTable(conn, null, true, thisClass, tabName);
                            this.updateEnumEntries(null, exstEntries, sqlName, insPrepStmt, type, thisClass, baseClass);
                            continue;
                        }
                        if (!(entro instanceof Domain) || (domain = (Domain)entro) == this.td.INTERLIS.BOOLEAN) continue;
                        type = (EnumerationType)domain.getType();
                        thisClass = domain.getScopedName(null);
                        base = domain.getExtending();
                        baseClass = null;
                        if (base != null) {
                            baseClass = base.getScopedName(null);
                        }
                        exstEntries = EnumValueMap.readEnumTable(conn, null, true, thisClass, tabName);
                        this.updateEnumEntries(null, exstEntries, sqlName, insPrepStmt, type, thisClass, baseClass);
                    }
                }
                catch (SQLException ex) {
                    throw new Ili2dbException("failed to insert enum values for type " + thisClass, ex);
                }
                finally {
                    insPrepStmt.close();
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to update enum-table " + sqlName, ex);
            }
        }
        if (gen != null) {
            this.addMissingEnumDomains(this.visitedEnums);
            Iterator entri = this.visitedEnums.iterator();
            try {
                while (entri.hasNext()) {
                    Domain domain;
                    HashSet<String> exstEntries;
                    String baseClass;
                    Domain base;
                    String thisClass;
                    EnumerationType type;
                    Object entro = entri.next();
                    if (entro instanceof AttributeDef) {
                        AttributeDef attr = (AttributeDef)entro;
                        if (attr.getDomain() instanceof TypeAlias) continue;
                        type = (EnumerationType)attr.getDomainResolvingAll();
                        thisClass = attr.getContainer().getScopedName(null) + "." + attr.getName();
                        base = (AttributeDef)attr.getExtending();
                        baseClass = null;
                        if (base != null) {
                            baseClass = base.getContainer().getScopedName(null) + "." + base.getName();
                        }
                        exstEntries = new HashSet();
                        this.updateEnumEntries(gen, exstEntries, sqlName, null, type, thisClass, baseClass);
                        continue;
                    }
                    if (!(entro instanceof Domain) || (domain = (Domain)entro) == this.td.INTERLIS.BOOLEAN) continue;
                    type = (EnumerationType)domain.getType();
                    thisClass = domain.getScopedName(null);
                    base = domain.getExtending();
                    baseClass = null;
                    if (base != null) {
                        baseClass = base.getScopedName(null);
                    }
                    exstEntries = new HashSet<String>();
                    this.updateEnumEntries(gen, exstEntries, sqlName, null, type, thisClass, baseClass);
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to create inserts for enum-table " + sqlName, ex);
            }
        }
    }

    public void updateMultiEnumTable(GeneratorJdbc gen, Connection conn) throws Ili2dbException {
        this.addMissingEnumDomains(this.visitedEnums);
        for (Object entro : this.visitedEnums) {
            Domain domain;
            PreparedStatement ps;
            String stmt;
            HashSet<String> exstEntries;
            DbTableName thisSqlName;
            String thisClass;
            EnumerationType type;
            if (entro instanceof AttributeDef) {
                AttributeDef attr = (AttributeDef)entro;
                if (attr.getDomain() instanceof TypeAlias) continue;
                type = (EnumerationType)attr.getDomainResolvingAll();
                thisClass = attr.getContainer().getScopedName(null) + "." + attr.getName();
                thisSqlName = this.getSqlTableNameEnum(attr);
                if (conn != null) {
                    try {
                        exstEntries = EnumValueMap.readEnumTable(conn, null, false, thisClass, thisSqlName);
                        stmt = "INSERT INTO " + thisSqlName + " (" + "seq" + "," + "iliCode" + "," + "itfCode" + "," + "dispName" + "," + "inactive" + "," + "description" + ") VALUES (?,?,?,?,?,?)";
                        EhiLogger.traceBackendCmd((String)stmt);
                        ps = conn.prepareStatement(stmt);
                        try {
                            this.updateEnumEntries(gen, exstEntries, thisSqlName.getQName(), ps, type, null, null);
                        }
                        catch (SQLException ex) {
                            throw new Ili2dbException("failed to insert enum values for type " + thisClass, ex);
                        }
                        finally {
                            ps.close();
                        }
                    }
                    catch (SQLException ex) {
                        throw new Ili2dbException("failed to update enum-table " + thisSqlName, ex);
                    }
                }
                if (gen == null) continue;
                try {
                    exstEntries = new HashSet();
                    this.updateEnumEntries(gen, exstEntries, thisSqlName.getQName(), null, type, null, null);
                    continue;
                }
                catch (SQLException ex) {
                    throw new Ili2dbException("failed to create inserts to enum-table " + thisSqlName, ex);
                }
            }
            if (!(entro instanceof Domain) || (domain = (Domain)entro) == this.td.INTERLIS.BOOLEAN) continue;
            type = (EnumerationType)domain.getType();
            thisClass = domain.getScopedName(null);
            thisSqlName = this.getSqlTableName(domain);
            if (conn != null) {
                try {
                    exstEntries = EnumValueMap.readEnumTable(conn, null, false, thisClass, thisSqlName);
                    stmt = "INSERT INTO " + thisSqlName + " (" + "seq" + "," + "iliCode" + "," + "itfCode" + "," + "dispName" + "," + "inactive" + "," + "description" + ") VALUES (?,?,?,?,?,?)";
                    EhiLogger.traceBackendCmd((String)stmt);
                    ps = conn.prepareStatement(stmt);
                    try {
                        this.updateEnumEntries(gen, exstEntries, thisSqlName.getQName(), ps, type, null, null);
                    }
                    catch (SQLException ex) {
                        throw new Ili2dbException("failed to insert enum values for type " + thisClass, ex);
                    }
                    finally {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    throw new Ili2dbException("failed to update enum-table " + thisSqlName, ex);
                }
            }
            if (gen == null) continue;
            try {
                exstEntries = new HashSet();
                this.updateEnumEntries(gen, exstEntries, thisSqlName.getQName(), null, type, null, null);
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to create inserts to enum-table " + thisSqlName, ex);
            }
        }
    }

    public void updateMultiEnumTableWithId(GeneratorJdbc gen, Connection conn) throws Ili2dbException {
        this.addMissingEnumDomains(this.visitedEnums);
        for (Object entro : this.visitedEnums) {
            Domain domain;
            PreparedStatement ps;
            String stmt;
            HashSet<String> exstEntries;
            DbTableName thisSqlName;
            String baseClass;
            Domain base;
            String thisClass;
            EnumerationType type;
            if (entro instanceof AttributeDef) {
                AttributeDef attr = (AttributeDef)entro;
                if (attr.getDomain() instanceof TypeAlias) continue;
                type = (EnumerationType)attr.getDomainResolvingAll();
                thisClass = attr.getContainer().getScopedName(null) + "." + attr.getName();
                base = (AttributeDef)attr.getExtending();
                baseClass = null;
                if (base != null) {
                    baseClass = base.getContainer().getScopedName(null) + "." + base.getName();
                }
                thisSqlName = this.getSqlTableNameEnum(Ili2cUtility.getRootBaseAttr(attr));
                if (conn != null) {
                    try {
                        exstEntries = EnumValueMap.readEnumTable(conn, this.colT_ID, true, thisClass, thisSqlName);
                        stmt = "INSERT INTO " + thisSqlName + " (" + "seq" + "," + "iliCode" + "," + "itfCode" + "," + "dispName" + "," + "inactive" + "," + "description" + "," + "thisClass" + "," + "baseClass" + ") VALUES (?,?,?,?,?,?,?,?)";
                        EhiLogger.traceBackendCmd((String)stmt);
                        ps = conn.prepareStatement(stmt);
                        try {
                            this.updateEnumEntries(gen, exstEntries, thisSqlName.getQName(), ps, type, thisClass, baseClass);
                        }
                        catch (SQLException ex) {
                            throw new Ili2dbException("failed to insert enum values for type " + thisClass, ex);
                        }
                        finally {
                            ps.close();
                        }
                    }
                    catch (SQLException ex) {
                        throw new Ili2dbException("failed to update enum-table " + thisSqlName, ex);
                    }
                }
                if (gen == null) continue;
                try {
                    exstEntries = new HashSet();
                    this.updateEnumEntries(gen, exstEntries, thisSqlName.getQName(), null, type, thisClass, baseClass);
                    continue;
                }
                catch (SQLException ex) {
                    throw new Ili2dbException("failed to create inserts into enum-table " + thisSqlName, ex);
                }
            }
            if (!(entro instanceof Domain) || (domain = (Domain)entro) == this.td.INTERLIS.BOOLEAN) continue;
            type = (EnumerationType)domain.getType();
            thisClass = domain.getScopedName(null);
            base = domain.getExtending();
            baseClass = null;
            if (base != null) {
                baseClass = base.getScopedName(null);
            }
            thisSqlName = this.getSqlTableName(Ili2cUtility.getRootBaseDomain(domain));
            if (conn != null) {
                try {
                    exstEntries = EnumValueMap.readEnumTable(conn, this.colT_ID, true, thisClass, thisSqlName);
                    stmt = "INSERT INTO " + thisSqlName + " (" + "seq" + "," + "iliCode" + "," + "itfCode" + "," + "dispName" + "," + "inactive" + "," + "description" + "," + "thisClass" + "," + "baseClass" + ") VALUES (?,?,?,?,?,?,?,?)";
                    EhiLogger.traceBackendCmd((String)stmt);
                    ps = conn.prepareStatement(stmt);
                    try {
                        this.updateEnumEntries(gen, exstEntries, thisSqlName.getQName(), ps, type, thisClass, baseClass);
                    }
                    catch (SQLException ex) {
                        throw new Ili2dbException("failed to insert enum values for type " + thisClass, ex);
                    }
                    finally {
                        ps.close();
                    }
                }
                catch (SQLException ex) {
                    throw new Ili2dbException("failed to update enum-table " + thisSqlName, ex);
                }
            }
            if (gen == null) continue;
            try {
                exstEntries = new HashSet();
                this.updateEnumEntries(gen, exstEntries, thisSqlName.getQName(), null, type, thisClass, baseClass);
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to create inserts into enum-table " + thisSqlName, ex);
            }
        }
    }

    private void updateEnumEntries(GeneratorJdbc gen, Set<String> exstEntries, String sqlTableName, PreparedStatement ps, EnumerationType type, String thisClass, String baseClass) throws SQLException {
        ArrayList ev = new ArrayList();
        ModelUtilities.buildEnumElementList(ev, (String)"", (Enumeration)type.getConsolidatedEnumeration());
        boolean isOrdered = type.isOrdered();
        int itfCode = 0;
        int seq = 0;
        for (Map.Entry ele : ev) {
            String eleName = (String)ele.getKey();
            Enumeration.Element eleElement = (Enumeration.Element)ele.getValue();
            if (ps != null && !exstEntries.contains(eleName)) {
                if (isOrdered) {
                    ps.setInt(1, seq);
                } else {
                    ps.setNull(1, 2);
                }
                ps.setString(2, eleName);
                ps.setInt(3, itfCode);
                String dispName = eleElement.getMetaValues().getValue("ili2db.dispName");
                if (dispName != null) {
                    ps.setString(4, dispName);
                } else {
                    ps.setString(4, this.recConv.beautifyEnumDispName(eleName));
                }
                ps.setBoolean(5, false);
                String description = eleElement.getDocumentation();
                if (description != null) {
                    ps.setString(6, description);
                } else {
                    ps.setNull(6, 12);
                }
                if (thisClass != null) {
                    ps.setString(7, thisClass);
                    if (baseClass != null) {
                        ps.setString(8, baseClass);
                    } else {
                        ps.setNull(8, 12);
                    }
                }
                ps.executeUpdate();
            }
            if (gen != null) {
                StringBuffer insStmt = new StringBuffer("INSERT INTO " + sqlTableName + " (" + "seq" + "," + "iliCode" + "," + "itfCode" + "," + "dispName" + "," + "inactive" + "," + "description");
                if (thisClass != null) {
                    insStmt.append(",thisClass,baseClass");
                }
                insStmt.append(") VALUES (");
                if (isOrdered) {
                    insStmt.append(seq);
                } else {
                    insStmt.append("NULL");
                }
                insStmt.append("," + Ili2db.quoteSqlStringValue(eleName));
                insStmt.append("," + itfCode);
                String dispName = eleElement.getMetaValues().getValue("ili2db.dispName");
                if (dispName != null) {
                    insStmt.append("," + Ili2db.quoteSqlStringValue(dispName));
                } else {
                    insStmt.append("," + Ili2db.quoteSqlStringValue(this.recConv.beautifyEnumDispName(eleName)));
                }
                insStmt.append(",'0'");
                String description = eleElement.getDocumentation();
                insStmt.append("," + Ili2db.quoteSqlStringValue(description));
                if (thisClass != null) {
                    insStmt.append("," + Ili2db.quoteSqlStringValue(thisClass));
                    insStmt.append("," + Ili2db.quoteSqlStringValue(baseClass));
                }
                insStmt = insStmt.append(")");
                GeneratorJdbc generatorJdbc = gen;
                generatorJdbc.getClass();
                gen.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt(generatorJdbc, insStmt.toString()));
            }
            ++itfCode;
            ++seq;
        }
    }

    public static void addTableMappingTable(DbSchema schema, Config config) {
        DbTable tab = new DbTable();
        tab.setName(new DbTableName(schema.getName(), "T_ILI2DB_CLASSNAME"));
        DbColVarchar iliClassName = new DbColVarchar();
        iliClassName.setName("IliName");
        iliClassName.setNotNull(true);
        int ilinameSize = 1024;
        try {
            ilinameSize = Integer.parseInt(config.getValue("ch.ehi.ili2db.classnameTabIlinameColSize"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        iliClassName.setSize(ilinameSize);
        iliClassName.setPrimaryKey(true);
        tab.addColumn((DbColumn)iliClassName);
        DbColVarchar sqlTableName = new DbColVarchar();
        sqlTableName.setName("SqlName");
        sqlTableName.setNotNull(true);
        sqlTableName.setSize(1024);
        tab.addColumn((DbColumn)sqlTableName);
        schema.addTable(tab);
    }

    public static void addAttrMappingTable(DbSchema schema, Config config) {
        DbTable tab = new DbTable();
        tab.setName(new DbTableName(schema.getName(), "T_ILI2DB_ATTRNAME"));
        DbColVarchar ilinameCol = new DbColVarchar();
        ilinameCol.setName("IliName");
        ilinameCol.setNotNull(true);
        ilinameCol.setSize(1024);
        tab.addColumn((DbColumn)ilinameCol);
        DbColVarchar sqlnameCol = new DbColVarchar();
        sqlnameCol.setName("SqlName");
        sqlnameCol.setNotNull(true);
        int sqlnameColSize = 1024;
        try {
            sqlnameColSize = Integer.parseInt(config.getValue("ch.ehi.ili2db.attrTabSqlnameColSize"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        sqlnameCol.setSize(sqlnameColSize);
        tab.addColumn((DbColumn)sqlnameCol);
        DbColVarchar ownerCol = new DbColVarchar();
        ownerCol.setName("ColOwner");
        ownerCol.setNotNull(true);
        int ownerColSize = 1024;
        try {
            ownerColSize = Integer.parseInt(config.getValue("ch.ehi.ili2db.attrTabOwnerColSize"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ownerCol.setSize(ownerColSize);
        tab.addColumn((DbColumn)ownerCol);
        DbColVarchar targetCol = new DbColVarchar();
        targetCol.setName("Target");
        targetCol.setNotNull(false);
        targetCol.setSize(1024);
        tab.addColumn((DbColumn)targetCol);
        DbIndex pk = new DbIndex();
        pk.setPrimary(true);
        pk.addAttr((DbColumn)ownerCol);
        pk.addAttr((DbColumn)sqlnameCol);
        tab.addIndex(pk);
        schema.addTable(tab);
    }

    public void updateMetaInfoTables(GeneratorJdbc gen, Connection conn) throws Ili2dbException {
        for (ViewableWrapper v : this.visitedWrapper) {
            String dispName;
            if (v.isSecondaryTable()) {
                this.metaInfo.setTableInfo(v.getSqlTablename(), "ch.ehi.ili2db.tableKind", "SECONDARY");
            } else if (v.getExtending() == null) {
                if (v.isStructure()) {
                    this.metaInfo.setTableInfo(v.getSqlTablename(), "ch.ehi.ili2db.tableKind", "STRUCTURE");
                } else if (v.getViewable() instanceof AssociationDef) {
                    this.metaInfo.setTableInfo(v.getSqlTablename(), "ch.ehi.ili2db.tableKind", "ASSOCIATION");
                } else if (Ili2cUtility.isChbaseCatalogueItem(this.td, v.getViewable())) {
                    this.metaInfo.setTableInfo(v.getSqlTablename(), "ch.ehi.ili2db.tableKind", "CATALOGUE");
                } else if (v.getViewable() instanceof Table) {
                    this.metaInfo.setTableInfo(v.getSqlTablename(), "ch.ehi.ili2db.tableKind", "CLASS");
                }
            }
            if ((dispName = v.getViewable().getMetaValues().getValue("ili2db.dispName")) == null) continue;
            this.metaInfo.setTableInfo(v.getSqlTablename(), "ch.ehi.ili2db.dispName", dispName);
        }
        this.metaInfo.updateMetaInfoTables(gen, conn, this.schema.getName());
    }

    public static boolean isLightweightAssociation(AssociationDef roleOwner) {
        if (!roleOwner.isLightweight()) {
            return false;
        }
        for (ExtendableContainer assocEle : roleOwner.getExtensions()) {
            AssociationDef assoc = (AssociationDef)assocEle;
            if (!assoc.getAttributes().hasNext() && !assoc.getLightweightAssociations().iterator().hasNext()) continue;
            return false;
        }
        return true;
    }

    public static int[] getEpsgCodes(AttributeDef attr, String srsModelAssignment, Integer defaultCrsCode) {
        TransferDescription td = (TransferDescription)attr.getContainer(TransferDescription.class);
        if (Ili2cUtility.isMultiSurfaceAttr(td, attr)) {
            AttributeDef surfaceAttr;
            MultiSurfaceMappings multiSurfaceAttrs = new MultiSurfaceMappings();
            multiSurfaceAttrs.addMultiSurfaceAttr(attr);
            attr = surfaceAttr = multiSurfaceAttrs.getSurfaceAttr(attr);
        } else if (Ili2cUtility.isMultiLineAttr(td, attr)) {
            AttributeDef polylineAttr;
            MultiLineMappings multiLineAttrs = new MultiLineMappings();
            multiLineAttrs.addMultiLineAttr(attr);
            attr = polylineAttr = multiLineAttrs.getPolylineAttr(attr);
        } else if (Ili2cUtility.isMultiPointAttr(td, attr)) {
            AttributeDef multipointAttr;
            MultiPointMappings multiPointAttrs = new MultiPointMappings();
            multiPointAttrs.addMultiPointAttr(attr);
            attr = multipointAttr = multiPointAttrs.getCoordAttr(attr);
        }
        AttributeDef attrOrDomainDef = attr;
        Type attrType = attr.getDomain();
        if (attrType == null) {
            while (attrType == null && attrOrDomainDef instanceof LocalAttribute) {
                Evaluable[] ev = ((LocalAttribute)attrOrDomainDef).getBasePaths();
                attrType = ((ObjectPath)ev[0]).getType();
                PathEl last = ((ObjectPath)ev[0]).getLastPathEl();
                attrOrDomainDef = ((AttributeRef)last).getAttr();
            }
        }
        Domain coordDomain = null;
        if (attrType instanceof TypeAlias && (attrType = ((Domain)(attrOrDomainDef = ((TypeAlias)attrType).getAliasing())).getType()) instanceof CoordType) {
            coordDomain = (Domain)attrOrDomainDef;
        }
        CoordType coord = null;
        if (attrType instanceof CoordType) {
            coord = (CoordType)attrType;
        } else if (attrType instanceof LineType && (coordDomain = ((LineType)attrType).getControlPointDomain()) != null) {
            attrOrDomainDef = coordDomain;
            coord = (CoordType)coordDomain.getType();
        }
        if (coord == null) {
            return null;
        }
        if (coord.isGeneric()) {
            Domain[] concreteCoordDomains = ((Model)attr.getContainer(Model.class)).resolveGenericDomain(coordDomain);
            HashSet<Integer> codes = new HashSet<Integer>();
            for (Domain concreteCoordDomain : concreteCoordDomains) {
                String crs = ((CoordType)concreteCoordDomain.getType()).getCrs((Element)concreteCoordDomain);
                if (crs == null) continue;
                codes.add(TransferFromIli.parseEpsgCode(crs));
            }
            ArrayList codev = new ArrayList(codes);
            Collections.sort(codev);
            int[] epsgCodes = new int[codev.size()];
            for (int i = 0; i < epsgCodes.length; ++i) {
                epsgCodes[i] = (Integer)codev.get(i);
            }
            return epsgCodes;
        }
        String crs = coord.getCrs((Element)attrOrDomainDef);
        if (crs != null) {
            Map<Element, Element> srsMapping;
            Element alternativeAttrOrDomainDef;
            if (srsModelAssignment != null && (alternativeAttrOrDomainDef = (srsMapping = TransferFromIli.getSrsMappingToAlternate((TransferDescription)attrOrDomainDef.getContainer(TransferDescription.class), srsModelAssignment)).get(attrOrDomainDef)) != null) {
                CoordType alternativeCoord = null;
                if (alternativeAttrOrDomainDef instanceof AttributeDef) {
                    Type attrType2 = ((AttributeDef)alternativeAttrOrDomainDef).getDomain();
                    if (attrType2 instanceof TypeAlias) {
                        alternativeAttrOrDomainDef = ((TypeAlias)attrType2).getAliasing();
                        alternativeCoord = (CoordType)((Domain)alternativeAttrOrDomainDef).getType();
                    } else {
                        alternativeCoord = (CoordType)attrType2;
                    }
                } else {
                    alternativeCoord = (CoordType)((Domain)alternativeAttrOrDomainDef).getType();
                }
                String alternativeCrs = alternativeCoord.getCrs(alternativeAttrOrDomainDef);
                if (alternativeCrs == null) {
                    throw new IllegalArgumentException("missing CRS definition " + alternativeAttrOrDomainDef.getScopedName());
                }
                int[] epsgCodes = new int[]{TransferFromIli.parseEpsgCode(crs), TransferFromIli.parseEpsgCode(alternativeCrs)};
                return epsgCodes;
            }
            int[] epsgCodes = new int[]{TransferFromIli.parseEpsgCode(crs)};
            return epsgCodes;
        }
        if (defaultCrsCode == null) {
            return null;
        }
        int[] epsgCodes = new int[]{defaultCrsCode};
        return epsgCodes;
    }

    public static Map<Element, Element> getSrsMappingToOriginal(TransferDescription td, String srsModelAssignment) {
        if (td.getTransientMetaValue(SRS_MAPPING_TO_ORIGINAL) == null) {
            TransferFromIli.initSrsMapping(td, srsModelAssignment);
        }
        return (Map)td.getTransientMetaValue(SRS_MAPPING_TO_ORIGINAL);
    }

    public static Map<Element, Element> getSrsMappingToAlternate(TransferDescription td, String srsModelAssignment) {
        if (td.getTransientMetaValue(SRS_MAPPING_TO_ALTERNATE) == null) {
            TransferFromIli.initSrsMapping(td, srsModelAssignment);
        }
        return (Map)td.getTransientMetaValue(SRS_MAPPING_TO_ALTERNATE);
    }

    private static void initSrsMapping(TransferDescription td, String srsModelAssignment) {
        String[] models = srsModelAssignment.split("=");
        Model originalModel = (Model)td.getElement(models[0]);
        Model alternateModel = (Model)td.getElement(models[1]);
        HashMap<Element, Element> map2originalModel = new HashMap<Element, Element>();
        TransferFromIli.setupSrsTranslation(map2originalModel, (Element)alternateModel, (Element)originalModel);
        td.setTransientMetaValue(SRS_MAPPING_TO_ORIGINAL, map2originalModel);
        HashMap<Element, Element> map2alternateModel = new HashMap<Element, Element>();
        TransferFromIli.setupSrsTranslation(map2alternateModel, (Element)originalModel, (Element)alternateModel);
        td.setTransientMetaValue(SRS_MAPPING_TO_ALTERNATE, map2alternateModel);
    }

    private static void setupSrsTranslation(Map<Element, Element> mapping, Element srcEle, Element destEle) {
        mapping.put(srcEle, destEle);
        if (destEle instanceof Container) {
            Iterator destIt = ((Container)destEle).iterator();
            Iterator srcIt = ((Container)srcEle).iterator();
            while (destIt.hasNext()) {
                TransferFromIli.setupSrsTranslation(mapping, (Element)srcIt.next(), (Element)destIt.next());
            }
        }
    }

    public static int parseEpsgCode(String crs) {
        String[] crsv = crs.split(":");
        String auth = crsv[0];
        if (!auth.equals(EPSG)) {
            throw new IllegalArgumentException("unexpected SRS authority <" + auth + ">");
        }
        return Integer.parseInt(crsv[1]);
    }

    @Deprecated
    public static int getEpsgCode(AttributeDef attr, Map<String, String> genericDomains, Integer defaultCrsCode) {
        AttributeDef attrOrDomainDef = attr;
        Type attrType = attr.getDomain();
        Domain coordDomain = null;
        if (attrType instanceof TypeAlias && (attrType = ((Domain)(attrOrDomainDef = ((TypeAlias)attrType).getAliasing())).getType()) instanceof CoordType) {
            coordDomain = (Domain)attrOrDomainDef;
        }
        CoordType coord = null;
        if (attrType instanceof CoordType) {
            coord = (CoordType)attrType;
        } else if (attrType instanceof LineType && (coordDomain = ((LineType)attrType).getControlPointDomain()) != null) {
            attrOrDomainDef = coordDomain;
            coord = (CoordType)coordDomain.getType();
        }
        if (coord == null) {
            throw new IllegalArgumentException(attr.getScopedName() + " is not a geometry attribute");
        }
        if (coord.isGeneric()) {
            Domain concreteCoordDomain = ((Model)attr.getContainer(Model.class)).mapGenericDomain(coordDomain, genericDomains);
            String crs = ((CoordType)concreteCoordDomain.getType()).getCrs((Element)concreteCoordDomain);
            if (crs == null) {
                // empty if block
            }
            int epsgCode = TransferFromIli.parseEpsgCode(crs);
            return epsgCode;
        }
        String crs = coord.getCrs((Element)attrOrDomainDef);
        if (crs != null) {
            int epsgCode = TransferFromIli.parseEpsgCode(crs);
            return epsgCode;
        }
        if (defaultCrsCode == null) {
            throw new IllegalArgumentException("no CRS defined for " + attr.getScopedName());
        }
        return defaultCrsCode;
    }

    public static int getEpsgCode(Viewable aclass, AttributeDef attr, Map<String, String> genericDomains, Integer defaultCrsCode) {
        AttributeDef attrOrDomainDef = attr = TransferFromIli.getAttribute(aclass, attr.getName());
        Type attrType = attr.getDomain();
        Domain coordDomain = null;
        if (attrType instanceof TypeAlias && (attrType = ((Domain)(attrOrDomainDef = ((TypeAlias)attrType).getAliasing())).getType()) instanceof CoordType) {
            coordDomain = (Domain)attrOrDomainDef;
        }
        CoordType coord = null;
        if (attrType instanceof CoordType) {
            coord = (CoordType)attrType;
        } else if (attrType instanceof LineType && (coordDomain = ((LineType)attrType).getControlPointDomain()) != null) {
            attrOrDomainDef = coordDomain;
            coord = (CoordType)coordDomain.getType();
        }
        if (coord == null) {
            throw new IllegalArgumentException(attr.getScopedName() + " is not a geometry attribute");
        }
        if (coord.isGeneric()) {
            Domain concreteCoordDomain = ((Model)attr.getContainer(Model.class)).mapGenericDomain(coordDomain, genericDomains);
            String crs = ((CoordType)concreteCoordDomain.getType()).getCrs((Element)concreteCoordDomain);
            if (crs == null) {
                // empty if block
            }
            int epsgCode = TransferFromIli.parseEpsgCode(crs);
            return epsgCode;
        }
        String crs = coord.getCrs((Element)attrOrDomainDef);
        if (crs != null) {
            int epsgCode = TransferFromIli.parseEpsgCode(crs);
            return epsgCode;
        }
        if (defaultCrsCode == null) {
            throw new IllegalArgumentException("no CRS defined for " + attr.getScopedName());
        }
        return defaultCrsCode;
    }

    private static AttributeDef getAttribute(Viewable aclass, String name) {
        Iterator attri = aclass.getAttributesAndRoles2();
        while (attri.hasNext()) {
            ViewableTransferElement prop = (ViewableTransferElement)attri.next();
            if (!(prop.obj instanceof AttributeDef) || !((AttributeDef)prop.obj).getName().equals(name)) continue;
            return (AttributeDef)prop.obj;
        }
        return null;
    }
}

