/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.base;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.ErrorTracker;
import ch.ehi.basics.logging.LogEvent;
import ch.ehi.basics.logging.LogListener;
import ch.ehi.basics.logging.StdListener;
import ch.ehi.basics.logging.StdLogEvent;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.basics.view.GenericFileFilter;
import ch.ehi.ili2db.base.DbIdGen;
import ch.ehi.ili2db.base.GeodbConnection;
import ch.ehi.ili2db.base.Ili2dbException;
import ch.ehi.ili2db.base.Ili2dbLibraryInit;
import ch.ehi.ili2db.base.Ili2dbLibraryInitNull;
import ch.ehi.ili2db.converter.ConverterException;
import ch.ehi.ili2db.converter.SqlColumnConverter;
import ch.ehi.ili2db.dbmetainfo.DbExtMetaInfo;
import ch.ehi.ili2db.fromili.CustomMapping;
import ch.ehi.ili2db.fromili.CustomMappingNull;
import ch.ehi.ili2db.fromili.IliFromDb;
import ch.ehi.ili2db.fromili.ModelElementSelector;
import ch.ehi.ili2db.fromili.TransferFromIli;
import ch.ehi.ili2db.fromxtf.BasketStat;
import ch.ehi.ili2db.fromxtf.ClassStat;
import ch.ehi.ili2db.fromxtf.TransferFromXtf;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2db.mapping.NameMapping;
import ch.ehi.ili2db.mapping.TrafoConfig;
import ch.ehi.ili2db.mapping.Viewable2TableMapper;
import ch.ehi.ili2db.mapping.Viewable2TableMapping;
import ch.ehi.ili2db.metaattr.MetaAttrUtility;
import ch.ehi.ili2db.toxtf.TransferToXtf;
import ch.ehi.sqlgen.DbUtility;
import ch.ehi.sqlgen.generator.Generator;
import ch.ehi.sqlgen.generator.GeneratorDriver;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTableName;
import ch.interlis.ili2c.Main;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Ili2cMetaAttrs;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ilirepository.IliFiles;
import ch.interlis.iom_j.iligml.Iligml10Writer;
import ch.interlis.iom_j.iligml.Iligml20Writer;
import ch.interlis.iom_j.itf.ItfReader;
import ch.interlis.iom_j.itf.ItfReader2;
import ch.interlis.iom_j.itf.ItfWriter;
import ch.interlis.iom_j.itf.ItfWriter2;
import ch.interlis.iom_j.xtf.Xtf24Reader;
import ch.interlis.iom_j.xtf.XtfModel;
import ch.interlis.iom_j.xtf.XtfReader;
import ch.interlis.iom_j.xtf.XtfWriter;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox.IoxWriter;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox_j.IoxIliReader;
import ch.interlis.iox_j.logging.FileLogger;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.logging.StdLogger;
import ch.interlis.iox_j.logging.XtfErrorsLogger;
import ch.interlis.iox_j.utility.IoxUtility;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipFile;

public class Ili2db {
    public static final String XTF = "%XTF";
    public static final String XTF_DIR = "%XTF_DIR";
    public static final String JAR_DIR = "%JAR_DIR";
    public static final String ILI_FROM_DB = "%ILI_FROM_DB";
    private static final String SETTINGS_FILE = System.getProperty("user.home") + "/.ili2db";
    public static final String SETTING_DIRUSED = "ch.ehi.ili2db.dirused";
    public static final char NO_BREAK_SPACE = '\u00a0';

    public static void readAppSettings(Settings settings) {
        File file = new File(SETTINGS_FILE);
        try {
            if (file.exists()) {
                settings.load(file);
            }
        }
        catch (IOException ex) {
            EhiLogger.logError((String)("failed to load settings from file " + SETTINGS_FILE), (Throwable)ex);
        }
    }

    public static void writeAppSettings(Settings settings) {
        File file = new File(SETTINGS_FILE);
        try {
            settings.store(file, "ili2db settings");
        }
        catch (IOException ex) {
            EhiLogger.logError((String)("failed to settings settings to file " + SETTINGS_FILE), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readSettingsFromDb(Config config) throws Ili2dbException {
        boolean connectionFromExtern = config.getJdbcConnection() != null;
        String dburl = config.getDburl();
        String dbusr = config.getDbusr();
        String dbpwd = config.getDbpwd();
        if (!connectionFromExtern && dburl == null) {
            EhiLogger.logError((String)"no dburl given");
            return;
        }
        if (dbusr == null) {
            dbusr = "";
        }
        if (dbpwd == null) {
            dbpwd = "";
        }
        if (!connectionFromExtern) {
            String jdbcDriver = config.getJdbcDriver();
            if (jdbcDriver == null) {
                EhiLogger.logError((String)"no JDBC driver given");
                return;
            }
            if (jdbcDriver.equals("ch.ehi.ili2geodb.jdbc.GeodbDriver")) {
                return;
            }
            try {
                Class.forName(jdbcDriver);
            }
            catch (Exception ex) {
                EhiLogger.logError((String)"failed to load JDBC driver", (Throwable)ex);
                return;
            }
            Ili2dbLibraryInit ao = null;
            try {
                ao = Ili2db.getInitStrategy(config);
                ao.init();
            }
            finally {
                if (ao != null) {
                    ao.end();
                }
            }
        }
        CustomMapping customMapping = Ili2db.getCustomMappingStrategy(config);
        Connection conn = null;
        String url = dburl;
        try {
            conn = connectionFromExtern ? config.getJdbcConnection() : Ili2db.connect(url, dbusr, dbpwd, config, customMapping);
            customMapping.postConnect(conn, config);
            TransferFromIli.readSettings(conn, config, config.getDbschema(), customMapping);
            return;
        }
        catch (SQLException e) {
            EhiLogger.logError((Throwable)e);
            return;
        }
        catch (IOException e) {
            EhiLogger.logError((Throwable)e);
            return;
        }
        finally {
            if (!connectionFromExtern && conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
                finally {
                    config.setJdbcConnection(null);
                    conn = null;
                }
            }
        }
    }

    public static void run(Config config, String appHome) throws Ili2dbException {
        if (config.getFunction() == 1) {
            Ili2db.runUpdate(config, appHome, 1);
        } else if (config.getFunction() == 8) {
            Ili2db.runExport(config, appHome, 8);
        } else if (config.getFunction() == 4) {
            Ili2db.runUpdate(config, appHome, 4);
        } else if (config.getFunction() == 6) {
            Ili2db.runUpdate(config, appHome, 6);
        } else if (config.getFunction() == 5) {
            Ili2db.runUpdate(config, appHome, 5);
        } else if (config.getFunction() == 3) {
            Ili2db.runExport(config, appHome, 3);
        } else if (config.getFunction() == 2 || config.getFunction() == 7) {
            Ili2db.runSchemaImport(config, appHome);
        } else {
            throw new Ili2dbException("function not supported");
        }
    }

    public static void runImport(Config config, String appHome) throws Ili2dbException {
        Ili2db.runUpdate(config, appHome, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void runUpdate(Config config, String appHome, int function) throws Ili2dbException {
        logfile = null;
        xtflog = null;
        if (config.getLogfile() != null) {
            logfile = new FileLogger(new File(config.getLogfile()));
            EhiLogger.getInstance().addListener((LogListener)logfile);
        }
        if ((xtflogFilename = config.getXtfLogfile()) != null) {
            f = new File(xtflogFilename);
            try {
                if (!Ili2db.isWriteable(f)) {
                    throw new Ili2dbException("failed to write to logfile <" + f.getPath() + ">");
                }
                xtflog = new XtfErrorsLogger(f, config.getSender());
                EhiLogger.getInstance().addListener((LogListener)xtflog);
            }
            catch (IOException e) {
                throw new Ili2dbException("failed to write to logfile <" + f.getPath() + ">", e);
            }
        }
        logStderr = new StdLogger(config.getLogfile());
        EhiLogger.getInstance().addListener((LogListener)logStderr);
        EhiLogger.getInstance().removeListener((LogListener)StdListener.getInstance());
        try {
            block186: {
                block183: {
                    block184: {
                        connectionFromExtern = config.getJdbcConnection() != null;
                        Ili2db.logGeneralInfo(config);
                        zipXtfEntry = null;
                        zipFile = null;
                        inputFilename = config.getXtffile();
                        if (function == 5) {
                            if (config.getDatasetName() == null) {
                                throw new Ili2dbException("no datasetName given");
                            }
                        } else if (function == 8) {
                            if (config.getDatasetName() == null) {
                                throw new Ili2dbException("no datasetName given");
                            }
                        } else {
                            if (inputFilename == null) {
                                throw new Ili2dbException("no xtf-file given");
                            }
                            if (GenericFileFilter.getFileExtension((String)inputFilename).toLowerCase().equals("zip")) {
                                try {
                                    zipFile = new ZipFile(inputFilename);
                                }
                                catch (IOException ex) {
                                    throw new Ili2dbException(ex);
                                }
                                filei = zipFile.entries();
                                while (filei.hasMoreElements()) {
                                    zipEntry = filei.nextElement();
                                    ext = GenericFileFilter.getFileExtension((String)zipEntry.getName()).toLowerCase();
                                    if (ext == null || !ext.equals("xml") && !ext.equals("xtf") && !ext.equals("itf")) continue;
                                    zipXtfEntry = zipEntry;
                                    break;
                                }
                                if (zipXtfEntry == null) {
                                    throw new Ili2dbException("no xtf/itf-file in zip-archive " + zipFile.getName());
                                }
                            }
                        }
                        if ((modeldir = config.getModeldir()) == null) {
                            throw new Ili2dbException("no modeldir given");
                        }
                        EhiLogger.traceState((String)("modeldir <" + modeldir + ">"));
                        iliVersion = null;
                        modelv = new Configuration();
                        if (function != 5) {
                            models = config.getModels();
                            if (models == null) {
                                throw new Ili2dbException("no models given");
                            }
                            EhiLogger.traceState((String)("models <" + models + ">"));
                            modelnames = Ili2db.getModelNames(models);
                            for (modeli = 0; modeli < modelnames.length; ++modeli) {
                                m = modelnames[modeli];
                                if (m.equals("%XTF")) {
                                    if (zipXtfEntry != null) {
                                        try {
                                            in = zipFile.getInputStream(zipXtfEntry);
                                            m = Ili2db.getModelFromXtf(in, zipXtfEntry.getName());
                                            if (m == null) continue;
                                            modelv.addFileEntry(new FileEntry(m, 1));
                                            continue;
                                        }
                                        catch (IOException ex) {
                                            throw new Ili2dbException(ex);
                                        }
                                    }
                                    modelsFromXtf = null;
                                    try {
                                        modelsFromXtf = IoxUtility.getModels((File)new File(inputFilename));
                                        if (iliVersion == null) {
                                            iliVersion = IoxUtility.getModelVersion((String[])new String[]{inputFilename}, (LogEventFactory)new LogEventFactory());
                                        }
                                    }
                                    catch (IoxException e) {
                                        throw new Ili2dbException(e);
                                    }
                                    for (String modelFromXtf : modelsFromXtf) {
                                        modelv.addFileEntry(new FileEntry(modelFromXtf, 1));
                                    }
                                    continue;
                                }
                                modelv.addFileEntry(new FileEntry(m, 1));
                            }
                        }
                        dburl = config.getDburl();
                        dbusr = config.getDbusr();
                        dbpwd = config.getDbpwd();
                        if (!connectionFromExtern && dburl == null) {
                            throw new Ili2dbException("no dburl given");
                        }
                        if (dbusr == null) {
                            dbusr = "";
                        }
                        if (dbpwd == null) {
                            dbpwd = "";
                        }
                        if ((dbschema = config.getDbschema()) != null) {
                            EhiLogger.logState((String)("dbschema <" + dbschema + ">"));
                        }
                        if ((geometryConverter = config.getGeometryConverter()) == null) {
                            throw new Ili2dbException("no geoemtry converter given");
                        }
                        ddlGenerator = config.getDdlGenerator();
                        if (ddlGenerator == null) {
                            throw new Ili2dbException("no DDL generator given");
                        }
                        idGenerator = config.getIdGenerator();
                        if (idGenerator == null) {
                            throw new Ili2dbException("no ID generator given");
                        }
                        if (!connectionFromExtern) {
                            jdbcDriver = config.getJdbcDriver();
                            if (jdbcDriver == null) {
                                throw new Ili2dbException("no JDBC driver given");
                            }
                            try {
                                Class.forName(jdbcDriver);
                            }
                            catch (Exception ex) {
                                throw new Ili2dbException("failed to load JDBC driver", ex);
                            }
                        }
                        customMapping = Ili2db.getCustomMappingStrategy(config);
                        conn = null;
                        url = dburl;
                        errs = null;
                        try {
                            conn = connectionFromExtern != false ? config.getJdbcConnection() : Ili2db.connect(url, dbusr, dbpwd, config, customMapping);
                            customMapping.postConnect(conn, config);
                        }
                        catch (SQLException ex) {
                            throw new Ili2dbException("failed to get db connection", ex);
                        }
                        catch (IOException e) {
                            throw new Ili2dbException("failed to get db connection", e);
                        }
                        Ili2db.logDBVersion(conn);
                        if (!connectionFromExtern) {
                            try {
                                conn.setAutoCommit(false);
                            }
                            catch (SQLException ex) {
                                throw new Ili2dbException("failed to switch off auto-commit", ex);
                            }
                        }
                        customMapping.prePreScript(conn, config);
                        if (config.getPreScript() != null) {
                            try {
                                DbUtility.executeSqlScript((Connection)conn, (InputStreamReader)new FileReader(config.getPreScript()));
                                EhiLogger.logState((String)"run update pre-script...");
                            }
                            catch (FileNotFoundException e) {
                                throw new Ili2dbException("update pre-script statements failed", e);
                            }
                        }
                        if (function == 1 && config.getDbschema() != null && !DbUtility.schemaExists((Connection)conn, (String)config.getDbschema())) {
                            DbUtility.createSchema((Connection)conn, (String)config.getDbschema());
                        }
                        if (function == 5) {
                            createBasketCol = "readWrite".equals(config.getBasketHandling());
                            if (!createBasketCol) {
                                throw new Ili2dbException("delete requires column T_basket");
                            }
                            datasetName = config.getDatasetName();
                            datasetId = Ili2db.getDatasetId(datasetName, conn, config);
                            if (datasetId == null) {
                                throw new Ili2dbException("dataset <" + datasetName + "> doesn't exist");
                            }
                            Ili2db.getBasketSqlIdsFromDatasetId(datasetId, modelv, conn, config);
                        } else if (function == 1 && (datasetName = config.getDatasetName()) != null) {
                            if (customMapping.tableExists(conn, new DbTableName(config.getDbschema(), "T_ILI2DB_DATASET")) && (datasetId = Ili2db.getDatasetId(datasetName, conn, config)) != null) {
                                throw new Ili2dbException("dataset <" + datasetName + "> already exists");
                            }
                            createBasketCol = "readWrite".equals(config.getBasketHandling());
                            if (!createBasketCol) {
                                throw new Ili2dbException("import with dataset name requires column T_basket");
                            }
                        }
                        if (modelv.getSizeFileEntry() == 0) {
                            throw new Ili2dbException("no models given");
                        }
                        Ili2db.setupIli2cPathmap(config, appHome, inputFilename, conn, customMapping);
                        ili2cMetaAttrs = new Ili2cMetaAttrs();
                        ili2cConfig = null;
                        try {
                            ili2cConfig = (Configuration)modelv.clone();
                        }
                        catch (CloneNotSupportedException e1) {
                            throw new Ili2dbException(e1);
                        }
                        Ili2db.setupIli2cMetaAttrs(ili2cMetaAttrs, config, ili2cConfig);
                        EhiLogger.logState((String)"compile models...");
                        ili2cConfig.setAutoCompleteModelList(true);
                        ili2cConfig.setGenerateWarnings(false);
                        if (iliVersion != null) {
                            config.setValue("ch.interlis.ili2c.iliLangVersion", iliVersion);
                        }
                        if ((td = Main.runCompiler((Configuration)ili2cConfig, (Settings)config, (Ili2cMetaAttrs)ili2cMetaAttrs)) == null) {
                            throw new Ili2dbException("compiler failed");
                        }
                        if (config.getCreateMetaInfo() && customMapping.tableExists(conn, new DbTableName(config.getDbschema(), "T_ILI2DB_META_ATTRS"))) {
                            MetaAttrUtility.addMetaAttrsFromDb(td, conn, config.getDbschema());
                        }
                        if (config.getIliMetaAttrsFile() != null) {
                            if (config.getCreateMetaInfo()) {
                                try {
                                    EhiLogger.logState((String)"import meta-attributes from toml file");
                                    MetaAttrUtility.addMetaAttrsFromConfigFile(td, new File(config.getIliMetaAttrsFile()));
                                }
                                catch (IOException e) {
                                    throw new Ili2dbException("import meta-attributes failed", e);
                                }
                            } else {
                                throw new Ili2dbException("import meta-attributes requires --createMetaInfo option");
                            }
                        }
                        if (config.getModelSrsCode() != null) {
                            Ili2db.addModellSrsCode(td, config.getModelSrsCode());
                        }
                        mapping = new NameMapping(td, config);
                        if (customMapping.tableExists(conn, new DbTableName(config.getDbschema(), "T_ILI2DB_CLASSNAME"))) {
                            mapping.readTableMappingTable(conn, config.getDbschema());
                        }
                        if (customMapping.tableExists(conn, new DbTableName(config.getDbschema(), "T_ILI2DB_ATTRNAME"))) {
                            mapping.readAttrMappingTable(conn, config.getDbschema());
                        }
                        trafoConfig = new TrafoConfig();
                        trafoConfig.readTrafoConfig(conn, config.getDbschema(), customMapping);
                        ms = new ModelElementSelector();
                        modelNames = new ArrayList<String>();
                        for (modeli = 0; modeli < modelv.getSizeFileEntry(); ++modeli) {
                            if (modelv.getFileEntry(modeli).getKind() != 1) continue;
                            m = modelv.getFileEntry(modeli).getFilename();
                            EhiLogger.traceState((String)("use model " + m));
                            modelNames.add(m);
                        }
                        eles = ms.getModelElements(modelNames, td, td.getIli1Format() != null && config.getDoItfLineTables() != false, "multiTable".equals(config.getCreateEnumDefs()), config);
                        class2wrapper = Viewable2TableMapper.getClass2TableMapping(config, trafoConfig, eles, mapping);
                        gen = null;
                        try {
                            gen = (Generator)Class.forName(ddlGenerator).newInstance();
                        }
                        catch (Exception ex) {
                            throw new Ili2dbException("failed to load/create DDL generator", ex);
                        }
                        idGen = null;
                        try {
                            idGen = (DbIdGen)Class.forName(idGenerator).newInstance();
                        }
                        catch (Exception ex) {
                            throw new Ili2dbException("failed to load/create ID generator", ex);
                        }
                        idGen.init(config.getDbschema(), config);
                        geomConverter = null;
                        try {
                            geomConverter = (SqlColumnConverter)Class.forName(geometryConverter).newInstance();
                        }
                        catch (Exception ex) {
                            throw new Ili2dbException("failed to load/create geometry converter", ex);
                        }
                        geomConverter.setup(conn, config);
                        idGen.initDb(conn, dbusr);
                        if (function != 1 || !config.isDoImplicitSchemaImport()) ** GOTO lbl300
                        EhiLogger.logState((String)"create table structure, if not existing...");
                        idGen.initDbDefs(gen);
                        trsfFromIli = new TransferFromIli();
                        try {
                            schema = trsfFromIli.doit(td, eles, mapping, config, idGen, trafoConfig, class2wrapper, customMapping);
                        }
                        catch (Ili2dbException e) {
                            throw new Ili2dbException("mapping of ili-classes to sql-tables failed", e);
                        }
                        if (schema != null) break block183;
                        if (connectionFromExtern || conn == null) break block184;
                        try {
                            conn.close();
                        }
                        catch (SQLException ex) {
                            EhiLogger.logError((Throwable)ex);
                        }
                        finally {
                            config.setJdbcConnection(null);
                            conn = null;
                        }
                    }
                    if (errs != null) {
                        EhiLogger.getInstance().removeListener((LogListener)errs);
                        errs = null;
                    }
                    return;
                }
                try {
                    trsfFromIli.addBasketsTable(schema);
                    if (config.isCreateImportTabs()) {
                        trsfFromIli.addImportsTable(schema);
                    }
                    TransferFromIli.addInheritanceTable(schema, config);
                    TransferFromIli.addSettingsTable(schema);
                    TransferFromIli.addTrafoConfigTable(schema);
                    TransferFromIli.addModelsTable(schema, config);
                    trsfFromIli.addEnumTable(schema);
                    TransferFromIli.addTableMappingTable(schema, config);
                    TransferFromIli.addAttrMappingTable(schema, config);
                    DbExtMetaInfo.addMetaInfoTables(schema);
                    idGen.addMappingTable(schema);
                    if (config.getCreateMetaInfo()) {
                        MetaAttrUtility.addMetaAttributesTable(schema);
                    }
                    drv = new GeneratorDriver(gen);
                    drv.visitSchema((Settings)config, schema);
                    insertCollector = config.getCreatescript() != null ? (GeneratorJdbc)gen : null;
                    mapping.updateTableMappingTable(insertCollector, conn, config.getDbschema());
                    mapping.updateAttrMappingTable(insertCollector, conn, config.getDbschema());
                    trafoConfig.updateTrafoConfig(insertCollector, conn, config.getDbschema(), customMapping);
                    trsfFromIli.updateInheritanceTable(insertCollector, conn, config.getDbschema());
                    trsfFromIli.updateEnumTable(insertCollector, conn);
                    trsfFromIli.updateMetaInfoTables(insertCollector, conn);
                    TransferFromIli.addModels(insertCollector, conn, td, config.getDbschema(), customMapping, false);
                    if (!config.isConfigReadFromDb()) {
                        TransferFromIli.updateSettings(insertCollector, conn, config, config.getDbschema());
                    }
                    if (config.getCreateMetaInfo()) {
                        MetaAttrUtility.updateMetaAttributesTable(insertCollector, conn, config.getDbschema(), td);
                        MetaAttrUtility.addMetaAttrsFromDb(td, conn, config.getDbschema());
                    }
                    if ((createscript = config.getCreatescript()) != null && gen instanceof GeneratorJdbc) {
                        Ili2db.writeScript(createscript, ((GeneratorJdbc)gen).iteratorCreateLines());
                    }
                    if ((dropscript = config.getDropscript()) != null && gen instanceof GeneratorJdbc) {
                        Ili2db.writeScript(dropscript, ((GeneratorJdbc)gen).iteratorDropLines());
                    }
                    {
                        catch (IOException ex) {
                            throw new Ili2dbException(ex);
                        }
                    }
lbl300:
                    // 2 sources

                    EhiLogger.logState((String)"process data file...");
                    stat = new HashMap<String, BasketStat>();
                    errs = new ErrorTracker();
                    EhiLogger.getInstance().addListener((LogListener)errs);
                    if (zipXtfEntry != null) {
                        ioxReader = null;
                        in = null;
                        try {
                            EhiLogger.logState((String)("data <" + inputFilename + ":" + zipXtfEntry.getName() + ">"));
                            in = zipFile.getInputStream(zipXtfEntry);
                            if (Ili2db.isItfFilename(zipXtfEntry.getName())) {
                                if (config.getDoItfLineTables()) {
                                    ioxReader = new ItfReader(in);
                                    ((ItfReader)ioxReader).setModel(td);
                                } else {
                                    ioxReader = new ItfReader2(in, config.isSkipGeometryErrors());
                                    ((ItfReader2)ioxReader).setModel(td);
                                }
                            } else {
                                ioxReader = new XtfReader(in);
                            }
                            Ili2db.transferFromXtf(conn, ioxReader, function, mapping, td, dbusr, geomConverter, idGen, config, stat, trafoConfig, class2wrapper, customMapping);
                        }
                        catch (IOException ex) {
                            throw new Ili2dbException(ex);
                        }
                        catch (IoxException ex) {
                            throw new Ili2dbException(ex);
                        }
                        finally {
                            if (ioxReader != null) {
                                try {
                                    ioxReader.close();
                                }
                                catch (IoxException e) {
                                    throw new Ili2dbException(e);
                                }
                                ioxReader = null;
                            }
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {
                                    throw new Ili2dbException(e);
                                }
                                in = null;
                            }
                        }
                        attachmentKey = config.getAttachmentKey();
                        attachmentsBase = config.getAttachmentsPath();
                        if (attachmentsBase != null) {
                            basePath = new File(attachmentsBase, attachmentKey);
                            filei = zipFile.entries();
                            while (filei.hasMoreElements()) {
                                zipEntry = filei.nextElement();
                                if (zipXtfEntry.getName().equals(zipEntry.getName())) continue;
                                destFile = new File(basePath, zipEntry.getName());
                                parent = destFile.getAbsoluteFile().getParentFile();
                                if (!parent.exists() && !parent.mkdirs()) {
                                    throw new Ili2dbException("failed to create " + parent.getAbsolutePath());
                                }
                                try {
                                    Ili2db.copyStream(destFile, zipFile.getInputStream(zipEntry));
                                }
                                catch (IOException ex) {
                                    throw new Ili2dbException("failed to save attachment " + zipEntry.getName(), ex);
                                }
                            }
                        }
                    } else {
                        ioxReader = null;
                        try {
                            if (function != 5) {
                                EhiLogger.logState((String)("data <" + inputFilename + ">"));
                                if (Ili2db.isItfFilename(inputFilename)) {
                                    config.setValue("ch.interlis.iox_j.validator.doItfOidPerTable", "doItfOidPerTable");
                                    if (config.getDoItfLineTables()) {
                                        ioxReader = new ItfReader(new File(inputFilename));
                                        ((ItfReader)ioxReader).setModel(td);
                                        ((ItfReader)ioxReader).setBidPrefix(config.getDatasetName());
                                    } else {
                                        ioxReader = new ItfReader2(new File(inputFilename), config.isSkipGeometryErrors());
                                        ((ItfReader2)ioxReader).setModel(td);
                                        ((ItfReader2)ioxReader).setBidPrefix(config.getDatasetName());
                                    }
                                } else {
                                    ioxReader = Xtf24Reader.createReader((File)new File(inputFilename));
                                    if (ioxReader instanceof IoxIliReader) {
                                        ((IoxIliReader)ioxReader).setModel(td);
                                    }
                                }
                            }
                            Ili2db.transferFromXtf(conn, ioxReader, function, mapping, td, dbusr, geomConverter, idGen, config, stat, trafoConfig, class2wrapper, customMapping);
                        }
                        catch (IoxException e) {
                            throw new Ili2dbException(e);
                        }
                        finally {
                            if (ioxReader != null) {
                                try {
                                    ioxReader.close();
                                }
                                catch (IoxException e) {
                                    throw new Ili2dbException(e);
                                }
                                ioxReader = null;
                            }
                        }
                    }
                    if (config.getPostScript() != null) {
                        try {
                            DbUtility.executeSqlScript((Connection)conn, (InputStreamReader)new FileReader(config.getPostScript()));
                            EhiLogger.logState((String)"run update post-script...");
                        }
                        catch (FileNotFoundException e) {
                            throw new Ili2dbException("update post-script statements failed", e);
                        }
                    }
                    customMapping.postPostScript(conn, config);
                    functionTxt = "import";
                    if (function == 5) {
                        functionTxt = "delete";
                    } else if (function == 4) {
                        functionTxt = "update";
                    } else if (function == 6) {
                        functionTxt = "replace";
                    }
                    if (errs.hasSeenErrors()) {
                        if (!connectionFromExtern) {
                            try {
                                conn.rollback();
                            }
                            catch (SQLException e) {
                                EhiLogger.logError((String)"rollback failed", (Throwable)e);
                            }
                        }
                        throw new Ili2dbException("..." + functionTxt + " failed");
                    }
                    if (!connectionFromExtern) {
                        try {
                            conn.commit();
                        }
                        catch (SQLException e) {
                            EhiLogger.logError((String)"commit failed", (Throwable)e);
                            throw new Ili2dbException("..." + functionTxt + " failed");
                        }
                    }
                    Ili2db.logStatistics(td.getIli1Format() != null, stat);
                    EhiLogger.logState((String)("..." + functionTxt + " done"));
                    if (connectionFromExtern || conn == null) break block186;
                }
                catch (Throwable var51_90) {
                    if (!connectionFromExtern && conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException ex) {
                            EhiLogger.logError((Throwable)ex);
                        }
                        finally {
                            config.setJdbcConnection(null);
                            conn = null;
                        }
                    }
                    if (errs != null) {
                        EhiLogger.getInstance().removeListener(errs);
                        errs = null;
                    }
                    throw var51_90;
                }
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
                finally {
                    config.setJdbcConnection(null);
                    conn = null;
                }
            }
            if (errs != null) {
                EhiLogger.getInstance().removeListener((LogListener)errs);
                errs = null;
            }
        }
        catch (Ili2dbException ex) {
            if (logfile != null) {
                logfile.logEvent((LogEvent)new StdLogEvent(7, null, (Throwable)ex, null));
            }
            if (xtflog != null) {
                xtflog.logEvent((LogEvent)new StdLogEvent(7, null, (Throwable)ex, null));
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (logfile != null) {
                logfile.logEvent((LogEvent)new StdLogEvent(7, null, (Throwable)ex, null));
            }
            if (xtflog != null) {
                xtflog.logEvent((LogEvent)new StdLogEvent(7, null, (Throwable)ex, null));
            }
            throw ex;
        }
        finally {
            if (xtflog != null) {
                EhiLogger.getInstance().removeListener((LogListener)xtflog);
                xtflog.close();
                xtflog = null;
            }
            if (logfile != null) {
                EhiLogger.getInstance().removeListener((LogListener)logfile);
                logfile.close();
                logfile = null;
            }
            if (logStderr != null) {
                EhiLogger.getInstance().addListener((LogListener)StdListener.getInstance());
                EhiLogger.getInstance().removeListener((LogListener)logStderr);
            }
        }
    }

    private static void addModellSrsCode(TransferDescription td, String modelSrsCodeTxt) {
        String[] modelNameSrsCodes;
        for (String modelNameSrsCode : modelNameSrsCodes = modelSrsCodeTxt.split(";")) {
            String[] srsMapping = modelNameSrsCode.split("=");
            String modelName = srsMapping[0];
            String epsgCode = srsMapping[1];
            if (modelName == null || epsgCode == null) continue;
            Model model = (Model)td.getElement(modelName);
            if (model != null) {
                model.setMetaValue("CRS", "EPSG:" + epsgCode);
                continue;
            }
            EhiLogger.logAdaption((String)("SRS assignment to model ignored; unkonwn model <" + modelName + ">"));
        }
    }

    private static void setupIli2cMetaAttrs(Ili2cMetaAttrs ili2cMetaAttrs, Config config, Configuration modelv) {
        String srsModelAssignment;
        String ili2translation = config.getIli1Translation();
        if (ili2translation != null) {
            String[] modelNameMappings;
            for (String modelNameMapping : modelNameMappings = ili2translation.split(";")) {
                String[] modelNames = modelNameMapping.split("=");
                String translatedModelName = modelNames[0];
                String originLanguageModelName = modelNames[1];
                if (translatedModelName == null || originLanguageModelName == null) continue;
                ili2cMetaAttrs.setMetaAttrValue(translatedModelName, "ili2c.translationOf", originLanguageModelName);
                if (modelv == null) continue;
                modelv.addFileEntry(new FileEntry(originLanguageModelName, 1));
                modelv.addFileEntry(new FileEntry(translatedModelName, 1));
            }
        }
        if ((srsModelAssignment = config.getSrsModelAssignment()) != null) {
            String[] modelNames = srsModelAssignment.split("=");
            String originalSrsModelName = modelNames[0];
            String alternativeSrsModelName = modelNames[1];
            if (originalSrsModelName != null && alternativeSrsModelName != null && modelv != null) {
                modelv.addFileEntry(new FileEntry(originalSrsModelName, 1));
                modelv.addFileEntry(new FileEntry(alternativeSrsModelName, 1));
            }
        }
    }

    private static void logStatistics(boolean isIli1, Map<String, BasketStat> stat) {
        ArrayList<BasketStat> statv = new ArrayList<BasketStat>(stat.values());
        Collections.sort(statv, new Comparator<BasketStat>(){

            @Override
            public int compare(BasketStat b0, BasketStat b1) {
                int ret = b0.getDatasource().compareTo(b1.getDatasource());
                if (ret == 0 && (ret = b0.getTopic().compareTo(b1.getTopic())) == 0) {
                    ret = b0.getBasketId().compareTo(b1.getBasketId());
                }
                return ret;
            }
        });
        for (BasketStat basketStat : statv) {
            if (isIli1) {
                EhiLogger.logState((String)(basketStat.getDatasource() + ": " + basketStat.getTopic()));
            } else {
                EhiLogger.logState((String)(basketStat.getDatasource() + ": " + basketStat.getTopic() + " BID=" + basketStat.getBasketId()));
            }
            HashMap<String, ClassStat> objStat = basketStat.getObjStat();
            ArrayList<String> classv = new ArrayList<String>(objStat.keySet());
            Collections.sort(classv, new Comparator<String>(){

                @Override
                public int compare(String b0, String b1) {
                    int ret = b0.compareTo(b1);
                    return ret;
                }
            });
            for (String className : classv) {
                ClassStat classStat = objStat.get(className);
                String objCount = Long.toString(classStat.getObjcount());
                if (objCount.length() < 6) {
                    objCount = StringUtility.STRING((int)(6 - objCount.length()), (char)' ') + objCount;
                }
                EhiLogger.logState((String)(Character.toString('\u00a0') + objCount + " objects in CLASS " + className));
            }
        }
    }

    private static void copyStream(File outFile, InputStream in) throws IOException {
        int i;
        BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
        byte[] bt = new byte[1024];
        while ((i = in.read(bt)) != -1) {
            out.write(new String(bt, 0, i));
        }
        out.close();
    }

    @Deprecated
    public static Ili2dbLibraryInit getInitStrategy(Config config) throws Ili2dbException {
        String initClassName = config.getInitStrategy();
        if (initClassName == null) {
            return new Ili2dbLibraryInitNull();
        }
        Ili2dbLibraryInit init = null;
        try {
            init = (Ili2dbLibraryInit)Class.forName(initClassName).newInstance();
        }
        catch (Exception ex) {
            throw new Ili2dbException("failed to load/create init strategy", ex);
        }
        return init;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runSchemaImport(Config config, String appHome) throws Ili2dbException {
        String xtflogFilename;
        FileLogger logfile = null;
        XtfErrorsLogger xtflog = null;
        if (config.getLogfile() != null) {
            logfile = new FileLogger(new File(config.getLogfile()));
            EhiLogger.getInstance().addListener((LogListener)logfile);
        }
        if ((xtflogFilename = config.getXtfLogfile()) != null) {
            File f = new File(xtflogFilename);
            try {
                if (!Ili2db.isWriteable(f)) {
                    throw new Ili2dbException("failed to write to logfile <" + f.getPath() + ">");
                }
                xtflog = new XtfErrorsLogger(f, config.getSender());
                EhiLogger.getInstance().addListener((LogListener)xtflog);
            }
            catch (IOException e) {
                throw new Ili2dbException("failed to write to logfile <" + f.getPath() + ">", e);
            }
        }
        StdLogger logStderr = new StdLogger(config.getLogfile());
        EhiLogger.getInstance().addListener((LogListener)logStderr);
        EhiLogger.getInstance().removeListener((LogListener)StdListener.getInstance());
        boolean importToDb = config.getFunction() != 7;
        try {
            block116: {
                boolean connectionFromExtern = config.getJdbcConnection() != null;
                Ili2db.logGeneralInfo(config);
                Ili2dbLibraryInit ao = null;
                Connection conn = null;
                try {
                    String dropscript;
                    String createscript;
                    DbSchema schema;
                    TransferFromIli trsfFromIli;
                    TrafoConfig trafoConfig;
                    NameMapping mapping;
                    DbIdGen idGen;
                    Generator gen;
                    TransferDescription td;
                    CustomMapping customMapping;
                    String dbusr;
                    block115: {
                        Viewable2TableMapping class2wrapper;
                        List<Element> eles;
                        block114: {
                            String geometryConverter;
                            String dbschema;
                            String models;
                            ao = Ili2db.getInitStrategy(config);
                            ao.init();
                            Configuration modelv = new Configuration();
                            String xtffile = config.getXtffile();
                            String ilifile = null;
                            if (xtffile != null && xtffile.endsWith(".ili")) {
                                ilifile = xtffile;
                                modelv.addFileEntry(new FileEntry(ilifile, 1));
                            }
                            if ((models = config.getModels()) != null) {
                                String[] modelnames = models.split(";");
                                for (int modeli = 0; modeli < modelnames.length; ++modeli) {
                                    String m = modelnames[modeli];
                                    if (m == null || m.equals(XTF)) continue;
                                    modelv.addFileEntry(new FileEntry(m, 1));
                                }
                            }
                            if (modelv.getSizeFileEntry() == 0) {
                                throw new Ili2dbException("no models given");
                            }
                            String dburl = config.getDburl();
                            dbusr = config.getDbusr();
                            String dbpwd = config.getDbpwd();
                            if (!connectionFromExtern && dburl == null && importToDb) {
                                throw new Ili2dbException("no dburl given");
                            }
                            if (dbusr == null) {
                                dbusr = "";
                            }
                            if (dbpwd == null) {
                                dbpwd = "";
                            }
                            if ((dbschema = config.getDbschema()) != null) {
                                EhiLogger.logState((String)("dbschema <" + dbschema + ">"));
                            }
                            if ((geometryConverter = config.getGeometryConverter()) == null) {
                                throw new Ili2dbException("no geoemtry converter given");
                            }
                            String ddlGenerator = config.getDdlGenerator();
                            if (ddlGenerator == null) {
                                throw new Ili2dbException("no DDL generator given");
                            }
                            String idGenerator = config.getIdGenerator();
                            if (idGenerator == null) {
                                throw new Ili2dbException("no ID generator given");
                            }
                            if (!connectionFromExtern) {
                                String jdbcDriver = config.getJdbcDriver();
                                if (jdbcDriver == null) {
                                    throw new Ili2dbException("no JDBC driver given");
                                }
                                try {
                                    Class.forName(jdbcDriver);
                                }
                                catch (Exception ex) {
                                    throw new Ili2dbException("failed to load JDBC driver", ex);
                                }
                            }
                            customMapping = Ili2db.getCustomMappingStrategy(config);
                            String url = dburl;
                            if (importToDb) {
                                try {
                                    conn = connectionFromExtern ? config.getJdbcConnection() : Ili2db.connect(url, dbusr, dbpwd, config, customMapping);
                                    customMapping.postConnect(conn, config);
                                    Ili2db.logDBVersion(conn);
                                    if (!connectionFromExtern) {
                                        conn.setAutoCommit(false);
                                    }
                                }
                                catch (SQLException ex) {
                                    throw new Ili2dbException(ex);
                                }
                                catch (IOException e) {
                                    throw new Ili2dbException(e);
                                }
                            }
                            if (importToDb) {
                                customMapping.prePreScript(conn, config);
                            }
                            if (importToDb && config.getPreScript() != null) {
                                try {
                                    EhiLogger.logState((String)"run schemaImport pre-script...");
                                    DbUtility.executeSqlScript((Connection)conn, (InputStreamReader)new FileReader(config.getPreScript()));
                                }
                                catch (FileNotFoundException e) {
                                    throw new Ili2dbException("schemaImport pre-script statements failed", e);
                                }
                            }
                            Ili2db.setupIli2cPathmap(config, appHome, ilifile, conn, customMapping);
                            Ili2cMetaAttrs ili2cMetaAttrs = new Ili2cMetaAttrs();
                            Ili2db.setupIli2cMetaAttrs(ili2cMetaAttrs, config, modelv);
                            EhiLogger.logState((String)"compile models...");
                            modelv.setAutoCompleteModelList(true);
                            modelv.setGenerateWarnings(false);
                            td = Main.runCompiler((Configuration)modelv, (Settings)config, (Ili2cMetaAttrs)ili2cMetaAttrs);
                            if (td == null) {
                                throw new Ili2dbException("compiler failed");
                            }
                            if (config.getIliMetaAttrsFile() != null) {
                                if (config.getCreateMetaInfo()) {
                                    try {
                                        EhiLogger.logState((String)"import meta-attributes from toml file");
                                        MetaAttrUtility.addMetaAttrsFromConfigFile(td, new File(config.getIliMetaAttrsFile()));
                                    }
                                    catch (IOException e) {
                                        throw new Ili2dbException("import meta-attributes failed", e);
                                    }
                                } else {
                                    throw new Ili2dbException("import meta-attributes requires --createMetaInfo option");
                                }
                            }
                            if (config.getModelSrsCode() != null) {
                                Ili2db.addModellSrsCode(td, config.getModelSrsCode());
                            }
                            if (td.getIli1Format() != null) {
                                config.setItfTransferfile(true);
                            }
                            gen = null;
                            try {
                                gen = (Generator)Class.forName(ddlGenerator).newInstance();
                            }
                            catch (Exception ex) {
                                throw new Ili2dbException("failed to load/create DDL generator", ex);
                            }
                            if (config.getDbschema() != null) {
                                String sql;
                                if (importToDb) {
                                    if (!DbUtility.schemaExists((Connection)conn, (String)config.getDbschema())) {
                                        DbUtility.createSchema((Connection)conn, (String)config.getDbschema());
                                    }
                                } else if (gen instanceof GeneratorJdbc && (sql = customMapping.getCreateSchemaStmt(config.getDbschema())) != null) {
                                    GeneratorJdbc generatorJdbc = (GeneratorJdbc)gen;
                                    GeneratorJdbc generatorJdbc2 = (GeneratorJdbc)gen;
                                    generatorJdbc2.getClass();
                                    generatorJdbc.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt(generatorJdbc2, sql));
                                }
                            }
                            idGen = null;
                            try {
                                idGen = (DbIdGen)Class.forName(idGenerator).newInstance();
                            }
                            catch (Exception ex) {
                                throw new Ili2dbException("failed to load/create ID generator", ex);
                            }
                            idGen.init(config.getDbschema(), config);
                            mapping = new NameMapping(td, config);
                            if (importToDb) {
                                if (customMapping.tableExists(conn, new DbTableName(config.getDbschema(), "T_ILI2DB_CLASSNAME"))) {
                                    mapping.readTableMappingTable(conn, config.getDbschema());
                                }
                                if (customMapping.tableExists(conn, new DbTableName(config.getDbschema(), "T_ILI2DB_ATTRNAME"))) {
                                    mapping.readAttrMappingTable(conn, config.getDbschema());
                                }
                            }
                            trafoConfig = new TrafoConfig();
                            trafoConfig.readTrafoConfig(conn, config.getDbschema(), customMapping);
                            ModelElementSelector ms = new ModelElementSelector();
                            ArrayList<String> modelNames = new ArrayList<String>();
                            if (models != null) {
                                String[] modelnames = models.split(";");
                                for (int modeli = 0; modeli < modelnames.length; ++modeli) {
                                    String m = modelnames[modeli];
                                    if (m == null || m.equals(XTF)) continue;
                                    modelNames.add(m);
                                }
                            }
                            eles = ms.getModelElements(modelNames, td, td.getIli1Format() != null && config.getDoItfLineTables(), "multiTable".equals(config.getCreateEnumDefs()), config);
                            class2wrapper = Viewable2TableMapper.getClass2TableMapping(config, trafoConfig, eles, mapping);
                            SqlColumnConverter geomConverter = null;
                            try {
                                geomConverter = (SqlColumnConverter)Class.forName(geometryConverter).newInstance();
                            }
                            catch (Exception ex) {
                                throw new Ili2dbException("failed to load/create geometry converter", ex);
                            }
                            geomConverter.setup(conn, config);
                            if (importToDb) {
                                if (config.getDefaultSrsCode() != null && config.getDefaultSrsAuthority() != null) {
                                    try {
                                        if (geomConverter.getSrsid(config.getDefaultSrsAuthority(), config.getDefaultSrsCode(), conn) == null) {
                                            throw new Ili2dbException(config.getDefaultSrsAuthority() + "/" + config.getDefaultSrsCode() + " does not exist");
                                        }
                                        break block114;
                                    }
                                    catch (ConverterException ex) {
                                        throw new Ili2dbException("failed to query existence of SRS", ex);
                                    }
                                }
                                if (config.getModelSrsCode() != null && config.getDefaultSrsAuthority() != null) {
                                    String[] modelNameSrsCodes;
                                    String modelSrsCodeTxt = config.getModelSrsCode();
                                    for (String modelNameSrsCode : modelNameSrsCodes = modelSrsCodeTxt.split(";")) {
                                        String[] srsMapping = modelNameSrsCode.split("=");
                                        String modelName = srsMapping[0];
                                        String srsCode = srsMapping[1];
                                        if (modelName == null || srsCode == null) continue;
                                        try {
                                            if (geomConverter.getSrsid(config.getDefaultSrsAuthority(), srsCode, conn) != null) continue;
                                            throw new Ili2dbException(config.getDefaultSrsAuthority() + "/" + srsCode + " does not exist");
                                        }
                                        catch (ConverterException ex) {
                                            throw new Ili2dbException("failed to query existence of SRS", ex);
                                        }
                                    }
                                }
                            }
                        }
                        EhiLogger.logState((String)"create table structure, if not existing...");
                        try {
                            trsfFromIli = new TransferFromIli();
                            try {
                                schema = trsfFromIli.doit(td, eles, mapping, config, idGen, trafoConfig, class2wrapper, customMapping);
                            }
                            catch (Ili2dbException e) {
                                throw new Ili2dbException("mapping of ili-classes to sql-tables failed", e);
                            }
                            if (schema != null) break block115;
                            return;
                        }
                        catch (IOException ex) {
                            throw new Ili2dbException(ex);
                        }
                    }
                    if (!(conn instanceof GeodbConnection)) {
                        trsfFromIli.addBasketsTable(schema);
                        if (config.isCreateImportTabs()) {
                            trsfFromIli.addImportsTable(schema);
                        }
                        TransferFromIli.addInheritanceTable(schema, config);
                        TransferFromIli.addSettingsTable(schema);
                        TransferFromIli.addTrafoConfigTable(schema);
                        TransferFromIli.addModelsTable(schema, config);
                        trsfFromIli.addEnumTable(schema);
                        TransferFromIli.addTableMappingTable(schema, config);
                        TransferFromIli.addAttrMappingTable(schema, config);
                        DbExtMetaInfo.addMetaInfoTables(schema);
                        idGen.addMappingTable(schema);
                        if (config.getCreateMetaInfo()) {
                            MetaAttrUtility.addMetaAttributesTable(schema);
                        }
                    }
                    if (conn instanceof GeodbConnection) {
                        // empty if block
                    }
                    GeneratorDriver drv = new GeneratorDriver(gen);
                    idGen.initDb(conn, dbusr);
                    idGen.initDbDefs(gen);
                    drv.visitSchema((Settings)config, schema);
                    Ili2db.validateSchemaNames(schema, mapping);
                    if (!(conn instanceof GeodbConnection)) {
                        GeneratorJdbc insertCollector = config.getCreatescript() != null ? (GeneratorJdbc)gen : null;
                        mapping.updateTableMappingTable(insertCollector, conn, config.getDbschema());
                        mapping.updateAttrMappingTable(insertCollector, conn, config.getDbschema());
                        trafoConfig.updateTrafoConfig(insertCollector, conn, config.getDbschema(), customMapping);
                        trsfFromIli.updateInheritanceTable(insertCollector, conn, config.getDbschema());
                        trsfFromIli.updateEnumTable(insertCollector, conn);
                        trsfFromIli.updateMetaInfoTables(insertCollector, conn);
                        TransferFromIli.addModels(insertCollector, conn, td, config.getDbschema(), customMapping, false);
                        if (!config.isConfigReadFromDb()) {
                            TransferFromIli.updateSettings(insertCollector, conn, config, config.getDbschema());
                        }
                        if (config.getCreateMetaInfo()) {
                            MetaAttrUtility.updateMetaAttributesTable(insertCollector, conn, config.getDbschema(), td);
                            if (conn != null) {
                                MetaAttrUtility.addMetaAttrsFromDb(td, conn, config.getDbschema());
                            }
                        }
                    }
                    if ((createscript = config.getCreatescript()) != null && gen instanceof GeneratorJdbc) {
                        Ili2db.writeScript(createscript, ((GeneratorJdbc)gen).iteratorCreateLines());
                    }
                    if ((dropscript = config.getDropscript()) != null && gen instanceof GeneratorJdbc) {
                        Ili2db.writeScript(dropscript, ((GeneratorJdbc)gen).iteratorDropLines());
                    }
                    if (importToDb && config.getPostScript() != null) {
                        try {
                            EhiLogger.logState((String)"run schemaImport post-script...");
                            DbUtility.executeSqlScript((Connection)conn, (InputStreamReader)new FileReader(config.getPostScript()));
                        }
                        catch (FileNotFoundException e) {
                            throw new Ili2dbException("schemaImport post-script statements failed", e);
                        }
                    }
                    if (importToDb) {
                        customMapping.postPostScript(conn, config);
                    }
                    if (!importToDb || connectionFromExtern) break block116;
                    try {
                        conn.commit();
                    }
                    catch (SQLException e) {
                        throw new Ili2dbException("failed to commit", e);
                    }
                }
                finally {
                    block117: {
                        try {
                            if (!importToDb || connectionFromExtern || conn == null) break block117;
                            try {
                                conn.close();
                            }
                            finally {
                                conn = null;
                                config.setJdbcConnection(null);
                            }
                        }
                        catch (SQLException ex) {
                            EhiLogger.logError((Throwable)ex);
                        }
                    }
                    ao.end();
                }
            }
            EhiLogger.logState((String)"...done");
        }
        catch (Ili2dbException ex) {
            if (logfile != null) {
                logfile.logEvent((LogEvent)new StdLogEvent(7, null, (Throwable)ex, null));
            }
            if (xtflog != null) {
                xtflog.logEvent((LogEvent)new StdLogEvent(7, null, (Throwable)ex, null));
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (logfile != null) {
                logfile.logEvent((LogEvent)new StdLogEvent(7, null, (Throwable)ex, null));
            }
            if (xtflog != null) {
                xtflog.logEvent((LogEvent)new StdLogEvent(7, null, (Throwable)ex, null));
            }
            throw ex;
        }
        finally {
            if (xtflog != null) {
                EhiLogger.getInstance().removeListener((LogListener)xtflog);
                xtflog.close();
                xtflog = null;
            }
            if (logfile != null) {
                EhiLogger.getInstance().removeListener((LogListener)logfile);
                logfile.close();
                logfile = null;
            }
            if (logStderr != null) {
                EhiLogger.getInstance().addListener((LogListener)StdListener.getInstance());
                EhiLogger.getInstance().removeListener((LogListener)logStderr);
            }
        }
    }

    private static void validateSchemaNames(DbSchema schema, NameMapping mapping) {
    }

    private static void logGeneralInfo(Config config) {
        EhiLogger.logState((String)config.getSender());
        EhiLogger.logState((String)("ili2c-" + Main.getVersion()));
        EhiLogger.logState((String)("iox-ili-" + IoxUtility.getVersion()));
        EhiLogger.logState((String)("java.version " + System.getProperty("java.version")));
        EhiLogger.logState((String)("user.name <" + System.getProperty("user.name") + ">"));
        EhiLogger.logState((String)("maxMemory " + Runtime.getRuntime().maxMemory() / 1024L + " KB"));
        EhiLogger.logState((String)("currentTime " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())));
    }

    private static void setupIli2cPathmap(Config config, String appHome, String xtffile, Connection conn, CustomMapping mapping) throws Ili2dbException {
        config.setValue("ch.interlis.ili2c.ilidirs", config.getModeldir());
        HashMap<String, String> pathMap = new HashMap<String, String>();
        if (xtffile != null) {
            pathMap.put(XTF_DIR, new File(xtffile).getAbsoluteFile().getParent());
        } else {
            pathMap.put(XTF_DIR, null);
        }
        pathMap.put(JAR_DIR, appHome);
        config.setTransientObject("ch.interlis.ili2c.pathMap", pathMap);
        if (conn != null) {
            IliFiles iliFiles = null;
            String url = null;
            try {
                url = conn.getMetaData().getURL();
                url = mapping.shortenConnectUrl4IliCache(url);
                iliFiles = TransferFromIli.readIliFiles(conn, config.getDbschema(), mapping, config.isVer3_export());
            }
            catch (SQLException e) {
                throw new Ili2dbException(e);
            }
            if (iliFiles != null) {
                String dbSchema = config.getDbschema();
                if (dbSchema != null) {
                    url = url + "/" + dbSchema;
                }
                pathMap.put(ILI_FROM_DB, url);
                config.setTransientValue("ch.interlis.ili2c.tempReposUri", url);
                config.setTransientObject("ch.interlis.ili2c.tempReposIliFiles", iliFiles);
                config.setTransientObject("ch.interlis.ili2c.customIliResolver", new IliFromDb(url, conn, dbSchema, config));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void runExport(Config config, String appHome, int function) throws Ili2dbException {
        String xtflogFilename;
        String functionName = "export";
        if (function == 8) {
            functionName = "validate";
        }
        FileLogger logfile = null;
        XtfErrorsLogger xtflog = null;
        if (config.getLogfile() != null) {
            logfile = new FileLogger(new File(config.getLogfile()));
            EhiLogger.getInstance().addListener((LogListener)logfile);
        }
        if ((xtflogFilename = config.getXtfLogfile()) != null) {
            File f = new File(xtflogFilename);
            try {
                if (!Ili2db.isWriteable(f)) throw new Ili2dbException("failed to write to logfile <" + f.getPath() + ">");
                xtflog = new XtfErrorsLogger(f, config.getSender());
                EhiLogger.getInstance().addListener((LogListener)xtflog);
            }
            catch (IOException e) {
                throw new Ili2dbException("failed to write to logfile <" + f.getPath() + ">", e);
            }
        }
        StdLogger logStderr = new StdLogger(config.getLogfile());
        EhiLogger.getInstance().addListener((LogListener)logStderr);
        EhiLogger.getInstance().removeListener((LogListener)StdListener.getInstance());
        try {
            String geometryConverter;
            String dbschema;
            boolean connectionFromExtern = config.getJdbcConnection() != null;
            Ili2db.logGeneralInfo(config);
            String xtffile = config.getXtffile();
            if (function != 8 && xtffile == null) {
                throw new Ili2dbException("no xtf-file given");
            }
            String modeldir = config.getModeldir();
            if (modeldir == null) {
                throw new Ili2dbException("no modeldir given");
            }
            String dburl = config.getDburl();
            String dbusr = config.getDbusr();
            String dbpwd = config.getDbpwd();
            if (!connectionFromExtern && dburl == null) {
                throw new Ili2dbException("no dburl given");
            }
            if (dbusr == null) {
                dbusr = "";
            }
            if (dbpwd == null) {
                dbpwd = "";
            }
            if ((dbschema = config.getDbschema()) != null) {
                EhiLogger.logState((String)("dbschema <" + dbschema + ">"));
            }
            if ((geometryConverter = config.getGeometryConverter()) == null) {
                throw new Ili2dbException("no geoemtry converter given");
            }
            if (!connectionFromExtern) {
                String jdbcDriver = config.getJdbcDriver();
                if (jdbcDriver == null) {
                    throw new Ili2dbException("no JDBC driver given");
                }
                try {
                    Class.forName(jdbcDriver);
                }
                catch (Exception ex) {
                    throw new Ili2dbException("failed to load JDBC driver", ex);
                }
            }
            String baskets = config.getBaskets();
            String topics = config.getTopics();
            String models = config.getModels();
            String datasetName = config.getDatasetName();
            if (models == null && baskets == null && topics == null && datasetName == null) {
                throw new Ili2dbException("no dataset, baskets, models or topics given");
            }
            CustomMapping customMapping = Ili2db.getCustomMappingStrategy(config);
            Connection conn = null;
            String url = dburl;
            try {
                long[] basketSqlIds;
                String[] exportModelnames;
                Configuration modelv;
                block78: {
                    boolean createBasketCol;
                    block80: {
                        block81: {
                            try {
                                conn = connectionFromExtern ? config.getJdbcConnection() : Ili2db.connect(url, dbusr, dbpwd, config, customMapping);
                                customMapping.postConnect(conn, config);
                            }
                            catch (SQLException e) {
                                throw new Ili2dbException("failed to get db connection", e);
                            }
                            catch (IOException e) {
                                throw new Ili2dbException("failed to get db connection", e);
                            }
                            Ili2db.logDBVersion(conn);
                            customMapping.prePreScript(conn, config);
                            if (config.getPreScript() != null) {
                                try {
                                    EhiLogger.logState((String)("run " + functionName + " pre-script..."));
                                    DbUtility.executeSqlScript((Connection)conn, (InputStreamReader)new FileReader(config.getPreScript()));
                                }
                                catch (FileNotFoundException e) {
                                    throw new Ili2dbException(functionName + " pre-script statements failed", e);
                                }
                            }
                            modelv = new Configuration();
                            createBasketCol = "readWrite".equals(config.getBasketHandling());
                            exportModelnames = null;
                            basketSqlIds = null;
                            if (datasetName != null) break block80;
                            if (baskets == null) break block81;
                            if (!createBasketCol) {
                                throw new Ili2dbException("basket wise " + functionName + " requires column " + "T_basket");
                            }
                            String[] basketids = baskets.split(";");
                            basketSqlIds = Ili2db.getBasketSqlIdsFromBID(basketids, modelv, conn, config);
                            break block78;
                        }
                        if (topics != null) {
                            if (!createBasketCol) {
                                throw new Ili2dbException("topic wise " + functionName + " requires column " + "T_basket");
                            }
                            String[] topicv = topics.split(";");
                            basketSqlIds = Ili2db.getBasketSqlIdsFromTopic(topicv, modelv, conn, config);
                            if (basketSqlIds == null) throw new Ili2dbException("no baskets with given topic names in table T_ILI2DB_BASKET");
                            if (basketSqlIds.length == 0) {
                                throw new Ili2dbException("no baskets with given topic names in table T_ILI2DB_BASKET");
                            }
                            break block78;
                        } else if (createBasketCol) {
                            String[] modelnames = Ili2db.getModelNames(models);
                            basketSqlIds = Ili2db.getBasketSqlIdsFromModel(modelnames, modelv, conn, config);
                            break block78;
                        } else {
                            exportModelnames = Ili2db.getModelNames(models);
                            for (int modeli = 0; modeli < exportModelnames.length; ++modeli) {
                                String m = exportModelnames[modeli];
                                if (m.equals(XTF)) {
                                    // empty if block
                                }
                                modelv.addFileEntry(new FileEntry(m, 1));
                            }
                        }
                        break block78;
                    }
                    if (!createBasketCol) {
                        throw new Ili2dbException("dataset wise " + functionName + " requires column " + "T_basket");
                    }
                    String[] datasetNames = datasetName.split(";");
                    ArrayList<Long> tmpListOfBasket = new ArrayList<Long>();
                    for (String dtName : datasetNames) {
                        Long datasetId = Ili2db.getDatasetId(dtName, conn, config);
                        if (datasetId == null) {
                            throw new Ili2dbException("dataset <" + dtName + "> doesn't exist");
                        }
                        long[] tmpbasketSqlIds = Ili2db.getBasketSqlIdsFromDatasetId(datasetId, modelv, conn, config);
                        for (int i = 0; i < tmpbasketSqlIds.length; ++i) {
                            tmpListOfBasket.add(tmpbasketSqlIds[i]);
                        }
                    }
                    if (tmpListOfBasket.size() > 0) {
                        basketSqlIds = new long[tmpListOfBasket.size()];
                        for (int i = 0; i < tmpListOfBasket.size(); ++i) {
                            basketSqlIds[i] = (Long)tmpListOfBasket.get(i);
                        }
                    }
                }
                if (modelv.getSizeFileEntry() == 0) {
                    throw new Ili2dbException("no models given");
                }
                String adapterClassName = config.getGeometryConverter();
                if (adapterClassName == null) {
                    throw new Ili2dbException("no adapter given");
                }
                SqlColumnConverter geomConverter = null;
                try {
                    geomConverter = (SqlColumnConverter)Class.forName(geometryConverter).newInstance();
                }
                catch (Exception ex) {
                    throw new Ili2dbException("failed to load/create geometry converter", ex);
                }
                Ili2db.setupIli2cPathmap(config, appHome, xtffile, conn, customMapping);
                Ili2cMetaAttrs ili2cMetaAttrs = new Ili2cMetaAttrs();
                Ili2db.setupIli2cMetaAttrs(ili2cMetaAttrs, config, null);
                EhiLogger.logState((String)"compile models...");
                modelv.setAutoCompleteModelList(true);
                modelv.setGenerateWarnings(false);
                TransferDescription td = Main.runCompiler((Configuration)modelv, (Settings)config, (Ili2cMetaAttrs)ili2cMetaAttrs);
                if (td == null) {
                    throw new Ili2dbException("compiler failed");
                }
                if (config.getCreateMetaInfo() && customMapping.tableExists(conn, new DbTableName(config.getDbschema(), "T_ILI2DB_META_ATTRS"))) {
                    MetaAttrUtility.addMetaAttrsFromDb(td, conn, config.getDbschema());
                }
                if (config.getModelSrsCode() != null) {
                    Ili2db.addModellSrsCode(td, config.getModelSrsCode());
                }
                geomConverter.setup(conn, config);
                NameMapping mapping = new NameMapping(td, config);
                if (customMapping.tableExists(conn, new DbTableName(config.getDbschema(), "T_ILI2DB_CLASSNAME"))) {
                    mapping.readTableMappingTable(conn, config.getDbschema());
                }
                if (customMapping.tableExists(conn, new DbTableName(config.getDbschema(), "T_ILI2DB_ATTRNAME"))) {
                    mapping.readAttrMappingTable(conn, config.getDbschema());
                }
                TrafoConfig trafoConfig = new TrafoConfig();
                trafoConfig.readTrafoConfig(conn, config.getDbschema(), customMapping);
                ModelElementSelector ms = new ModelElementSelector();
                ArrayList<String> modelNames = new ArrayList<String>();
                Iterator modi = modelv.iteratorFileEntry();
                while (modi.hasNext()) {
                    FileEntry mod = (FileEntry)modi.next();
                    if (mod.getKind() != 1) continue;
                    modelNames.add(mod.getFilename());
                    EhiLogger.traceState((String)("modelname <" + mod.getFilename() + ">"));
                }
                String srsModelAssignment = config.getSrsModelAssignment();
                if (srsModelAssignment != null) {
                    String[] srsModelNames = srsModelAssignment.split("=");
                    String originalSrsModelName = srsModelNames[0];
                    String alternativeSrsModelName = srsModelNames[1];
                    modelNames.remove(alternativeSrsModelName);
                }
                List<Element> eles = ms.getModelElements(modelNames, td, td.getIli1Format() != null && config.getDoItfLineTables(), "multiTable".equals(config.getCreateEnumDefs()), config);
                Viewable2TableMapping class2wrapper = Viewable2TableMapper.getClass2TableMapping(config, trafoConfig, eles, mapping);
                EhiLogger.logState((String)"process data...");
                if (function != 8) {
                    EhiLogger.logState((String)("data <" + xtffile + ">"));
                }
                HashMap<String, BasketStat> stat = new HashMap<String, BasketStat>();
                ErrorTracker errs = new ErrorTracker();
                EhiLogger.getInstance().addListener((LogListener)errs);
                Ili2db.transferToXtf(conn, function, xtffile, customMapping, mapping, td, geomConverter, config.getSender(), config, exportModelnames, basketSqlIds, stat, trafoConfig, class2wrapper);
                if (errs.hasSeenErrors()) {
                    throw new Ili2dbException("..." + functionName + " failed");
                }
                Ili2db.logStatistics(td.getIli1Format() != null, stat);
                EhiLogger.logState((String)("..." + functionName + " done"));
                EhiLogger.getInstance().removeListener((LogListener)errs);
                if (config.getPostScript() != null) {
                    try {
                        DbUtility.executeSqlScript((Connection)conn, (InputStreamReader)new FileReader(config.getPostScript()));
                        EhiLogger.logState((String)("run " + functionName + " post-script..."));
                    }
                    catch (FileNotFoundException e) {
                        throw new Ili2dbException(functionName + " post-script statements failed", e);
                    }
                }
                customMapping.postPostScript(conn, config);
                return;
            }
            finally {
                if (!connectionFromExtern) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        EhiLogger.logError((Throwable)ex);
                    }
                    finally {
                        conn = null;
                        config.setJdbcConnection(null);
                    }
                }
            }
        }
        catch (Ili2dbException ex) {
            if (logfile != null) {
                logfile.logEvent((LogEvent)new StdLogEvent(7, null, (Throwable)ex, null));
            }
            if (xtflog == null) throw ex;
            xtflog.logEvent((LogEvent)new StdLogEvent(7, null, (Throwable)ex, null));
            throw ex;
        }
        catch (RuntimeException ex) {
            if (logfile != null) {
                logfile.logEvent((LogEvent)new StdLogEvent(7, null, (Throwable)ex, null));
            }
            if (xtflog == null) throw ex;
            xtflog.logEvent((LogEvent)new StdLogEvent(7, null, (Throwable)ex, null));
            throw ex;
        }
        finally {
            if (xtflog != null) {
                EhiLogger.getInstance().removeListener((LogListener)xtflog);
                xtflog.close();
                xtflog = null;
            }
            if (logfile != null) {
                EhiLogger.getInstance().removeListener((LogListener)logfile);
                logfile.close();
                logfile = null;
            }
            if (logStderr != null) {
                EhiLogger.getInstance().addListener((LogListener)StdListener.getInstance());
                EhiLogger.getInstance().removeListener((LogListener)logStderr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection connect(String url, String dbusr, String dbpwd, Config config, CustomMapping customMapping) throws SQLException, IOException {
        EhiLogger.logState((String)("dburl <" + url + ">"));
        EhiLogger.logState((String)("dbusr <" + dbusr + ">"));
        String dbParams = config.getDbParams();
        if (dbParams != null) {
            EhiLogger.logState((String)("dbparams <" + dbParams + ">"));
            Reader reader = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(dbParams), "UTF-8");
                Properties props = new Properties();
                props.load(reader);
                config.setDbProperties(props);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    reader = null;
                }
            }
        }
        customMapping.preConnect(url, dbusr, dbpwd, config);
        Connection conn = customMapping.connect(url, dbusr, dbpwd, config);
        config.setJdbcConnection(conn);
        return conn;
    }

    public static Long getDatasetId(String datasetName, Connection conn, Config config) throws Ili2dbException {
        String schema = config.getDbschema();
        String colT_ID = config.getColT_ID();
        if (colT_ID == null) {
            colT_ID = "T_Id";
        }
        String sqlName = "T_ILI2DB_DATASET";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        Statement getstmt = null;
        ResultSet res = null;
        try {
            String stmt = "SELECT " + colT_ID + " FROM " + sqlName + " WHERE " + "datasetName" + "= ?";
            if (datasetName == null) {
                stmt = "SELECT " + colT_ID + " FROM " + sqlName + " WHERE " + "datasetName" + " IS NULL";
            }
            EhiLogger.traceBackendCmd((String)stmt);
            getstmt = conn.prepareStatement(stmt);
            if (datasetName != null) {
                getstmt.setString(1, datasetName);
            }
            if ((res = getstmt.executeQuery()).next()) {
                long sqlId = res.getLong(1);
                Long l = sqlId;
                return l;
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to query " + sqlName, ex);
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
            }
            if (getstmt != null) {
                try {
                    getstmt.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
            }
        }
        return null;
    }

    public static long[] getBasketSqlIdsFromDatasetId(long datasetId, Configuration modelv, Connection conn, Config config) throws Ili2dbException {
        ArrayList<Long> ret = new ArrayList<Long>();
        String schema = config.getDbschema();
        String colT_ID = config.getColT_ID();
        if (colT_ID == null) {
            colT_ID = "T_Id";
        }
        String sqlName = "T_ILI2DB_BASKET";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        HashSet<String> models = new HashSet<String>();
        Statement getstmt = null;
        try {
            String stmt = "SELECT " + colT_ID + "," + "topic" + " FROM " + sqlName + " WHERE " + "dataset" + "= ?";
            EhiLogger.traceBackendCmd((String)stmt);
            getstmt = conn.prepareStatement(stmt);
            getstmt.setLong(1, datasetId);
            ResultSet res = getstmt.executeQuery();
            while (res.next()) {
                long sqlId = res.getLong(1);
                String topicQName = res.getString(2);
                String[] topicName = Ili2db.splitIliQName(topicQName.toString());
                if (topicName[0] == null) {
                    throw new Ili2dbException("unexpected unqualified name " + topicQName + " in table " + sqlName);
                }
                String modelName = topicName[0];
                if (!models.contains(modelName)) {
                    modelv.addFileEntry(new FileEntry(modelName, 1));
                    models.add(modelName);
                }
                ret.add(sqlId);
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to query " + sqlName, ex);
        }
        finally {
            if (getstmt != null) {
                try {
                    getstmt.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
            }
        }
        long[] ret2 = new long[ret.size()];
        int idx = 0;
        Iterator iterator = ret.iterator();
        while (iterator.hasNext()) {
            long x = (Long)iterator.next();
            ret2[idx++] = x;
        }
        return ret2;
    }

    private static long[] getBasketSqlIdsFromBID(String[] basketids, Configuration modelv, Connection conn, Config config) throws Ili2dbException {
        long[] ret = new long[basketids.length];
        int retidx = 0;
        String schema = config.getDbschema();
        String colT_ID = config.getColT_ID();
        if (colT_ID == null) {
            colT_ID = "T_Id";
        }
        String sqlName = "T_ILI2DB_BASKET";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        HashSet<String> models = new HashSet<String>();
        for (String basketid : basketids) {
            StringBuilder topicQName = new StringBuilder();
            Long sqlId = Ili2db.getBasketSqlIdFromBID(basketid, conn, schema, colT_ID, topicQName);
            if (sqlId == null) {
                throw new Ili2dbException("no basket with BID " + basketid + " in table " + sqlName);
            }
            String[] topicName = Ili2db.splitIliQName(topicQName.toString());
            if (topicName[0] == null) {
                throw new Ili2dbException("unexpected unqualified name " + topicQName + " in table " + sqlName);
            }
            String modelName = topicName[0];
            if (!models.contains(modelName)) {
                modelv.addFileEntry(new FileEntry(modelName, 1));
                models.add(modelName);
            }
            ret[retidx++] = sqlId;
        }
        return ret;
    }

    public static Long getBasketSqlIdFromBID(String basketid, Connection conn, String schema, String colT_ID, StringBuilder topicName) throws Ili2dbException {
        String sqlName = "T_ILI2DB_BASKET";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        long sqlId = 0L;
        Statement getstmt = null;
        try {
            String stmt = "SELECT " + colT_ID + "," + "topic" + " FROM " + sqlName + " WHERE " + "T_Ili_Tid" + "= ?";
            EhiLogger.traceBackendCmd((String)stmt);
            getstmt = conn.prepareStatement(stmt);
            getstmt.setString(1, basketid);
            ResultSet res = getstmt.executeQuery();
            if (res.next()) {
                sqlId = res.getLong(1);
                topicName.append(res.getString(2));
                Long l = sqlId;
                return l;
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to query " + sqlName, ex);
        }
        finally {
            if (getstmt != null) {
                try {
                    getstmt.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
            }
        }
        return null;
    }

    public static long[] getBasketSqlIdsFromTopic(String[] topics, Configuration modelv, Connection conn, Config config) throws Ili2dbException {
        String schema = config.getDbschema();
        String colT_ID = config.getColT_ID();
        if (colT_ID == null) {
            colT_ID = "T_Id";
        }
        String[][] qryTopics = new String[topics.length][];
        int idx = 0;
        for (String topic : topics) {
            qryTopics[idx++] = Ili2db.splitIliQName(topic);
        }
        String sqlName = "T_ILI2DB_BASKET";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        HashSet<String> models = new HashSet<String>();
        HashSet<Long> bids = new HashSet<Long>();
        String topicQName = null;
        long sqlId = 0L;
        Statement getstmt = null;
        try {
            String stmt = "SELECT " + colT_ID + "," + "topic" + " FROM " + sqlName;
            EhiLogger.traceBackendCmd((String)stmt);
            getstmt = conn.prepareStatement(stmt);
            ResultSet res = getstmt.executeQuery();
            while (res.next()) {
                sqlId = res.getLong(1);
                topicQName = res.getString(2);
                String[] dbTopic = Ili2db.splitIliQName(topicQName);
                String modelName = null;
                for (String[] qryTopic : qryTopics) {
                    if (qryTopic[0] == null && qryTopic[1].equals(dbTopic[1])) {
                        modelName = dbTopic[0];
                        break;
                    }
                    if (qryTopic[0] == null || !qryTopic[0].equals(dbTopic[0]) || !qryTopic[1].equals(dbTopic[1])) continue;
                    modelName = dbTopic[0];
                    break;
                }
                if (modelName == null) continue;
                if (!models.contains(modelName)) {
                    modelv.addFileEntry(new FileEntry(modelName, 1));
                    models.add(modelName);
                }
                if (bids.contains(sqlId)) continue;
                bids.add(sqlId);
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to query " + sqlName, ex);
        }
        finally {
            if (getstmt != null) {
                try {
                    getstmt.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
            }
        }
        long[] ret = new long[bids.size()];
        idx = 0;
        Iterator iterator = bids.iterator();
        while (iterator.hasNext()) {
            long bid = (Long)iterator.next();
            ret[idx++] = bid;
        }
        return ret;
    }

    private static long[] getBasketSqlIdsFromModel(String[] qryModels, Configuration modelv, Connection conn, Config config) throws Ili2dbException {
        String schema = config.getDbschema();
        String colT_ID = config.getColT_ID();
        if (colT_ID == null) {
            colT_ID = "T_Id";
        }
        int idx = 0;
        String sqlName = "T_ILI2DB_BASKET";
        if (schema != null) {
            sqlName = schema + "." + sqlName;
        }
        HashSet<String> models = new HashSet<String>();
        HashSet<Long> bids = new HashSet<Long>();
        String topicQName = null;
        long sqlId = 0L;
        Statement getstmt = null;
        ResultSet res = null;
        try {
            String stmt = "SELECT " + colT_ID + "," + "topic" + " FROM " + sqlName;
            EhiLogger.traceBackendCmd((String)stmt);
            getstmt = conn.prepareStatement(stmt);
            res = getstmt.executeQuery();
            while (res.next()) {
                sqlId = res.getLong(1);
                topicQName = res.getString(2);
                String[] dbTopic = Ili2db.splitIliQName(topicQName);
                String modelName = null;
                for (String qryModel : qryModels) {
                    if (!qryModel.equals(dbTopic[0])) continue;
                    modelName = qryModel;
                    break;
                }
                if (modelName == null) continue;
                if (!models.contains(modelName)) {
                    modelv.addFileEntry(new FileEntry(modelName, 1));
                    models.add(modelName);
                }
                if (bids.contains(sqlId)) continue;
                bids.add(sqlId);
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to query " + sqlName, ex);
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                    res = null;
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
            }
            if (getstmt != null) {
                try {
                    getstmt.close();
                }
                catch (SQLException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
            }
        }
        if (bids.size() == 0) {
            throw new Ili2dbException("no baskets with given model names in table " + sqlName);
        }
        long[] ret = new long[bids.size()];
        idx = 0;
        Iterator iterator = bids.iterator();
        while (iterator.hasNext()) {
            long bid = (Long)iterator.next();
            ret[idx++] = bid;
        }
        return ret;
    }

    private static String[] splitIliQName(String topicQName) {
        String modelName = null;
        String topicName = null;
        int endModelName = topicQName.indexOf(46);
        if (endModelName <= 0) {
            topicName = topicQName;
        } else {
            modelName = topicQName.substring(0, endModelName);
            topicName = topicQName.substring(endModelName + 1);
        }
        String[] ret = new String[]{modelName, topicName};
        return ret;
    }

    @Deprecated
    public static String getModelFromXtf(String filename) {
        StartBasketEvent be = null;
        try {
            IoxEvent event;
            Object ioxReader = null;
            ioxReader = Ili2db.isItfFilename(filename) ? new ItfReader(new File(filename)) : new XtfReader(new File(filename));
            do {
                if (!((event = ioxReader.read()) instanceof StartBasketEvent)) continue;
                be = (StartBasketEvent)event;
                break;
            } while (!(event instanceof EndTransferEvent));
            ioxReader.close();
            ioxReader = null;
        }
        catch (IoxException ex) {
            EhiLogger.logError((String)("failed to read model from xml file " + filename), (Throwable)ex);
            return null;
        }
        if (be == null) {
            return null;
        }
        String[] qtopic = be.getType().split("\\.");
        String model = qtopic[0];
        return model;
    }

    public static String getModelFromXtf(InputStream f, String filename) {
        StartBasketEvent be = null;
        try {
            IoxEvent event;
            Object ioxReader = null;
            ioxReader = Ili2db.isItfFilename(filename) ? new ItfReader(f) : new XtfReader(f);
            do {
                if (!((event = ioxReader.read()) instanceof StartBasketEvent)) continue;
                be = (StartBasketEvent)event;
                break;
            } while (!(event instanceof EndTransferEvent));
            ioxReader.close();
            ioxReader = null;
        }
        catch (IoxException ex) {
            EhiLogger.logError((String)("failed to read model from xml file " + filename), (Throwable)ex);
            return null;
        }
        if (be == null) {
            return null;
        }
        String[] qtopic = be.getType().split("\\.");
        String model = qtopic[0];
        return model;
    }

    public static ArrayList getModelDirv(String modeldir, String xtffile, String ili2dbHome) {
        ArrayList<String> modeldirv = new ArrayList<String>();
        String[] modeldirs = modeldir.split(";");
        for (int modeli = 0; modeli < modeldirs.length; ++modeli) {
            String m = modeldirs[modeli];
            if (m.equals(XTF_DIR)) {
                m = xtffile != null ? new File(xtffile).getAbsoluteFile().getParentFile().getAbsolutePath() : null;
            } else if (m.equals(JAR_DIR)) {
                m = ili2dbHome != null ? ili2dbHome : null;
            }
            if (m == null || m.length() <= 0) continue;
            modeldirv.add(m);
        }
        return modeldirv;
    }

    private static void transferFromXtf(Connection conn, IoxReader reader, int function, NameMapping ili2sqlName, TransferDescription td, String dbusr, SqlColumnConverter geomConv, DbIdGen idGen, Config config, Map<String, BasketStat> stat, TrafoConfig trafoConfig, Viewable2TableMapping class2wrapper, CustomMapping customMapping) {
        try {
            TransferFromXtf trsfr = new TransferFromXtf(function, ili2sqlName, td, conn, dbusr, geomConv, idGen, config, trafoConfig, class2wrapper);
            trsfr.doit(reader, config, stat, customMapping);
        }
        catch (IoxException ex) {
            EhiLogger.logError((String)"failed to transfer data from file to db", (Throwable)ex);
        }
        catch (Ili2dbException ex) {
            EhiLogger.logError((String)"failed to transfer data from file to db", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transferToXtf(Connection conn, int function, String xtffile, CustomMapping customMapping, NameMapping ili2sqlName, TransferDescription td, SqlColumnConverter geomConv, String sender, Config config, String[] exportParamModelnames, long[] basketSqlIds, Map<String, BasketStat> stat, TrafoConfig trafoConfig, Viewable2TableMapping class2wrapper) {
        if (function == 8) {
            try {
                TransferToXtf trsfr = new TransferToXtf(ili2sqlName, td, conn, geomConv, config, trafoConfig, class2wrapper);
                trsfr.doit(function, customMapping.shortenConnectUrl4Log(config.getDburl()), null, sender, exportParamModelnames, basketSqlIds, stat, customMapping);
            }
            catch (IoxException ex) {
                EhiLogger.logError((String)"failed to validate data from db", (Throwable)ex);
            }
            catch (Ili2dbException ex) {
                EhiLogger.logError((String)"failed to validate data from db", (Throwable)ex);
            }
        } else {
            File outfile = new File(xtffile);
            Object ioxWriter = null;
            try {
                if ("ILIGML20".equals(config.getTransferFileFormat())) {
                    ioxWriter = new Iligml20Writer(outfile, td);
                } else {
                    String ext = GenericFileFilter.getFileExtension((String)xtffile).toLowerCase();
                    if (config.isItfTransferfile()) {
                        ioxWriter = !config.getDoItfLineTables() ? new ItfWriter2(outfile, td) : new ItfWriter(outfile, td);
                        config.setValue("ch.interlis.iox_j.validator.doItfOidPerTable", "doItfOidPerTable");
                    } else if (ext != null && ext.equals("gml")) {
                        ioxWriter = new Iligml10Writer(outfile, td);
                    } else {
                        ioxWriter = new XtfWriter(outfile, td);
                        if (config.getExportModels() != null) {
                            ((XtfWriter)ioxWriter).setModels(Ili2db.buildModelList(td, config.getExportModels()));
                        }
                    }
                }
                TransferToXtf trsfr = new TransferToXtf(ili2sqlName, td, conn, geomConv, config, trafoConfig, class2wrapper);
                trsfr.doit(function, outfile.getName(), (IoxWriter)ioxWriter, sender, exportParamModelnames, basketSqlIds, stat, customMapping);
                ioxWriter.flush();
            }
            catch (IoxException ex) {
                EhiLogger.logError((String)"failed to write xml output", (Throwable)ex);
            }
            catch (Ili2dbException ex) {
                EhiLogger.logError((String)"failed to write xml output", (Throwable)ex);
            }
            finally {
                if (ioxWriter != null) {
                    try {
                        ioxWriter.close();
                    }
                    catch (IoxException ex) {
                        EhiLogger.logError((String)"failed to close xml output", (Throwable)ex);
                    }
                }
                ioxWriter = null;
            }
        }
    }

    private static XtfModel[] buildModelList(TransferDescription td, String modelNames) {
        List<Model> modelv = Ili2db.getModels(modelNames, td);
        XtfModel[] ret = new XtfModel[modelv.size()];
        for (int i = 0; i < modelv.size(); ++i) {
            Model model = modelv.get(i);
            ret[i] = new XtfModel();
            ret[i].setName(model.getName());
            String version = model.getModelVersion();
            ret[i].setVersion(version == null ? "" : version);
            String issuer = model.getIssuer();
            ret[i].setUri(issuer == null ? "" : issuer);
        }
        return ret;
    }

    private static HashSet getModelNames(ArrayList modelv) {
        HashSet<String> ret = new HashSet<String>();
        for (String topic : modelv) {
            int endModelName = topic.indexOf(46);
            if (endModelName <= 0) {
                ret.add(topic);
                continue;
            }
            String model = topic.substring(0, endModelName);
            ret.add(model);
        }
        return ret;
    }

    public static String[] getModelNames(String models) {
        String[] modelnames = models.split(";");
        return modelnames;
    }

    private static void writeScript(String filename, Iterator linei) throws IOException {
        PrintStream out = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(filename)), false, "UTF-8");
        while (linei.hasNext()) {
            GeneratorJdbc.AbstractStmt stmt = (GeneratorJdbc.AbstractStmt)linei.next();
            String line = stmt.getLine();
            if (stmt instanceof GeneratorJdbc.Stmt) {
                out.println(line + ";");
                continue;
            }
            out.println("-- " + line);
        }
        out.close();
    }

    public static boolean isItfFilename(String filename) {
        String xtfExt = GenericFileFilter.getFileExtension((File)new File(filename));
        return xtfExt != null && "itf".equals(xtfExt.toLowerCase());
    }

    public static void logDBVersion(Connection conn) {
        block5: {
            try {
                EhiLogger.logState((String)("databaseProduct <" + conn.getMetaData().getDatabaseProductName() + ">"));
                EhiLogger.logState((String)("databaseVersion <" + conn.getMetaData().getDatabaseProductVersion() + ">"));
                EhiLogger.logState((String)("driverName <" + conn.getMetaData().getDriverName() + ">"));
                EhiLogger.logState((String)("driverVersion <" + conn.getMetaData().getDriverVersion() + ">"));
                if (!conn.getMetaData().getURL().startsWith("jdbc:postgresql:")) break block5;
                try {
                    Statement stmt = conn.createStatement();
                    String sql = "SELECT PostGIS_Full_Version()";
                    ResultSet rs = stmt.executeQuery(sql);
                    if (rs.next()) {
                        String ver = rs.getString(1);
                        EhiLogger.logState((String)("postGISVersion <" + ver + ">"));
                    }
                }
                catch (SQLException e) {
                    throw new IllegalStateException("failed to get PostGIS version", e);
                }
            }
            catch (SQLException e) {
                EhiLogger.logError((Throwable)e);
            }
        }
    }

    private static CustomMapping getCustomMappingStrategy(Config config) throws Ili2dbException {
        String mappingClassName = config.getIli2dbCustomStrategy();
        if (mappingClassName == null) {
            return new CustomMappingNull();
        }
        CustomMapping mapping = null;
        try {
            mapping = (CustomMapping)Class.forName(mappingClassName).newInstance();
        }
        catch (Exception ex) {
            throw new Ili2dbException("failed to load/create custom mapping strategy", ex);
        }
        return mapping;
    }

    public static void setSkipPolygonBuilding(Config config) {
        config.setDoItfLineTables(true);
        config.setAreaRef("keep");
    }

    public static void setNoSmartMapping(Config config) {
        config.setCatalogueRefTrafo(null);
        config.setMultiSurfaceTrafo(null);
        config.setMultiLineTrafo(null);
        config.setMultiPointTrafo(null);
        config.setArrayTrafo(null);
        config.setJsonTrafo(null);
        config.setMultilingualTrafo(null);
        config.setLocalisedTrafo(null);
        config.setInheritanceTrafo(null);
    }

    public static List<Model> getModels(String modelNames, TransferDescription td) {
        String[] modelNamev;
        ArrayList<Model> models = new ArrayList<Model>();
        if (modelNames == null) {
            return models;
        }
        for (String modelName : modelNamev = Ili2db.getModelNames(modelNames)) {
            Model model = (Model)td.getElement(Model.class, modelName);
            if (model == null) {
                throw new IllegalArgumentException("unknown model <" + modelName + ">");
            }
            models.add(model);
        }
        return models;
    }

    public static String quoteSqlStringValue(String value) {
        if (value == null) {
            return "NULL";
        }
        return "'" + value.replace("'", "''") + "'";
    }

    private static boolean isWriteable(File f) throws IOException {
        f.createNewFile();
        return f.canWrite();
    }
}

