/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.ErrorTracker;
import ch.ehi.basics.logging.LogListener;
import ch.ehi.basics.logging.StdListener;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.view.GenericFileFilter;
import ch.interlis.ili2c.CheckReposIlis;
import ch.interlis.ili2c.CloneRepos;
import ch.interlis.ili2c.CompilerLogEvent;
import ch.interlis.ili2c.Ili2c;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.ListData;
import ch.interlis.ili2c.ListModels;
import ch.interlis.ili2c.ListModels2;
import ch.interlis.ili2c.ModelScan;
import ch.interlis.ili2c.config.BoidEntry;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.generator.ETF1Generator;
import ch.interlis.ili2c.generator.Gml32Generator;
import ch.interlis.ili2c.generator.Iligml20Generator;
import ch.interlis.ili2c.generator.Imd16Generator;
import ch.interlis.ili2c.generator.ImdGenerator;
import ch.interlis.ili2c.generator.Interlis1Generator;
import ch.interlis.ili2c.generator.Interlis2Generator;
import ch.interlis.ili2c.generator.TransformationParameter;
import ch.interlis.ili2c.generator.Uml21Generator;
import ch.interlis.ili2c.generator.XSD22Generator;
import ch.interlis.ili2c.generator.XSD24Generator;
import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.generator.iom.IomGenerator;
import ch.interlis.ili2c.generator.nls.Ili2TranslationXml;
import ch.interlis.ili2c.generator.nls.ModelElements;
import ch.interlis.ili2c.gui.UserSettings;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Ili2cMetaAttrs;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.parser.Ili1Parser;
import ch.interlis.ili2c.parser.Ili22Parser;
import ch.interlis.ili2c.parser.Ili23Parser;
import ch.interlis.ili2c.parser.Ili24Parser;
import ch.interlis.ili2c.parser.MetaObjectParser;
import ch.interlis.ilirepository.IliFiles;
import ch.interlis.ilirepository.IliManager;
import ch.interlis.ilirepository.IliResolver;
import ch.interlis.ilirepository.impl.RepositoryVisitor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Main {
    public static final String APP_JAR = "ili2c.jar";
    public static final String APP_NAME = "ili2c";
    @Deprecated
    public static final String ILI_DIR = "%ILI_DIR";
    @Deprecated
    public static final String JAR_DIR = "%JAR_DIR";
    @Deprecated
    public static final String JAR_MODELS = "standard";
    @Deprecated
    public static final String ILI_REPOSITORY = "http://models.interlis.ch/";
    @Deprecated
    public static final String ILIDIR_SEPARATOR = ";";
    @Deprecated
    public static final String MODELS_SEPARATOR = ";";
    @Deprecated
    public static final String DEFAULT_ILIDIRS = "%ILI_DIR;http://models.interlis.ch/;%JAR_DIR";

    protected static boolean hasArg(String v1, String v2, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(v1) && !args[i].equals(v2)) continue;
            return true;
        }
        return false;
    }

    protected static void printVersion() {
        System.err.println("INTERLIS Compiler, Version " + TransferDescription.getVersion());
        System.err.println("  Distributed by the Coordination of Geographic Information");
        System.err.println("  and Geographic Information Systems Group (COSIG), CH-3084 Wabern");
        System.err.println("  Developed by Adasys AG, CH-8005 Zurich");
        System.err.println("  Maintained by Eisenhut Informatik AG, CH-3400 Burgdorf");
        System.err.println("  See http://www.interlis.ch for information about INTERLIS");
        System.err.println("  Parts of this program have been generated by ANTLR; see http://www.antlr.org");
        System.err.println("  This product includes software developed by the");
        System.err.println("  Apache Software Foundation (http://www.apache.org/).");
    }

    protected static void printDescription() {
        System.err.println("DESCRIPTION");
        System.err.println("  Parses and compiles INTERLIS Version 2.3 data model definitions.");
        System.err.println("  Other options include conversion from INTERLIS Version 1 and back");
        System.err.println("  (option -o1) and generation of an XML-Schema, released 2001 (option -oXSD).");
    }

    protected static void printUsage(String progName) {
        System.err.println("USAGE");
        System.err.println("  " + progName + " [Options] file1.ili file2.ili ...");
    }

    protected static void printExamples(String progName) {
        System.err.println("EXAMPLES");
        System.err.println();
        System.err.println("Check whether an INTERLIS definition in \"file1.ili\" is valid:");
        System.err.println("    java -jar " + progName + " file1.ili");
        System.err.println();
        System.err.println("Check whether a definition distributed over several files is valid:");
        System.err.println("    java -jar " + progName + " file1.ili file2.ili");
        System.err.println();
        System.err.println("Generate an INTERLIS-1 definition:");
        System.err.println("    java -jar " + progName + " -o1 file1.ili file2.ili");
        System.err.println();
        System.err.println("Generate an INTERLIS-2 definition:");
        System.err.println("    java -jar " + progName + " -o2 file1.ili file2.ili");
        System.err.println();
        System.err.println("Generate a definition of the predefined MODEL INTERLIS:");
        System.err.println("    java -jar " + progName + " -o2 --with-predefined");
        System.err.println();
        System.err.println("Generate an XML-Schema:");
        System.err.println("    java -jar " + progName + " -oXSD file1.ili file2.ili");
        System.err.println();
        System.err.println("Generate a Translation-XML file:");
        System.err.println("    java -jar " + progName + " -oNLS --out translation.xml file.ili");
        System.err.println();
        System.err.println("Generate a translated INTERLIS-2 definition with help of a Translation-XML file:");
        System.err.println("    java -jar " + progName + " -o2 --out file_it.ili --lang it --nlsxml translation.xml file.ili");
        System.err.println();
        System.err.println("Generate a CRS transformed INTERLIS-2 definition:");
        System.err.println("    java -jar " + progName + " -o2 --out file_LV95.ili --trafoNewModel model_LV95 --trafoDiff 2000000,1000000 --trafoFactor 1,1 --trafoEpsg 2056 --trafoImports  GeometryCHLV95_V1=GeometryCHLV03_V1 file.ili");
        System.err.println();
        System.err.println("List all models starting in the given repository:");
        System.err.println("    java -jar " + progName + " --listModels " + ILI_REPOSITORY);
        System.err.println();
        System.err.println("List all data starting in the given repository:");
        System.err.println("    java -jar " + progName + " --listData " + ILI_REPOSITORY);
        System.err.println();
    }

    public static void main(String[] args) {
        boolean emitPredefined = false;
        boolean doAuto = true;
        boolean checkMetaObjs = false;
        boolean doCheckRepoIlis = false;
        boolean doCloneRepos = false;
        boolean doListModels = false;
        boolean doListAllModels = false;
        boolean doListModels2 = false;
        boolean doListAllModels2 = false;
        boolean doListData = false;
        boolean withWarnings = true;
        boolean numErrorsWhileGenerating = false;
        String notifyOnError = "compiler@interlis.ch";
        String ilidirs = DEFAULT_ILIDIRS;
        String httpProxyHost = null;
        String httpProxyPort = null;
        Object translationDef = null;
        Ili2cMetaAttrs ili2cMetaAttrs = new Ili2cMetaAttrs();
        TransformationParameter params = new TransformationParameter();
        if (args.length == 0) {
            ch.interlis.ili2c.gui.Main.main(args);
            return;
        }
        if (Main.hasArg("-u", "--usage", args)) {
            Main.printUsage(APP_NAME);
            return;
        }
        if (Main.hasArg("-h", "--help", args) || args.length == 0) {
            Main.printVersion();
            System.err.println();
            Main.printDescription();
            System.err.println();
            Main.printUsage(APP_NAME);
            System.err.println();
            System.err.println("OPTIONS");
            System.err.println();
            System.err.println("--no-auto             don't look automatically after required models.");
            System.err.println("-o0                   Generate no output (default).");
            System.err.println("-o1                   Generate INTERLIS-1 output.");
            System.err.println("-o2                   Generate INTERLIS-2 output.");
            System.err.println("-oXSD                 Generate an XTF XML-Schema.");
            System.err.println("-oGML                 Generate an eCH-118-1.0/GML3.2-Schema.");
            System.err.println("-oILIGML2             Generate an eCH-118-2.0/GML3.2-Schema.");
            System.err.println("-oFMT                 Generate an INTERLIS-1 Format.");
            System.err.println("-oIMD                 Generate Model as IlisMeta07 INTERLIS-Transfer (XTF).");
            System.err.println("-oIMD16               Generate Model as IlisMeta16 INTERLIS-Transfer (XTF).");
            System.err.println("-oNLS                 Generate an Translation-XML file.");
            System.err.println("--nlsxml file         Name of the Translation-XML file.");
            System.err.println("--lang lang           Language (de,fr,it or en).");
            System.err.println("--trafoDiff d_x,d_y   offset to calculate new coord domains");
            System.err.println("--trafoFactor f_x,f_y factor to calculate new coord domains");
            System.err.println("--trafoEpsg code      new EPSG code (e.g. 2056)");
            System.err.println("--trafoImports  newImport=oldImport change the name of an imported model (e.g. GeometryCHLV95_V1=GeometryCHLV03_V1)");
            System.err.println("--trafoNewModel newName name of the new model.");
            System.err.println("-oUML                 Generate Model as UML2/XMI-Transfer (eclipse flavour).");
            System.err.println("-oIOM                 (deprecated) Generate Model as INTERLIS-Transfer (XTF).");
            System.err.println("--check-repo-ilis uri   check all ili files in the given repository.");
            System.err.println("--clone-repos         clones the given repositories to the --out folder.");
            System.err.println("--listModels uri      list all models starting in the given repository. (IliRepository09)");
            System.err.println("--listAllModels uri   list all models (without removing old entries) starting in the given repository. (IliRepository09)");
            System.err.println("--listModels2 uri     list all models starting in the given repository. (IliRepository20)");
            System.err.println("--listAllModels2 uri  list all models (without removing old entries) starting in the given repository. (IliRepository20)");
            System.err.println("--listData uri        list all data starting in the given repository.");
            System.err.println("--translation translatedModel=originModel assigns a translated model to its orginal language equivalent.");
            System.err.println("--out file/dir        file or folder for output (folder must exist).");
            System.err.println("--modeldir " + ilidirs + " list of directories with ili-files.");
            System.err.println("--proxy host          proxy server to access model repositories.");
            System.err.println("--proxyPort port      proxy port to access model repositories.");
            System.err.println("--with-predefined     Include the predefined MODEL INTERLIS in");
            System.err.println("                      the output. Usually, this is omitted.");
            System.err.println("--without-warnings    Report only errors, no warnings. Usually,");
            System.err.println("                      warnings are generated as well.");
            System.err.println("--trace               Display detailed trace messages.");
            System.err.println("--quiet               Suppress info messages.");
            System.err.println("-h|--help             Display this help text.");
            System.err.println("-u|--usage            Display short information about usage.");
            System.err.println("-v|--version          Display the version of ili2c.");
            System.err.println();
            Main.printExamples(APP_NAME);
            return;
        }
        if (Main.hasArg("-v", "--version", args)) {
            Main.printVersion();
            return;
        }
        try {
            String outfile = null;
            String language = null;
            String nlsxmlFilename = null;
            int outputKind = 1;
            ArrayList<String> ilifilev = new ArrayList<String>();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("--with-predefined")) {
                    emitPredefined = true;
                    continue;
                }
                if (args[i].equals("--trace")) {
                    EhiLogger.getInstance().setTraceFilter(false);
                    continue;
                }
                if (args[i].equals("--quiet")) {
                    StdListener.getInstance().skipInfo(true);
                    continue;
                }
                if (args[i].equals("--no-auto")) {
                    doAuto = false;
                    continue;
                }
                if (args[i].equals("--check-repo-ilis")) {
                    doCheckRepoIlis = true;
                    continue;
                }
                if (args[i].equals("--clone-repos")) {
                    doCloneRepos = true;
                    continue;
                }
                if (args[i].equals("--listModels")) {
                    doListModels = true;
                    continue;
                }
                if (args[i].equals("--listModels2")) {
                    doListModels2 = true;
                    continue;
                }
                if (args[i].equals("--listData")) {
                    doListData = true;
                    continue;
                }
                if (args[i].equals("--listAllModels")) {
                    doListAllModels = true;
                    continue;
                }
                if (args[i].equals("--listAllModels2")) {
                    doListAllModels2 = true;
                    continue;
                }
                if (args[i].equals("--out")) {
                    outfile = args[++i];
                    continue;
                }
                if (args[i].equals("--translation")) {
                    String[] modelNameMappings;
                    for (String modelNameMapping : modelNameMappings = args[++i].split(";")) {
                        String[] modelNames = modelNameMapping.split("=");
                        String translatedModelName = modelNames[0];
                        String originLanguageModelName = modelNames[1];
                        if (translatedModelName == null || originLanguageModelName == null) continue;
                        ili2cMetaAttrs.setMetaAttrValue(translatedModelName, "ili2c.translationOf", originLanguageModelName);
                    }
                    continue;
                }
                if (args[i].equals("--proxy")) {
                    httpProxyHost = args[++i];
                    continue;
                }
                if (args[i].equals("--proxyPort")) {
                    httpProxyPort = args[++i];
                    continue;
                }
                if (args[i].equals("--lang")) {
                    language = args[++i];
                    continue;
                }
                if (args[i].equals("--trafoDiff")) {
                    String[] diffs = args[++i].split("\\,");
                    params.setDiff_x(Double.parseDouble(diffs[0]));
                    params.setDiff_y(Double.parseDouble(diffs[1]));
                    continue;
                }
                if (args[i].equals("--trafoFactor")) {
                    String[] factor = args[++i].split("\\,");
                    params.setFactor_x(Double.parseDouble(factor[0]));
                    params.setFactor_y(Double.parseDouble(factor[1]));
                    continue;
                }
                if (args[i].equals("--trafoEpsg")) {
                    params.setEpsgCode(Integer.parseInt(args[++i]));
                    continue;
                }
                if (args[i].equals("--trafoImports")) {
                    String[] imports = args[++i].split("\\=");
                    params.setImportModels(new TransformationParameter.ModelTransformation[]{new TransformationParameter.ModelTransformation(imports[0], imports[1])});
                    continue;
                }
                if (args[i].equals("--trafoNewModel")) {
                    params.setNewModelName(args[++i]);
                    continue;
                }
                if (args[i].equals("--nlsxml")) {
                    nlsxmlFilename = args[++i];
                    continue;
                }
                if (args[i].equals("--ilidirs") || args[i].equals("--modeldir")) {
                    ilidirs = args[++i];
                    continue;
                }
                if (args[i].equals("-o0")) {
                    outputKind = 1;
                    continue;
                }
                if (args[i].equals("-o1")) {
                    outputKind = 2;
                    continue;
                }
                if (args[i].equals("-o2")) {
                    outputKind = 3;
                    continue;
                }
                if (args[i].equals("-oXSD")) {
                    outputKind = 4;
                    continue;
                }
                if (args[i].equals("-oFMT")) {
                    outputKind = 5;
                    continue;
                }
                if (args[i].equals("-oGML")) {
                    outputKind = 6;
                    continue;
                }
                if (args[i].equals("-oILIGML2")) {
                    outputKind = 11;
                    continue;
                }
                if (args[i].equals("-oETF1")) {
                    outputKind = 8;
                    continue;
                }
                if (args[i].equals("-oIMD")) {
                    outputKind = 9;
                    continue;
                }
                if (args[i].equals("-oIMD16")) {
                    outputKind = 12;
                    continue;
                }
                if (args[i].equals("-oUML")) {
                    outputKind = 10;
                    continue;
                }
                if (args[i].equals("-oIOM")) {
                    outputKind = 7;
                    continue;
                }
                if (args[i].equals("-oNLS")) {
                    outputKind = 13;
                    continue;
                }
                if (args[i].equals("--without-warnings")) {
                    withWarnings = false;
                    continue;
                }
                if (args[i].equals("--with-warnings")) {
                    withWarnings = true;
                    continue;
                }
                if (args[i].charAt(0) == '-') {
                    System.err.println("ili2c:Unknown option: " + args[i]);
                    continue;
                }
                String filename = args[i];
                if (doCheckRepoIlis || doCloneRepos || doListModels || doListAllModels || doListModels2 || doListAllModels2 || doListData || new File(filename).isFile()) {
                    ilifilev.add(filename);
                    continue;
                }
                EhiLogger.logError((String)(args[i] + ": There is no such file."));
            }
            UserSettings settings = new UserSettings();
            Main.setDefaultIli2cPathMap((Settings)settings);
            settings.setHttpProxyHost(httpProxyHost);
            settings.setHttpProxyPort(httpProxyPort);
            settings.setIlidirs(ilidirs);
            Configuration config = new Configuration();
            for (String ilifile : ilifilev) {
                FileEntry file = new FileEntry(ilifile, 1);
                config.addFileEntry(file);
            }
            if (doAuto) {
                config.setAutoCompleteModelList(true);
            } else {
                config.setAutoCompleteModelList(false);
            }
            config.setGenerateWarnings(withWarnings);
            config.setOutputKind(outputKind);
            config.setLanguage(language);
            config.setNlsxmlFilename(nlsxmlFilename);
            config.setParams(params);
            if (doCloneRepos || doListModels || doListAllModels || doListModels2 || doListAllModels2 || doListData || outputKind != 1) {
                if (outfile != null) {
                    config.setOutputFile(outfile);
                } else {
                    config.setOutputFile("-");
                }
            }
            EhiLogger.logState((String)("ili2c-" + TransferDescription.getVersion()));
            if (doCheckRepoIlis) {
                boolean failed = new CheckReposIlis().checkRepoIlis(config, settings);
                if (failed) {
                    EhiLogger.logError((String)"check of ili's in repositories failed");
                    System.exit(1);
                }
            } else if (doCloneRepos) {
                boolean failed = new CloneRepos().cloneRepos(config, settings);
                if (failed) {
                    EhiLogger.logError((String)"clone of repositories failed");
                    System.exit(1);
                }
            } else if (doListModels || doListAllModels) {
                boolean failed = new ListModels().listModels(config, settings, doListModels);
                if (failed) {
                    EhiLogger.logError((String)"list of models failed");
                    System.exit(1);
                }
            } else if (doListModels2 || doListAllModels2) {
                boolean failed = new ListModels2().listModels(config, settings, doListModels2);
                if (failed) {
                    EhiLogger.logError((String)"list of models failed");
                    System.exit(1);
                }
            } else if (doListData) {
                boolean failed = new ListData().listData(config, settings);
                if (failed) {
                    EhiLogger.logError((String)"list of data failed");
                    System.exit(1);
                }
            } else {
                TransferDescription td = Main.runCompiler(config, (Settings)settings, ili2cMetaAttrs);
                if (td == null) {
                    EhiLogger.logError((String)"compiler failed");
                    System.exit(1);
                }
            }
        }
        catch (Exception ex) {
            EhiLogger.logError((String)("ili2c: An internal error has occured. Please notify " + notifyOnError), (Throwable)ex);
            System.exit(1);
        }
    }

    public static ArrayList<String> getIliLookupPaths(ArrayList<String> ilifilev) {
        ArrayList<String> ilipathv = new ArrayList<String>();
        HashSet<String> seenDirs = new HashSet<String>();
        for (String ilifile : ilifilev) {
            String parentdir = new File(ilifile).getAbsoluteFile().getParent();
            if (seenDirs.contains(parentdir)) continue;
            seenDirs.add(parentdir);
            ilipathv.add(parentdir);
        }
        String ili2cHome = Main.getIli2cHome();
        if (ili2cHome != null) {
            ilipathv.add(ili2cHome + File.separator + JAR_MODELS);
        }
        return ilipathv;
    }

    public static String getIli2cHome() {
        int start;
        String classpath = System.getProperty("java.class.path");
        int index = classpath.toLowerCase().indexOf(APP_JAR);
        return index > (start = classpath.lastIndexOf(File.pathSeparator, index) + 1) ? classpath.substring(start, index - 1) : null;
    }

    public static TransferDescription runCompiler(Configuration config) {
        return Main.runCompiler(config, null);
    }

    public static void setDefaultIli2cPathMap(Settings settings) {
        HashMap<String, String> pathmap = new HashMap<String, String>();
        String ili2cHome = Main.getIli2cHome();
        if (ili2cHome != null) {
            pathmap.put(JAR_DIR, ili2cHome + File.separator + JAR_MODELS);
        }
        pathmap.put(ILI_DIR, null);
        settings.setTransientObject("ch.interlis.ili2c.pathMap", pathmap);
    }

    public static TransferDescription runCompiler(Configuration config, Settings settings) {
        return Main.runCompiler(config, settings, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TransferDescription runCompiler(Configuration config, Settings settings, Ili2cMetaAttrs metaAttrs) {
        Object stream;
        FileEntry e;
        BoidEntry e2;
        ArrayList<Object> filev;
        block129: {
            block128: {
                String ilidirs;
                filev = new ArrayList<Object>();
                boolean doAutoCompleteModelList = config.isAutoCompleteModelList();
                if (doAutoCompleteModelList && settings != null && (ilidirs = settings.getValue("ch.interlis.ili2c.ilidirs")) == null) {
                    doAutoCompleteModelList = false;
                }
                if (!doAutoCompleteModelList) break block128;
                if (settings == null) {
                    Configuration files;
                    ArrayList<String> ilifilev = new ArrayList<String>();
                    Iterator filei = config.iteratorFileEntry();
                    while (filei.hasNext()) {
                        FileEntry e3 = (FileEntry)filei.next();
                        if (e3.getKind() != 1) continue;
                        String fileName = e3.getFilename();
                        ilifilev.add(fileName);
                    }
                    ArrayList<String> modeldirv = Main.getIliLookupPaths(ilifilev);
                    try {
                        files = ModelScan.getConfigWithFiles(modeldirv, ilifilev);
                    }
                    catch (Ili2cException ex) {
                        EhiLogger.logError((String)"ili-file scan failed", (Throwable)ex);
                        return null;
                    }
                    if (files == null) {
                        EhiLogger.logError((String)"ili-file scan failed");
                        return null;
                    }
                    Main.logIliFiles(files);
                    filei = files.iteratorFileEntry();
                    while (filei.hasNext()) {
                        e2 = (FileEntry)filei.next();
                        filev.add(e2);
                    }
                    break block129;
                } else {
                    IliResolver iliResolver;
                    String iliVersion = settings.getValue("ch.interlis.ili2c.iliLangVersion");
                    double version = 0.0;
                    if (iliVersion != null) {
                        version = Double.parseDouble(iliVersion);
                    }
                    ArrayList<String> ilifilev = new ArrayList<String>();
                    Iterator filei = config.iteratorFileEntry();
                    while (filei.hasNext()) {
                        FileEntry e4 = (FileEntry)filei.next();
                        if (e4.getKind() != 1) continue;
                        ilifilev.add(e4.getFilename());
                    }
                    Main.setHttpProxySystemProperties(settings);
                    HashMap pathmap = (HashMap)settings.getTransientObject("ch.interlis.ili2c.pathMap");
                    ArrayList modeldirv = Main.getModelRepos(settings, ilifilev, pathmap);
                    IliManager manager = (IliManager)settings.getTransientObject("ch.interlis.ili2c.customIliManager");
                    if (manager == null) {
                        manager = new IliManager();
                    }
                    if ((iliResolver = (IliResolver)settings.getTransientObject("ch.interlis.ili2c.customIliResolver")) != null) {
                        manager.setResolver(iliResolver);
                    }
                    manager.setRepositories(modeldirv.toArray(new String[1]));
                    String tempReposUri = settings.getTransientValue("ch.interlis.ili2c.tempReposUri");
                    if (tempReposUri != null) {
                        manager.setIliFiles(RepositoryVisitor.fixUri(tempReposUri), (IliFiles)settings.getTransientObject("ch.interlis.ili2c.tempReposIliFiles"));
                    }
                    try {
                        Configuration fileconfig = manager.getConfigWithFiles(ilifilev, metaAttrs, version);
                        Ili2c.logIliFiles(fileconfig);
                        Iterator filei2 = fileconfig.iteratorFileEntry();
                        while (filei2.hasNext()) {
                            e = (FileEntry)filei2.next();
                            filev.add(e);
                        }
                    }
                    catch (Ili2cException ex) {
                        EhiLogger.logError((Throwable)ex);
                        return null;
                    }
                }
            }
            Iterator filei = config.iteratorFileEntry();
            while (filei.hasNext()) {
                FileEntry e5 = (FileEntry)filei.next();
                filev.add(e5);
            }
        }
        TransferDescription desc = new TransferDescription();
        boolean emitPredefined = config.isIncPredefModel();
        boolean checkMetaObjs = config.isCheckMetaObjs();
        CompilerLogEvent.enableWarnings((boolean)config.isGenerateWarnings());
        Iterator boidi = config.iteratorBoidEntry();
        while (boidi.hasNext()) {
            e2 = (BoidEntry)boidi.next();
            desc.addMetadataMapping(e2.getMetaDataUseDef(), e2.getBoid());
        }
        double version = 0.0;
        for (FileEntry fileEntry : filev) {
            if (fileEntry.getKind() == 2) {
                if (!checkMetaObjs || MetaObjectParser.parse((TransferDescription)desc, (String)fileEntry.getFilename())) continue;
                return null;
            }
            String streamName = fileEntry.getFilename();
            if (version == 0.0) {
                version = ModelScan.getIliFileVersion(new File(streamName));
            }
            stream = null;
            try {
                stream = new InputStreamReader((InputStream)new FileInputStream(streamName), "UTF-8");
            }
            catch (Exception ex) {
                EhiLogger.logError((Throwable)ex);
                return null;
            }
            ErrorTracker tracker = null;
            try {
                tracker = new ErrorTracker();
                EhiLogger.getInstance().addListener((LogListener)tracker);
                if (version == 2.2) {
                    if (!Ili22Parser.parseIliFile((TransferDescription)desc, (String)streamName, (Reader)stream, (boolean)checkMetaObjs, (int)0, (Ili2cMetaAttrs)metaAttrs)) {
                        e = null;
                        return e;
                    }
                } else if (version == 2.4) {
                    if (!Ili24Parser.parseIliFile((TransferDescription)desc, (String)streamName, (Reader)stream, (boolean)checkMetaObjs, (int)0, (Ili2cMetaAttrs)metaAttrs)) {
                        e = null;
                        return e;
                    }
                } else if (version == 1.0) {
                    if (!Ili1Parser.parseIliFile((TransferDescription)desc, (String)streamName, (Reader)stream, (int)0, (Ili2cMetaAttrs)metaAttrs)) {
                        e = null;
                        return e;
                    }
                } else if (version == 2.3) {
                    if (!Ili23Parser.parseIliFile((TransferDescription)desc, (String)streamName, (Reader)stream, (boolean)checkMetaObjs, (int)0, (Ili2cMetaAttrs)metaAttrs)) {
                        e = null;
                        return e;
                    }
                } else {
                    EhiLogger.logError((String)Element.formatMessage((String)"err_wrongInterlisVersion", (String)Double.toString(version)));
                }
                if (!tracker.hasSeenErrors()) continue;
                e = null;
                return e;
            }
            catch (Exception ex5) {
                EhiLogger.logError((Throwable)ex5);
                TransferDescription ex2 = null;
                return ex2;
            }
            finally {
                if (tracker != null) {
                    EhiLogger.getInstance().removeListener((LogListener)tracker);
                    tracker = null;
                }
                try {
                    ((Reader)stream).close();
                }
                catch (IOException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
            }
        }
        Writer writer = null;
        try {
            switch (config.getOutputKind()) {
                case 1: {
                    return desc;
                }
                case 2: {
                    void var12_24;
                    if ("-".equals(config.getOutputFile())) {
                        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
                    } else {
                        try {
                            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(config.getOutputFile()), "UTF-8");
                        }
                        catch (IOException ex) {
                            EhiLogger.logError((Throwable)ex);
                            stream = desc;
                            if (writer == null) return stream;
                            try {
                                writer.close();
                                return stream;
                            }
                            catch (IOException ex3) {
                                EhiLogger.logError((Throwable)ex3);
                            }
                            return stream;
                        }
                    }
                    if (config.getParams() != null) {
                        Interlis1Generator.generate((Writer)var12_24, (TransferDescription)desc, (TransformationParameter)config.getParams());
                        return desc;
                    }
                    Interlis1Generator.generate((Writer)var12_24, (TransferDescription)desc, null);
                    return desc;
                }
                case 3: {
                    void var12_27;
                    if ("-".equals(config.getOutputFile())) {
                        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
                    } else {
                        try {
                            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(config.getOutputFile()), "UTF-8");
                        }
                        catch (IOException ex) {
                            EhiLogger.logError((Throwable)ex);
                            stream = desc;
                            if (writer == null) return stream;
                            try {
                                writer.close();
                                return stream;
                            }
                            catch (IOException ex4) {
                                EhiLogger.logError((Throwable)ex4);
                            }
                            return stream;
                        }
                    }
                    Interlis2Generator gen = new Interlis2Generator();
                    if (config.getLanguage() != null && config.getNlsxmlFilename() != null) {
                        ModelElements modelElements = Ili2TranslationXml.readModelElementsXml((File)new File(config.getNlsxmlFilename()));
                        gen.generateWithNewLanguage((Writer)var12_27, desc, modelElements, config.getLanguage());
                        return desc;
                    }
                    if (config.getParams() != null) {
                        gen.generateWithNewCrs((Writer)var12_27, desc, config.getParams());
                        return desc;
                    }
                    gen.generate((Writer)var12_27, desc, emitPredefined);
                    return desc;
                }
                case 4: {
                    void var12_30;
                    String ver = desc.getLastModel().getIliVersion();
                    if (!ver.equals("2.2") && !ver.equals("2.3")) {
                        XSD24Generator.generate((TransferDescription)desc, (File)new File(config.getOutputFile()));
                        return desc;
                    }
                    if ("-".equals(config.getOutputFile())) {
                        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
                    } else {
                        try {
                            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(config.getOutputFile()), "UTF-8"));
                        }
                        catch (IOException ex) {
                            EhiLogger.logError((Throwable)ex);
                            TransferDescription ex5 = desc;
                            if (writer == null) return ex5;
                            try {
                                writer.close();
                                return ex5;
                            }
                            catch (IOException ex6) {
                                EhiLogger.logError((Throwable)ex6);
                            }
                            return ex5;
                        }
                    }
                    if (ver.equals("2.2")) {
                        XSD22Generator.generate((Writer)var12_30, (TransferDescription)desc);
                        return desc;
                    }
                    if (!ver.equals("2.3")) return desc;
                    XSDGenerator.generate((Writer)var12_30, (TransferDescription)desc);
                    return desc;
                }
                case 5: {
                    void var12_34;
                    TransferDescription ex;
                    if ("-".equals(config.getOutputFile())) {
                        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
                    } else {
                        try {
                            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(config.getOutputFile()), "UTF-8");
                        }
                        catch (IOException ex7) {
                            EhiLogger.logError((Throwable)ex7);
                            ex = desc;
                            if (writer == null) return ex;
                            try {
                                writer.close();
                                return ex;
                            }
                            catch (IOException ex8) {
                                EhiLogger.logError((Throwable)ex8);
                            }
                            return ex;
                        }
                    }
                    Interlis1Generator.generateFmt((Writer)var12_34, (TransferDescription)desc);
                    return desc;
                }
                case 6: {
                    Gml32Generator.generate((TransferDescription)desc, (String)config.getOutputFile());
                    return desc;
                }
                case 11: {
                    Iligml20Generator.generate((TransferDescription)desc, (String)config.getOutputFile());
                    return desc;
                }
                case 8: {
                    ETF1Generator.generate((TransferDescription)desc, (String)config.getOutputFile());
                    return desc;
                }
                case 9: {
                    ImdGenerator.generate(new File(config.getOutputFile()), desc, "ili2c-" + TransferDescription.getVersion());
                    return desc;
                }
                case 13: {
                    Main.generateXML(config, desc);
                    return desc;
                }
                case 12: {
                    Imd16Generator.generate(new File(config.getOutputFile()), desc, "ili2c-" + TransferDescription.getVersion());
                    return desc;
                }
                case 10: {
                    Uml21Generator.generate((File)new File(config.getOutputFile()), (TransferDescription)desc);
                    return desc;
                }
                case 7: {
                    void var12_37;
                    TransferDescription ex;
                    if ("-".equals(config.getOutputFile())) {
                        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
                    } else {
                        try {
                            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(config.getOutputFile()), "UTF-8"));
                        }
                        catch (IOException ex9) {
                            EhiLogger.logError((Throwable)ex9);
                            ex = desc;
                            if (writer == null) return ex;
                            try {
                                writer.close();
                                return ex;
                            }
                            catch (IOException ex10) {
                                EhiLogger.logError((Throwable)ex10);
                            }
                            return ex;
                        }
                    }
                    IomGenerator.generate((Writer)var12_37, desc);
                    return desc;
                }
            }
            return desc;
        }
        catch (Throwable e6) {
            EhiLogger.logError((String)"failed to generate output", (Throwable)e6);
            TransferDescription transferDescription = null;
            return transferDescription;
        }
        finally {
            void var12_38;
            if (var12_38 != null) {
                try {
                    var12_38.close();
                }
                catch (IOException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
            }
        }
    }

    private static void generateXML(Configuration config, TransferDescription desc) throws Exception {
        FileEntry e = config.getFileEntry(config.getSizeFileEntry() - 1);
        Ili2TranslationXml xml = new Ili2TranslationXml();
        ModelElements eles = xml.convertTransferDescription2ModelElements(desc);
        Ili2TranslationXml.writeModelElementsAsXML((ModelElements)eles, (File)new File(config.getOutputFile()));
    }

    private static ArrayList getModelRepos(Settings settings, ArrayList<String> ilifilev, HashMap pathmap) {
        ArrayList<String> modeldirv = new ArrayList<String>();
        if (pathmap == null) {
            pathmap = new HashMap();
        }
        String ilidirs = settings.getValue("ch.interlis.ili2c.ilidirs");
        String[] modeldirs = ilidirs.split(";");
        HashSet<String> ilifiledirs = new HashSet<String>();
        for (int modeli = 0; modeli < modeldirs.length; ++modeli) {
            String m = modeldirs[modeli];
            if (m.equals(ILI_DIR) && pathmap.containsKey(ILI_DIR)) {
                for (int filei = 0; filei < ilifilev.size(); ++filei) {
                    String ilifile = ilifilev.get(filei);
                    if (GenericFileFilter.getFileExtension((String)ilifile) == null || (m = new File(ilifile).getAbsoluteFile().getParentFile().getAbsolutePath()) == null || m.length() <= 0 || ilifiledirs.contains(m)) continue;
                    ilifiledirs.add(m);
                    modeldirv.add(m);
                }
                continue;
            }
            if (m.startsWith("%")) {
                String key = m;
                EhiLogger.traceState((String)("pathmap key <" + key + ">"));
                if (!pathmap.containsKey(key) || (m = (String)pathmap.get(key)) == null || m.length() <= 0) continue;
                modeldirv.add(m);
                continue;
            }
            if (m == null || m.length() <= 0) continue;
            modeldirv.add(m);
        }
        return modeldirv;
    }

    public static void setHttpProxySystemProperties(Settings settings) {
        String httpProxyHost = settings.getValue("ch.interlis.ili2c.http_proxy_host");
        String httpProxyPort = settings.getValue("ch.interlis.ili2c.http_proxy_port");
        if (httpProxyHost != null) {
            EhiLogger.logState((String)("httpProxyHost <" + httpProxyHost + ">"));
            System.setProperty("http.proxyHost", httpProxyHost);
            System.setProperty("https.proxyHost", httpProxyHost);
            if (httpProxyPort != null) {
                EhiLogger.logState((String)("httpProxyPort <" + httpProxyPort + ">"));
                System.setProperty("http.proxyPort", httpProxyPort);
                System.setProperty("https.proxyPort", httpProxyPort);
            }
        } else {
            System.setProperty("java.net.useSystemProxies", "true");
        }
    }

    public static boolean editConfig(Configuration config) {
        ch.interlis.ili2c.gui.Main dialog = new ch.interlis.ili2c.gui.Main();
        return dialog.showDialog();
    }

    @Deprecated
    public static String getVersion() {
        return TransferDescription.getVersion();
    }

    public static TransferDescription compileIliModels(ArrayList modelv, ArrayList modeldirv, String ilxFile) {
        Configuration config = null;
        try {
            config = ModelScan.getConfig(modeldirv, modelv);
        }
        catch (Ili2cException ex) {
            EhiLogger.logError((String)"ili-file scan failed", (Throwable)ex);
            return null;
        }
        if (config == null) {
            return null;
        }
        config.setGenerateWarnings(false);
        Main.logIliFiles(config);
        if (ilxFile != null) {
            config.setOutputKind(7);
            config.setOutputFile(ilxFile);
        } else {
            config.setOutputKind(1);
        }
        TransferDescription ret = Main.runCompiler(config);
        return ret;
    }

    public static TransferDescription compileIliFiles(ArrayList filev, ArrayList modeldirv, String ilxFile) {
        Configuration config = null;
        try {
            config = ModelScan.getConfigWithFiles(modeldirv, filev);
        }
        catch (Ili2cException ex) {
            EhiLogger.logError((String)"ili-file scan failed", (Throwable)ex);
            return null;
        }
        if (config == null) {
            return null;
        }
        Main.logIliFiles(config);
        config.setGenerateWarnings(false);
        if (ilxFile != null) {
            config.setOutputKind(7);
            config.setOutputFile(ilxFile);
        } else {
            config.setOutputKind(1);
        }
        TransferDescription ret = Main.runCompiler(config);
        return ret;
    }

    public static ObjectPath parseObjectOrAttributePath(Viewable viewable, String objectPath) throws Ili2cException {
        TransferDescription td = (TransferDescription)viewable.getContainer(TransferDescription.class);
        return Ili23Parser.parseObjectOrAttributePath((TransferDescription)td, (Viewable)viewable, (String)objectPath);
    }

    public static void logIliFiles(Configuration config) {
        Iterator filei = config.iteratorFileEntry();
        while (filei.hasNext()) {
            FileEntry file = (FileEntry)filei.next();
            EhiLogger.logState((String)("ilifile <" + file.getFilename() + ">"));
        }
    }
}

