/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.validator;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox_j.inifile.IniFileReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ValidationConfig
implements IoxValidationConfig {
    private HashMap<String, HashMap<String, String>> data = new HashMap();
    public static final String MULTIPLICITY = "multiplicity";
    public static final String TYPE = "type";
    public static final String TOPOLOGY = "topology";
    public static final String TARGET = "target";
    public static final String REQUIRED_IN = "requiredIn";
    public static final String MSG = "msg";
    public static final String CHECK = "check";
    public static final String KEYMSG = "keymsg";
    public static final String ILI_METAATTR_PREFIX = "ilivalid.";
    public static final String WARNING = "warning";
    public static final String OFF = "off";
    public static final String ON = "on";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String PARAMETER = "PARAMETER";
    public static final String VALIDATION = "validation";
    public static final String AREA_OVERLAP_VALIDATION = "areaOverlapValidation";
    public static final String CONSTRAINT_VALIDATION = "constraintValidation";
    public static final String DEFAULT_GEOMETRY_TYPE_VALIDATION = "defaultGeometryTypeValidation";
    public static final String ADDITIONAL_MODELS = "additionalModels";
    public static final String VERIFY_MODEL_VERSION = "verifyModelVersion";
    public static final String ALLOW_ONLY_MULTIPLICITY_REDUCTION = "allowOnlyMultiplicityReduction";
    public static final String ALL_OBJECTS_ACCESSIBLE = "allObjectsAccessible";
    public static final String DISABLE_ROUNDING = "disableRounding";
    public static final String DISABLE_AREAREAS_MESSAGES = "disableAreAreasMessages";
    public static final String TOPOLOGY_VALIDATION_OK = "topologyValidationOk";

    public void mergeIliMetaAttrs(TransferDescription td) {
        this.mergeIliMetaAttrsHelper((Element)td);
    }

    private void mergeIliMetaAttrsHelper(Element ele) {
        Settings metaValues = ele.getMetaValues();
        String iliQName = null;
        if (ele instanceof AttributeDef) {
            iliQName = ele.getContainer().getScopedName(null) + "." + ele.getName();
        } else if (ele instanceof RoleDef) {
            iliQName = ele.getContainer().getScopedName(null) + "." + ele.getName();
        } else if (ele instanceof Constraint) {
            Object constraintName = ele.getName();
            if (constraintName == null) {
                constraintName = this.getConstraintName((Constraint)ele);
            }
            iliQName = ele.getContainer().getScopedName(null) + "." + (String)constraintName;
        } else {
            iliQName = ele.getScopedName(null);
        }
        if (iliQName != null) {
            for (String name : metaValues.getValues()) {
                if (!name.startsWith(ILI_METAATTR_PREFIX)) continue;
                String paramName = name.substring(ILI_METAATTR_PREFIX.length());
                String paramValue = metaValues.getValue(name);
                this.setConfigValue(iliQName, paramName, paramValue);
            }
        }
        if (ele instanceof Container) {
            for (Element subEle : (Container)ele) {
                this.mergeIliMetaAttrsHelper(subEle);
            }
        }
    }

    private String getConstraintName(Constraint ele) {
        String name = ele.getMetaValue("name");
        if (name != null) {
            return name;
        }
        Container container = ele.getContainer();
        int cnstrIdx = 0;
        for (Element element : container) {
            if (element == ele) {
                return "CONSTRAINT" + cnstrIdx;
            }
            if (!(element instanceof Constraint)) continue;
            ++cnstrIdx;
        }
        return null;
    }

    public void mergeConfigFile(File file) throws IOException {
        IniFileReader.mergeIniFile(this, file);
    }

    public static ValidationConfig readFromConfigFile(File file) throws IOException {
        ValidationConfig ret = IniFileReader.readFile(file);
        return ret;
    }

    private static String stripQuotes(String key) {
        if (key.startsWith("\"") && key.endsWith("\"")) {
            return key.substring(1, key.length() - 1);
        }
        return key;
    }

    public Set<String> getConfigParams(String iliQName) {
        HashMap<String, String> modelele = null;
        if (this.data.containsKey(iliQName)) {
            modelele = this.data.get(iliQName);
        }
        if (modelele == null) {
            return null;
        }
        return new HashSet<String>(modelele.keySet());
    }

    public String getConfigValue(String iliQName, String configParam) {
        HashMap<String, String> modelele = null;
        if (this.data.containsKey(iliQName)) {
            modelele = this.data.get(iliQName);
        }
        if (modelele == null) {
            return null;
        }
        return (String)modelele.get(configParam);
    }

    public Set<String> getIliQnames() {
        return new HashSet<String>(this.data.keySet());
    }

    public void setConfigValue(String iliQName, String configParam, String value) {
        EhiLogger.traceState((String)("modelele <" + iliQName + ">, param <" + configParam + ">, value <" + value + ">"));
        HashMap<Object, Object> modelele = null;
        if (this.data.containsKey(iliQName)) {
            modelele = this.data.get(iliQName);
        } else {
            modelele = new HashMap();
            this.data.put(iliQName, modelele);
        }
        modelele.put(configParam, value);
    }
}

