/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.xtf;

import ch.interlis.ili2c.generator.XSD24Generator;
import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.BlackboxType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.OIDType;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom_j.ViewableProperties;
import ch.interlis.iom_j.ViewableProperty;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iom_j.xtf.XtfModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Ili2cUtility {
    private Ili2cUtility() {
    }

    public static ViewableProperties getIoxMappingTable(TransferDescription td) {
        ViewableProperties mapping = new ViewableProperties();
        if (td.getLastModel().getIliVersion().equals("2.4")) {
            mapping.setXtf24nameMapping(XSD24Generator.createName2NameMapping((TransferDescription)td));
            HashMap tagv = XSD24Generator.createDef2NameMapping((TransferDescription)td);
            for (Element ili2cEle : tagv.keySet()) {
                String tag = null;
                ArrayList propv = null;
                if (ili2cEle instanceof AttributeDef) {
                    AttributeDef attr = (AttributeDef)ili2cEle;
                    tag = ili2cEle.getContainer().getScopedName(null) + "." + ili2cEle.getName();
                    propv = Ili2cUtility.mapLinetable(attr);
                } else if (ili2cEle instanceof Viewable) {
                    propv = new ArrayList();
                    Viewable v = (Viewable)ili2cEle;
                    tag = v.getScopedName(null);
                    Iterator iter = v.getAttributesAndRoles2();
                    while (iter.hasNext()) {
                        ViewableTransferElement obj = (ViewableTransferElement)iter.next();
                        ViewableProperty prop = Ili2cUtility.mapViewableTransferElement(v, obj);
                        propv.add(prop);
                    }
                }
                if (propv == null) continue;
                mapping.defineClass(tag, propv.toArray(new ViewableProperty[propv.size()]));
            }
        } else {
            HashMap tagv = XSDGenerator.getTagMap((TransferDescription)td);
            for (String tag : tagv.keySet()) {
                Viewable v = (Viewable)tagv.get(tag);
                Iterator iter = v.getAttributesAndRoles2();
                ArrayList<ViewableProperty> propv = new ArrayList<ViewableProperty>();
                while (iter.hasNext()) {
                    ViewableTransferElement obj = (ViewableTransferElement)iter.next();
                    ViewableProperty prop = Ili2cUtility.mapViewableTransferElement(v, obj);
                    propv.add(prop);
                }
                mapping.defineClass(tag, propv.toArray(new ViewableProperty[propv.size()]));
            }
        }
        return mapping;
    }

    public static ArrayList mapLinetable(AttributeDef attr) {
        ArrayList<ViewableProperty> propv = new ArrayList<ViewableProperty>();
        Table linattrTab = ((AreaType)attr.getDomainResolvingAliases()).getLineAttributeStructure();
        if (linattrTab != null) {
            Iterator iter = linattrTab.getAttributesAndRoles2();
            while (iter.hasNext()) {
                String propName = null;
                ViewableTransferElement obj = (ViewableTransferElement)iter.next();
                if (obj.obj instanceof AttributeDef) {
                    propName = ((AttributeDef)obj.obj).getName();
                }
                if (obj.obj instanceof RoleDef) {
                    AssociationDef roleOwner;
                    RoleDef role = (RoleDef)obj.obj;
                    if (obj.embedded && (roleOwner = (AssociationDef)role.getContainer()).getDerivedFrom() == null) {
                        propName = role.getName();
                    }
                }
                if (propName == null) continue;
                ViewableProperty prop = new ViewableProperty(propName);
                propv.add(prop);
            }
        }
        ViewableProperty prop = new ViewableProperty(ModelUtilities.getHelperTableGeomAttrName(attr));
        if (attr.isFinal()) {
            prop.setTypeFinal(true);
        }
        propv.add(prop);
        return propv;
    }

    public static ViewableProperty mapViewableTransferElement(Viewable v, ViewableTransferElement obj) {
        ViewableProperty prop = null;
        if (obj.obj instanceof AttributeDef) {
            AttributeDef attr = (AttributeDef)obj.obj;
            prop = new ViewableProperty(attr.getName());
            Type type = attr.getDomain();
            if (type instanceof TypeAlias) {
                Domain domainDef = ((TypeAlias)type).getAliasing();
                if (domainDef.getType() instanceof EnumerationType) {
                    prop.setEnumType(domainDef.getScopedName(null));
                }
                if (domainDef.isFinal()) {
                    prop.setTypeFinal(true);
                }
            } else {
                if (type instanceof EnumerationType) {
                    prop.setEnumType(attr.getContainer().getScopedName(null) + ":" + attr.getName());
                }
                if (attr.isFinal()) {
                    prop.setTypeFinal(true);
                }
            }
            if (attr.getDomainResolvingAliases() instanceof OIDType) {
                prop.setTypeOid(true);
            } else if (attr.getDomainResolvingAliases() instanceof BlackboxType) {
                BlackboxType bbType = (BlackboxType)attr.getDomainResolvingAliases();
                if (bbType.getKind() == 2) {
                    prop.setTypeBlackboxBin(true);
                } else {
                    prop.setTypeBlackboxXml(true);
                }
            }
            AttributeDef baseAttr = attr;
            if (attr.getExtending() != null) {
                baseAttr = (AttributeDef)attr.getExtending();
                while (baseAttr.getExtending() != null) {
                    baseAttr = (AttributeDef)baseAttr.getExtending();
                }
            }
            if (baseAttr.getContainer() != v) {
                prop.setBaseDefInClass(baseAttr.getContainer().getScopedName(null));
            }
        }
        if (obj.obj instanceof RoleDef) {
            RoleDef role = (RoleDef)obj.obj;
            if (obj.embedded) {
                AssociationDef roleOwner = (AssociationDef)role.getContainer();
                if (roleOwner.getDerivedFrom() == null) {
                    prop = new ViewableProperty(role.getName());
                    RoleDef baseOppRole = role.getOppEnd().getRootExtending();
                    if (baseOppRole == null) {
                        baseOppRole = role.getOppEnd();
                    }
                    if (baseOppRole.getDestination() != v) {
                        prop.setBaseDefInClass(baseOppRole.getDestination().getScopedName(null));
                    }
                }
            } else {
                prop = new ViewableProperty(role.getName());
                RoleDef baseRole = role.getRootExtending();
                if (baseRole == null) {
                    baseRole = role;
                }
                if (baseRole.getContainer() != v) {
                    prop.setBaseDefInClass(baseRole.getContainer().getScopedName(null));
                }
            }
        }
        return prop;
    }

    public static XtfModel[] buildModelList(TransferDescription td) {
        ArrayList modelv = new ArrayList();
        for (Object modelo : td) {
            if (modelo instanceof PredefinedModel || !(modelo instanceof Model)) continue;
            modelv.add(modelo);
        }
        XtfModel[] ret = new XtfModel[modelv.size()];
        for (int i = 0; i < modelv.size(); ++i) {
            Model model = (Model)modelv.get(i);
            ret[i] = new XtfModel();
            ret[i].setName(model.getName());
            String version = model.getModelVersion();
            ret[i].setVersion(version == null ? "" : version);
            String issuer = model.getIssuer();
            ret[i].setUri(issuer == null ? "" : issuer);
        }
        return ret;
    }
}

