/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.validator.gui;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.swing.SwingWorker;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.basics.view.FileChooser;
import ch.ehi.basics.view.GenericFileFilter;
import ch.interlis.ili2c.gui.RepositoriesDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.interlis2.validator.Main;
import org.interlis2.validator.Validator;
import org.interlis2.validator.gui.LogListener;

public class MainFrame
extends JFrame {
    private ResourceBundle rsrc = ResourceBundle.getBundle("org.interlis2.validator.gui.IliValidatorTexts");
    private Settings settings = null;
    private JPanel jContentPane = null;
    private JLabel xtfFileLabel = null;
    private JTextArea xtfFileUi = null;
    private JCheckBox allObjectsAccessibleUi = null;
    private JButton doXtfFileSelBtn = null;
    private JLabel modelNamesLabel = null;
    private JTextField modelNamesUi = null;
    private JLabel configFileLabel = null;
    private JTextField configFileUi = null;
    private JButton doConfigFileSelBtn = null;
    private JLabel logFileLabel = null;
    private JTextField logFileUi = null;
    private JButton doLogFileSelBtn = null;
    private JLabel xtfLogFileLabel = null;
    private JTextField xtfLogFileUi = null;
    private JButton doXtfLogFileSelBtn = null;
    private JButton doNewConfigFileBtn = null;
    private JTextArea logUi = null;
    private JButton clearlogBtn = null;
    private JCheckBoxMenuItem optionsSkipPolygonBuildingItem = null;
    private JCheckBoxMenuItem optionsMultiplicityOffItem = null;
    private JCheckBoxMenuItem optionsAllowItfAreaHolesItem = null;
    private JCheckBoxMenuItem optionsTraceItem = null;
    private JCheckBoxMenuItem optionsDisableConstraintValidationItem = null;
    private JCheckBoxMenuItem optionsDisableAreaValidationItem = null;
    private StringBuffer body = new StringBuffer();
    private JScrollPane jScrollPane = null;
    private JButton doValidateBtn = null;

    public MainFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(500, 361);
        this.setContentPane(this.getJContentPane());
        this.setDefaultCloseOperation(3);
        this.setName("ilivalidator");
        this.setTitle(this.rsrc.getString("MainFrame.Title"));
        this.xtfFileUi.setBorder(new JTextField().getBorder());
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu(this.rsrc.getString("MainFrame.ToolsMenu"));
        menu.setMnemonic(84);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem(this.rsrc.getString("MainFrame.ModelRepositoriesMenuItem"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoriesDialog dlg = new RepositoriesDialog(MainFrame.this);
                dlg.setIlidirs(MainFrame.this.settings.getValue("org.interlis2.validator.ilidirs"));
                dlg.setHttpProxyHost(MainFrame.this.settings.getValue("ch.interlis.ili2c.http_proxy_host"));
                dlg.setHttpProxyPort(MainFrame.this.settings.getValue("ch.interlis.ili2c.http_proxy_port"));
                if (dlg.showDialog() == 1) {
                    String ilidirs = dlg.getIlidirs();
                    if (ilidirs == null) {
                        ilidirs = "%ITF_DIR;http://models.interlis.ch/;%JAR_DIR/ilimodels";
                    }
                    MainFrame.this.settings.setValue("org.interlis2.validator.ilidirs", ilidirs);
                    MainFrame.this.settings.setValue("ch.interlis.ili2c.http_proxy_host", dlg.getHttpProxyHost());
                    MainFrame.this.settings.setValue("ch.interlis.ili2c.http_proxy_port", dlg.getHttpProxyPort());
                    MainFrame.this.saveSettings(MainFrame.this.settings);
                }
            }
        });
        menu.add(menuItem);
        JMenu optionsMenu = new JMenu(this.rsrc.getString("MainFrame.OptionsMenu"));
        optionsMenu.setMnemonic(84);
        menuBar.add(optionsMenu);
        this.optionsMultiplicityOffItem = new JCheckBoxMenuItem(this.rsrc.getString("MainFrame.OptionsMultiplicityOffItem"));
        optionsMenu.add(this.optionsMultiplicityOffItem);
        this.optionsSkipPolygonBuildingItem = new JCheckBoxMenuItem(this.rsrc.getString("MainFrame.OptionsSkipPolygonBuildingItem"));
        optionsMenu.add(this.optionsSkipPolygonBuildingItem);
        this.optionsAllowItfAreaHolesItem = new JCheckBoxMenuItem(this.rsrc.getString("MainFrame.OptionsAllowItfAreaHolesItem"));
        optionsMenu.add(this.optionsAllowItfAreaHolesItem);
        this.optionsDisableConstraintValidationItem = new JCheckBoxMenuItem(this.rsrc.getString("MainFrame.OptionsDisableConstraintValidationItem"));
        optionsMenu.add(this.optionsDisableConstraintValidationItem);
        this.optionsDisableAreaValidationItem = new JCheckBoxMenuItem(this.rsrc.getString("MainFrame.OptionsDisableAreaValidationItem"));
        optionsMenu.add(this.optionsDisableAreaValidationItem);
        this.optionsTraceItem = new JCheckBoxMenuItem(this.rsrc.getString("MainFrame.OptionsTraceItem"));
        optionsMenu.add(this.optionsTraceItem);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrame.this.saveSettings(MainFrame.this.getSettings());
                System.exit(0);
            }
        });
    }

    private void saveSettings(Settings settings) {
        Settings toSave = new Settings();
        toSave.setValue("WORKING_DIRECTORY", settings.getValue("WORKING_DIRECTORY"));
        toSave.setValue("org.interlis2.validator.ilidirs", settings.getValue("org.interlis2.validator.ilidirs"));
        toSave.setValue("org.interlis2.validator.modelNames", settings.getValue("org.interlis2.validator.modelNames"));
        toSave.setValue("org.interlis2.validator.allobjectsaccessible", settings.getValue("org.interlis2.validator.allobjectsaccessible"));
        toSave.setValue("ch.interlis.ili2c.http_proxy_host", settings.getValue("ch.interlis.ili2c.http_proxy_host"));
        toSave.setValue("ch.interlis.ili2c.http_proxy_port", settings.getValue("ch.interlis.ili2c.http_proxy_port"));
        Main.writeSettings(toSave);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            GridBagConstraints xtfFileLabelConstraints = new GridBagConstraints();
            GridBagConstraints xtfFileUiConstraints = new GridBagConstraints();
            GridBagConstraints allObjectsAccessibleConstraints = new GridBagConstraints();
            GridBagConstraints doXtfFileSelBtnConstraints = new GridBagConstraints();
            GridBagConstraints modelNamesLabelConstraints = new GridBagConstraints();
            GridBagConstraints modelNamesUiConstraints = new GridBagConstraints();
            GridBagConstraints logFileLabelConstraints = new GridBagConstraints();
            GridBagConstraints logFileUiConstraints = new GridBagConstraints();
            GridBagConstraints doLogFileSelBtnConstraints = new GridBagConstraints();
            GridBagConstraints xtfLogFileLabelConstraints = new GridBagConstraints();
            GridBagConstraints xtfLogFileUiConstraints = new GridBagConstraints();
            GridBagConstraints doXtfLogFileSelBtnConstraints = new GridBagConstraints();
            GridBagConstraints configFileLabelConstraints = new GridBagConstraints();
            GridBagConstraints configFileUiConstraints = new GridBagConstraints();
            GridBagConstraints doConfigFileSelBtnConstraints = new GridBagConstraints();
            GridBagConstraints doNewConfigFileBtnConstraints = new GridBagConstraints();
            GridBagConstraints clearlogBtnConstraints = new GridBagConstraints();
            GridBagConstraints logPaneConstraints = new GridBagConstraints();
            GridBagConstraints doValidateConstraints = new GridBagConstraints();
            xtfFileLabelConstraints.gridx = 0;
            xtfFileLabelConstraints.gridy = 0;
            xtfFileLabelConstraints.anchor = 18;
            xtfFileUiConstraints.fill = 2;
            xtfFileUiConstraints.weightx = 1.0;
            xtfFileUiConstraints.gridx = 1;
            xtfFileUiConstraints.gridy = 0;
            xtfFileUiConstraints.anchor = 18;
            doXtfFileSelBtnConstraints.gridx = 2;
            doXtfFileSelBtnConstraints.gridy = 0;
            doXtfFileSelBtnConstraints.anchor = 17;
            allObjectsAccessibleConstraints.gridx = 1;
            allObjectsAccessibleConstraints.gridy = 1;
            allObjectsAccessibleConstraints.anchor = 18;
            modelNamesLabelConstraints.gridx = 0;
            modelNamesLabelConstraints.gridy = 2;
            modelNamesLabelConstraints.anchor = 18;
            modelNamesUiConstraints.fill = 2;
            modelNamesUiConstraints.weightx = 1.0;
            modelNamesUiConstraints.gridx = 1;
            modelNamesUiConstraints.gridy = 2;
            modelNamesUiConstraints.anchor = 18;
            logFileLabelConstraints.gridx = 0;
            logFileLabelConstraints.gridy = 3;
            logFileLabelConstraints.anchor = 18;
            logFileUiConstraints.fill = 2;
            logFileUiConstraints.weightx = 1.0;
            logFileUiConstraints.gridx = 1;
            logFileUiConstraints.gridy = 3;
            logFileUiConstraints.anchor = 18;
            doLogFileSelBtnConstraints.gridx = 2;
            doLogFileSelBtnConstraints.gridy = 3;
            doLogFileSelBtnConstraints.anchor = 17;
            xtfLogFileLabelConstraints.gridx = 0;
            xtfLogFileLabelConstraints.gridy = 4;
            xtfLogFileLabelConstraints.anchor = 18;
            xtfLogFileUiConstraints.fill = 2;
            xtfLogFileUiConstraints.weightx = 1.0;
            xtfLogFileUiConstraints.gridx = 1;
            xtfLogFileUiConstraints.gridy = 4;
            xtfLogFileUiConstraints.anchor = 18;
            doXtfLogFileSelBtnConstraints.gridx = 2;
            doXtfLogFileSelBtnConstraints.gridy = 4;
            doXtfLogFileSelBtnConstraints.anchor = 17;
            configFileLabelConstraints.gridx = 0;
            configFileLabelConstraints.gridy = 5;
            configFileLabelConstraints.anchor = 18;
            configFileUiConstraints.fill = 2;
            configFileUiConstraints.weightx = 1.0;
            configFileUiConstraints.gridx = 1;
            configFileUiConstraints.gridy = 5;
            configFileUiConstraints.anchor = 18;
            doConfigFileSelBtnConstraints.gridx = 2;
            doConfigFileSelBtnConstraints.gridy = 5;
            doConfigFileSelBtnConstraints.anchor = 17;
            doNewConfigFileBtnConstraints.gridx = 3;
            doNewConfigFileBtnConstraints.gridy = 5;
            logPaneConstraints.fill = 1;
            logPaneConstraints.weightx = 1.0;
            logPaneConstraints.weighty = 1.0;
            logPaneConstraints.gridx = 0;
            logPaneConstraints.gridy = 6;
            logPaneConstraints.gridheight = 2;
            logPaneConstraints.gridwidth = 2;
            doValidateConstraints.gridy = 6;
            doValidateConstraints.gridx = 2;
            doValidateConstraints.gridwidth = 2;
            doValidateConstraints.anchor = 17;
            clearlogBtnConstraints.gridx = 2;
            clearlogBtnConstraints.gridy = 7;
            clearlogBtnConstraints.gridwidth = 2;
            clearlogBtnConstraints.anchor = 18;
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getXtfFileLabel(), xtfFileLabelConstraints);
            this.jContentPane.add((Component)this.getXtfFileUi(), xtfFileUiConstraints);
            this.jContentPane.add((Component)this.getDoXtfFileSelBtn(), doXtfFileSelBtnConstraints);
            this.jContentPane.add((Component)this.getModelNamesLabel(), modelNamesLabelConstraints);
            this.jContentPane.add((Component)this.getModelNamesUi(), modelNamesUiConstraints);
            this.jContentPane.add((Component)this.getLogFileLabel(), logFileLabelConstraints);
            this.jContentPane.add((Component)this.getLogFileUi(), logFileUiConstraints);
            this.jContentPane.add((Component)this.getDoLogFileSelBtn(), doLogFileSelBtnConstraints);
            this.jContentPane.add((Component)this.getXtfLogFileLabel(), xtfLogFileLabelConstraints);
            this.jContentPane.add((Component)this.getXtfLogFileUi(), xtfLogFileUiConstraints);
            this.jContentPane.add((Component)this.getDoXtfLogFileSelBtn(), doXtfLogFileSelBtnConstraints);
            this.jContentPane.add((Component)this.getConfigFileLabel(), configFileLabelConstraints);
            this.jContentPane.add((Component)this.getConfigFileUi(), configFileUiConstraints);
            this.jContentPane.add((Component)this.getDoConfigFileSelBtn(), doConfigFileSelBtnConstraints);
            this.jContentPane.add((Component)this.getNewConfigFileBtn(), doNewConfigFileBtnConstraints);
            this.jContentPane.add((Component)this.getJScrollPane(), logPaneConstraints);
            this.jContentPane.add((Component)this.getClearlogBtn(), clearlogBtnConstraints);
            this.jContentPane.add((Component)this.getAllObjectsAccessibleUi(), allObjectsAccessibleConstraints);
            this.jContentPane.add((Component)this.getDoValidateBtn(), doValidateConstraints);
        }
        return this.jContentPane;
    }

    private JLabel getXtfFileLabel() {
        if (this.xtfFileLabel == null) {
            this.xtfFileLabel = new JLabel();
            this.xtfFileLabel.setText(this.rsrc.getString("MainFrame.xtfFileLabel"));
        }
        return this.xtfFileLabel;
    }

    private JLabel getModelNamesLabel() {
        if (this.modelNamesLabel == null) {
            this.modelNamesLabel = new JLabel();
            this.modelNamesLabel.setText(this.rsrc.getString("MainFrame.modelNamesLabel"));
        }
        return this.modelNamesLabel;
    }

    private JLabel getConfigFileLabel() {
        if (this.configFileLabel == null) {
            this.configFileLabel = new JLabel();
            this.configFileLabel.setText(this.rsrc.getString("MainFrame.configFileLabel"));
        }
        return this.configFileLabel;
    }

    private JLabel getLogFileLabel() {
        if (this.logFileLabel == null) {
            this.logFileLabel = new JLabel();
            this.logFileLabel.setText(this.rsrc.getString("MainFrame.logFileLabel"));
        }
        return this.logFileLabel;
    }

    private JLabel getXtfLogFileLabel() {
        if (this.xtfLogFileLabel == null) {
            this.xtfLogFileLabel = new JLabel();
            this.xtfLogFileLabel.setText(this.rsrc.getString("MainFrame.xtfLogFileLabel"));
        }
        return this.xtfLogFileLabel;
    }

    private JTextArea getXtfFileUi() {
        if (this.xtfFileUi == null) {
            this.xtfFileUi = new JTextArea();
        }
        return this.xtfFileUi;
    }

    private JTextField getModelNamesUi() {
        if (this.modelNamesUi == null) {
            this.modelNamesUi = new JTextField();
        }
        return this.modelNamesUi;
    }

    private JTextField getConfigFileUi() {
        if (this.configFileUi == null) {
            this.configFileUi = new JTextField();
        }
        return this.configFileUi;
    }

    private JTextField getLogFileUi() {
        if (this.logFileUi == null) {
            this.logFileUi = new JTextField();
        }
        return this.logFileUi;
    }

    private JTextField getXtfLogFileUi() {
        if (this.xtfLogFileUi == null) {
            this.xtfLogFileUi = new JTextField();
        }
        return this.xtfLogFileUi;
    }

    private JTextArea getLogUi() {
        if (this.logUi == null) {
            this.logUi = new JTextArea();
            this.logUi.setEditable(false);
        }
        return this.logUi;
    }

    private JButton getClearlogBtn() {
        if (this.clearlogBtn == null) {
            this.clearlogBtn = new JButton();
            this.clearlogBtn.setText(this.rsrc.getString("MainFrame.clearLogButton"));
            this.clearlogBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.logClear();
                }
            });
        }
        return this.clearlogBtn;
    }

    private JCheckBox getAllObjectsAccessibleUi() {
        if (this.allObjectsAccessibleUi == null) {
            this.allObjectsAccessibleUi = new JCheckBox();
            this.allObjectsAccessibleUi.setText(this.rsrc.getString("MainFrame.allObjectsAccessible"));
        }
        return this.allObjectsAccessibleUi;
    }

    public String[] getXtfFile() {
        String fileTextInUi = this.getXtfFileUi().getText();
        String[] files = MainFrame.splitFilenames(fileTextInUi);
        return files;
    }

    public static String[] splitFilenames(String lines) {
        String[] dataFileParts = lines.split("\n");
        ArrayList<String> trimmedFileParts = new ArrayList<String>();
        for (String fileText : dataFileParts) {
            String trimmedText = fileText.trim();
            String retText = trimmedText.replace("\n", "");
            if (retText == null || retText.isEmpty() || retText.toString().length() <= 0) continue;
            trimmedFileParts.add(retText);
        }
        String[] partArr = trimmedFileParts.toArray(new String[0]);
        return partArr;
    }

    public void setXtfFile(String[] xtfFileList) {
        StringBuilder stringBuilder = new StringBuilder();
        if (xtfFileList != null) {
            String newLine = "";
            for (int i = 0; i < xtfFileList.length; ++i) {
                if (xtfFileList[i] == null) continue;
                stringBuilder.append(newLine);
                stringBuilder.append(xtfFileList[i]);
                newLine = "\n";
            }
        }
        this.getXtfFileUi().setText(stringBuilder.toString());
    }

    public String getModelNames() {
        return StringUtility.purge((String)this.getModelNamesUi().getText());
    }

    public void setModelNames(String modelNames) {
        this.getModelNamesUi().setText(modelNames);
    }

    public String getConfigFile() {
        return StringUtility.purge((String)this.getConfigFileUi().getText());
    }

    public boolean getObjectsAccessible() {
        boolean allObjectsAccessible = this.getAllObjectsAccessibleUi().isSelected();
        return allObjectsAccessible;
    }

    public void setObjectsAccessible(boolean allObjectsAccessible) {
        this.getAllObjectsAccessibleUi().setSelected(allObjectsAccessible);
    }

    public void setConfigFile(String dbhost) {
        this.getConfigFileUi().setText(dbhost);
    }

    public String getLogFile() {
        return StringUtility.purge((String)this.getLogFileUi().getText());
    }

    public void setLogFile(String logfile) {
        this.getLogFileUi().setText(logfile);
    }

    public String getXtfLogFile() {
        return StringUtility.purge((String)this.getXtfLogFileUi().getText());
    }

    public void setXtfLogFile(String xtflogfile) {
        this.getXtfLogFileUi().setText(xtflogfile);
    }

    public Settings getSettings() {
        String logFile = this.getLogFile();
        String xtflogFile = this.getXtfLogFile();
        String configFile = this.getConfigFile();
        String modelNames = this.getModelNames();
        String objectsAccess = this.getObjectsAccessible() ? "true" : "false";
        String workingDir = this.settings.getValue("WORKING_DIRECTORY");
        String proxyHost = this.settings.getValue("ch.interlis.ili2c.http_proxy_host");
        String proxyPort = this.settings.getValue("ch.interlis.ili2c.http_proxy_port");
        String ilidirs = this.settings.getValue("org.interlis2.validator.ilidirs");
        String appHome = this.settings.getValue("org.interlis2.validator.appHome");
        Settings newSettings = new Settings();
        newSettings.setValue("WORKING_DIRECTORY", workingDir);
        newSettings.setValue("org.interlis2.validator.log", logFile);
        newSettings.setValue("org.interlis2.validator.xtflog", xtflogFile);
        newSettings.setValue("org.interlis2.validator.modelNames", modelNames);
        newSettings.setValue("org.interlis2.validator.configfile", configFile);
        newSettings.setValue("org.interlis2.validator.allobjectsaccessible", objectsAccess);
        newSettings.setValue("org.interlis2.validator.ilidirs", ilidirs);
        newSettings.setValue("org.interlis2.validator.appHome", appHome);
        newSettings.setValue("ch.interlis.ili2c.http_proxy_host", proxyHost);
        newSettings.setValue("ch.interlis.ili2c.http_proxy_port", proxyPort);
        if (this.optionsSkipPolygonBuildingItem.isSelected()) {
            newSettings.setValue("ch.interlis.iox_j.validator.doItfLinetables", "doItfLinetables");
        }
        if (this.optionsMultiplicityOffItem.isSelected()) {
            newSettings.setValue(Validator.SETTING_MULTIPLICITY_VALIDATION, "off");
        }
        if (this.optionsAllowItfAreaHolesItem.isSelected()) {
            newSettings.setValue("org.interlis2.validator.allowitfareaholes", "true");
        }
        if (this.optionsTraceItem.isSelected()) {
            EhiLogger.getInstance().setTraceFilter(false);
        } else {
            EhiLogger.getInstance().setTraceFilter(true);
        }
        if (this.optionsDisableConstraintValidationItem.isSelected()) {
            newSettings.setValue("org.interlis2.validator.disableconstraintvalidation", "true");
        }
        if (this.optionsDisableAreaValidationItem.isSelected()) {
            newSettings.setValue("org.interlis2.validator.disableareavalidation", "true");
        }
        return newSettings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void logAppend(String msg) {
        this.body.append(msg);
        if (!msg.endsWith("\n")) {
            this.body.append("\n");
        }
        this.getLogUi().setText(this.body.toString());
    }

    public void logClear() {
        this.body = new StringBuffer();
        this.getLogUi().setText(this.body.toString());
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getLogUi());
        }
        return this.jScrollPane;
    }

    public static void main(String[] xtfFile, Settings settings) {
        MainFrame frame = new MainFrame();
        frame.setSettings(settings);
        String logFile = settings.getValue("org.interlis2.validator.log");
        frame.setLogFile(logFile);
        EhiLogger.getInstance().addListener((ch.ehi.basics.logging.LogListener)new LogListener(frame, logFile));
        frame.setXtfFile(xtfFile);
        String modelList = settings.getValue("org.interlis2.validator.modelNames");
        frame.setModelNames(modelList);
        String xtflogFile = settings.getValue("org.interlis2.validator.xtflog");
        frame.setXtfLogFile(xtflogFile);
        String configFile = settings.getValue("org.interlis2.validator.configfile");
        frame.setConfigFile(configFile);
        frame.setObjectsAccessible("true".equals(settings.getValue("org.interlis2.validator.allobjectsaccessible")));
        frame.show();
    }

    private JButton getDoValidateBtn() {
        if (this.doValidateBtn == null) {
            this.doValidateBtn = new JButton();
            this.doValidateBtn.setText(this.rsrc.getString("MainFrame.doValidateButton"));
            this.doValidateBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingWorker worker = new SwingWorker(){

                        public Object construct() {
                            try {
                                boolean ret = Validator.runValidation(MainFrame.this.getXtfFile(), MainFrame.this.getSettings());
                                MainFrame.this.getLogUi().setCaretPosition(MainFrame.this.getLogUi().getDocument().getLength());
                                Toolkit.getDefaultToolkit().beep();
                                JOptionPane.showMessageDialog(MainFrame.this, ret ? "...validation done" : "...validation failed");
                            }
                            catch (Exception ex) {
                                EhiLogger.logError((String)MainFrame.this.rsrc.getString("MainFrame.generalError"), (Throwable)ex);
                            }
                            return null;
                        }
                    };
                    worker.start();
                }
            });
        }
        return this.doValidateBtn;
    }

    private JButton getDoXtfFileSelBtn() {
        if (this.doXtfFileSelBtn == null) {
            this.doXtfFileSelBtn = new JButton();
            this.doXtfFileSelBtn.setText("...");
            this.doXtfFileSelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileChooser fileDialog = new FileChooser();
                    fileDialog.setCurrentDirectory(new File(MainFrame.this.getWorkingDirectory()));
                    fileDialog.setDialogTitle(MainFrame.this.rsrc.getString("MainFrame.xtfFileChooserTitle"));
                    fileDialog.addChoosableFileFilter((FileFilter)new GenericFileFilter(MainFrame.this.rsrc.getString("MainFrame.itfFileFilter"), "itf"));
                    fileDialog.addChoosableFileFilter((FileFilter)GenericFileFilter.createXmlFilter());
                    FileNameExtensionFilter filter = new FileNameExtensionFilter(MainFrame.this.rsrc.getString("MainFrame.xtfFileFilter"), "xtf", "xml");
                    fileDialog.setFileFilter((FileFilter)filter);
                    fileDialog.setMultiSelectionEnabled(true);
                    if (fileDialog.showOpenDialog((Component)MainFrame.this) == 0) {
                        MainFrame.this.setWorkingDirectory(fileDialog.getCurrentDirectory().getAbsolutePath());
                        File[] multipleFiles = fileDialog.getSelectedFiles();
                        String[] selectedFiles = new String[multipleFiles.length];
                        for (int i = 0; i < multipleFiles.length; ++i) {
                            selectedFiles[i] = multipleFiles[i].getAbsolutePath();
                        }
                        MainFrame.this.setXtfFile(selectedFiles);
                    }
                }
            });
        }
        return this.doXtfFileSelBtn;
    }

    private JButton getDoLogFileSelBtn() {
        if (this.doLogFileSelBtn == null) {
            this.doLogFileSelBtn = new JButton();
            this.doLogFileSelBtn.setText("...");
            this.doLogFileSelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String file = MainFrame.this.getLogFile();
                    FileChooser fileDialog = new FileChooser(file);
                    fileDialog.setCurrentDirectory(new File(MainFrame.this.getWorkingDirectory()));
                    fileDialog.setDialogTitle(MainFrame.this.rsrc.getString("MainFrame.logFileChooserTitle"));
                    fileDialog.setFileFilter((FileFilter)new GenericFileFilter(MainFrame.this.rsrc.getString("MainFrame.logFileFilter"), "log"));
                    fileDialog.addChoosableFileFilter((FileFilter)new GenericFileFilter(MainFrame.this.rsrc.getString("MainFrame.txtFileFilter"), "txt"));
                    if (fileDialog.showSaveDialog((Component)MainFrame.this) == 0) {
                        MainFrame.this.setWorkingDirectory(fileDialog.getCurrentDirectory().getAbsolutePath());
                        file = fileDialog.getSelectedFile().getAbsolutePath();
                        MainFrame.this.setLogFile(file);
                    }
                }
            });
        }
        return this.doLogFileSelBtn;
    }

    private JButton getDoXtfLogFileSelBtn() {
        if (this.doXtfLogFileSelBtn == null) {
            this.doXtfLogFileSelBtn = new JButton();
            this.doXtfLogFileSelBtn.setText("...");
            this.doXtfLogFileSelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String file = MainFrame.this.getLogFile();
                    FileChooser fileDialog = new FileChooser(file);
                    fileDialog.setCurrentDirectory(new File(MainFrame.this.getWorkingDirectory()));
                    fileDialog.setDialogTitle(MainFrame.this.rsrc.getString("MainFrame.xtflogFileChooserTitle"));
                    fileDialog.setFileFilter((FileFilter)new GenericFileFilter(MainFrame.this.rsrc.getString("MainFrame.xtfFileFilter"), "xtf"));
                    if (fileDialog.showSaveDialog((Component)MainFrame.this) == 0) {
                        MainFrame.this.setWorkingDirectory(fileDialog.getCurrentDirectory().getAbsolutePath());
                        file = fileDialog.getSelectedFile().getAbsolutePath();
                        MainFrame.this.setXtfLogFile(file);
                    }
                }
            });
        }
        return this.doXtfLogFileSelBtn;
    }

    private JButton getNewConfigFileBtn() {
        if (this.doNewConfigFileBtn == null) {
            this.doNewConfigFileBtn = new JButton();
            this.doNewConfigFileBtn.setText("new..");
            this.doNewConfigFileBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String file = MainFrame.this.getLogFile();
                    FileChooser fileDialog = new FileChooser(file);
                    fileDialog.setCurrentDirectory(new File(MainFrame.this.getWorkingDirectory()));
                    fileDialog.setDialogTitle(MainFrame.this.rsrc.getString("MainFrame.xtflogFileChooserTitle"));
                    fileDialog.setFileFilter((FileFilter)MainFrame.this.createConfigFileFilter());
                    if (fileDialog.showSaveDialog((Component)MainFrame.this) == 0) {
                        MainFrame.this.setWorkingDirectory(fileDialog.getCurrentDirectory().getAbsolutePath());
                        file = fileDialog.getSelectedFile().getAbsolutePath();
                        MainFrame.this.setConfigFile(file);
                        this.writeNewConfigFile(file);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void writeNewConfigFile(String file) {
                    BufferedWriter writer = null;
                    if (file != null) {
                        try {
                            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine1"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine2"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine3"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine4"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine5"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine6"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine7"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine8"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine9"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine10"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine11"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine12"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine13"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine14"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine15"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine16"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine17"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine18"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine19"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine20"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine21"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine22"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine23"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine24"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine25"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine26"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine27"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine28"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine29"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine30"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine31"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine32"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine33"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine34"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine35"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine36"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine37"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine38"));
                        }
                        catch (IOException e) {
                            EhiLogger.logError((Throwable)e);
                        }
                        finally {
                            if (writer != null) {
                                try {
                                    writer.close();
                                }
                                catch (IOException e) {
                                    EhiLogger.logError((Throwable)e);
                                }
                            }
                        }
                    }
                }
            });
        }
        return this.doNewConfigFileBtn;
    }

    private JButton getDoConfigFileSelBtn() {
        if (this.doConfigFileSelBtn == null) {
            this.doConfigFileSelBtn = new JButton();
            this.doConfigFileSelBtn.setText("...");
            this.doConfigFileSelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String file = MainFrame.this.getLogFile();
                    FileChooser fileDialog = new FileChooser(file);
                    fileDialog.setCurrentDirectory(new File(MainFrame.this.getWorkingDirectory()));
                    fileDialog.setDialogTitle(MainFrame.this.rsrc.getString("MainFrame.configFileChooserTitle"));
                    fileDialog.setFileFilter((FileFilter)MainFrame.this.createConfigFileFilter());
                    if (fileDialog.showOpenDialog((Component)MainFrame.this) == 0) {
                        MainFrame.this.setWorkingDirectory(fileDialog.getCurrentDirectory().getAbsolutePath());
                        file = fileDialog.getSelectedFile().getAbsolutePath();
                        MainFrame.this.setConfigFile(file);
                    }
                }
            });
        }
        return this.doConfigFileSelBtn;
    }

    private GenericFileFilter createConfigFileFilter() {
        return new GenericFileFilter(this.rsrc.getString("MainFrame.configFileFilter"), "ini");
    }

    private String getWorkingDirectory() {
        String wd = this.settings.getValue("WORKING_DIRECTORY");
        if (wd == null) {
            wd = new File(".").getAbsolutePath();
        }
        return wd;
    }

    private void setWorkingDirectory(String workingDirectory) {
        this.settings.setValue("WORKING_DIRECTORY", workingDirectory);
    }
}

