/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.generator;

import ch.ehi.basics.io.IndentPrintWriter;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.tools.TopoSort;
import ch.interlis.ili2c.generator.TransformationParameter;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.BaseUnit;
import ch.interlis.ili2c.metamodel.ClassType;
import ch.interlis.ili2c.metamodel.ComposedUnit;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.DataModel;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.NumericallyDerivedUnit;
import ch.interlis.ili2c.metamodel.OIDType;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.StructuredUnitType;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.UniqueEl;
import ch.interlis.ili2c.metamodel.UniquenessConstraint;
import ch.interlis.ili2c.metamodel.Unit;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public final class Interlis1Generator {
    private IndentPrintWriter ipw;
    private TransferDescription td;
    private boolean genFmt = false;
    private int fmtAttrIdx;
    private static String FMT_CMT = "!!!!";
    private Type typeOf_ILI1_DATE;
    private Type typeOf_URI;
    private Type typeOf_NAME;
    private Type typeOf_BOOLEAN;
    private Type typeOf_HALIGNMENT;
    private Type typeOf_VALIGNMENT;
    private int numErrors = 0;
    private TransformationParameter params = null;
    private static ResourceBundle rsrc = ResourceBundle.getBundle(Interlis1Generator.class.getName(), Locale.getDefault());

    private Interlis1Generator(Writer out, TransferDescription td) {
        this.ipw = new IndentPrintWriter(out);
        this.td = td;
        this.typeOf_ILI1_DATE = td.INTERLIS.INTERLIS_1_DATE.getType();
        this.typeOf_URI = td.INTERLIS.URI.getType();
        this.typeOf_NAME = td.INTERLIS.NAME.getType();
        this.typeOf_BOOLEAN = td.INTERLIS.BOOLEAN.getType();
        this.typeOf_HALIGNMENT = td.INTERLIS.HALIGNMENT.getType();
        this.typeOf_VALIGNMENT = td.INTERLIS.VALIGNMENT.getType();
    }

    private void finish() {
        this.ipw.close();
    }

    private void printError() {
        ++this.numErrors;
        this.ipw.print(Element.makeErrorName(null));
    }

    private final boolean printErrorOrToString(Object obj, double factor, double diff) {
        if (obj == null) {
            this.printError();
            return true;
        }
        PrecisionDecimal parameterValue = (PrecisionDecimal)obj;
        int value = (int)((double)((int)(factor * parameterValue.doubleValue())) + diff);
        String newValue = String.valueOf(value);
        for (int j = 0; j < parameterValue.getAccuracy(); ++j) {
            newValue = j == 0 ? newValue + ".0" : newValue + "0";
        }
        this.ipw.print(newValue);
        return false;
    }

    private final boolean printErrorOrToString(Object obj) {
        if (obj == null) {
            this.printError();
            return true;
        }
        if (obj instanceof PrecisionDecimal) {
            this.ipw.print(((PrecisionDecimal)obj).toIli1String());
        } else {
            this.ipw.print(obj.toString());
        }
        return false;
    }

    private void printExplanation(String explanation) {
        this.ipw.print("//");
        if (explanation != null) {
            this.ipw.print(explanation);
        }
        this.ipw.print("//");
    }

    public static int generate(Writer out, TransferDescription td, TransformationParameter params) {
        Interlis1Generator i = new Interlis1Generator(out, td);
        i.setParams(params);
        i.printTransferDescription(td);
        i.finish();
        return i.numErrors;
    }

    public static int generateFmt(Writer out, TransferDescription td) {
        Interlis1Generator i = new Interlis1Generator(out, td);
        i.genFmt = true;
        i.printTransferDescription(td);
        i.finish();
        return i.numErrors;
    }

    private void printTransferDescriptionHeader(TransferDescription td) {
        if (this.genFmt) {
            this.ipw.println("SCNT");
            this.ipw.println("Beschreibung der Transferdatei");
            this.ipw.println("////");
            this.ipw.println("MTID model.ili");
        } else {
            this.ipw.println("TRANSFER TransferName;");
            this.ipw.println();
        }
    }

    private void printTransferDescriptionTrailer(TransferDescription td) {
        if (this.genFmt) {
            this.ipw.println("ENDE");
        } else {
            this.ipw.println("FORMAT");
            this.ipw.indent();
            this.ipw.println("FREE;");
            this.ipw.unindent();
            this.ipw.println();
            this.ipw.println("CODE");
            this.ipw.indent();
            this.ipw.println("BLANK = DEFAULT, UNDEFINED = DEFAULT, CONTINUE = DEFAULT;");
            this.ipw.println("TID = ANY;");
            this.ipw.unindent();
            this.ipw.println("END.");
        }
    }

    private void printTransferDescription(TransferDescription td) {
        this.printTransferDescriptionHeader(td);
        int numEmittedModels = 0;
        for (Object obj : td) {
            if (!(obj instanceof Model) || !this.needToPrintModel((Model)obj)) continue;
            if (numEmittedModels > 0) {
                this.printTransferDescriptionTrailer(td);
                if (!this.genFmt) {
                    this.ipw.println();
                    this.ipw.println();
                    this.ipw.println("!! " + rsrc.getString("err_multipleModels_line_1"));
                    this.ipw.println("!! " + rsrc.getString("err_multipleModels_line_2"));
                    this.ipw.println("!! " + rsrc.getString("err_multipleModels_line_3"));
                    this.ipw.println();
                }
                this.printTransferDescriptionHeader(td);
            }
            ++numEmittedModels;
            this.printModel((Model)obj);
            if (this.genFmt) continue;
            this.ipw.println();
        }
        this.printTransferDescriptionTrailer(td);
    }

    private boolean needToPrintModel(Model model) {
        if (model == null) {
            return false;
        }
        if (model == this.td.INTERLIS) {
            return false;
        }
        if (!(model instanceof DataModel)) {
            return false;
        }
        for (Object obj : model) {
            if (!(obj instanceof Topic) || !this.needToPrintTopic((Topic)obj)) continue;
            return true;
        }
        return false;
    }

    private boolean needToPrintTopic(Topic topic) {
        if (topic == null) {
            return false;
        }
        if (topic.isAbstract()) {
            return true;
        }
        for (Viewable<?> obj : topic.getViewables()) {
            if (!(obj instanceof Table) || !this.needToPrintTable((Table)obj)) continue;
            return true;
        }
        return false;
    }

    private boolean needToPrintTable(AbstractClassDef table) {
        if (table == null) {
            return false;
        }
        if (table instanceof Table && ((Table)table).isImplicit()) {
            return false;
        }
        if (table.isAbstract()) {
            return false;
        }
        if (table instanceof Table) {
            return true;
        }
        return table instanceof AssociationDef && !((AssociationDef)table).isLightweight();
    }

    public void printDocumentation(String doc) {
        String line;
        if (doc == null) {
            return;
        }
        if (doc.length() == 0) {
            return;
        }
        String beg = "!!* ";
        int last = 0;
        int next = doc.indexOf("\n", last);
        while (next > -1) {
            line = doc.substring(last, next);
            this.ipw.println(beg + line);
            last = next + 1;
            next = doc.indexOf("\n", last);
        }
        line = doc.substring(last);
        this.ipw.println(beg + line);
    }

    private void printModel(Model model) {
        Class lastPrinted = null;
        if (this.genFmt) {
            this.ipw.println("MODL " + model.getName());
        } else {
            this.printDocumentation(model.getDocumentation());
            this.printMetaValues(model.getMetaValues());
            if (model.getIssuer() != null) {
                this.ipw.println("!!* @Issuer " + model.getIssuer());
            }
            if (model.getModelVersion() != null) {
                this.ipw.println("!!* @Version " + model.getModelVersion());
            }
            this.ipw.print("MODEL ");
            if (this.params != null) {
                this.ipw.println(this.params.getNewModelName());
            } else {
                this.ipw.println(model.getName());
            }
            this.ipw.indent();
        }
        Iterator iter = null;
        if (!this.genFmt) {
            iter = model.iterator();
            boolean isFirst = true;
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof Domain)) continue;
                Domain domain = (Domain)obj;
                if (isFirst) {
                    this.ipw.println("DOMAIN");
                    isFirst = false;
                    this.ipw.indent();
                }
                this.printDomain(domain);
            }
            if (!isFirst) {
                this.ipw.unindent();
                this.ipw.println("");
            }
        }
        for (Object obj : model) {
            Topic topic;
            if (obj instanceof Topic && this.needToPrintTopic(topic = (Topic)obj)) {
                if (lastPrinted != null && !this.genFmt) {
                    this.ipw.println();
                }
                this.printTopic(topic);
                lastPrinted = Topic.class;
            }
            if (!(obj instanceof Table) || !((Table)obj).isIdentifiable() || this.genFmt) continue;
            this.printTable((AbstractClassDef)obj);
            lastPrinted = Table.class;
        }
        if (this.genFmt) {
            this.ipw.println("EMOD");
        } else {
            this.ipw.unindent();
            this.ipw.print("END ");
            if (this.params != null) {
                this.ipw.print(this.params.getNewModelName());
            } else {
                this.ipw.print(model.getName());
            }
            this.ipw.println('.');
        }
    }

    private void printTopic(Topic topic) {
        if (this.genFmt) {
            this.ipw.println(FMT_CMT);
            this.ipw.println("TOPI " + topic.getName());
        } else {
            this.printDocumentation(topic.getDocumentation());
            this.printMetaValues(topic.getMetaValues());
            this.ipw.print("TOPIC ");
            this.ipw.print(topic.getName());
            this.ipw.println(" =");
            this.ipw.indent();
        }
        Iterator<Object> defi = null;
        if (!this.genFmt) {
            defi = topic.iterator();
            boolean isFirst = true;
            while (defi.hasNext()) {
                Object obj = defi.next();
                if (!(obj instanceof Domain)) continue;
                Domain domain = (Domain)obj;
                if (isFirst) {
                    this.ipw.println("DOMAIN");
                    isFirst = false;
                    this.ipw.indent();
                }
                this.printDomain(domain);
            }
            if (!isFirst) {
                this.ipw.unindent();
                this.ipw.println("");
            }
        }
        Class<Table> lastPrinted = null;
        List tables = topic.getViewables();
        if (!((Model)topic.getContainer()).getIliVersion().equals("1")) {
            TopoSort sortDefs = new TopoSort();
            for (Object object : topic.getViewables()) {
                AbstractClassDef table;
                if (!(object instanceof AbstractClassDef) || !this.needToPrintTable(table = (AbstractClassDef)object)) continue;
                sortDefs.add((Object)table);
                Iterator<ViewableTransferElement> attri = table.getAttributesAndRoles2();
                while (attri.hasNext()) {
                    ViewableTransferElement roleo = attri.next();
                    if (roleo.obj instanceof AttributeDef || !(roleo.obj instanceof RoleDef)) continue;
                    RoleDef role = (RoleDef)roleo.obj;
                    if (role.getContainer() == table) {
                        sortDefs.addcond((Object)role.getDestination(), (Object)table);
                        continue;
                    }
                    if (role.getContainer() == table) continue;
                    sortDefs.addcond((Object)role.getDestination(), (Object)table);
                }
            }
            if (!sortDefs.sort()) {
                throw new IllegalStateException("Cycle in table definitions");
            }
            tables = sortDefs.getResult();
        }
        for (Object obj : tables) {
            AbstractClassDef abstractClassDef;
            if (!(obj instanceof AbstractClassDef) || !this.needToPrintTable(abstractClassDef = (AbstractClassDef)obj)) continue;
            if (lastPrinted != null && !this.genFmt) {
                this.ipw.println();
            }
            this.printTable(abstractClassDef);
            lastPrinted = Table.class;
        }
        if (this.genFmt) {
            this.ipw.println("ETOP");
        } else {
            this.ipw.unindent();
            this.ipw.print("END ");
            this.ipw.print(topic.getName());
            this.ipw.println('.');
        }
    }

    private Iterator determineUniquenessConstraints(AbstractClassDef forTable) {
        LinkedList result = new LinkedList();
        for (AbstractClassDef tab = forTable; tab != null; tab = (AbstractClassDef)tab.getExtending()) {
            for (Object obj : tab) {
                if (!(obj instanceof UniquenessConstraint)) continue;
                result.add(obj);
            }
        }
        return result.iterator();
    }

    private void printTable(AbstractClassDef table) {
        AttributeDef attr;
        Iterator<Object> iter;
        if (this.genFmt) {
            iter = table.getAttributes();
            while (iter.hasNext()) {
                AttributeDef attr2;
                Type type;
                Extendable obj = iter.next();
                if (!(obj instanceof AttributeDef) || !((type = Type.findReal((attr2 = (AttributeDef)obj).getDomain())) instanceof AreaType)) continue;
                this.printSurfaceOrAreaTypeFmt(table, attr2, (AreaType)type);
            }
            this.ipw.println(FMT_CMT);
            this.ipw.println("TABL " + table.getName());
            this.ipw.print("OBJE " + this.genFmtField(1, 1));
            this.fmtAttrIdx = 2;
        } else {
            this.printDocumentation(table.getDocumentation());
            this.printMetaValues(table.getMetaValues());
            this.ipw.print("TABLE ");
            this.ipw.print(table.getName());
            this.ipw.println(" =");
            this.ipw.indent();
        }
        ArrayList<Object> attrlist = new ArrayList<Object>();
        iter = table.getAttributesAndRoles();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof AttributeDef) {
                attrlist.add(obj);
                continue;
            }
            if (!(obj instanceof RoleDef) || ((AssociationDef)table).isLightweight()) continue;
            attrlist.add(obj);
        }
        ArrayList<RoleDef> rolesSorted = new ArrayList<RoleDef>(table.getLightweightAssociations());
        Collections.sort(rolesSorted, new Comparator(){

            public int compare(Object o1, Object o2) {
                int idx2;
                int idx1 = ((RoleDef)o1).getIli1AttrIdx();
                if (idx1 == (idx2 = ((RoleDef)o2).getIli1AttrIdx())) {
                    return 0;
                }
                if (idx1 == -1) {
                    return 1;
                }
                if (idx2 == -1) {
                    return -1;
                }
                if (idx1 < idx2) {
                    return -1;
                }
                return 1;
            }
        });
        for (RoleDef role : rolesSorted) {
            RoleDef oppend = this.getOppEnd(role);
            if (role.getIli1AttrIdx() == -1) {
                attrlist.add(role);
                continue;
            }
            attrlist.add(role.getIli1AttrIdx(), role);
        }
        for (Object obj : attrlist) {
            if (obj instanceof AttributeDef) {
                attr = (AttributeDef)obj;
                this.printAttribute(table, attr);
                continue;
            }
            if (!(obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)obj;
            if (role.getContainer() == table && table instanceof AssociationDef && !((AssociationDef)table).isLightweight()) {
                if (this.genFmt) {
                    this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, 1));
                    ++this.fmtAttrIdx;
                    continue;
                }
                this.ipw.println(role.getName() + " : ->" + role.getDestination().getName() + "; !! {1}");
                continue;
            }
            if (role.getContainer() == table) continue;
            RoleDef oppend = this.getOppEnd(role);
            if (this.genFmt) {
                this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, 1));
                ++this.fmtAttrIdx;
                continue;
            }
            this.ipw.println(oppend.getName() + " : ->" + oppend.getDestination().getName() + "; !! " + role.getCardinality().toString());
        }
        if (this.genFmt) {
            this.ipw.println("");
            this.ipw.println(FMT_CMT);
            this.ipw.println(FMT_CMT + " 1: Objektidentifikation");
            iter = attrlist.iterator();
            int idx = 2;
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof AttributeDef) {
                    AttributeDef attr3 = (AttributeDef)obj;
                    Type type = Type.findReal(attr3.getDomain());
                    if (!(type instanceof LineType) || type instanceof AreaType) {
                        this.ipw.println(FMT_CMT + " " + Interlis1Generator.getIdxCode(idx) + ": " + attr3.getName());
                    }
                } else if (obj instanceof RoleDef) {
                    RoleDef role = (RoleDef)obj;
                    if (role.getContainer() == table && table instanceof AssociationDef && !((AssociationDef)table).isLightweight()) {
                        this.ipw.println(FMT_CMT + " " + Interlis1Generator.getIdxCode(idx) + ": " + role.getName() + " ->" + role.getDestination().getName());
                    } else if (role.getContainer() != table) {
                        RoleDef oppend = this.getOppEnd(role);
                        this.ipw.println(FMT_CMT + " " + Interlis1Generator.getIdxCode(idx) + ": " + oppend.getName() + " ->" + oppend.getDestination().getName());
                    }
                }
                ++idx;
            }
            this.ipw.println(FMT_CMT);
            iter = table.getAttributes();
            while (iter.hasNext()) {
                attr = (AttributeDef)iter.next();
                Type type = Type.findReal(attr.getDomain());
                if (!(type instanceof PolylineType)) continue;
                this.ipw.println(FMT_CMT + " " + attr.getName());
                this.printLineTypeFmt((PolylineType)type);
            }
        } else {
            this.ipw.unindent();
            Iterator idents = this.determineUniquenessConstraints(table);
            if (idents.hasNext()) {
                this.ipw.println("IDENT");
                this.ipw.indent();
                do {
                    UniquenessConstraint uc;
                    UniqueEl attribs;
                    if ((attribs = (uc = (UniquenessConstraint)idents.next()).getElements()) == null) {
                        this.printError();
                    } else {
                        Iterator<ObjectPath> attri = attribs.iteratorAttribute();
                        String sep = "";
                        while (attri.hasNext()) {
                            ObjectPath path = attri.next();
                            if (path == null) {
                                this.printError();
                            } else {
                                this.ipw.print(sep + path.getPathElements()[0].getName());
                            }
                            sep = ", ";
                        }
                    }
                    this.ipw.println(';');
                } while (idents.hasNext());
                this.ipw.unindent();
            } else {
                this.ipw.println("NO IDENT");
            }
        }
        if (this.genFmt) {
            this.ipw.println("ETAB");
            iter = table.getAttributes();
            while (iter.hasNext()) {
                AttributeDef attr4 = (AttributeDef)iter.next();
                Type type = Type.findReal(attr4.getDomain());
                if (!(type instanceof SurfaceType)) continue;
                this.printSurfaceOrAreaTypeFmt(table, attr4, (SurfaceType)type);
            }
        } else {
            this.ipw.print("END ");
            this.ipw.print(table.getName());
            this.ipw.println(';');
        }
    }

    private void printMetaValues(Settings values) {
        if (values != null) {
            for (String name : values.getValues()) {
                String value = "";
                value = name.equals("CRS") ? String.valueOf(this.params.getEpsgCode()) : values.getValue(name);
                this.ipw.print("!!@ ");
                this.ipw.print(name);
                this.ipw.print("=");
                if (value.indexOf(32) != -1 || value.indexOf(61) != -1 || value.indexOf(59) != -1 || value.indexOf(44) != -1 || value.indexOf(34) != -1 || value.indexOf(92) != -1) {
                    this.ipw.println("\"" + value + "\"");
                    continue;
                }
                this.ipw.println(value);
            }
        }
    }

    private void printDomain(Domain domain) {
        if (!this.genFmt) {
            this.printDocumentation(domain.getDocumentation());
            this.printMetaValues(domain.getMetaValues());
            this.ipw.print(domain.getName());
            this.ipw.print(" = ");
            String comment = this.printType(null, domain.getType(), true);
            if (comment != null) {
                this.ipw.print(";  !! ");
                this.ipw.println(comment);
            } else {
                this.ipw.println(';');
            }
        }
    }

    private void printAttribute(AbstractClassDef forTable, AttributeDef attr) {
        if (attr.isAbstract()) {
            return;
        }
        if (this.genFmt) {
            String comment = this.printType(forTable, attr.getDomain(), false);
            ++this.fmtAttrIdx;
        } else {
            this.printDocumentation(attr.getDocumentation());
            this.printMetaValues(attr.getMetaValues());
            this.ipw.print(attr.getName());
            this.ipw.print(" : ");
            String comment = this.printType(forTable, attr.getDomain(), false);
            if (!this.genFmt && attr.getExplanation() != null) {
                this.ipw.print(" ");
                this.printExplanation(attr.getExplanation());
            }
            if (comment != null) {
                this.ipw.print(";  !! ");
                this.ipw.println(comment);
            } else {
                this.ipw.println(';');
            }
        }
    }

    private String printType(Container scope, Type typ, boolean withoutOptional) {
        Domain aliased;
        String comment = null;
        if (typ == null) {
            this.printError();
            return rsrc.getString("err_inSource");
        }
        Type t = typ;
        boolean mand = false;
        do {
            mand |= t.isMandatory();
            if (!(t instanceof TypeAlias)) continue;
            aliased = ((TypeAlias)t).getAliasing();
            t = aliased.getType();
        } while (t instanceof TypeAlias);
        if (!(mand || this.genFmt || withoutOptional)) {
            this.ipw.print("OPTIONAL ");
        }
        if (typ instanceof TypeAlias) {
            aliased = ((TypeAlias)typ).getAliasing();
            if (aliased == this.td.INTERLIS.INTERLIS_1_DATE) {
                if (this.genFmt) {
                    this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, 8));
                } else {
                    this.ipw.print("DATE");
                }
                return null;
            }
            if (aliased == this.td.INTERLIS.BOOLEAN) {
                if (this.genFmt) {
                    this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, 1));
                } else {
                    this.ipw.print("BOOLEAN");
                }
                return null;
            }
            if (aliased == this.td.INTERLIS.HALIGNMENT) {
                if (this.genFmt) {
                    this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, 1));
                } else {
                    this.ipw.print("HALIGNMENT");
                }
                return null;
            }
            if (aliased == this.td.INTERLIS.VALIGNMENT) {
                if (this.genFmt) {
                    this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, 1));
                } else {
                    this.ipw.print("VALIGNMENT");
                }
                return null;
            }
            if (!this.genFmt) {
                this.ipw.print(aliased.getName());
                return null;
            }
        }
        if ((t = Type.findReal(typ)) instanceof TextType) {
            int maxLength = ((TextType)t).getMaxLength();
            if (maxLength == -1) {
                maxLength = 2400;
            }
            if (this.genFmt) {
                this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, maxLength));
            } else {
                this.ipw.print("TEXT*");
                this.ipw.print(maxLength);
            }
            if (t == this.typeOf_URI) {
                comment = rsrc.getString("comment_uri");
            } else if (t == this.typeOf_NAME) {
                comment = rsrc.getString("comment_name");
            }
            return comment;
        }
        if (t instanceof NumericType) {
            return this.printNumericType((NumericType)t);
        }
        if (t instanceof CoordType) {
            return this.printCoordType((CoordType)t);
        }
        if (!(t instanceof EnumerationType)) {
            if (t instanceof LineType) {
                if (this.genFmt) {
                    LineType lineType = (LineType)Type.findReal(t);
                    if (lineType instanceof AreaType) {
                        Domain controlPointDomain = lineType.getControlPointDomain();
                        if (controlPointDomain == null) {
                            this.printError();
                        } else {
                            return this.printCoordType((CoordType)Type.findReal(controlPointDomain.getType()));
                        }
                    }
                    return null;
                }
                return this.printLineType((LineType)t);
            }
            if (t instanceof ReferenceType) {
                return this.printReferenceType(scope, (ReferenceType)t);
            }
            if (t instanceof CompositionType) {
                CompositionType ct = (CompositionType)t;
                String referredName = ct.getComponentType().getName();
                this.ipw.print("-> ");
                if (ct.getCardinality().getMaximum() > 1L) {
                    this.ipw.print(ct.getCardinality().toString() + " ");
                    comment = rsrc.getString("err_notExpressible");
                } else {
                    comment = null;
                }
                this.ipw.print(referredName);
                return comment;
            }
            if (t instanceof ClassType) {
                int classTypeLen = 767;
                if (this.genFmt) {
                    this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, classTypeLen));
                } else {
                    this.ipw.print("TEXT*");
                    this.ipw.print(classTypeLen);
                }
                return null;
            }
            if (t instanceof StructuredUnitType) {
                StructuredUnitType st = (StructuredUnitType)t;
                int textLen = Math.min(st.getMaximum().toString().length(), st.getMinimum().toString().length());
                if (this.genFmt) {
                    this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, textLen));
                } else {
                    this.ipw.print("TEXT*");
                    this.ipw.print(textLen);
                }
                return null;
            }
            if (t instanceof OIDType) {
                OIDType ot = (OIDType)t;
                return this.printType(scope, ot.getOIDType(), true);
            }
            this.printError();
            return rsrc.getString("err_notExpressible");
        }
        this.printEnumeration(((EnumerationType)t).getEnumeration());
        return comment;
    }

    private String printReferenceType(Container scope, ReferenceType type) {
        if (!this.genFmt) {
            Topic referredTopic;
            AbstractClassDef referred;
            if (type == null || (referred = type.getReferred()) == null) {
                this.printError();
                return rsrc.getString("err_inSource");
            }
            if (referred.isAbstract()) {
                this.printError();
                this.ipw.println();
                this.ipw.print("!! ");
                this.ipw.println(new MessageFormat(rsrc.getString("err_relationToAbstractClass_line_1")).format(new Object[]{referred.toString()}));
                this.ipw.print("!! ");
                this.ipw.println(rsrc.getString("err_relationToAbstractClass_line_2"));
                return null;
            }
            Topic scopeTopic = (Topic)scope.getContainerOrSame(Topic.class);
            if (scopeTopic != (referredTopic = (Topic)referred.getContainer(Topic.class))) {
                this.printError();
                this.ipw.println();
                this.ipw.print("!! ");
                this.ipw.println(new MessageFormat(rsrc.getString("err_crossTopicRelation_line_1")).format(new Object[]{referred.toString(), referredTopic.toString(), scopeTopic.toString()}));
                this.ipw.print("!! ");
                this.ipw.println(rsrc.getString("err_crossTopicRelation_line_2"));
                return null;
            }
            String referredName = referred.getName();
            this.ipw.print("-> ");
            if (referredName == null || referredName.length() == 0) {
                this.printError();
                return rsrc.getString("err_inSource");
            }
            this.ipw.print(referredName);
        }
        return null;
    }

    private String printNumericType(NumericType type) {
        String before;
        if (this.genFmt) {
            String fld = Interlis1Generator.genFmtField(this.fmtAttrIdx, type.getMinimum(), type.getMaximum());
            this.ipw.print(" " + fld);
            return null;
        }
        Unit unit = type.getUnit();
        String between = " ";
        String after = "";
        String comment = null;
        boolean error = false;
        if (unit != null) {
            String docName = unit.getDocName();
            String shortName = unit.getName();
            if (shortName != null) {
                comment = shortName.equals(docName) ? "[" + shortName + "]" : docName + " [" + shortName + "]";
            }
        }
        if (this.isDIM1(type)) {
            before = "DIM1 ";
        } else if (this.isDIM2(type)) {
            before = "DIM2 ";
        } else if (this.isRADIANS(type)) {
            before = "RADIANS ";
            comment = null;
        } else if (this.isDEGREES(type)) {
            before = "DEGREES ";
            comment = null;
        } else if (this.isGRADS(type)) {
            before = "GRADS ";
            comment = null;
        } else {
            before = "[";
            between = " .. ";
            after = "]";
        }
        this.ipw.print(before);
        error |= this.printErrorOrToString(type.getMinimum());
        this.ipw.print(between);
        this.ipw.print(after);
        if (error |= this.printErrorOrToString(type.getMaximum())) {
            return rsrc.getString("err_inSource");
        }
        return comment;
    }

    private boolean isDIM1(NumericType type) {
        if (type == null) {
            return false;
        }
        Unit unit = type.getUnit();
        if (unit == null) {
            return false;
        }
        if (!(unit instanceof NumericallyDerivedUnit) && !(unit instanceof BaseUnit)) {
            return false;
        }
        return unit.isExtendingIndirectly(this.td.INTERLIS.LENGTH);
    }

    private boolean isDIM2(NumericType type) {
        if (type == null) {
            return false;
        }
        Unit unit = type.getUnit();
        if (!(unit instanceof ComposedUnit)) {
            return false;
        }
        ComposedUnit.Composed[] parts = ((ComposedUnit)unit).getComposedUnits();
        if (parts == null || parts.length != 2) {
            return false;
        }
        if (!parts[0].getUnit().isExtendingIndirectly(this.td.INTERLIS.LENGTH)) {
            return false;
        }
        if (parts[0].getCompositionOperator() != '*') {
            return false;
        }
        if (!parts[1].getUnit().isExtendingIndirectly(this.td.INTERLIS.LENGTH)) {
            return false;
        }
        return parts[1].getCompositionOperator() == '*';
    }

    private boolean isRADIANS(NumericType type) {
        if (type == null) {
            return false;
        }
        return type.getUnit() == this.td.INTERLIS.RADIAN;
    }

    private boolean isDEGREES(NumericType type) {
        if (type == null) {
            return false;
        }
        Unit unit = type.getUnit();
        if (!(unit instanceof NumericallyDerivedUnit)) {
            return false;
        }
        Unit baseUnit = (Unit)((NumericallyDerivedUnit)unit).getExtending();
        if (baseUnit != this.td.INTERLIS.RADIAN) {
            return false;
        }
        NumericallyDerivedUnit.Factor[] factors = ((NumericallyDerivedUnit)unit).getConversionFactors();
        if (factors == null || factors.length != 2 || factors[0] == null || factors[1] == null) {
            return false;
        }
        if (factors[0].getConversionFactor() != PrecisionDecimal.PI) {
            return false;
        }
        if (factors[0].getConversionOperator() != '*') {
            return false;
        }
        if (factors[1].getConversionFactor().doubleValue() != 180.0) {
            return false;
        }
        return factors[1].getConversionOperator() == '/';
    }

    private boolean isGRADS(NumericType type) {
        if (type == null) {
            return false;
        }
        Unit unit = type.getUnit();
        if (!(unit instanceof NumericallyDerivedUnit)) {
            return false;
        }
        Unit baseUnit = (Unit)((NumericallyDerivedUnit)unit).getExtending();
        if (baseUnit != this.td.INTERLIS.RADIAN) {
            return false;
        }
        NumericallyDerivedUnit.Factor[] factors = ((NumericallyDerivedUnit)unit).getConversionFactors();
        if (factors == null || factors.length != 2 || factors[0] == null || factors[1] == null) {
            return false;
        }
        if (factors[0].getConversionFactor() != PrecisionDecimal.PI) {
            return false;
        }
        if (factors[0].getConversionOperator() != '*') {
            return false;
        }
        if (factors[1].getConversionFactor().doubleValue() != 200.0) {
            return false;
        }
        return factors[1].getConversionOperator() == '/';
    }

    public static int countEnumLeafs(Enumeration enumer) {
        int ret = 0;
        Iterator<Enumeration.Element> iter = enumer.getElements();
        while (iter.hasNext()) {
            Enumeration.Element ee = iter.next();
            Enumeration subEnum = ee.getSubEnumeration();
            if (subEnum != null) {
                ret += Interlis1Generator.countEnumLeafs(subEnum);
                continue;
            }
            ++ret;
        }
        return ret;
    }

    private void printEnumeration(Enumeration enumer) {
        if (this.genFmt) {
            int leafs = Interlis1Generator.countEnumLeafs(enumer);
            int size = Integer.toString(leafs).length();
            this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, size));
        } else {
            this.ipw.println('(');
            this.ipw.indent();
            if (enumer == null) {
                this.printError();
            } else {
                Iterator<Enumeration.Element> iter = enumer.getElements();
                while (iter.hasNext()) {
                    this.printEnumerationElement(iter.next());
                    if (!iter.hasNext()) continue;
                    this.ipw.println(',');
                }
            }
            this.ipw.unindent();
            this.ipw.print(')');
        }
    }

    private void printEnumerationElement(Enumeration.Element ee) {
        this.ipw.print(ee.getName());
        Enumeration subEnum = ee.getSubEnumeration();
        if (subEnum != null) {
            this.ipw.print(' ');
            this.printEnumeration(subEnum);
        }
    }

    private String printCoordType(CoordType coord) {
        if (coord == null) {
            this.printError();
            return rsrc.getString("err_inSource");
        }
        NumericalType[] dimensions = coord.getDimensions();
        boolean error = false;
        if (dimensions == null) {
            this.printError();
            return rsrc.getString("err_inSource");
        }
        if (dimensions.length == 2) {
            if (!this.genFmt) {
                this.ipw.print("COORD2");
            }
        } else if (dimensions.length == 3) {
            if (!this.genFmt) {
                this.ipw.print("COORD3");
            }
        } else {
            this.printError();
            return rsrc.getString("err_notExpressible");
        }
        if (dimensions[0] instanceof StructuredUnitType || dimensions[1] instanceof StructuredUnitType || dimensions.length > 2 && dimensions[2] instanceof StructuredUnitType) {
            this.printError();
            return rsrc.getString("err_notExpressible");
        }
        if (!this.genFmt) {
            this.ipw.println();
            this.ipw.indent();
        }
        PrecisionDecimal minE = null;
        PrecisionDecimal minN = null;
        PrecisionDecimal minH = null;
        PrecisionDecimal maxE = null;
        PrecisionDecimal maxN = null;
        PrecisionDecimal maxH = null;
        NumericType eastingDimension = dimensions[0] instanceof NumericType ? (NumericType)dimensions[0] : null;
        NumericType northingDimension = dimensions[1] instanceof NumericType ? (NumericType)dimensions[1] : null;
        NumericType heightDimension = dimensions.length == 3 && dimensions[2] instanceof NumericType ? (NumericType)dimensions[2] : null;
        if (eastingDimension != null) {
            minE = eastingDimension.getMinimum();
            maxE = eastingDimension.getMaximum();
        }
        if (northingDimension != null) {
            minN = northingDimension.getMinimum();
            maxN = northingDimension.getMaximum();
        }
        if (heightDimension != null) {
            minH = heightDimension.getMinimum();
            maxH = heightDimension.getMaximum();
        }
        if (this.genFmt) {
            this.ipw.print(" " + Interlis1Generator.genFmtField(this.fmtAttrIdx, minE, maxE));
            this.ipw.print(" " + Interlis1Generator.genFmtField(this.fmtAttrIdx, minN, maxN));
            if (dimensions.length == 3) {
                this.ipw.print(" " + Interlis1Generator.genFmtField(this.fmtAttrIdx, minH, maxH));
            }
        } else {
            error = this.params != null ? (error |= this.printErrorOrToString(minE, this.params.getFactor_x(), this.params.getDiff_x())) : (error |= this.printErrorOrToString(minE));
            this.ipw.print(' ');
            error = this.params != null ? (error |= this.printErrorOrToString(minN, this.params.getFactor_x(), this.params.getDiff_x())) : (error |= this.printErrorOrToString(minN));
            if (dimensions.length == 3) {
                this.ipw.print(' ');
                error |= this.printErrorOrToString(minH);
            }
            this.ipw.println();
            error = this.params != null ? (error |= this.printErrorOrToString(maxE, this.params.getFactor_y(), this.params.getDiff_y())) : (error |= this.printErrorOrToString(maxE));
            this.ipw.print(' ');
            error = this.params != null ? (error |= this.printErrorOrToString(maxN, this.params.getFactor_y(), this.params.getDiff_y())) : (error |= this.printErrorOrToString(maxN));
            if (dimensions.length == 3) {
                this.ipw.print(' ');
                error |= this.printErrorOrToString(maxH);
            }
            this.ipw.unindent();
        }
        if (error) {
            return rsrc.getString("err_inSource");
        }
        return null;
    }

    private String printLineType(LineType lineType) {
        if (this.genFmt) {
            return null;
        }
        String comment = null;
        if (lineType instanceof PolylineType) {
            this.ipw.print("POLYLINE ");
        } else if (lineType instanceof SurfaceType) {
            this.ipw.print("SURFACE ");
        } else if (lineType instanceof AreaType) {
            this.ipw.print("AREA ");
        }
        LineForm[] lineForms = lineType.getLineForms();
        this.ipw.print("WITH (");
        for (int i = 0; i < lineForms.length; ++i) {
            if (i > 0) {
                this.ipw.print(", ");
            }
            if (lineForms[i] == null) {
                this.printError();
                continue;
            }
            if (lineForms[i] == this.td.INTERLIS.STRAIGHTS) {
                this.ipw.print("STRAIGHTS");
                continue;
            }
            if (lineForms[i] == this.td.INTERLIS.ARCS) {
                this.ipw.print("ARCS");
                continue;
            }
            this.printExplanation(lineForms[i].getExplanation());
        }
        this.ipw.println(")");
        this.ipw.indent();
        this.ipw.print("VERTEX ");
        Domain controlPointDomain = lineType.getControlPointDomain();
        if (controlPointDomain == null) {
            this.printError();
        } else {
            comment = this.printCoordType((CoordType)Type.findReal(controlPointDomain.getType()));
        }
        PrecisionDecimal maxOverlap = lineType.getMaxOverlap();
        if (maxOverlap != null) {
            this.ipw.println();
            this.ipw.print("WITHOUT OVERLAPS > ");
            this.ipw.print(maxOverlap.toString());
        }
        this.printLineAttributes(lineType);
        this.ipw.unindent();
        return comment;
    }

    private void printSurfaceOrAreaTypeFmt(AbstractClassDef table, AttributeDef thisAttr, SurfaceOrAreaType lineType) {
        if (!this.genFmt) {
            return;
        }
        this.ipw.println(FMT_CMT);
        this.ipw.println("TABL " + table.getName() + "_" + thisAttr.getName());
        this.ipw.print("OBJE " + this.genFmtField(1, 1));
        this.fmtAttrIdx = 2;
        if (lineType instanceof SurfaceType) {
            this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, 1));
            ++this.fmtAttrIdx;
        }
        Iterator<Extendable> iter = null;
        Table attributeTable = lineType.getLineAttributeStructure();
        if (attributeTable != null) {
            iter = attributeTable.getAttributes();
            while (iter.hasNext()) {
                this.printAttribute(attributeTable, (AttributeDef)iter.next());
            }
        }
        this.ipw.println();
        this.ipw.println(FMT_CMT);
        this.ipw.println(FMT_CMT + " 1: Objektidentifikation");
        int idx = 2;
        if (lineType instanceof SurfaceType) {
            this.ipw.println(FMT_CMT + " 2: ->" + table.getName());
            ++idx;
        }
        if (attributeTable != null) {
            iter = attributeTable.getAttributes();
            while (iter.hasNext()) {
                AttributeDef attr = (AttributeDef)iter.next();
                Type type = Type.findReal(attr.getDomain());
                if (!(type instanceof LineType) || type instanceof AreaType) {
                    this.ipw.println(FMT_CMT + " " + Interlis1Generator.getIdxCode(idx) + ": " + attr.getName());
                }
                ++idx;
            }
        }
        this.ipw.println(FMT_CMT);
        this.printLineTypeFmt(lineType);
        this.ipw.println("ETAB");
    }

    private void printLineTypeFmt(LineType lineType) {
        if (!this.genFmt) {
            return;
        }
        if (lineType instanceof PolylineType || lineType instanceof SurfaceType || lineType instanceof AreaType) {
            // empty if block
        }
        CoordType ct = null;
        Domain controlPointDomain = lineType.getControlPointDomain();
        if (controlPointDomain == null) {
            this.printError();
        } else {
            ct = (CoordType)Type.findReal(controlPointDomain.getType());
        }
        this.fmtAttrIdx = 1;
        this.ipw.print("STPT ");
        this.printCoordType(ct);
        this.ipw.println();
        this.ipw.print("LIPT ");
        this.printCoordType(ct);
        this.ipw.println();
        LineForm[] lineForms = lineType.getLineForms();
        for (int i = 0; i < lineForms.length; ++i) {
            if (lineForms[i] == null) {
                this.printError();
            }
            if (lineForms[i] != this.td.INTERLIS.ARCS) continue;
            this.ipw.print("ARCP ");
            this.printCoordType(ct);
            this.ipw.println();
        }
        this.ipw.println("ELIN");
    }

    private void printLineAttributes(LineType lineType) {
        if (lineType == null) {
            return;
        }
        Table attributeTable = null;
        if (lineType instanceof SurfaceOrAreaType) {
            attributeTable = ((SurfaceOrAreaType)lineType).getLineAttributeStructure();
        }
        if (attributeTable == null) {
            return;
        }
        boolean hasOutput = false;
        Iterator<Extendable> attrs = attributeTable.getAttributes();
        while (attrs.hasNext()) {
            AttributeDef attr = (AttributeDef)attrs.next();
            if (!hasOutput) {
                this.ipw.println();
                this.ipw.println("LINEATTR =");
                this.ipw.indent();
                hasOutput = true;
            }
            this.printAttribute(attributeTable, attr);
        }
        if (hasOutput) {
            this.ipw.unindent();
            this.ipw.print("END");
        }
    }

    private static char getIdxCode(int idx) {
        return Character.toUpperCase(Character.forDigit(idx, 36));
    }

    private String genFmtField(int idx, int size) {
        StringBuilder ret = new StringBuilder(size);
        char c = Interlis1Generator.getIdxCode(idx);
        for (int i = 0; i < size; ++i) {
            ret.append(c);
        }
        return ret.toString();
    }

    public static String genFmtField(int idx, PrecisionDecimal value) {
        int i;
        StringBuilder ret = new StringBuilder(10);
        char c = Interlis1Generator.getIdxCode(idx);
        int size = value.getUnscaledValue().toString().length();
        for (i = 0; i < size; ++i) {
            ret.append(c);
        }
        size = value.getAccuracy();
        if (size > 0) {
            ret.append('.');
            for (i = 0; i < size; ++i) {
                ret.append(c);
            }
        }
        return ret.toString();
    }

    public static String genFmtField(int idx, PrecisionDecimal min, PrecisionDecimal max) {
        String minFld = Interlis1Generator.genFmtField(idx, min);
        String maxFld = Interlis1Generator.genFmtField(idx, max);
        if (minFld.length() > maxFld.length()) {
            return minFld;
        }
        return maxFld;
    }

    private RoleDef getOppEnd(RoleDef oneRole) {
        RoleDef role1 = null;
        RoleDef role2 = null;
        Iterator<Element> rolei = ((AssociationDef)oneRole.getContainer()).getAttributesAndRoles();
        while (rolei.hasNext()) {
            Element obj = rolei.next();
            if (!(obj instanceof RoleDef)) continue;
            if (role1 == null) {
                role1 = (RoleDef)obj;
                continue;
            }
            if (role2 != null) continue;
            role2 = (RoleDef)obj;
        }
        if (role1 == oneRole) {
            return role2;
        }
        return role1;
    }

    public TransformationParameter getParams() {
        return this.params;
    }

    public void setParams(TransformationParameter params) {
        this.params = params;
    }
}

