/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.Main;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.gui.UserSettings;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.modelscan.IliFile;
import ch.interlis.ili2c.modelscan.IliModel;
import ch.interlis.ilirepository.IliFiles;
import ch.interlis.ilirepository.impl.RepositoryAccess;
import ch.interlis.ilirepository.impl.RepositoryAccessException;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.xtf.XtfModel;
import ch.interlis.iom_j.xtf.XtfWriterBase;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.StartTransferEvent;
import ch.interlis.models.ILIREPOSITORY20;
import ch.interlis.models.IliRepository20.RepositoryIndex.ModelMetadata;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CloneRepos {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cloneRepos(Configuration config, UserSettings settings) {
        boolean failed = false;
        Main.setHttpProxySystemProperties((Settings)settings);
        if (config.getOutputFile() == null) {
            EhiLogger.logError((String)"no output folder given");
            return true;
        }
        ArrayList<ModelMetadata> mergedModelMetadatav = new ArrayList<ModelMetadata>();
        Iterator reposi = config.iteratorFileEntry();
        File destFolder = new File(config.getOutputFile());
        destFolder.mkdir();
        EhiLogger.logState((String)("outputFolder <" + destFolder.getPath() + ">"));
        RepositoryAccess reposAccess = new RepositoryAccess();
        while (reposi.hasNext()) {
            File ilimodelsFile;
            FileEntry e = (FileEntry)reposi.next();
            if (e.getKind() != 1) continue;
            String repos = e.getFilename();
            String localReposPath = this.escapeReposUri(repos);
            try {
                ilimodelsFile = reposAccess.getLocalFileLocation(repos, "ilimodels.xml", 0L, null);
            }
            catch (RepositoryAccessException e2) {
                EhiLogger.logError((Throwable)e2);
                failed = true;
                continue;
            }
            if (ilimodelsFile == null) {
                EhiLogger.logAdaption((String)("URL <" + repos + "> contains no " + "ilimodels.xml" + "; ignored"));
                continue;
            }
            IliFiles files = null;
            List<ch.interlis.ilirepository.impl.ModelMetadata> modelMetadatav = null;
            try {
                modelMetadatav = RepositoryAccess.readIliModelsXml2(ilimodelsFile);
                modelMetadatav = RepositoryAccess.getLatestVersions2(modelMetadatav);
                files = RepositoryAccess.createIliFiles2(repos, modelMetadatav);
            }
            catch (RepositoryAccessException e2) {
                EhiLogger.logError((Throwable)e2);
                failed = true;
                continue;
            }
            Iterator<IliFile> filei = files.iteratorFile();
            while (filei.hasNext()) {
                IliFile file = filei.next();
                ArrayList<String> ilimodels = new ArrayList<String>();
                Iterator modeli = file.iteratorModel();
                while (modeli.hasNext()) {
                    IliModel model = (IliModel)modeli.next();
                    ilimodels.add(model.getName());
                }
                try {
                    File srcFile = reposAccess.getLocalFileLocation(repos, file.getPath(), 0L, file.getMd5());
                    File destFile = new File(new File(destFolder, localReposPath), file.getPath());
                    RepositoryAccess.copyFile(destFile, srcFile);
                }
                catch (RepositoryAccessException e1) {
                    EhiLogger.logError((Throwable)e1);
                    failed = true;
                }
            }
            for (ch.interlis.ilirepository.impl.ModelMetadata md : modelMetadatav) {
                String file = md.getFile();
                md.setFile(new File(localReposPath, file).getPath());
                mergedModelMetadatav.add(RepositoryAccess.mapToIom20(md));
            }
        }
        FileOutputStream outStream = null;
        XtfWriterBase ioxWriter = null;
        try {
            outStream = new FileOutputStream(new File(destFolder, "ilimodels.xml"));
            ioxWriter = new XtfWriterBase((OutputStream)outStream, ILIREPOSITORY20.getIoxMapping(), "2.3");
            ioxWriter.setModels(new XtfModel[]{ILIREPOSITORY20.getXtfModel()});
            StartTransferEvent startTransferEvent = new StartTransferEvent();
            startTransferEvent.setSender("ili2c-" + TransferDescription.getVersion());
            ioxWriter.write((IoxEvent)startTransferEvent);
            StartBasketEvent startBasketEvent = new StartBasketEvent("IliRepository20.RepositoryIndex", "b1");
            ioxWriter.write((IoxEvent)startBasketEvent);
            for (ModelMetadata model : mergedModelMetadatav) {
                ioxWriter.write((IoxEvent)new ObjectEvent((IomObject)model));
            }
            ioxWriter.write((IoxEvent)new EndBasketEvent());
            ioxWriter.write((IoxEvent)new EndTransferEvent());
            ioxWriter.flush();
        }
        catch (FileNotFoundException ex) {
            EhiLogger.logError((Throwable)ex);
            failed = true;
        }
        catch (IoxException ex) {
            EhiLogger.logError((Throwable)ex);
            failed = true;
        }
        finally {
            if (ioxWriter != null) {
                try {
                    ioxWriter.close();
                }
                catch (IoxException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
                ioxWriter = null;
            }
            if (outStream != null) {
                try {
                    ((OutputStream)outStream).close();
                }
                catch (IOException ex) {
                    EhiLogger.logError((Throwable)ex);
                }
                outStream = null;
            }
        }
        return failed;
    }

    private String escapeReposUri(String uri) {
        String urilc = uri.toLowerCase();
        boolean isHttps = urilc.startsWith("https://");
        boolean isHttp = urilc.startsWith("http://");
        if (isHttp || isHttps) {
            uri = isHttps ? uri.substring("https://".length()) : uri.substring("http://".length());
        }
        return RepositoryAccess.escapeUri(uri);
    }
}

