/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.logging;

import ch.ehi.basics.logging.FileListener;
import ch.ehi.basics.logging.LogEvent;
import ch.interlis.iox.IoxLogEvent;
import java.io.File;
import java.util.ArrayList;

public class FileLogger
extends FileListener {
    public FileLogger(File arg0) {
        super(arg0, false);
    }

    public void outputEvent(LogEvent event, ArrayList msgv) {
        String msgTag = this.getMessageTag(event);
        msgTag = msgTag == null ? "" : msgTag + ": ";
        String msgTimestamp = null;
        msgTimestamp = this.getTimestamp();
        msgTimestamp = msgTimestamp == null ? "" : msgTimestamp + ": ";
        String objRef = null;
        if (event instanceof IoxLogEvent) {
            objRef = "";
            IoxLogEvent ioxEvent = (IoxLogEvent)event;
            if (ioxEvent.getSourceLineNr() != null) {
                objRef = objRef + "line " + ioxEvent.getSourceLineNr() + ": ";
            }
            if (ioxEvent.getSourceObjectTag() != null) {
                objRef = objRef + ioxEvent.getSourceObjectTag() + ": ";
            }
            if (ioxEvent.getSourceObjectTechId() != null) {
                objRef = objRef + ioxEvent.getSourceObjectTechId() + ": ";
            }
            if (ioxEvent.getSourceObjectXtfId() != null) {
                objRef = objRef + "tid " + ioxEvent.getSourceObjectXtfId() + ": ";
            }
            if (ioxEvent.getSourceObjectUsrId() != null) {
                objRef = objRef + ioxEvent.getSourceObjectUsrId() + ": ";
            }
        } else {
            objRef = "";
        }
        for (String msg : msgv) {
            this.outputMsgLine(event.getEventKind(), event.getCustomLevel(), msgTimestamp + msgTag + objRef + msg);
        }
    }

    public String getMessageTag(LogEvent event) {
        switch (event.getEventKind()) {
            case 7: {
                return "Error";
            }
            case 6: {
                return "Warning";
            }
        }
        return "Info";
    }
}

