/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.iox.objpool.impl;

import ch.ehi.iox.objpool.ObjectPoolManager;
import ch.ehi.iox.objpool.impl.Serializer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ObjPoolImpl2<K, V>
implements Map<K, V> {
    private TreeMap<K, Long> tree = null;
    private RandomAccessFile outFile = null;
    private File outFilename = null;
    private Serializer valueSerializer = null;
    private ObjectPoolManager objectPoolManager = null;
    private static int MAX_CACHE = 32;
    private LinkedHashMap<Long, SoftReference<V>> cache = new LinkedHashMap<Long, SoftReference<V>>(MAX_CACHE, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, SoftReference<V>> eldest) {
            return this.size() >= MAX_CACHE;
        }
    };

    public ObjPoolImpl2(ObjectPoolManager objectPoolManager1, Serializer valueSerializer1) {
        try {
            this.objectPoolManager = objectPoolManager1;
            this.valueSerializer = valueSerializer1;
            this.tree = new TreeMap();
            this.outFilename = ObjectPoolManager.getCacheTmpFilename();
            this.outFile = new RandomAccessFile(this.outFilename, "rw");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void close() {
        if (this.tree != null) {
            this.tree = null;
        }
        if (this.outFile != null) {
            try {
                this.outFile.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            this.outFile = null;
        }
        if (this.outFilename != null) {
            this.outFilename.delete();
            this.outFilename = null;
        }
    }

    public void disableCache() {
        this.cache = null;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.tree.get(key) != null;
    }

    @Override
    public boolean containsValue(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(Object key) {
        try {
            if (this.cache != null) {
                this.objectPoolManager.flushWriteQueues();
            }
            Long pos = this.tree.get(key);
            return this.readValue(pos);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private V readValue(Long pos) throws IOException {
        if (pos != null) {
            SoftReference<V> valueRef = null;
            if (this.cache != null) {
                valueRef = this.cache.get(pos);
            }
            V value = null;
            if (valueRef != null && (value = (V)valueRef.get()) != null) {
                return value;
            }
            this.outFile.seek(pos);
            int size = this.outFile.readInt();
            byte[] bytes = new byte[size];
            this.outFile.read(bytes);
            try {
                value = (V)this.valueSerializer.getObject(bytes);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            return value;
        }
        return null;
    }

    private void writeValue(long pos, V value) throws IOException {
        this.outFile.seek(pos);
        byte[] bytes = this.valueSerializer.getBytes(value);
        this.outFile.writeInt(bytes.length);
        this.outFile.write(bytes);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        return this.tree.keySet();
    }

    @Override
    public V put(K key, V value) {
        try {
            long pos = this.outFile.length();
            this.writeValue(pos, value);
            if (this.cache != null) {
                this.objectPoolManager.flushWriteQueues();
                if (this.cache != null) {
                    this.cache.put(pos, new SoftReference<V>(value));
                }
            }
            Long retPos = this.tree.get(key);
            this.tree.put(key, pos);
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        this.tree.remove(key);
        return null;
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    public Iterator<K> keyIterator() {
        return this.tree.keySet().iterator();
    }

    public Iterator<V> valueIterator() {
        Iterator ret = new Iterator<V>(){
            Iterator<K> cursor;
            {
                this.cursor = ObjPoolImpl2.this.tree.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.cursor.hasNext();
            }

            @Override
            public V next() {
                Long pos = (Long)ObjPoolImpl2.this.tree.get(this.cursor.next());
                try {
                    return ObjPoolImpl2.this.readValue(pos);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return ret;
    }
}

