/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.types.OutParam;
import ch.ehi.iox.objpool.ObjectPoolManager;
import ch.ehi.iox.objpool.impl.CompoundCurveSerializer;
import ch.ehi.iox.objpool.impl.FileBasedCollection;
import ch.ehi.iox.objpool.impl.IomObjectSerializer;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurvePolygon;
import ch.interlis.iom_j.itf.impl.jtsext.noding.CompoundCurveDissolver;
import ch.interlis.iom_j.itf.impl.jtsext.noding.CompoundCurveNoder;
import ch.interlis.iom_j.itf.impl.jtsext.noding.CurvePairInt;
import ch.interlis.iom_j.itf.impl.jtsext.noding.Intersection;
import ch.interlis.iox.IoxException;
import ch.interlis.iox_j.IoxIntersectionException;
import ch.interlis.iox_j.IoxInvalidDataException;
import ch.interlis.iox_j.jts.Iox2jtsException;
import ch.interlis.iox_j.jts.Iox2jtsext;
import ch.interlis.iox_j.jts.Jtsext2iox;
import ch.interlis.iox_j.logging.LogEventFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ItfAreaPolygon2Linetable {
    private Collection<? extends CompoundCurve> lines = null;
    private List<Polygon> polygons = null;
    private Collection<IomObject> ioxlines = null;
    private ObjectPoolManager recman = null;
    private String iliqname = null;

    public ItfAreaPolygon2Linetable(String iliqname1, ObjectPoolManager recman1) {
        this.lines = new FileBasedCollection<CompoundCurve>(recman1, new CompoundCurveSerializer());
        this.polygons = new ArrayList<Polygon>();
        this.recman = recman1;
        this.iliqname = iliqname1;
    }

    public void addLines(String mainObjTid, String internalTid, ArrayList<IomObject> ioxlines) throws IoxException {
        for (IomObject ioxline : ioxlines) {
            CompoundCurve line = Iox2jtsext.polyline2JTS(ioxline, false, 0.0);
            if (internalTid != null) {
                line.setUserData(internalTid);
            } else {
                line.setUserData(mainObjTid);
            }
            this.lines.add(line);
        }
    }

    public void addLines(String mainObjTid, String internalTid, ArrayList<IomObject> ioxlines, String validationType, LogEventFactory errs) throws IoxException {
        for (IomObject ioxline : ioxlines) {
            OutParam foundErrs;
            CompoundCurve line = Iox2jtsext.polyline2JTS(ioxline, false, 0.0, (OutParam<Boolean>)(foundErrs = new OutParam()), errs, 0.0, validationType, "warning");
            if (line == null) continue;
            if (internalTid != null) {
                line.setUserData(internalTid);
            } else {
                line.setUserData(mainObjTid);
            }
            this.lines.add(line);
        }
    }

    public void addPolygon(String mainObjTid, String internalTid, IomObject iomPolygon, String validationType, LogEventFactory errs) throws IoxException {
        ArrayList<IomObject> ioxlines = ItfAreaPolygon2Linetable.getLinesFromPolygon(iomPolygon);
        OutParam foundErrs = new OutParam();
        Polygon polygon = Iox2jtsext.surface2JTS(iomPolygon, 0.0, (OutParam<Boolean>)foundErrs, errs, 0.0, validationType);
        if (polygon != null) {
            if (internalTid != null) {
                polygon.setUserData((Object)internalTid);
            } else {
                polygon.setUserData((Object)mainObjTid);
            }
            this.polygons.add(polygon);
        }
        for (IomObject ioxline : ioxlines) {
            CompoundCurve line = Iox2jtsext.polyline2JTS(ioxline, false, 0.0, (OutParam<Boolean>)foundErrs, errs, 0.0, validationType, "warning");
            if (line == null) continue;
            if (internalTid != null) {
                line.setUserData(internalTid);
            } else {
                line.setUserData(mainObjTid);
            }
            this.lines.add(line);
        }
    }

    public List<IoxInvalidDataException> validate() {
        CompoundCurveNoder noder = new CompoundCurveNoder(this.recman, (List)this.lines, false);
        noder.setEnableCommonSegments(true);
        ArrayList<IoxInvalidDataException> intersectionsWithoutCompleteOverlays = new ArrayList<IoxInvalidDataException>();
        List<Intersection> intersections = noder.getIntersections();
        for (Intersection is : intersections) {
            CompoundCurve e0 = is.getCurve1();
            String tid1 = (String)e0.getUserData();
            intersectionsWithoutCompleteOverlays.add(new IoxIntersectionException(this.iliqname, tid1, is));
        }
        if (!intersectionsWithoutCompleteOverlays.isEmpty()) {
            return intersectionsWithoutCompleteOverlays;
        }
        if (this.polygons == null) {
            return null;
        }
        STRtree polyidx = new STRtree();
        for (int i = 0; i < this.polygons.size(); ++i) {
            Polygon currentPolygon = this.polygons.get(i);
            if (currentPolygon == null) continue;
            Envelope env = new Envelope(currentPolygon.getEnvelopeInternal());
            polyidx.insert(env, (Object)i);
        }
        HashSet<CurvePairInt> compared = new HashSet<CurvePairInt>();
        for (int i0 = 0; i0 < this.polygons.size(); ++i0) {
            Polygon e0 = this.polygons.get(i0);
            List hits = polyidx.query(e0.getEnvelopeInternal());
            for (int hitIdx = 0; hitIdx < hits.size(); ++hitIdx) {
                CurvePairInt pair;
                int i1 = (Integer)hits.get(hitIdx);
                if (i0 == i1 || compared.contains(pair = new CurvePairInt(i0, i1))) continue;
                compared.add(pair);
                Polygon e1 = this.polygons.get(i1);
                if (!CurvePolygon.polygonOverlays(e0, e1)) continue;
                String tid1 = (String)e0.getUserData();
                String tid2 = (String)e1.getUserData();
                intersectionsWithoutCompleteOverlays.add(new IoxInvalidDataException("polygons overlay tid1 " + tid1 + ", tid2 " + tid2));
            }
        }
        if (!intersectionsWithoutCompleteOverlays.isEmpty()) {
            return intersectionsWithoutCompleteOverlays;
        }
        return null;
    }

    public List<IomObject> getLines() throws IoxException {
        if (this.ioxlines == null) {
            CompoundCurveNoder noder = new CompoundCurveNoder(this.recman, (List)this.lines, false);
            noder.setEnableCommonSegments(true);
            if (!noder.isValid()) {
                for (Intersection intersection : noder.getIntersections()) {
                    EhiLogger.logError((String)("intersection tid1 " + intersection.getCurve1().getUserData() + ", tid2 " + intersection.getCurve2().getUserData() + ", coord " + intersection.getPt()[0].toString() + (intersection.getPt().length == 2 ? ", coord2 " + intersection.getPt()[1].toString() : "")));
                    EhiLogger.traceState((String)("overlap " + intersection.getOverlap() + ", seg1 " + intersection.getSegment1() + ", seg2 " + intersection.getSegment2()));
                }
                throw new IoxException("intersections");
            }
            this.lines = noder.getNodedSubstrings();
            noder = null;
            CompoundCurveDissolver dissolver = new CompoundCurveDissolver();
            dissolver.dissolve(this.lines);
            this.lines = dissolver.getDissolved();
            this.ioxlines = new FileBasedCollection<IomObject>(this.recman, new IomObjectSerializer());
            for (CompoundCurve compoundCurve : this.lines) {
                IomObject ioxline;
                try {
                    ioxline = Jtsext2iox.JTS2polyline(compoundCurve);
                }
                catch (Iox2jtsException e) {
                    throw new IoxException((Throwable)e);
                }
                this.ioxlines.add(ioxline);
            }
        }
        return (List)this.ioxlines;
    }

    public static ArrayList<IomObject> getLinesFromPolygon(IomObject polygon) {
        ArrayList<IomObject> ret = new ArrayList<IomObject>();
        boolean clipped = polygon.getobjectconsistency() == 1;
        for (int surfacei = 0; surfacei < polygon.getattrvaluecount("surface"); ++surfacei) {
            if (clipped) {
                throw new IllegalArgumentException("clipped surface not supported");
            }
            if (surfacei > 0) {
                throw new IllegalArgumentException("unclipped surface with multi 'surface' elements");
            }
            IomObject surface = polygon.getattrobj("surface", surfacei);
            for (int boundaryi = 0; boundaryi < surface.getattrvaluecount("boundary"); ++boundaryi) {
                IomObject boundary = surface.getattrobj("boundary", boundaryi);
                for (int polylinei = 0; polylinei < boundary.getattrvaluecount("polyline"); ++polylinei) {
                    IomObject polyline = boundary.getattrobj("polyline", polylinei);
                    ret.add(polyline);
                }
            }
            if (!clipped) continue;
        }
        return ret;
    }
}

