/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.iox.objpool.ObjectPoolManager;
import ch.ehi.iox.objpool.impl.IomObjectSerializer;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.itf.ItfWriter;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iom_j.itf.impl.ItfAreaPolygon2Linetable;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxFactoryCollection;
import ch.interlis.iox.IoxWriter;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.StartTransferEvent;
import ch.interlis.iox_j.jts.Iox2jtsext;
import ch.interlis.iox_j.jts.Jtsext2iox;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ItfWriter2
implements IoxWriter {
    private TransferDescription td = null;
    private ItfWriter out = null;
    private ObjectPoolManager recman = null;
    private ArrayList itftablev = null;
    private HashMap tag2class = null;
    private HashSet topics = null;
    private long maxOid = 0L;
    public static final String INTERNAL_T_ID = "_t_id";
    private HashMap<String, StartBasketEvent> startBasketEvents = new HashMap();
    private HashMap<String, EndBasketEvent> endBasketEvents = new HashMap();
    private String currentTopic = null;
    private Model currentModel = null;
    HashMap<String, Map<String, IomObject>> pools = null;

    public ItfWriter2(OutputStream out, TransferDescription td) throws IoxException {
        this.td = td;
        this.out = new ItfWriter(out, td);
        this.init();
    }

    public ItfWriter2(File outFile, TransferDescription td) throws IoxException {
        this.td = td;
        this.out = new ItfWriter(outFile, td);
        this.init();
    }

    private void init() throws IoxException {
        this.recman = new ObjectPoolManager();
    }

    public void close() throws IoxException {
        this.flush();
        for (Map<String, IomObject> m : this.pools.values()) {
            m.clear();
        }
        this.pools = null;
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.recman != null) {
            this.recman.close();
        }
        this.recman = null;
        this.td = null;
    }

    public void flush() throws IoxException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void write(IoxEvent event) throws IoxException {
        if (event instanceof StartTransferEvent) {
            this.pools = new HashMap();
            this.out.write(event);
        } else if (event instanceof StartBasketEvent) {
            this.currentTopic = ((StartBasketEvent)event).getType();
            if (this.topics == null) {
                this.topics = new HashSet();
                String currentModelName = this.currentTopic.substring(0, this.currentTopic.indexOf(46));
                this.currentModel = (Model)this.td.getElement(Model.class, currentModelName);
                for (Object tObj : this.currentModel) {
                    if (!(tObj instanceof Topic)) continue;
                    Topic topic = (Topic)tObj;
                    String topicQName = topic.getScopedName(null);
                    this.topics.add(topicQName);
                }
            }
            if (!this.topics.contains(this.currentTopic)) {
                throw new IoxException("unknown topic <" + this.currentTopic + ">");
            }
            this.startBasketEvents.put(this.currentTopic, (StartBasketEvent)event);
        } else if (event instanceof ObjectEvent) {
            if (this.currentTopic == null) {
                throw new IoxException("object unexpected outside of a basket");
            }
            IomObject iomObj = ((ObjectEvent)event).getIomObject();
            String iliQName = iomObj.getobjecttag();
            if (this.tag2class == null) {
                this.tag2class = ModelUtilities.getTagMap(this.td);
            }
            if (!this.tag2class.containsKey(iliQName)) {
                throw new IoxException("unknown class <" + iliQName + ">");
            }
            String currentTid = iomObj.getobjectoid();
            Map<String, IomObject> pool = this.getObjectPool(iliQName);
            if (pool.containsKey(currentTid)) {
                throw new IoxException("duplicate tid " + currentTid + " in " + iliQName);
            }
            pool.put(currentTid, iomObj);
            try {
                int tidInt = Integer.parseInt(currentTid);
                if ((long)tidInt > this.maxOid) {
                    this.maxOid = tidInt;
                }
            }
            catch (NumberFormatException tidInt) {}
        } else if (event instanceof EndBasketEvent) {
            this.endBasketEvents.put(this.currentTopic, (EndBasketEvent)event);
            this.currentTopic = null;
        } else if (event instanceof EndTransferEvent) {
            if (this.currentModel != null) {
                String modelName = this.currentModel.getName();
                for (Object tObj : this.currentModel) {
                    if (!(tObj instanceof Topic)) continue;
                    Topic topic = (Topic)tObj;
                    String topicName = topic.getName();
                    String topicQName = topic.getScopedName(null);
                    if (!this.startBasketEvents.containsKey(topicQName)) continue;
                    this.out.write((IoxEvent)this.startBasketEvents.get(topicQName));
                    this.itftablev = ModelUtilities.getItfTables(this.td, modelName, topicName);
                    for (Object tableo : this.itftablev) {
                        Polygon polygon;
                        String lineTableName;
                        String attrName;
                        IomObject iomObj;
                        Map<String, IomObject> pool;
                        if (!(tableo instanceof Table)) continue;
                        Table table = (Table)tableo;
                        String tableQName = table.getScopedName(null);
                        ArrayList<AttributeDef> areaAttrs = new ArrayList<AttributeDef>();
                        ArrayList<AttributeDef> surfaceAttrs = new ArrayList<AttributeDef>();
                        this.getPolygonAttrs((AbstractClassDef<?>)table, areaAttrs, surfaceAttrs);
                        if (areaAttrs.size() == 0 && surfaceAttrs.size() == 0) {
                            pool = this.getObjectPool(tableQName);
                            for (String poolId : pool.keySet()) {
                                iomObj = pool.get(poolId);
                                this.out.write((IoxEvent)new ObjectEvent(iomObj));
                            }
                            continue;
                        }
                        for (AttributeDef attributeDef : areaAttrs) {
                            attrName = attributeDef.getName();
                            lineTableName = tableQName + "_" + attrName;
                            EhiLogger.logState((String)("build linetable " + lineTableName + "..."));
                            ItfAreaPolygon2Linetable allLines = new ItfAreaPolygon2Linetable(tableQName, this.recman);
                            Map<String, IomObject> pool2 = this.getObjectPool(tableQName);
                            for (String mainObjTid : pool2.keySet()) {
                                IomObject iomObj2 = pool2.get(mainObjTid);
                                IomObject iomPolygon = iomObj2.getattrobj(attrName, 0);
                                if (iomPolygon == null) continue;
                                String internalTid = iomObj2.getattrvalue(INTERNAL_T_ID);
                                ArrayList<IomObject> lines = ItfAreaPolygon2Linetable.getLinesFromPolygon(iomPolygon);
                                allLines.addLines(mainObjTid, internalTid, lines);
                            }
                            for (IomObject line : allLines.getLines()) {
                                Iom_jObject lineTableObj = new Iom_jObject(lineTableName, Long.toString(++this.maxOid));
                                String iomAttrName = ModelUtilities.getHelperTableGeomAttrName(attributeDef);
                                lineTableObj.addattrobj(iomAttrName, line);
                                this.out.write((IoxEvent)new ObjectEvent(lineTableObj));
                            }
                        }
                        pool = this.getObjectPool(tableQName);
                        for (String poolId : pool.keySet()) {
                            iomObj = pool.get(poolId);
                            for (AttributeDef attr3 : areaAttrs) {
                                String attrName2 = attr3.getName();
                                IomObject iomPolygon = iomObj.getattrobj(attrName2, 0);
                                if (iomPolygon == null) continue;
                                polygon = Iox2jtsext.surface2JTS(iomPolygon, 0.0);
                                Coordinate geoRef = polygon.getInteriorPoint().getCoordinate();
                                iomObj.changeattrobj(attrName2, 0, Jtsext2iox.JTS2coord(geoRef));
                            }
                            this.out.write((IoxEvent)new ObjectEvent(iomObj));
                        }
                        for (AttributeDef attributeDef : surfaceAttrs) {
                            attrName = attributeDef.getName();
                            lineTableName = tableQName + "_" + attrName;
                            EhiLogger.logState((String)("build linetable " + lineTableName + "..."));
                            Map<String, IomObject> pool3 = this.getObjectPool(tableQName);
                            for (String poolId : pool3.keySet()) {
                                IomObject iomObj3 = pool3.get(poolId);
                                polygon = iomObj3.getattrobj(attrName, 0);
                                if (polygon == null) continue;
                                ArrayList<IomObject> lines = ItfAreaPolygon2Linetable.getLinesFromPolygon((IomObject)polygon);
                                for (IomObject line : lines) {
                                    Iom_jObject lineTableObj = new Iom_jObject(lineTableName, Long.toString(++this.maxOid));
                                    String iomAttrName = ModelUtilities.getHelperTableGeomAttrName(attributeDef);
                                    String fkName = ModelUtilities.getHelperTableMainTableRef(attributeDef);
                                    lineTableObj.addattrobj(iomAttrName, line);
                                    IomObject refvalue = lineTableObj.addattrobj(fkName, "REF");
                                    refvalue.setobjectrefoid(iomObj3.getobjectoid());
                                    this.out.write((IoxEvent)new ObjectEvent(lineTableObj));
                                }
                            }
                        }
                    }
                    this.out.write((IoxEvent)this.endBasketEvents.get(topicQName));
                }
            }
            this.out.write(event);
        }
    }

    private Map<String, IomObject> getObjectPool(String classQName) throws IoxException {
        Map<String, IomObject> m = null;
        m = this.pools.get(classQName);
        if (m == null) {
            m = this.recman.newObjectPool(new IomObjectSerializer());
            this.pools.put(classQName, m);
        }
        return m;
    }

    private void getPolygonAttrs(AbstractClassDef<?> aclass, ArrayList<AttributeDef> attrs_areaAttrs, ArrayList<AttributeDef> attrs_surfaceAttrs) {
        Iterator attri = aclass.getAttributes();
        while (attri.hasNext()) {
            Object attrObj = attri.next();
            if (!(attrObj instanceof AttributeDef)) continue;
            AttributeDef attr = (AttributeDef)attrObj;
            Type type = Type.findReal((Type)attr.getDomain());
            if (type instanceof SurfaceType) {
                attrs_surfaceAttrs.add(attr);
                continue;
            }
            if (!(type instanceof AreaType)) continue;
            attrs_areaAttrs.add(attr);
        }
    }

    public IomObject createIomObject(String type, String oid) throws IoxException {
        return this.out.createIomObject(type, oid);
    }

    public IoxFactoryCollection getFactory() throws IoxException {
        return this.out.getFactory();
    }

    public void setFactory(IoxFactoryCollection factory) throws IoxException {
        this.out.setFactory(factory);
    }
}

