/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.validator;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import java.io.File;
import java.io.IOException;
import org.interlis2.validator.CheckRepoDataTool;
import org.interlis2.validator.CreateIliDataTool;
import org.interlis2.validator.UpdateIliDataTool;
import org.interlis2.validator.Validator;
import org.interlis2.validator.gui.MainFrame;

public class Main {
    public static final String APP_NAME = "ilivalidator";
    public static final String APP_JAR = "ilivalidator.jar";
    private static String version = null;
    private static int FC_VALIDATE = 0;
    private static int FC_CHECK_REPO_DATA = 1;
    private static int FC_CREATE_ILIDATA_XML = 2;
    private static int FC_UPDATE_ILIDATA_XML = 3;
    private static final String SETTINGS_FILE = System.getProperty("user.home") + "/.ilivalidator";

    public static void main(String[] args) {
        int argi;
        Settings settings = new Settings();
        settings.setValue("org.interlis2.validator.ilidirs", "%ITF_DIR;http://models.interlis.ch/;%JAR_DIR/ilimodels");
        String appHome = Main.getAppHome();
        if (appHome != null) {
            settings.setValue("org.interlis2.validator.pluginfolder", new File(appHome, "plugins").getAbsolutePath());
            settings.setValue("org.interlis2.validator.appHome", appHome);
        } else {
            settings.setValue("org.interlis2.validator.pluginfolder", new File("plugins").getAbsolutePath());
        }
        String[] xtfFile = null;
        Object httpProxyHost = null;
        Object httpProxyPort = null;
        if (args.length == 0) {
            xtfFile = new String[]{};
            Main.readSettings(settings);
            MainFrame.main(xtfFile, settings);
            return;
        }
        int function = FC_VALIDATE;
        boolean doGui = false;
        for (argi = 0; argi < args.length; ++argi) {
            String arg = args[argi];
            if (arg.equals("--trace")) {
                EhiLogger.getInstance().setTraceFilter(false);
                continue;
            }
            if (arg.equals("--gui")) {
                Main.readSettings(settings);
                doGui = true;
                continue;
            }
            if (arg.equals("--models")) {
                settings.setValue("org.interlis2.validator.modelNames", args[++argi]);
                continue;
            }
            if (arg.equals("--modeldir")) {
                settings.setValue("org.interlis2.validator.ilidirs", args[++argi]);
                continue;
            }
            if (arg.equals("--config")) {
                settings.setValue("org.interlis2.validator.configfile", args[++argi]);
                continue;
            }
            if (arg.equals("--forceTypeValidation")) {
                settings.setValue("org.interlis2.validator.forcetypevalidation", "true");
                continue;
            }
            if (arg.equals("--disableAreaValidation")) {
                settings.setValue("org.interlis2.validator.disableareavalidation", "true");
                continue;
            }
            if (arg.equals("--disableConstraintValidation")) {
                settings.setValue("org.interlis2.validator.disableconstraintvalidation", "true");
                continue;
            }
            if (arg.equals("--multiplicityOff")) {
                settings.setValue(Validator.SETTING_MULTIPLICITY_VALIDATION, "off");
                continue;
            }
            if (arg.equals("--allObjectsAccessible")) {
                settings.setValue("org.interlis2.validator.allobjectsaccessible", "true");
                continue;
            }
            if (arg.equals("--allowItfAreaHoles")) {
                settings.setValue("org.interlis2.validator.allowitfareaholes", "true");
                continue;
            }
            if (arg.equals("--skipPolygonBuilding")) {
                settings.setValue("ch.interlis.iox_j.validator.doItfLinetables", "doItfLinetables");
                continue;
            }
            if (arg.equals("--createIliData")) {
                function = FC_CREATE_ILIDATA_XML;
                continue;
            }
            if (arg.equals("--updateIliData")) {
                function = FC_UPDATE_ILIDATA_XML;
                continue;
            }
            if (arg.equals("--check-repo-data")) {
                function = FC_CHECK_REPO_DATA;
                settings.setValue("org.interlis2.validator.baseUrl", args[++argi]);
                continue;
            }
            if (arg.equals("--ilidata")) {
                settings.setValue("org.interlis2.validator.ilidata", args[++argi]);
                continue;
            }
            if (arg.equals("--srcfiles")) {
                settings.setValue("org.interlis2.validator.filelist", args[++argi]);
                continue;
            }
            if (arg.equals("--datasetId")) {
                settings.setValue("org.interlis2.validator.datasetIDToUpdate", args[++argi]);
                continue;
            }
            if (arg.equals("--repos")) {
                settings.setValue("org.interlis2.validator.baseUrl", args[++argi]);
                continue;
            }
            if (arg.equals("--log")) {
                settings.setValue("org.interlis2.validator.log", args[++argi]);
                continue;
            }
            if (arg.equals("--xtflog")) {
                settings.setValue("org.interlis2.validator.xtflog", args[++argi]);
                continue;
            }
            if (arg.equals("--plugins")) {
                settings.setValue("org.interlis2.validator.pluginfolder", args[++argi]);
                continue;
            }
            if (arg.equals("--proxy")) {
                settings.setValue("ch.interlis.ili2c.http_proxy_host", args[++argi]);
                continue;
            }
            if (arg.equals("--proxyPort")) {
                settings.setValue("ch.interlis.ili2c.http_proxy_port", args[++argi]);
                continue;
            }
            if (arg.equals("--version")) {
                Main.printVersion();
                return;
            }
            if (arg.equals("--help")) {
                Main.printVersion();
                System.err.println();
                Main.printDescription();
                System.err.println();
                Main.printUsage();
                System.err.println();
                System.err.println("OPTIONS");
                System.err.println();
                System.err.println("--gui                 start GUI.");
                System.err.println("--config file         config file to control validation.");
                System.err.println("--forceTypeValidation  restrict customization of validation related to \"multiplicity\".");
                System.err.println("--disableAreaValidation  disable AREA validation.");
                System.err.println("--disableConstraintValidation  disable constraint validation.");
                System.err.println("--allObjectsAccessible  assume that all objects are known to the validator.");
                System.err.println("--multiplicityOff     disable all multiplicity validation.");
                System.err.println("--createIliData(formedFilename, sourceFolder)   create a new xml file by reading/analyzing existing xtf/itf files.");
                System.err.println("--srcfiles (formedFilename, filename, remoteLocation)   reads a list of relative file names and reads all these files from the remote location and creates new xml(ilidata formatted)");
                System.err.println("--updateIliData       Ili data to be updated");
                System.err.println("--dataset             The requested Dataset ID to be updated");
                System.err.println("--skipPolygonBuilding skip polygon building (only ITF).");
                System.err.println("--allowItfAreaHoles   allow empty holes (unassigned inner boundaries) in ITF AREA attributes.");
                System.err.println("--log file            text file, that receives validation results.");
                System.err.println("--xtflog file         INTERLIS transfer file, that receives validation results.");
                System.err.println("--models model\t\t  user sets certain models, separated by a semicolon.");
                System.err.println("--modeldir %ITF_DIR;http://models.interlis.ch/;%JAR_DIR/ilimodels list of directories/repositories with ili-files.");
                System.err.println("--plugins folder      directory with jar files that contain user defined functions.");
                System.err.println("--proxy host          proxy server to access model repositories.");
                System.err.println("--proxyPort port      proxy port to access model repositories.");
                System.err.println("--trace               enable trace messages.");
                System.err.println("--help                Display this help text.");
                System.err.println("--version             Display the version of ilivalidator.");
                System.err.println();
                return;
            }
            if (!arg.startsWith("-")) break;
            EhiLogger.logAdaption((String)(arg + ": unknown option; ignored"));
        }
        int dataFileCount = args.length - argi;
        if (doGui) {
            if (dataFileCount > 0) {
                xtfFile = Main.getDataFiles(args, argi, dataFileCount);
            }
            MainFrame.main(xtfFile, settings);
        } else {
            xtfFile = Main.getDataFiles(args, argi, dataFileCount);
            boolean ok = false;
            if (function == FC_VALIDATE) {
                if (dataFileCount == 0) {
                    EhiLogger.logError((String)"ilivalidator: wrong number of arguments");
                    System.exit(2);
                }
                ok = Validator.runValidation(xtfFile, settings);
            } else if (function == FC_CREATE_ILIDATA_XML) {
                if (dataFileCount != 0) {
                    EhiLogger.logError((String)"ilivalidator: wrong number of arguments");
                    System.exit(2);
                }
                ok = CreateIliDataTool.start(settings);
            } else if (function == FC_UPDATE_ILIDATA_XML) {
                if (dataFileCount != 1) {
                    EhiLogger.logError((String)"ilivalidator: wrong number of arguments");
                    System.exit(2);
                }
                ok = UpdateIliDataTool.update(new File(xtfFile[0]), settings);
            } else if (function == FC_CHECK_REPO_DATA) {
                if (dataFileCount != 0) {
                    EhiLogger.logError((String)"ilivalidator: wrong number of arguments");
                    System.exit(2);
                }
                ok = CheckRepoDataTool.launch(settings);
            } else {
                throw new IllegalStateException("function==" + function);
            }
            System.exit(ok ? 0 : 1);
        }
    }

    private static String[] getDataFiles(String[] args, int argi, int dataFileCount) {
        String[] xtfFile = new String[dataFileCount];
        int fileCount = 0;
        while (argi < args.length) {
            xtfFile[fileCount] = args[argi];
            ++fileCount;
            ++argi;
        }
        return xtfFile;
    }

    public static void readSettings(Settings settings) {
        File file = new File(SETTINGS_FILE);
        try {
            if (file.exists()) {
                settings.load(file);
            }
        }
        catch (IOException ex) {
            EhiLogger.logError((String)("failed to load settings from file " + SETTINGS_FILE), (Throwable)ex);
        }
    }

    public static void writeSettings(Settings settings) {
        File file = new File(SETTINGS_FILE);
        try {
            settings.store(file, "ilivalidator settings");
        }
        catch (IOException ex) {
            EhiLogger.logError((String)("failed to settings settings to file " + SETTINGS_FILE), (Throwable)ex);
        }
    }

    protected static void printVersion() {
        System.err.println("ilivalidator, Version " + Main.getVersion());
        System.err.println("  Developed by Eisenhut Informatik AG, CH-3400 Burgdorf");
    }

    protected static void printDescription() {
        System.err.println("DESCRIPTION");
        System.err.println("  Validates an INTERLIS transfer file.");
    }

    protected static void printUsage() {
        System.err.println("USAGE");
        System.err.println("  java -jar ilivalidator.jar [Options] in.xtf");
    }

    public static String getVersion() {
        if (version == null) {
            java.util.ResourceBundle resVersion = java.util.ResourceBundle.getBundle(ResourceBundle.class2qpackageName(Main.class) + ".Version");
            StringBuffer ret = new StringBuffer(20);
            ret.append(resVersion.getString("version"));
            ret.append('-');
            ret.append(resVersion.getString("versionCommit"));
            version = ret.toString();
        }
        return version;
    }

    public static String getAppHome() {
        String[] classpaths;
        for (String classpath : classpaths = System.getProperty("java.class.path").split(System.getProperty("path.separator"))) {
            File file;
            String jarName;
            if (!classpath.toLowerCase().endsWith(".jar") || !(jarName = (file = new File(classpath)).getName()).toLowerCase().startsWith(APP_NAME) || !(file = new File(file.getAbsolutePath())).exists()) continue;
            return file.getParent();
        }
        return null;
    }
}

