/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.iox.objpool;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.iox.objpool.impl.BTreeImpl;
import ch.ehi.iox.objpool.impl.JavaSerializer;
import ch.ehi.iox.objpool.impl.ObjPoolImpl;
import ch.ehi.iox.objpool.impl.ObjPoolImpl2;
import ch.ehi.iox.objpool.impl.Serializer;
import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class ObjectPoolManager {
    private ArrayList<ObjPoolImpl> maps = new ArrayList();
    private ArrayList<BTreeImpl> maps2 = new ArrayList();
    private ArrayList<ObjPoolImpl2> maps3 = new ArrayList();
    private long initGcTime = this.getTotalGcTime();
    private boolean doCacheing = true;
    private int callCount = 0;

    @Deprecated
    public <K, V> Map<K, V> newObjectPool() {
        this.flushWriteQueues();
        ObjPoolImpl m = null;
        m = new ObjPoolImpl(this, new JavaSerializer());
        this.maps.add(m);
        return m;
    }

    public <K, V> Map<K, V> newObjectPool(Serializer<V> serializer) {
        this.flushWriteQueues();
        ObjPoolImpl m = null;
        m = new ObjPoolImpl(this, serializer);
        this.maps.add(m);
        return m;
    }

    public <K, V> Map<K, V> newObjectPoolImpl2(Serializer<V> serializer) {
        this.flushWriteQueues();
        ObjPoolImpl2 m = null;
        m = new ObjPoolImpl2(this, serializer);
        if (!this.doCacheing) {
            m.disableCache();
        }
        this.maps3.add(m);
        return m;
    }

    public <K, V> Map<K, V> newObjectPool2(Serializer keySerializer, Serializer valueSerializer) {
        this.flushWriteQueues();
        BTreeImpl m = null;
        m = new BTreeImpl(this, keySerializer, valueSerializer);
        if (!this.doCacheing) {
            m.disableCache();
        }
        this.maps2.add(m);
        return m;
    }

    public void flushWriteQueues() {
        for (ObjPoolImpl objPoolImpl : this.maps) {
            objPoolImpl.flushWriteQueue();
        }
        if (this.doCacheing) {
            if (this.callCount == 0) {
                if (this.getTotalGcTime() - this.initGcTime > 10000L) {
                    EhiLogger.traceState((String)"switch off object cache");
                    for (BTreeImpl bTreeImpl : this.maps2) {
                        bTreeImpl.disableCache();
                    }
                    for (ObjPoolImpl2 objPoolImpl2 : this.maps3) {
                        objPoolImpl2.disableCache();
                    }
                    this.doCacheing = false;
                }
                ++this.callCount;
            } else {
                this.callCount = this.callCount == 1000 ? 0 : ++this.callCount;
            }
        }
    }

    private long getTotalGcTime() {
        List<GarbageCollectorMXBean> memBeans = ManagementFactory.getGarbageCollectorMXBeans();
        long totalGcTime = 0L;
        for (GarbageCollectorMXBean memBean : memBeans) {
            if (!memBean.isValid()) continue;
            totalGcTime += memBean.getCollectionTime();
        }
        return totalGcTime;
    }

    public void close() {
        for (ObjPoolImpl objPoolImpl : this.maps) {
            objPoolImpl.clear();
        }
        this.maps.clear();
        for (BTreeImpl bTreeImpl : this.maps2) {
            bTreeImpl.close();
        }
        this.maps2.clear();
        for (ObjPoolImpl2 objPoolImpl2 : this.maps3) {
            objPoolImpl2.close();
        }
        this.maps3.clear();
    }

    public static File getCacheTmpFilename() {
        String tmp = System.getProperty("java.io.tmpdir");
        return new File(tmp, ObjectPoolManager.getTmpName());
    }

    public static String getTmpName() {
        long n = new Random().nextLong();
        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
        return "ioxtmp" + n;
    }
}

