/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.mapping;

import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.TransferDescription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TranslationNameMapper {
    private Map<Element, Map<String, Element>> mappings = new HashMap<Element, Map<String, Element>>();

    public TranslationNameMapper(TransferDescription td, Settings config) {
        ArrayList<Model> models = new ArrayList<Model>();
        for (Model model : td) {
            models.add(0, model);
        }
        for (Model model : models) {
            this.visitElement((Element)model);
        }
    }

    public Element translateElement(String[] langPath, Element src) {
        Map<String, Element> translations = this.mappings.get(src);
        if (translations != null) {
            for (String lang : langPath) {
                Element dest = translations.get(lang);
                if (dest == null) continue;
                return dest;
            }
        }
        return src;
    }

    private void visitElement(Element el) {
        if (this.mappings.containsKey(el)) {
            return;
        }
        HashMap<Object, Element> translations = new HashMap<Object, Element>();
        ArrayList<Element> eles = new ArrayList<Element>();
        for (Element translatedEle = el; translatedEle != null; translatedEle = translatedEle.getTranslationOf()) {
            eles.add(0, translatedEle);
            String lang = TranslationNameMapper.getLang(translatedEle);
            if (translations.containsKey(lang)) continue;
            translations.put(lang, translatedEle);
        }
        for (Element e : eles) {
            this.mappings.put(e, translations);
        }
        if (el instanceof Container) {
            Container e = (Container)el;
            Iterator it = e.iterator();
            while (it.hasNext()) {
                this.visitElement((Element)it.next());
            }
        }
    }

    private static String getLang(Element el) {
        Model model = null;
        model = el instanceof Model ? (Model)el : (Model)el.getContainer(Model.class);
        String lang = model.getLanguage();
        return lang;
    }
}

