/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Unit;
import java.beans.PropertyVetoException;
import java.math.BigDecimal;
import java.util.List;

public class NumericType
extends NumericalType {
    protected PrecisionDecimal minimum;
    protected PrecisionDecimal maximum;

    public NumericType() {
        this.maximum = null;
        this.minimum = null;
    }

    public PrecisionDecimal getMinimum() {
        return this.minimum;
    }

    public PrecisionDecimal getMaximum() {
        return this.maximum;
    }

    public NumericType(PrecisionDecimal minimum, PrecisionDecimal maximum) {
        if (minimum == null || maximum == null) {
            throw new Ili2cSemanticException(rsrc.getString("err_nullNotAcceptable"));
        }
        if (minimum.compareTo(maximum) == 1) {
            throw new Ili2cSemanticException(rsrc.getString("err_numericType_minGreaterMax"));
        }
        if (minimum.getAccuracy() != maximum.getAccuracy()) {
            throw new Ili2cSemanticException(rsrc.getString("err_numericType_precisionMismatch"));
        }
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public String toString() {
        if (this.minimum == null || this.maximum == null) {
            return "NUMERIC";
        }
        return this.minimum.toString() + ".." + this.maximum.toString();
    }

    @Override
    public boolean isAbstract(StringBuilder err) {
        if (this.minimum == null || this.maximum == null) {
            err.append("missing min/max");
            return true;
        }
        Unit unit = this.getUnit();
        if (unit != null && unit.isAbstract()) {
            err.append("UnitDef is abstract");
            return true;
        }
        return false;
    }

    @Override
    public void setUnit(Unit unit) throws PropertyVetoException {
        Unit oldValue = this.unit;
        Unit newValue = unit;
        if (oldValue == newValue) {
            return;
        }
        if (newValue != null && this.minimum != null && newValue.isAbstract()) {
            throw new Ili2cSemanticException(NumericType.formatMessage("err_numericType_concreteWithAbstractUnit", newValue.toString()));
        }
        this.fireVetoableChange("unit", oldValue, newValue);
        this.unit = newValue;
        this.firePropertyChange("unit", oldValue, newValue);
    }

    @Override
    public Unit getUnit() {
        Type realExt = this.extending != null ? this.extending.resolveAliases() : null;
        if (this.unit == null && realExt instanceof NumericType) {
            return ((NumericType)realExt).getUnit();
        }
        return this.unit;
    }

    @Override
    void checkTypeExtension(Type wantToExtend) {
        if (wantToExtend == null || (wantToExtend = wantToExtend.resolveAliases()) == null) {
            return;
        }
        if (!(wantToExtend instanceof NumericType)) {
            throw new Ili2cSemanticException(rsrc.getString("err_numericType_ExtOther"));
        }
        NumericType general = (NumericType)wantToExtend;
        if (this.isAbstract() && !general.isAbstract()) {
            throw new Ili2cSemanticException(rsrc.getString("err_numericType_abstractExtConcrete"));
        }
        if (this.minimum != null && this.maximum != null && general.minimum != null && general.maximum != null) {
            BigDecimal min_rounded = new BigDecimal(this.minimum.toString()).setScale(this.minimum.getExponent(), 4);
            BigDecimal max_rounded = new BigDecimal(this.maximum.toString()).setScale(this.maximum.getExponent(), 4);
            BigDecimal min_general = new BigDecimal(general.minimum.toString()).setScale(general.minimum.getExponent(), 4);
            BigDecimal max_general = new BigDecimal(general.maximum.toString()).setScale(general.maximum.getExponent(), 4);
            if (min_rounded.compareTo(min_general) == -1) {
                throw new Ili2cSemanticException(NumericType.formatMessage("err_numericType_minLessInheritedMin", Integer.toString(general.minimum.getExponent()), this.minimum.toString(), min_rounded.toString(), general.minimum.toString()));
            }
            if (max_rounded.compareTo(max_general) == 1) {
                throw new Ili2cSemanticException(NumericType.formatMessage("err_numericType_maxGreaterInheritedMax", Integer.toString(general.maximum.getExponent()), this.maximum.toString(), max_rounded.toString(), general.maximum.toString()));
            }
        }
        if (this.unit != null) {
            Unit generalUnit = general.getUnit();
            if (!general.isAbstract() && generalUnit == null) {
                throw new Ili2cSemanticException(rsrc.getString("err_numericType_withUnitExtWithoutUnit"));
            }
            if (generalUnit != null && generalUnit.isAbstract() && !this.unit.isExtendingIndirectly(generalUnit)) {
                throw new Ili2cSemanticException(NumericType.formatMessage("err_numericType_unitNotExtAbstractBaseUnit", this.unit.toString(), generalUnit.toString()));
            }
            if (generalUnit != null && !generalUnit.isAbstract() && generalUnit != this.unit) {
                throw new Ili2cSemanticException(NumericType.formatMessage("err_numericType_unitExtConcreteBaseUnit", this.unit.toString(), generalUnit.toString()));
            }
        }
        String errorString = null;
        block0 : switch (this.getRotation()) {
            case 0: {
                switch (general.getRotation()) {
                    case 1: {
                        errorString = "err_numericType_noneExtCw";
                        break;
                    }
                    case 2: {
                        errorString = "err_numericType_noneExtCcw";
                    }
                }
                break;
            }
            case 1: {
                switch (general.getRotation()) {
                    case 0: {
                        errorString = "err_numericType_cwExtNone";
                        break;
                    }
                    case 2: {
                        errorString = "err_numericType_cwExtCcw";
                    }
                }
                break;
            }
            case 2: {
                switch (general.getRotation()) {
                    case 0: {
                        errorString = "err_numericType_ccwExtNone";
                        break block0;
                    }
                    case 1: {
                        errorString = "err_numericType_ccwExtCw";
                    }
                }
            }
        }
        if (errorString != null) {
            throw new Ili2cSemanticException(rsrc.getString(errorString));
        }
        this.checkCardinalityExtension(wantToExtend);
    }

    @Override
    protected void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) {
        super.checkTranslationOf(errs, name, baseName);
        NumericType origin = (NumericType)this.getTranslationOf();
        if (origin == null) {
            return;
        }
        if (!PrecisionDecimal.equals(this.minimum, origin.minimum)) {
            throw new Ili2cSemanticException();
        }
        if (!PrecisionDecimal.equals(this.maximum, origin.maximum)) {
            throw new Ili2cSemanticException();
        }
        if (!this.isAbstract() && this.minimum.getAccuracy() != origin.minimum.getAccuracy()) {
            throw new Ili2cSemanticException();
        }
    }

    @Override
    public NumericType clone() {
        return (NumericType)super.clone();
    }
}

