/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Type;
import java.beans.PropertyVetoException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CompositionType
extends Type {
    Table componentType;
    private LinkedList<Table> restrictedTo = new LinkedList();

    public CompositionType() {
        this.cardinality = new Cardinality(0L, Long.MAX_VALUE);
    }

    public Table getComponentType() {
        return this.componentType;
    }

    public void setComponentType(Table componentType) throws PropertyVetoException {
        Table oldValue = this.componentType;
        Table newValue = componentType;
        if (newValue == null) {
            throw new IllegalArgumentException(rsrc.getString("err_nullNotAcceptable"));
        }
        if (oldValue == newValue) {
            return;
        }
        if (newValue != null) {
            Iterator<Extendable> iter = newValue.getAttributes();
            while (iter.hasNext()) {
                Extendable obj = iter.next();
                if (!(obj instanceof AttributeDef)) continue;
                Type attrDomain = ((AttributeDef)obj).getDomain();
                if (attrDomain != null) {
                    attrDomain = attrDomain.resolveAliases();
                }
                if (!(attrDomain instanceof AreaType)) continue;
                throw new IllegalArgumentException(CompositionType.formatMessage("err_compositionType_areaAttr", newValue.toString(), obj.toString()));
            }
        }
        this.fireVetoableChange("componentType", oldValue, newValue);
        if (oldValue != null) {
            oldValue.componentFor.remove(this);
        }
        if (newValue != null) {
            newValue.componentFor.add(this);
        }
        this.componentType = newValue;
        this.firePropertyChange("componentType", oldValue, newValue);
    }

    @Override
    void checkTypeExtension(Type wantToExtend) {
        if (wantToExtend == null || (wantToExtend = wantToExtend.resolveAliases()) == null) {
            return;
        }
        if (!(wantToExtend instanceof CompositionType)) {
            throw new IllegalArgumentException(rsrc.getString("err_compositionType_ExtOther"));
        }
        CompositionType general = (CompositionType)wantToExtend;
        Table myComponent = this.getComponentType();
        Table generalComponent = general.getComponentType();
        if (myComponent != null && generalComponent != null && !myComponent.isExtending(generalComponent)) {
            throw new IllegalArgumentException(CompositionType.formatMessage("err_compositionType_componentNotExt", myComponent.toString(), generalComponent.toString()));
        }
        this.checkCardinalityExtension(general);
    }

    @Override
    protected void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) {
        super.checkTranslationOf(errs, name, baseName);
        CompositionType baseElement = (CompositionType)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        Ili2cSemanticException err = null;
        err = CompositionType.checkElementRef(this.getComponentType(), baseElement.getComponentType(), this.getSourceLine(), "err_diff_referencedClassMismatch");
        if (err != null) {
            errs.add(err);
        }
        Iterator<Table> depIt = this.iteratorRestrictedTo();
        Iterator<Table> baseDepIt = baseElement.iteratorRestrictedTo();
        while (true) {
            Table baseDep;
            if (!depIt.hasNext() || !baseDepIt.hasNext()) {
                if (depIt.hasNext() == baseDepIt.hasNext()) break;
                errs.add(new Ili2cSemanticException(this.getSourceLine(), CompositionType.formatMessage("err_diff_referencedClassMismatch")));
                break;
            }
            Table dep = depIt.next();
            err = CompositionType.checkElementRef(dep, baseDep = baseDepIt.next(), this.getSourceLine(), "err_diff_referencedClassMismatch");
            if (err == null) continue;
            errs.add(err);
        }
    }

    public void addRestrictedTo(Table structure) {
        this.restrictedTo.add(structure);
        if (!this.componentType.getScopedName((Container)null).equals("INTERLIS.ANYSTRUCTURE") && !structure.isExtending(this.componentType)) {
            throw new Ili2cSemanticException(this.getSourceLine(), CompositionType.formatMessage("err_compositionType_restriction", structure.toString(), this.componentType.toString()));
        }
    }

    public Iterator<Table> iteratorRestrictedTo() {
        return this.restrictedTo.iterator();
    }

    @Override
    public CompositionType clone() {
        CompositionType cloned = (CompositionType)super.clone();
        if (this.restrictedTo != null) {
            cloned.restrictedTo = (LinkedList)this.restrictedTo.clone();
        }
        return cloned;
    }
}

