/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.Type;

public abstract class Expression
extends Evaluable {
    @Override
    public boolean isLogical() {
        return true;
    }

    @Override
    public Type getType() {
        return PredefinedModel.getInstance().BOOLEAN.getType();
    }

    public static class DefinedCheck
    extends Expression {
        protected Evaluable argument;

        public DefinedCheck(Evaluable argument) {
            this.argument = argument;
        }

        public Evaluable getArgument() {
            return this.argument;
        }

        @Override
        public Ili2cSemanticException checkTranslation(Evaluable otherEv, int sourceLine) {
            Ili2cSemanticException ret = super.checkTranslation(otherEv, sourceLine);
            if (ret != null) {
                return ret;
            }
            DefinedCheck other = (DefinedCheck)otherEv;
            if (this.argument.getClass() != other.argument.getClass()) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_definedCheckMismatch"));
            }
            ret = this.argument.checkTranslation(other.argument, sourceLine);
            if (ret != null) {
                return ret;
            }
            return null;
        }
    }

    public static class GreaterThanOrEqual
    extends Expression {
        protected Evaluable left;
        protected Evaluable right;

        public GreaterThanOrEqual(Evaluable left, Evaluable right) {
            this.left = left;
            this.right = right;
        }

        public Evaluable getLeft() {
            return this.left;
        }

        public Evaluable getRight() {
            return this.right;
        }

        @Override
        public Ili2cSemanticException checkTranslation(Evaluable otherEv, int sourceLine) {
            Ili2cSemanticException ret = super.checkTranslation(otherEv, sourceLine);
            if (ret != null) {
                return ret;
            }
            GreaterThanOrEqual other = (GreaterThanOrEqual)otherEv;
            if (this.left.getClass() != other.left.getClass()) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_greaterThanOrEqualMismatch"));
            }
            ret = this.left.checkTranslation(other.left, sourceLine);
            if (ret != null) {
                return ret;
            }
            if (this.right.getClass() != other.right.getClass()) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_greaterThanOrEqualMismatch"));
            }
            ret = this.right.checkTranslation(other.right, sourceLine);
            if (ret != null) {
                return ret;
            }
            return null;
        }
    }

    public static class LessThanOrEqual
    extends Expression {
        protected Evaluable left;
        protected Evaluable right;

        public LessThanOrEqual(Evaluable left, Evaluable right) {
            this.left = left;
            this.right = right;
        }

        public Evaluable getLeft() {
            return this.left;
        }

        public Evaluable getRight() {
            return this.right;
        }

        @Override
        public Ili2cSemanticException checkTranslation(Evaluable otherEv, int sourceLine) {
            Ili2cSemanticException ret = super.checkTranslation(otherEv, sourceLine);
            if (ret != null) {
                return ret;
            }
            LessThanOrEqual other = (LessThanOrEqual)otherEv;
            if (this.left.getClass() != other.left.getClass()) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_lessThanOrEqualMismatch"));
            }
            ret = this.left.checkTranslation(other.left, sourceLine);
            if (ret != null) {
                return ret;
            }
            if (this.right.getClass() != other.right.getClass()) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_lessThanOrEqualMismatch"));
            }
            ret = this.right.checkTranslation(other.right, sourceLine);
            if (ret != null) {
                return ret;
            }
            return null;
        }
    }

    public static class LessThan
    extends Expression {
        protected Evaluable left;
        protected Evaluable right;

        public LessThan(Evaluable left, Evaluable right) {
            this.left = left;
            this.right = right;
        }

        public Evaluable getLeft() {
            return this.left;
        }

        public Evaluable getRight() {
            return this.right;
        }

        @Override
        public Ili2cSemanticException checkTranslation(Evaluable otherEv, int sourceLine) {
            Ili2cSemanticException ret = super.checkTranslation(otherEv, sourceLine);
            if (ret != null) {
                return ret;
            }
            LessThan other = (LessThan)otherEv;
            if (this.left.getClass() != other.left.getClass()) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_lessThanMismatch"));
            }
            ret = this.left.checkTranslation(other.left, sourceLine);
            if (ret != null) {
                return ret;
            }
            if (this.right.getClass() != other.right.getClass()) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_lessThanMismatch"));
            }
            ret = this.right.checkTranslation(other.right, sourceLine);
            if (ret != null) {
                return ret;
            }
            return null;
        }
    }

    public static class GreaterThan
    extends Expression {
        protected Evaluable left;
        protected Evaluable right;

        public GreaterThan(Evaluable left, Evaluable right) {
            this.left = left;
            this.right = right;
        }

        public Evaluable getLeft() {
            return this.left;
        }

        public Evaluable getRight() {
            return this.right;
        }

        @Override
        public Ili2cSemanticException checkTranslation(Evaluable otherEv, int sourceLine) {
            Ili2cSemanticException ret = super.checkTranslation(otherEv, sourceLine);
            if (ret != null) {
                return ret;
            }
            GreaterThan other = (GreaterThan)otherEv;
            if (this.left.getClass() != other.left.getClass()) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_greaterThanMismatch"));
            }
            ret = this.left.checkTranslation(other.left, sourceLine);
            if (ret != null) {
                return ret;
            }
            if (this.right.getClass() != other.right.getClass()) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_greaterThanMismatch"));
            }
            ret = this.right.checkTranslation(other.right, sourceLine);
            if (ret != null) {
                return ret;
            }
            return null;
        }
    }

    public static class Inequality
    extends Expression {
        protected Evaluable left;
        protected Evaluable right;

        public Inequality(Evaluable left, Evaluable right) {
            this.left = left;
            this.right = right;
        }

        public Evaluable getLeft() {
            return this.left;
        }

        public Evaluable getRight() {
            return this.right;
        }

        @Override
        public Ili2cSemanticException checkTranslation(Evaluable otherEv, int sourceLine) {
            Ili2cSemanticException ret = super.checkTranslation(otherEv, sourceLine);
            if (ret != null) {
                return ret;
            }
            Inequality other = (Inequality)otherEv;
            if (this.left.getClass() != other.left.getClass()) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_inequalityMismatch"));
            }
            ret = this.left.checkTranslation(other.left, sourceLine);
            if (ret != null) {
                return ret;
            }
            if (this.right.getClass() != other.right.getClass()) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_inequalityMismatch"));
            }
            ret = this.right.checkTranslation(other.right, sourceLine);
            if (ret != null) {
                return ret;
            }
            return null;
        }
    }

    public static class Equality
    extends Expression {
        protected Evaluable left;
        protected Evaluable right;

        public Equality(Evaluable left, Evaluable right) {
            this.left = left;
            this.right = right;
        }

        public Evaluable getLeft() {
            return this.left;
        }

        public Evaluable getRight() {
            return this.right;
        }

        @Override
        public Ili2cSemanticException checkTranslation(Evaluable otherEv, int sourceLine) {
            Ili2cSemanticException ret = super.checkTranslation(otherEv, sourceLine);
            if (ret != null) {
                return ret;
            }
            Equality other = (Equality)otherEv;
            if (this.left.getClass() != other.left.getClass()) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_equalityMismatch"));
            }
            ret = this.left.checkTranslation(other.left, sourceLine);
            if (ret != null) {
                return ret;
            }
            if (this.right.getClass() != other.right.getClass()) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_equalityMismatch"));
            }
            ret = this.right.checkTranslation(other.right, sourceLine);
            if (ret != null) {
                return ret;
            }
            return null;
        }
    }

    public static class Conjunction
    extends Expression {
        protected Evaluable[] conjoined;

        public Conjunction(Evaluable[] conjoined) {
            if (conjoined.length < 2) {
                throw new IllegalArgumentException();
            }
            this.conjoined = conjoined;
        }

        public Evaluable[] getConjoined() {
            return this.conjoined;
        }

        @Override
        public Ili2cSemanticException checkTranslation(Evaluable otherEv, int sourceLine) {
            Ili2cSemanticException ret = super.checkTranslation(otherEv, sourceLine);
            if (ret != null) {
                return ret;
            }
            Conjunction other = (Conjunction)otherEv;
            if (this.conjoined.length != other.conjoined.length) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_conjunctionMismatch"));
            }
            for (int pathi = 0; pathi < this.conjoined.length; ++pathi) {
                if (this.conjoined[pathi].getClass() != other.conjoined[pathi].getClass()) {
                    return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_conjunctionMismatch"));
                }
                ret = this.conjoined[pathi].checkTranslation(other.conjoined[pathi], sourceLine);
                if (ret == null) continue;
                return ret;
            }
            return null;
        }
    }

    public static class Disjunction
    extends Expression {
        protected Evaluable[] disjoined;

        public Disjunction(Evaluable[] disjoined) {
            if (disjoined.length < 2) {
                throw new IllegalArgumentException();
            }
            this.disjoined = disjoined;
        }

        public Evaluable[] getDisjoined() {
            return this.disjoined;
        }

        @Override
        public Ili2cSemanticException checkTranslation(Evaluable otherEv, int sourceLine) {
            Ili2cSemanticException ret = super.checkTranslation(otherEv, sourceLine);
            if (ret != null) {
                return ret;
            }
            Disjunction other = (Disjunction)otherEv;
            if (this.disjoined.length != other.disjoined.length) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_disjunctionMismatch"));
            }
            for (int pathi = 0; pathi < this.disjoined.length; ++pathi) {
                if (this.disjoined[pathi].getClass() != other.disjoined[pathi].getClass()) {
                    return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_disjunctionMismatch"));
                }
                ret = this.disjoined[pathi].checkTranslation(other.disjoined[pathi], sourceLine);
                if (ret == null) continue;
                return ret;
            }
            return null;
        }
    }

    public static class Negation
    extends Expression {
        protected Evaluable negated;

        public Negation(Evaluable negated) {
            this.negated = negated;
        }

        public Evaluable getNegated() {
            return this.negated;
        }

        @Override
        public Ili2cSemanticException checkTranslation(Evaluable otherEv, int sourceLine) {
            Ili2cSemanticException ret = super.checkTranslation(otherEv, sourceLine);
            if (ret != null) {
                return ret;
            }
            Negation other = (Negation)otherEv;
            if (this.negated.getClass() != other.negated.getClass()) {
                return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_negationMismatch"));
            }
            ret = this.negated.checkTranslation(other.negated, sourceLine);
            if (ret != null) {
                return ret;
            }
            return null;
        }
    }
}

