/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.DataContainer;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Ili1Format;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import java.beans.PropertyVetoException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class TransferDescription
extends Container<Model> {
    private static String version = null;
    protected String name = "";
    private Map<String, Element> name2ele = null;
    protected List<Model> contents = new LinkedList<Model>();
    private HashMap<String, DataContainer> metaDataBaskets = new HashMap();
    private HashMap<String, String> basketname2boid = new HashMap();
    public final PredefinedModel INTERLIS = PredefinedModel.getInstance();
    private Ili1Format ili1Format = null;
    public static final String MIMETYPE_ITF = "application/interlis;version=1.0";
    public static final String MIMETYPE_XTF = "application/interlis+xml;version=2.3";

    public TransferDescription() {
        this.add(this.INTERLIS);
    }

    @Override
    protected Collection<Model> createElements() {
        return new AbstractCollection<Model>(){

            @Override
            public Iterator<Model> iterator() {
                return TransferDescription.this.contents.iterator();
            }

            @Override
            public int size() {
                return TransferDescription.this.contents.size();
            }

            @Override
            public boolean add(Model o) {
                if (o instanceof Model) {
                    Model model = o;
                    Model conflicting = (Model)TransferDescription.this.getElement(Model.class, model.getName());
                    if (conflicting != null) {
                        throw new Ili2cSemanticException(model.getSourceLine(), Element.formatMessage("err_model_duplicateName", conflicting.toString()));
                    }
                    return TransferDescription.this.contents.add(o);
                }
                throw new ClassCastException();
            }
        };
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) throws PropertyVetoException {
        String oldValue = this.name;
        String newValue = name;
        this.fireVetoableChange("name", oldValue, newValue);
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    public String toString() {
        return "TRANSFER " + this.getName();
    }

    public Iterator<DataContainer> iteratorMetaDataContainer() {
        return this.metaDataBaskets.values().iterator();
    }

    public void addMetaDataContainer(DataContainer concreteBasket) {
        this.metaDataBaskets.put(concreteBasket.getBoid(), concreteBasket);
    }

    public void addMetadataMapping(String qualifiedBasketName, String boid) {
        this.basketname2boid.put(qualifiedBasketName, boid);
    }

    public HashMap<String, String> getBasketname2boid() {
        return (HashMap)this.basketname2boid.clone();
    }

    public DataContainer getMetaDataContainer(String qualifiedBasketName) {
        String boid = this.basketname2boid.get(qualifiedBasketName);
        if (boid == null) {
            return null;
        }
        return this.metaDataBaskets.get(boid);
    }

    public Ili1Format getIli1Format() {
        return this.ili1Format;
    }

    public void setIli1Format(Ili1Format ili1Format1) {
        this.ili1Format = ili1Format1;
    }

    public Model getLastModel() {
        Model mainModel2 = null;
        for (Model mainModel2 : this) {
        }
        return mainModel2;
    }

    public Model[] getModelsFromLastFile() {
        String mainModelFileName = this.getLastModel().getFileName();
        if (mainModelFileName == null) {
            return new Model[0];
        }
        ArrayList<Model> models = new ArrayList<Model>();
        for (Model model : this) {
            if (!mainModelFileName.equals(model.getFileName())) continue;
            models.add(model);
        }
        return models.toArray(new Model[models.size()]);
    }

    public Element getElement(String scopedName) {
        if (this.name2ele == null) {
            this.name2ele = new HashMap<String, Element>();
            for (Element transElem : this) {
                this.visitElement(transElem);
            }
        }
        return this.name2ele.get(scopedName);
    }

    private void visitElement(Element el) {
        String scopedName = el.getScopedName();
        this.name2ele.put(scopedName, el);
        if (el instanceof Container) {
            Container c = (Container)el;
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.visitElement((Element)it.next());
            }
        }
    }

    public static String getVersion() {
        if (version == null) {
            ResourceBundle resVersion = ResourceBundle.getBundle("ch.interlis.ili2c.Version");
            StringBuilder ret = new StringBuilder(20);
            ret.append(resVersion.getString("version"));
            ret.append('-');
            ret.append(resVersion.getString("versionCommit"));
            version = ret.toString();
        }
        return version;
    }
}

