/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AbstractPatternDef;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.CombiningIterator;
import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NoOid;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.Viewable;
import java.beans.PropertyVetoException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AssociationDef
extends AbstractClassDef<Element> {
    protected List<RoleDef> roles = new LinkedList<RoleDef>();
    private Cardinality cardinality = null;
    private boolean identifiable = false;
    private Viewable<?> derivedFrom;
    private boolean extended = false;

    public void setDerivedFrom(Viewable<?> ref) {
        this.derivedFrom = ref;
    }

    public Viewable<?> getDerivedFrom() {
        return this.derivedFrom;
    }

    @Override
    protected Collection<Element> createElements() {
        return new AbstractCollection<Element>(){

            @Override
            public Iterator<Element> iterator() {
                Iterator[] it = new Iterator[]{AssociationDef.this.roles.iterator(), AssociationDef.this.attributes.iterator(), AssociationDef.this.constraints.iterator()};
                return new CombiningIterator<Element>(it);
            }

            @Override
            public int size() {
                return AssociationDef.this.attributes.size() + AssociationDef.this.roles.size() + AssociationDef.this.constraints.size();
            }

            @Override
            public boolean add(Element o) {
                if (o instanceof Constraint) {
                    ((Constraint)o).setNameIdx(AssociationDef.this.constraints.size() + 1);
                    return AssociationDef.this.constraints.add((Constraint)o);
                }
                if (o instanceof LocalAttribute) {
                    LocalAttribute ad = (LocalAttribute)o;
                    if (ad.isAbstract() && !AssociationDef.this.isAbstract()) {
                        throw new Ili2cSemanticException(ad.getSourceLine(), Element.formatMessage("err_abstractAttrInConcreteContainer", AssociationDef.this.toString()));
                    }
                    Iterator<Element> iter = AssociationDef.this.getAttributesAndRoles();
                    while (iter.hasNext()) {
                        Element baseAttr = iter.next();
                        if (!(baseAttr instanceof RoleDef) || !baseAttr.getName().equals(ad.getName())) continue;
                        throw new Ili2cSemanticException(ad.getSourceLine(), Element.formatMessage("err_association_nonuniqueAttributeDef", ad.getName(), AssociationDef.this.toString()));
                    }
                    iter = AssociationDef.this.getOpposideRoles();
                    while (iter.hasNext()) {
                        RoleDef role = (RoleDef)iter.next();
                        if (!role.getName().equals(ad.getName())) continue;
                        throw new Ili2cSemanticException(ad.getSourceLine(), Element.formatMessage("err_abstractClassDef_AttributeNameConflictInTarget", ad.getName(), AssociationDef.this.toString()));
                    }
                    if (!AssociationDef.this.isAbstract() && AssociationDef.this.getContainer() instanceof Topic) {
                        AbstractPatternDef.checkTopicDepOfAttr((Topic)AssociationDef.this.getContainer(), ad, ad.getName());
                    }
                    return AssociationDef.this.attributes.add(ad);
                }
                if (o instanceof RoleDef) {
                    RoleDef role = (RoleDef)o;
                    if ((AssociationDef.this.getExtending() != null || AssociationDef.this.isExtended()) && !role.isExtended()) {
                        throw new Ili2cSemanticException(role.getSourceLine(), Element.formatMessage("err_association_nonewrole", role.getName()));
                    }
                    Element conflicting = AssociationDef.this.getElement(RoleDef.class, role.getName());
                    if (conflicting != null && conflicting != o && !role.isExtended()) {
                        AssociationDef.this.setDirty(true);
                        throw new Ili2cSemanticException(role.getSourceLine(), Element.formatMessage("err_association_nonuniqueRoleDef", role.getName(), AssociationDef.this.toString()));
                    }
                    if (role.isAbstract() && !AssociationDef.this.isAbstract()) {
                        AssociationDef.this.setDirty(true);
                        throw new Ili2cSemanticException(role.getSourceLine(), Element.formatMessage("err_abstractRoleInConcreteContainer", AssociationDef.this.toString()));
                    }
                    return AssociationDef.this.roles.add(role);
                }
                if (o == null) {
                    throw new IllegalArgumentException(Element.rsrc.getString("err_nullNotAcceptable"));
                }
                throw new ClassCastException();
            }
        };
    }

    @Override
    public Iterator<RoleDef> getRolesIterator() {
        return this.roles.iterator();
    }

    public List<RoleDef> getRoles() {
        ArrayList<RoleDef> ret = new ArrayList<RoleDef>(this.roles);
        return ret;
    }

    public String toString() {
        return "ASSOCIATION " + this.getScopedName((Container)null);
    }

    @Override
    public String getName() {
        if (this.name != "") {
            return this.name;
        }
        Iterator<RoleDef> iter = this.roles.iterator();
        StringBuilder assocName = new StringBuilder();
        while (iter.hasNext()) {
            RoleDef role = iter.next();
            assocName.append(role.getName());
        }
        return assocName.toString();
    }

    @Override
    public void setAbstract(boolean abst) throws PropertyVetoException {
        boolean oldValue = this._abstract;
        boolean newValue = abst;
        if (oldValue == newValue) {
            return;
        }
        if (!newValue && this.getContainer(Topic.class) == null && this.getContainer(Model.class) != null) {
            throw new IllegalArgumentException(AssociationDef.formatMessage("err_association_concreteOutsideTopic", this.toString()));
        }
        super.setAbstract(newValue);
    }

    @Override
    public void setExtending(Element extending) throws PropertyVetoException {
        AssociationDef oldValue = (AssociationDef)this.extending;
        AssociationDef newValue = (AssociationDef)extending;
        if (oldValue == newValue) {
            return;
        }
        super.setExtending(newValue);
    }

    @Override
    public void checkIntegrity(List<Ili2cSemanticException> errs) throws IllegalStateException {
        super.checkIntegrity(errs);
        if (this.extending != null && this.isExtended()) {
            AssociationDef tab;
            Topic myTopic = (Topic)this.getContainer(Topic.class);
            Topic topic = (Topic)this.extending.getContainer(Topic.class);
            if (myTopic == null) {
                throw new IllegalArgumentException(AssociationDef.formatMessage("err_association_extendedOutsideTopic", this.toString(), this.extending.toString(), this.toString()));
            }
            if (topic == null) {
                throw new IllegalArgumentException(AssociationDef.formatMessage("err_association_extendedOutsideTopic", this.toString(), this.extending.toString(), this.extending.toString()));
            }
            if (myTopic != null && !myTopic.isExtending(topic)) {
                throw new IllegalArgumentException(AssociationDef.formatMessage("err_association_extendedButTopicsDont", this.toString(), this.extending.toString(), myTopic.toString(), topic.toString()));
            }
            if (myTopic != null) {
                for (Object obj : myTopic) {
                    if (!(obj instanceof AssociationDef) || (tab = (AssociationDef)obj) == this || tab == this.extending || !tab.isExtending(this.extending)) continue;
                    throw new IllegalStateException(AssociationDef.formatMessage("err_association_extendedButOtherDoesToo", this.toString(), this.extending.toString(), myTopic.toString(), tab.toString()));
                }
            }
            if (topic != null) {
                for (Object obj : topic) {
                    if (!(obj instanceof AssociationDef) || (tab = (AssociationDef)obj) == this || tab == this.extending || !tab.isExtending(this.extending)) continue;
                    throw new IllegalStateException(AssociationDef.formatMessage("err_association_extendedButOtherDoesToo", this.toString(), this.extending.toString(), topic.toString(), tab.toString()));
                }
            }
        }
        for (AssociationDef associationDef : this.getReferencableTables()) {
            if (!this.isExtending(associationDef)) continue;
            throw new IllegalStateException(AssociationDef.formatMessage("err_association_cyclicRelationalStructure", this.toString(), associationDef.toString()));
        }
    }

    public void fixupRoles() {
        if (this.isDirty()) {
            return;
        }
        if (this.getContainer() == null) {
            throw new IllegalStateException("AssociationDef without container");
        }
        if (this.getExtending() != null) {
            AssociationDef base = (AssociationDef)this.getExtending();
            for (RoleDef role : this.roles) {
                Element baseEle = base.getElement(RoleDef.class, role.getName());
                if (baseEle == null) {
                    throw new Ili2cSemanticException(role.getSourceLine(), AssociationDef.formatMessage("err_association_noRoleToExtend", role.getName(), base.getScopedName((Container)null)));
                }
                RoleDef baserole = (RoleDef)baseEle;
                role.setExtending(baserole);
            }
        } else if (this.roles.size() < 2) {
            throw new Ili2cSemanticException(this.getSourceLine(), AssociationDef.formatMessage("err_association_twoRoleDef"));
        }
        for (RoleDef role : this.roles) {
            Iterator<AbstractClassDef> desti = role.iteratorDestination();
            while (desti.hasNext()) {
                AbstractClassDef targetClass = desti.next();
                if (role.isExtended()) continue;
                if (targetClass.getContainer() == this.getContainer()) {
                    targetClass.addTargetForRole(role);
                    continue;
                }
                targetClass.addNonNavigableTargetForRole(role);
            }
        }
        Iterator<Element> rolei = this.getAttributesAndRoles();
        int aggc = 0;
        while (rolei.hasNext()) {
            RoleDef role;
            Element obj = rolei.next();
            if (!(obj instanceof RoleDef) || (role = (RoleDef)obj).getKind() <= 1) continue;
            ++aggc;
        }
        if (aggc > 1) {
            throw new Ili2cSemanticException(this.getSourceLine(), AssociationDef.formatMessage("err_association_multipleAggregations"));
        }
    }

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public RoleDef getRoleWhereEmbedded() {
        RoleDef role2Base;
        int rolec = 0;
        RoleDef role1 = null;
        RoleDef role2 = null;
        Iterator<Element> rolei = this.getAttributesAndRoles();
        while (rolei.hasNext()) {
            Element obj = rolei.next();
            if (!(obj instanceof RoleDef)) continue;
            ++rolec;
            if (role1 == null) {
                role1 = (RoleDef)obj;
                continue;
            }
            if (role2 != null) continue;
            role2 = (RoleDef)obj;
        }
        if (rolec > 2) {
            return null;
        }
        RoleDef role1Base = role1.getRootExtending();
        if (role1Base == null) {
            role1Base = role1;
        }
        if ((role2Base = role2.getRootExtending()) == null) {
            role2Base = role2;
        }
        if (role1Base.getCardinality().getMaximum() > 1L && role2Base.getCardinality().getMaximum() > 1L) {
            return null;
        }
        RoleDef ret = null;
        RoleDef retBase = null;
        if (role1Base.getCardinality().getMaximum() == 1L) {
            ret = role2;
            retBase = role2Base;
        } else {
            ret = role1;
            retBase = role1Base;
        }
        AssociationDef base = (AssociationDef)this.getRootExtending();
        if (base == null) {
            base = this;
        }
        if (retBase.getDestination().getContainer() != base.getContainer()) {
            return null;
        }
        return ret;
    }

    public boolean isLightweight() {
        return this.getRoleWhereEmbedded() != null;
    }

    public void setCardinality(Cardinality v) {
        this.cardinality = v;
    }

    public boolean containsCardinality() {
        return this.cardinality != null;
    }

    public Cardinality getDefinedCardinality() {
        return this.cardinality;
    }

    public boolean isIdentifiable() {
        return this.identifiable;
    }

    @Override
    public Domain getOid() {
        for (AssociationDef def = this; def != null; def = (AssociationDef)def.getExtending()) {
            Topic topic;
            Domain oidDomain = def.getDefinedOid();
            if (oidDomain == null && def.isIdentifiable() && (topic = (Topic)def.getContainer(Topic.class)) != null) {
                oidDomain = topic.getOid();
            }
            if (oidDomain == null || oidDomain instanceof NoOid) continue;
            return oidDomain;
        }
        return null;
    }

    public void setIdentifiable(boolean b) {
        this.identifiable = b;
    }

    @Override
    public void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) throws IllegalStateException {
        super.checkTranslationOf(errs, name, baseName);
        AssociationDef baseElement = (AssociationDef)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        if (this.isIdentifiable() != baseElement.isIdentifiable()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), AssociationDef.formatMessage("err_diff_oidMismatch")));
        }
        Cardinality card = this.getDefinedCardinality();
        Cardinality baseCard = baseElement.getDefinedCardinality();
        if (card != null && baseCard != null) {
            if (!card.equals(baseCard)) {
                errs.add(new Ili2cSemanticException(this.getSourceLine(), AssociationDef.formatMessage("err_diff_cardinalityMismatch")));
            }
        } else if (card != null || baseCard != null) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), AssociationDef.formatMessage("err_diff_cardinalityMismatch")));
        }
        Ili2cSemanticException err = null;
        err = AssociationDef.checkElementRef(this.getDerivedFrom(), baseElement.getDerivedFrom(), this.getSourceLine(), "err_diff_derviedFromMismatch");
        if (err != null) {
            errs.add(err);
        }
    }
}

