/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.ObjectPath;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ExistenceConstraint
extends Constraint {
    private ObjectPath restrictedAttribute;
    private LinkedList<ObjectPath> requiredIn = new LinkedList();

    public void setRestrictedAttribute(ObjectPath path) {
        this.restrictedAttribute = path;
    }

    public ObjectPath getRestrictedAttribute() {
        return this.restrictedAttribute;
    }

    public void addRequiredIn(ObjectPath attribute) {
        this.requiredIn.add(attribute);
    }

    public Iterator<ObjectPath> iteratorRequiredIn() {
        return this.requiredIn.iterator();
    }

    @Override
    public void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) throws IllegalStateException {
        super.checkTranslationOf(errs, name, baseName);
        ExistenceConstraint baseElement = (ExistenceConstraint)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        Ili2cSemanticException err = Evaluable.checkTranslation(this.restrictedAttribute, baseElement.restrictedAttribute, this.getSourceLine(), "err_diff_existConstraintAttributePathMismatch");
        if (err != null) {
            errs.add(err);
        }
        if (this.requiredIn.size() != baseElement.requiredIn.size()) {
            err = new Ili2cSemanticException(this.getSourceLine(), Element.formatMessage("err_diff_existConstraintRequiredInMismatch"));
            if (err != null) {
                errs.add(err);
            }
        } else {
            for (int ri = 0; ri < this.requiredIn.size(); ++ri) {
                err = Evaluable.checkTranslation(this.requiredIn.get(ri), baseElement.requiredIn.get(ri), this.getSourceLine(), "err_diff_existConstraintRequiredInMismatch");
                if (err == null) continue;
                errs.add(err);
            }
        }
    }
}

