/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;

public class InteriorPointArea {
    private GeometryFactory factory;
    private Coordinate interiorPoint = null;
    private double maxWidth = 0.0;

    private static double avg(double a, double b) {
        return (a + b) / 2.0;
    }

    public InteriorPointArea(Geometry g) {
        this.factory = g.getFactory();
        this.add(g);
    }

    public Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }

    private void add(Geometry geom) {
        if (geom instanceof Polygon) {
            this.addPolygon(geom);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            int i = 0;
            while (i < gc.getNumGeometries()) {
                this.add(gc.getGeometryN(i));
                ++i;
            }
        }
    }

    private void addPolygon(Geometry geometry) {
        Coordinate intPt;
        if (geometry.isEmpty()) {
            return;
        }
        double width = 0.0;
        LineString bisector = this.horizontalBisector(geometry);
        if (bisector.getLength() == 0.0) {
            width = 0.0;
            intPt = bisector.getCoordinate();
        } else {
            Geometry intersections = bisector.intersection(geometry);
            Geometry widestIntersection = this.widestGeometry(intersections);
            width = widestIntersection.getEnvelopeInternal().getWidth();
            intPt = InteriorPointArea.centre(widestIntersection.getEnvelopeInternal());
        }
        if (this.interiorPoint == null || width > this.maxWidth) {
            this.interiorPoint = intPt;
            this.maxWidth = width;
        }
    }

    private Geometry widestGeometry(Geometry geometry) {
        if (!(geometry instanceof GeometryCollection)) {
            return geometry;
        }
        return this.widestGeometry((GeometryCollection)geometry);
    }

    private Geometry widestGeometry(GeometryCollection gc) {
        if (gc.isEmpty()) {
            return gc;
        }
        Geometry widestGeometry = gc.getGeometryN(0);
        int i = 1;
        while (i < gc.getNumGeometries()) {
            if (gc.getGeometryN(i).getEnvelopeInternal().getWidth() > widestGeometry.getEnvelopeInternal().getWidth()) {
                widestGeometry = gc.getGeometryN(i);
            }
            ++i;
        }
        return widestGeometry;
    }

    protected LineString horizontalBisector(Geometry geometry) {
        Envelope envelope = geometry.getEnvelopeInternal();
        double bisectY = SafeBisectorFinder.getBisectorY((Polygon)geometry);
        return this.factory.createLineString(new Coordinate[]{new Coordinate(envelope.getMinX(), bisectY), new Coordinate(envelope.getMaxX(), bisectY)});
    }

    public static Coordinate centre(Envelope envelope) {
        return new Coordinate(InteriorPointArea.avg(envelope.getMinX(), envelope.getMaxX()), InteriorPointArea.avg(envelope.getMinY(), envelope.getMaxY()));
    }

    private static class SafeBisectorFinder {
        private Polygon poly;
        private double centreY;
        private double hiY = Double.MAX_VALUE;
        private double loY = -1.7976931348623157E308;

        public static double getBisectorY(Polygon poly) {
            SafeBisectorFinder finder = new SafeBisectorFinder(poly);
            return finder.getBisectorY();
        }

        public SafeBisectorFinder(Polygon poly) {
            this.poly = poly;
            this.hiY = poly.getEnvelopeInternal().getMaxY();
            this.loY = poly.getEnvelopeInternal().getMinY();
            this.centreY = InteriorPointArea.avg(this.loY, this.hiY);
        }

        public double getBisectorY() {
            this.process(this.poly.getExteriorRing());
            int i = 0;
            while (i < this.poly.getNumInteriorRing()) {
                this.process(this.poly.getInteriorRingN(i));
                ++i;
            }
            double bisectY = InteriorPointArea.avg(this.hiY, this.loY);
            return bisectY;
        }

        private void process(LineString line) {
            CoordinateSequence seq = line.getCoordinateSequence();
            int i = 0;
            while (i < seq.size()) {
                double y = seq.getY(i);
                this.updateInterval(y);
                ++i;
            }
        }

        private void updateInterval(double y) {
            if (y <= this.centreY) {
                if (y > this.loY) {
                    this.loY = y;
                }
            } else if (y > this.centreY && y < this.hiY) {
                this.hiY = y;
            }
        }
    }
}

