/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.logging;

import ch.interlis.iom.IomObject;
import ch.interlis.iox.IoxLogEvent;
import ch.interlis.iox.IoxLogging;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox_j.IoxInvalidDataException;
import ch.interlis.iox_j.logging.LogEventImpl;
import java.util.Date;
import java.util.Locale;

public class LogEventFactory {
    private String dataSource = null;
    private IomObject dataObj = null;
    private IoxLogging logger = null;
    private String tid = null;
    private String iliqname = null;
    private Double coordX = null;
    private Double coordY = null;
    private Double coordZ = null;
    IoxValidationConfig validConfig = null;

    public LogEventFactory() {
    }

    public LogEventFactory(IoxValidationConfig validConfig) {
        this.validConfig = validConfig;
    }

    public void setValidationConfig(IoxValidationConfig validConfig) {
        this.validConfig = validConfig;
    }

    public IoxValidationConfig getValidationConfig() {
        return this.validConfig;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataObj(IomObject dataObj) {
        this.dataObj = dataObj;
        this.coordX = null;
        this.coordY = null;
        this.coordZ = null;
        this.iliqname = null;
        this.tid = null;
    }

    public void setTid(String tid1) {
        this.dataObj = null;
        this.tid = tid1;
    }

    public void setIliqname(String iliqname1) {
        this.dataObj = null;
        this.iliqname = iliqname1;
    }

    public void setDefaultCoord(IomObject coord) {
        if (coord != null) {
            String c1 = coord.getattrvalue("C1");
            String c2 = coord.getattrvalue("C2");
            String c3 = coord.getattrvalue("C3");
            if (c1 != null && c2 != null) {
                this.coordX = Double.valueOf(c1);
                this.coordY = Double.valueOf(c2);
                if (c3 != null) {
                    this.coordZ = Double.valueOf(c3);
                }
            }
        } else {
            this.coordX = null;
            this.coordY = null;
            this.coordZ = null;
        }
    }

    public void setDefaultCoord(Double c1, Double c2, Double c3) {
        this.coordX = c1;
        this.coordY = c2;
        this.coordZ = c3;
    }

    public IoxLogEvent logErrorMsg(String msg, String ... args) {
        String eventId = "codeInternal";
        if (this.dataObj != null) {
            return new LogEventImpl(this.dataSource, new Date(), eventId, 7, LogEventFactory.formatMessage(msg, this.dataObj, args), null, this.dataObj.getobjectline(), this.dataObj.getobjecttag(), this.getObjectTechId(this.dataObj), this.getObjectUsrId(this.dataObj), this.dataObj.getobjectoid(), null, this.coordX, this.coordY, this.coordZ, LogEventFactory.getCallerOrigin());
        }
        return new LogEventImpl(this.dataSource, new Date(), eventId, 7, LogEventFactory.formatMessage(msg, null, args), null, null, this.iliqname, null, null, this.tid, null, this.coordX, this.coordY, this.coordZ, LogEventFactory.getCallerOrigin());
    }

    public IoxLogEvent logErrorMsg(Throwable ex, String msg, String ... args) {
        String eventId = "codeInternal";
        if (this.dataObj != null) {
            return new LogEventImpl(this.dataSource, new Date(), eventId, 7, LogEventFactory.formatMessage(msg, this.dataObj, args), ex, this.dataObj.getobjectline(), this.dataObj.getobjecttag(), this.getObjectTechId(this.dataObj), this.getObjectUsrId(this.dataObj), this.dataObj.getobjectoid(), null, this.coordX, this.coordY, this.coordZ, LogEventFactory.getCallerOrigin());
        }
        return new LogEventImpl(this.dataSource, new Date(), eventId, 7, LogEventFactory.formatMessage(msg, null, args), ex, null, this.iliqname, null, null, this.tid, null, this.coordX, this.coordY, this.coordZ, LogEventFactory.getCallerOrigin());
    }

    public IoxLogEvent logWarningMsg(String msg, String ... args) {
        String eventId = "codeInternal";
        if (this.dataObj != null) {
            return new LogEventImpl(this.dataSource, new Date(), eventId, 6, LogEventFactory.formatMessage(msg, this.dataObj, args), null, this.dataObj.getobjectline(), this.dataObj.getobjecttag(), this.getObjectTechId(this.dataObj), this.getObjectUsrId(this.dataObj), this.dataObj.getobjectoid(), null, this.coordX, this.coordY, this.coordZ, LogEventFactory.getCallerOrigin());
        }
        return new LogEventImpl(this.dataSource, new Date(), eventId, 6, LogEventFactory.formatMessage(msg, null, args), null, null, this.iliqname, null, null, this.tid, null, this.coordX, this.coordY, this.coordZ, LogEventFactory.getCallerOrigin());
    }

    public IoxLogEvent logInfoMsg(String msg, String ... args) {
        String eventId = "codeInternal";
        return new LogEventImpl(this.dataSource, new Date(), eventId, 5, LogEventFactory.formatMessage(msg, null, args), null, null, null, null, null, null, null, null, null, null, LogEventFactory.getCallerOrigin());
    }

    public IoxLogEvent logDetailInfoMsg(String msg, String ... args) {
        String eventId = "codeInternal";
        return new LogEventImpl(this.dataSource, new Date(), eventId, 2, LogEventFactory.formatMessage(msg, null, args), null, null, null, null, null, null, null, null, null, null, LogEventFactory.getCallerOrigin());
    }

    public IoxLogEvent logErrorById(String eventId, String ... args) {
        if (this.dataObj != null) {
            return new LogEventImpl(this.dataSource, new Date(), eventId, 7, this.formatMessageId(eventId, this.dataObj, args), null, this.dataObj.getobjectline(), this.dataObj.getobjecttag(), this.getObjectTechId(this.dataObj), this.getObjectUsrId(this.dataObj), this.dataObj.getobjectoid(), null, this.coordX, this.coordY, this.coordZ, LogEventFactory.getCallerOrigin());
        }
        return new LogEventImpl(this.dataSource, new Date(), eventId, 7, this.formatMessageId(eventId, null, args), null, null, this.iliqname, null, null, this.tid, null, this.coordX, this.coordY, this.coordZ, LogEventFactory.getCallerOrigin());
    }

    public IoxLogEvent logError(IoxInvalidDataException ex) {
        return this.logError(7, ex);
    }

    public IoxLogEvent logWarning(IoxInvalidDataException ex) {
        return this.logError(6, ex);
    }

    private IoxLogEvent logError(int eventKind, IoxInvalidDataException ex) {
        String eventId = "codeInternal";
        String msg = ex.getRawMessage();
        Integer lineNumber = null;
        lineNumber = ex.getLineNumber() != -1 ? Integer.valueOf(ex.getLineNumber()) : null;
        String tid = ex.getTid();
        Double coordX = null;
        Double coordY = null;
        Double coordZ = null;
        IomObject geom = ex.getGeom();
        if (geom != null && geom.getobjecttag().equals("COORD")) {
            String c1 = geom.getattrvalue("C1");
            String c2 = geom.getattrvalue("C2");
            String c3 = geom.getattrvalue("C3");
            if (c1 != null && c2 != null) {
                coordX = Double.valueOf(c1);
                coordY = Double.valueOf(c2);
                if (c3 != null) {
                    coordZ = Double.valueOf(c3);
                }
            }
        }
        String iliqName = ex.getIliqname();
        return new LogEventImpl(this.dataSource, new Date(), eventId, eventKind, msg, ex.getCause(), lineNumber, iliqName, null, null, tid, null, coordX, coordY, coordZ, LogEventFactory.getCallerOrigin());
    }

    private String getObjectUsrId(IomObject iomObj) {
        String keymsg = null;
        String keyMsgWithLang = "keymsg_" + Locale.getDefault().getLanguage();
        if (this.validConfig != null && (keymsg = this.validConfig.getConfigValue(iomObj.getobjecttag(), keyMsgWithLang)) == null) {
            keymsg = this.validConfig.getConfigValue(iomObj.getobjecttag(), "keymsg");
        }
        if (keymsg != null) {
            return LogEventFactory.formatMessage(keymsg, iomObj, new String[0]);
        }
        return null;
    }

    private String getObjectTechId(IomObject iomObj) {
        return null;
    }

    public static String formatMessage(String rawMsg, IomObject iomObj, String ... args) {
        int startPos = rawMsg.indexOf(123);
        if (startPos == -1) {
            return rawMsg;
        }
        StringBuffer msg = new StringBuffer();
        StringBuffer param = null;
        for (int idx = 0; idx < rawMsg.length(); ++idx) {
            char c = rawMsg.charAt(idx);
            if (param == null) {
                if (c == '{') {
                    param = new StringBuffer();
                    continue;
                }
                msg.append(c);
                continue;
            }
            if (c == '}') {
                block8: {
                    try {
                        int argi = Integer.parseInt(param.toString());
                        if (args != null && argi < args.length) {
                            msg.append(args[argi]);
                        }
                    }
                    catch (NumberFormatException e) {
                        String value = iomObj.getattrvalue(param.toString());
                        if (value == null) break block8;
                        msg.append(value);
                    }
                }
                param = null;
                continue;
            }
            param.append(c);
        }
        return msg.toString();
    }

    private String formatMessageId(String eventId, IomObject dataObj2, String ... args) {
        return null;
    }

    private static StackTraceElement getCallerOrigin() {
        Throwable tr = new Throwable();
        StackTraceElement[] stack = tr.getStackTrace();
        if (2 < stack.length) {
            StackTraceElement st = stack[2];
            return st;
        }
        return null;
    }

    public void addEvent(IoxLogEvent ex) {
        if (this.logger == null) {
            throw new IllegalStateException("logger must not be null");
        }
        this.logger.addEvent(ex);
    }

    public IoxLogging getLogger() {
        return this.logger;
    }

    public void setLogger(IoxLogging logger) {
        this.logger = logger;
    }
}

