/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.validator;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.view.GenericFileFilter;
import ch.interlis.ili2c.Ili2c;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.Ili2cFailure;
import ch.interlis.ili2c.Main;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ilirepository.IliManager;
import ch.interlis.iom_j.itf.ItfReader;
import ch.interlis.iom_j.itf.ItfReader2;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox_j.IoxIliReader;
import ch.interlis.iox_j.PipelinePool;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.utility.ReaderFactory;
import ch.interlis.iox_j.validator.ValidationConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Validator {
    public static final String MSG_VALIDATION_DONE = "...validation done";
    public static final String MSG_VALIDATION_FAILED = "...validation failed";
    public static final String SETTING_DEFAULT_ILIDIRS = "%ITF_DIR;http://models.interlis.ch/;%JAR_DIR/ilimodels";
    public static final String SETTING_ILIDIRS = "org.interlis2.validator.ilidirs";
    public static final String SETTING_MODELNAMES = "org.interlis2.validator.modelNames";
    public static final String SETTING_APPHOME = "org.interlis2.validator.appHome";
    public static final String SETTING_ILIDATA_XML = "org.interlis2.validator.ilidata";
    public static final String SETTING_REMOTEFILE_LIST = "org.interlis2.validator.filelist";
    public static final String SETTING_DATASETID_TO_UPDATE = "org.interlis2.validator.datasetIDToUpdate";
    public static final String SETTING_REPOSITORY = "org.interlis2.validator.baseUrl";
    public static final String SETTING_DIRUSED = "org.interlis2.validator.dirused";
    public static final String SETTING_CONFIGFILE = "org.interlis2.validator.configfile";
    public static final String SETTING_FORCE_TYPE_VALIDATION = "org.interlis2.validator.forcetypevalidation";
    public static final String SETTING_MULTIPLICITY_VALIDATION = null;
    public static final String SETTING_DISABLE_AREA_VALIDATION = "org.interlis2.validator.disableareavalidation";
    public static final String SETTING_DISABLE_CONSTRAINT_VALIDATION = "org.interlis2.validator.disableconstraintvalidation";
    public static final String SETTING_DISABLE_STD_LOGGER = "org.interlis2.validator.disablestdlogger";
    public static final String SETTING_LOGFILE = "org.interlis2.validator.log";
    public static final String SETTING_ALL_OBJECTS_ACCESSIBLE = "org.interlis2.validator.allobjectsaccessible";
    public static final String SETTING_ALLOW_ITF_AREA_HOLES = "org.interlis2.validator.allowitfareaholes";
    public static final String SETTING_XTFLOG = "org.interlis2.validator.xtflog";
    public static final String SETTING_PLUGINFOLDER = "org.interlis2.validator.pluginfolder";
    public static final String ITF_DIR = "%ITF_DIR";
    public static final String JAR_DIR = "%JAR_DIR";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private boolean skipPolygonBuilding;
    private boolean skipGeometryErrors = false;
    private boolean allowItfAreaHoles;

    public static boolean runValidation(String dataFilename, Settings settings) {
        if (dataFilename == null || dataFilename.length() == 0) {
            EhiLogger.logError((String)"no INTERLIS file given");
            return false;
        }
        return Validator.runValidation(new String[]{dataFilename}, settings);
    }

    public static boolean runValidation(String[] dataFiles, Settings settings) {
        return new Validator().validate(dataFiles, settings);
    }

    /*
     * Exception decompiling
     */
    public boolean validate(String[] dataFiles, Settings settings) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 17[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isWriteable(File f) throws IOException {
        f.createNewFile();
        return f.canWrite();
    }

    private boolean getVersionControlFormConfigFile(String configFilename) throws IOException {
        if (configFilename != null) {
            ValidationConfig modelConfig = new ValidationConfig();
            modelConfig.mergeConfigFile(new File(configFilename));
            String versionControl = modelConfig.getConfigValue("PARAMETER", "verifyModelVersion");
            return versionControl != null ? versionControl.equals(TRUE) : false;
        }
        return false;
    }

    protected IoxReader createReader(String filename, TransferDescription td, LogEventFactory errFactory, Settings settings, PipelinePool pool) throws IoxException {
        IoxReader ioxReader = new ReaderFactory().createReader(new File(filename), errFactory);
        if (ioxReader instanceof ItfReader2 && this.skipPolygonBuilding) {
            ioxReader = new ItfReader(new File(filename));
        }
        if (ioxReader instanceof ItfReader2) {
            if (this.skipGeometryErrors) {
                ((ItfReader2)ioxReader).setIgnorePolygonBuildingErrors(1);
            }
            ((ItfReader2)ioxReader).setAllowItfAreaHoles(this.allowItfAreaHoles);
            ((ItfReader2)ioxReader).setIoxDataPool(pool);
        }
        if (ioxReader instanceof IoxIliReader) {
            ((IoxIliReader)ioxReader).setModel(td);
        }
        return ioxReader;
    }

    private static List<String> getModelsFromConfigFile(String configFilename) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        if (configFilename != null) {
            ValidationConfig modelConfig = new ValidationConfig();
            modelConfig.mergeConfigFile(new File(configFilename));
            String additionalModels = modelConfig.getConfigValue("PARAMETER", "additionalModels");
            if (additionalModels != null) {
                String[] additionalModelv;
                for (String additionalModel : additionalModelv = additionalModels.split(";")) {
                    ret.add(additionalModel);
                }
            }
        }
        return ret;
    }

    private static List<String> getSpecifiedModelNames(String modelNames) {
        ArrayList<String> ret = new ArrayList<String>();
        if (modelNames != null) {
            String[] modelNameList;
            for (String modelName : modelNameList = modelNames.split(";")) {
                ret.add(modelName);
            }
        }
        return ret;
    }

    public static TransferDescription compileIli(String iliVersion, List<String> modelNames, File ilifile, String itfDir, String appHome, Settings settings) {
        ArrayList<String> modeldirv = new ArrayList<String>();
        String ilidirs = settings.getValue(SETTING_ILIDIRS);
        if (ilidirs == null) {
            ilidirs = SETTING_DEFAULT_ILIDIRS;
        }
        EhiLogger.logState((String)("modeldir <" + ilidirs + ">"));
        String[] modeldirs = ilidirs.split(";");
        HashSet ilifiledirs = new HashSet();
        for (int modeli = 0; modeli < modeldirs.length; ++modeli) {
            String m = modeldirs[modeli];
            if (m.contains(ITF_DIR)) {
                if ((m = m.replace(ITF_DIR, itfDir)) == null || m.length() <= 0 || modeldirv.contains(m)) continue;
                modeldirv.add(m);
                continue;
            }
            if (m.contains(JAR_DIR)) {
                if (appHome == null) continue;
                m = m.replace(JAR_DIR, appHome);
                modeldirv.add(m);
                continue;
            }
            if (m == null || m.length() <= 0) continue;
            modeldirv.add(m);
        }
        Main.setHttpProxySystemProperties(settings);
        TransferDescription td = null;
        Configuration ili2cConfig = null;
        if (ilifile != null) {
            IliManager repositoryManager = (IliManager)settings.getTransientObject("ch.interlis.ili2c.customIliManager");
            if (repositoryManager == null) {
                repositoryManager = new IliManager();
                settings.setTransientObject("ch.interlis.ili2c.customIliManager", (Object)repositoryManager);
            }
            try {
                repositoryManager.setRepositories(modeldirv.toArray(new String[0]));
                ArrayList<String> ilifiles = new ArrayList<String>();
                ilifiles.add(ilifile.getPath());
                ili2cConfig = repositoryManager.getConfigWithFiles(ilifiles);
                ili2cConfig.setGenerateWarnings(false);
            }
            catch (Ili2cException ex) {
                EhiLogger.logError((Throwable)ex);
                return null;
            }
        }
        ArrayList<String> modelv = new ArrayList<String>();
        if (modelNames != null) {
            modelv.addAll(modelNames);
        }
        try {
            double version = 0.0;
            if (iliVersion != null) {
                version = Double.parseDouble(iliVersion);
            }
            IliManager modelManager = new IliManager();
            modelManager.setRepositories(modeldirv.toArray(new String[0]));
            ili2cConfig = modelManager.getConfig(modelv, version);
            ili2cConfig.setGenerateWarnings(false);
        }
        catch (Ili2cException ex) {
            EhiLogger.logError((Throwable)ex);
            return null;
        }
        try {
            Ili2c.logIliFiles(ili2cConfig);
            td = Ili2c.runCompiler(ili2cConfig);
        }
        catch (Ili2cFailure ex) {
            EhiLogger.logError((Throwable)ex);
            return null;
        }
        return td;
    }

    public static boolean isItfFilename(String filename) {
        String xtfExt = GenericFileFilter.getFileExtension((File)new File(filename)).toLowerCase();
        return "itf".equals(xtfExt);
    }
}

