/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.validator;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.view.GenericFileFilter;
import ch.interlis.ili2c.Ili2c;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ilirepository.IliManager;
import ch.interlis.ilirepository.impl.RepositoryAccess;
import ch.interlis.iom_j.itf.ItfReader;
import ch.interlis.iom_j.itf.ItfReader2;
import ch.interlis.iom_j.xtf.XtfModel;
import ch.interlis.iom_j.xtf.XtfWriterBase;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.StartTransferEvent;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.utility.IoxUtility;
import ch.interlis.iox_j.utility.ReaderFactory;
import ch.interlis.models.DATASETIDX16;
import ch.interlis.models.DatasetIdx16.Code_;
import ch.interlis.models.DatasetIdx16.DataFile;
import ch.interlis.models.DatasetIdx16.DataIndex.BasketMetadata;
import ch.interlis.models.DatasetIdx16.DataIndex.DatasetMetadata;
import ch.interlis.models.DatasetIdx16.LocalisedMText;
import ch.interlis.models.DatasetIdx16.ModelLink;
import ch.interlis.models.DatasetIdx16.MultilingualMText;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.interlis2.validator.Main;

public class CreateIliDataTool {
    public static boolean start(Settings settings) {
        return new CreateIliDataTool().createIliData(settings);
    }

    private boolean createIliData(Settings settings) {
        String destinationFile = settings.getValue("org.interlis2.validator.ilidata");
        String filelistFile = settings.getValue("org.interlis2.validator.filelist");
        String baseUrl = settings.getValue("org.interlis2.validator.baseUrl");
        try {
            HashSet<File> filelist = new HashSet<File>();
            if (filelistFile != null) {
                this.readFilelistFromFile(filelistFile, filelist);
            } else {
                File localFolder = new File(baseUrl);
                if (!(localFolder.exists() && localFolder.isDirectory() && localFolder.canRead())) {
                    EhiLogger.logError((String)("can't read repos folder <" + baseUrl + ">"));
                    return false;
                }
                this.scanLocalFolder(localFolder, null, filelist);
            }
            this.readFilesFromSourceFolder(new File(destinationFile), filelist, baseUrl, settings);
        }
        catch (Exception e) {
            EhiLogger.logError((Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFilesFromSourceFolder(File destFile, Set<File> allFiles, String baseUrl, Settings settings) throws Exception {
        XtfWriterBase ioxWriter = null;
        try {
            FileOutputStream outStream = new FileOutputStream(destFile.getPath());
            XtfWriterBase ioxWriter1 = new XtfWriterBase(outStream, DATASETIDX16.getIoxMapping(), "2.3");
            ioxWriter1.setModels(new XtfModel[]{DATASETIDX16.getXtfModel()});
            StartTransferEvent startTransferEvent = new StartTransferEvent();
            startTransferEvent.setSender("ilivalidator-" + Main.getVersion());
            ioxWriter1.write((IoxEvent)startTransferEvent);
            ioxWriter = ioxWriter1;
            StartBasketEvent startBasketEvent = new StartBasketEvent("DatasetIdx16.DataIndex", "b1");
            ioxWriter.write((IoxEvent)startBasketEvent);
            int oid = 1;
            String version = "1";
            for (File currentFile : allFiles) {
                DatasetMetadata datasetMetadata = this.generateNewDatasetMetaData(currentFile, settings, baseUrl, "1", oid++);
                ioxWriter.write((IoxEvent)new ObjectEvent(datasetMetadata));
            }
        }
        finally {
            if (ioxWriter != null) {
                ioxWriter.write((IoxEvent)new EndBasketEvent());
                ioxWriter.write((IoxEvent)new EndTransferEvent());
                ioxWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatasetMetadata generateNewDatasetMetaData(File currentFile, Settings settings, String baseUrl, String version, int oid) throws Exception {
        IoxReader ioxReader = null;
        DatasetMetadata datasetMetadata = new DatasetMetadata(Integer.toString(oid));
        ch.interlis.models.DatasetIdx16.File file = new ch.interlis.models.DatasetIdx16.File();
        DataFile dataFile = new DataFile();
        String filePath = CreateIliDataTool.getURLRelativePath(currentFile);
        file.setpath(filePath);
        dataFile.addfile(file);
        datasetMetadata.addfiles(dataFile);
        String id = CreateIliDataTool.getFileNameWithoutPfadExtensionAndDate(currentFile);
        datasetMetadata.setid(id);
        String owner = CreateIliDataTool.getOwnerByCurrentUser();
        datasetMetadata.setowner(owner);
        datasetMetadata.setversion(version);
        File localFile = null;
        if (this.isRemoteRepository(baseUrl)) {
            RepositoryAccess reposAccess = new RepositoryAccess();
            localFile = reposAccess.getLocalFileLocation(baseUrl, CreateIliDataTool.getURLRelativePath(currentFile), 0L, null);
            if (localFile == null) {
                throw new IllegalStateException("failed to download remote file " + baseUrl + " " + currentFile.getPath());
            }
        } else {
            localFile = new File(new File(baseUrl), currentFile.getPath());
        }
        List<String> models = IoxUtility.getModels(localFile);
        TransferDescription td = null;
        try {
            td = CreateIliDataTool.compileIli(models, settings.getValue("org.interlis2.validator.ilidirs"));
        }
        catch (Exception e) {
            throw new Exception("Failed to read file <" + localFile.getAbsolutePath() + ">", e);
        }
        if (td == null) {
            throw new Exception("Transfer Description can not be null for the file: " + localFile.getAbsolutePath());
        }
        String md5 = RepositoryAccess.calcMD5(localFile);
        file.setmd5(md5);
        ioxReader = CreateIliDataTool.createReader(localFile);
        if (ioxReader instanceof ItfReader) {
            dataFile.setfileFormat("application/interlis+txt;version=1.0");
        } else {
            dataFile.setfileFormat("application/interlis+xml;version=2.3");
        }
        try {
            IoxEvent event = null;
            Model model = null;
            do {
                if (!((event = ioxReader.read()) instanceof StartBasketEvent)) continue;
                StartBasketEvent basketEvent = (StartBasketEvent)event;
                BasketMetadata basketMetaData = new BasketMetadata();
                Topic topic = (Topic)td.getElement(basketEvent.getType());
                if (model == null) {
                    model = (Model)topic.getContainer();
                    String idgeoiv = model.getMetaValue("IDGeoIV");
                    if (idgeoiv != null) {
                        String[] ids;
                        for (String geoid : ids = idgeoiv.split("\\,")) {
                            Code_ idgeoivCode = new Code_();
                            idgeoivCode.setvalue("https://ids.geo.admin.ch/geoiv/" + geoid.trim());
                            datasetMetadata.addcategories(idgeoivCode);
                        }
                    }
                    if (model.getMetaValue("furtherInformation") != null) {
                        datasetMetadata.setfurtherInformation(model.getMetaValue("furtherInformation"));
                    }
                    if (model.getMetaValue("technicalContact") != null) {
                        datasetMetadata.settechnicalContact(model.getMetaValue("technicalContact"));
                    }
                    CreateIliDataTool.setShortDescription(datasetMetadata, model.getDocumentation());
                }
                ModelLink modelLink = new ModelLink();
                modelLink.setname(basketEvent.getType());
                basketMetaData.setmodel(modelLink);
                basketMetaData.setowner(owner);
                basketMetaData.setversion(version);
                if (topic.getBasketOid() != null) {
                    basketMetaData.setid(basketEvent.getBid());
                } else {
                    basketMetaData.setlocalId(basketEvent.getBid());
                }
                datasetMetadata.addbaskets(basketMetaData);
            } while (!(event instanceof EndTransferEvent));
        }
        finally {
            if (ioxReader != null) {
                try {
                    ioxReader.close();
                }
                catch (Exception e) {
                    EhiLogger.logState((String)("An error occurred while closing the file." + e));
                }
                ioxReader = null;
            }
        }
        return datasetMetadata;
    }

    protected static String getOwnerByCurrentUser() {
        return "mailto:" + System.getProperty("user.name") + "@localhost";
    }

    private boolean isRemoteRepository(String uri) {
        String urilc = uri.toLowerCase();
        return urilc.startsWith("http:") || urilc.startsWith("https:");
    }

    protected static void setShortDescription(DatasetMetadata datasetMetadata, String documentation) {
        if (documentation != null) {
            MultilingualMText mText = new MultilingualMText();
            LocalisedMText localisedMText = new LocalisedMText();
            localisedMText.setText(documentation);
            mText.addLocalisedText(localisedMText);
            datasetMetadata.setshortDescription(mText);
        }
    }

    protected static String getFileNameWithoutPfadExtensionAndDate(File currentFile) throws IllegalArgumentException {
        String filenameTmp;
        String pattern;
        Pattern compiledPattern;
        Matcher matcher;
        String filename = currentFile.getName();
        if (filename.endsWith(".xml")) {
            filename = filename.replace(".xml", "");
        } else if (filename.endsWith(".xtf")) {
            filename = filename.replace(".xtf", "");
        } else if (filename.endsWith(".itf")) {
            filename = filename.replace(".itf", "");
        } else {
            throw new IllegalArgumentException("Invalid file extension " + filename);
        }
        filename.trim();
        if (filename.length() > 10 && (matcher = (compiledPattern = Pattern.compile(pattern = "^[_][0-9]{8}$")).matcher(filenameTmp = filename.substring(filename.length() - 9, filename.length()))).matches()) {
            filename = filename.substring(0, filename.length() - 9).trim();
        }
        return filename;
    }

    protected static TransferDescription compileIli(List<String> models, String ilidirs) throws Exception {
        ArrayList<String> modeldirv = new ArrayList<String>();
        ArrayList<String> modelv = new ArrayList<String>();
        if (models != null) {
            modelv.addAll(models);
        }
        if (ilidirs == null) {
            ilidirs = "%ITF_DIR;http://models.interlis.ch/;%JAR_DIR/ilimodels";
        }
        EhiLogger.logState((String)("ilidirs <" + ilidirs + ">"));
        String[] modeldirs = ilidirs.split(";");
        for (int modeli = 0; modeli < modeldirs.length; ++modeli) {
            String m = modeldirs[modeli];
            if (m == null || m.isEmpty()) continue;
            modeldirv.add(m);
        }
        IliManager modelManager = new IliManager();
        modelManager.setRepositories(modeldirv.toArray(new String[0]));
        Configuration ili2cConfig = modelManager.getConfig(modelv, 0.0);
        ili2cConfig.setGenerateWarnings(false);
        Ili2c.logIliFiles(ili2cConfig);
        return Ili2c.runCompiler(ili2cConfig);
    }

    protected static String getURLRelativePath(File currentFile) {
        return currentFile.getPath().replace(File.separatorChar, '/');
    }

    private void scanLocalFolder(File baseFolder, String subFolder, Set<File> visitedFiles) {
        File[] listOfFiles;
        File expectedFilePath = subFolder == null ? baseFolder : new File(baseFolder, subFolder);
        for (File file : listOfFiles = expectedFilePath.listFiles()) {
            String relativeFileName;
            String string = relativeFileName = subFolder == null ? file.getName() : subFolder + "/" + file.getName();
            if (file.isFile()) {
                if (!this.isItfORXtfFilename(file.getName())) continue;
                visitedFiles.add(new File(relativeFileName));
                continue;
            }
            if (!file.isDirectory()) continue;
            this.scanLocalFolder(baseFolder, relativeFileName, visitedFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFilelistFromFile(String srcFile, Set<File> filelist) throws IOException, FileNotFoundException {
        BufferedReader br = null;
        try {
            String readFile;
            br = new BufferedReader(new FileReader(srcFile));
            while ((readFile = br.readLine()) != null) {
                filelist.add(new File(readFile));
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    protected static IoxReader createReader(File filename) throws IoxException {
        IoxReader ioxReader = new ReaderFactory().createReader(filename, new LogEventFactory());
        if (ioxReader instanceof ItfReader2) {
            ioxReader = new ItfReader(filename);
        }
        return ioxReader;
    }

    private boolean isItfORXtfFilename(String filename) {
        String xtfExt = GenericFileFilter.getFileExtension((File)new File(filename)).toLowerCase();
        return "itf".equals(xtfExt) || "xtf".equals(xtfExt);
    }
}

