/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractLeafElement;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Table;
import java.util.List;

public class MetaObject
extends AbstractLeafElement {
    protected String name = null;
    protected Table table = null;

    public MetaObject(String name, Table table) {
        MetaObject.checkNameSanity(name, false);
        this.name = name;
        this.table = table;
    }

    @Override
    public void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) throws IllegalStateException {
        super.checkTranslationOf(errs, name, baseName);
        MetaObject baseElement = (MetaObject)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        if (!this.getName().equals(baseElement.getName())) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), MetaObject.formatMessage("err_diff_referencedMetaObjMismatch", this.getName(), baseElement.getName())));
        }
        Ili2cSemanticException err = null;
        err = MetaObject.checkElementRef(this.getTable(), baseElement.getTable(), this.getSourceLine(), "err_diff_referencedClassMismatch");
        if (err != null) {
            errs.add(err);
        }
    }

    public String toString() {
        return "METAOBJECT " + this.getScopedName(null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Table getTable() {
        return this.table;
    }
}

