/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.generator;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;

public class IndentPrintWriter
extends Writer {
    protected Writer out;
    private int indent = 0;
    private int col;
    private String lineSeparator;
    private boolean trouble = false;

    public IndentPrintWriter(Writer out) {
        super((Object)out);
        this.out = out;
        this.lineSeparator = System.getProperty("line.separator");
        this.col = 0;
    }

    public void indent() {
        ++this.indent;
    }

    public void unindent() {
        if (this.indent > 0) {
            --this.indent;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    private void willWrite() throws IOException {
        this.ensureOpen();
        if (this.col == 0) {
            this.col = 2 * this.indent;
            for (int i = 0; i < this.col; ++i) {
                this.out.write(32);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                this.out.flush();
            }
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.out == null) {
                    return;
                }
                this.out.close();
                this.out = null;
            }
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        return this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.willWrite();
                this.out.write(c);
                ++this.col;
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] buf, int off, int len) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.willWrite();
                this.out.write(buf, off, len);
                this.col += len;
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    @Override
    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String s, int off, int len) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.willWrite();
                this.out.write(s, off, len);
                this.col += len;
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    @Override
    public void write(String s) {
        this.write(s, 0, s.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(this.lineSeparator);
                this.col = 0;
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public void print(boolean b) {
        this.write(b ? "true" : "false");
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int i) {
        this.write(String.valueOf(i));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) {
        this.write(s);
    }

    public void print(String s) {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }
}

