/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.json;

import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class Iox2json {
    private static final String REF = "@ref";
    private static final String REFBID = "@refbid";
    private static final String ORDERPOS = "@orderpos";
    private static final String CONSISTENCY = "@consistency";
    private static final String OPERATION = "@operation";
    private static final String TID = "@id";
    private static final String TYPE = "@type";
    private static final String CONSISTENCY_ADAPTED = "ADAPTED";
    private static final String CONSISTENCY_INCOMPLETE = "INCOMPLETE";
    private static final String CONSISTENCY_INCONSISTENT = "INCONSISTENT";
    private static final String OPERATION_UPDATE = "UPDATE";
    private static final String OPERATION_DELETE = "DELETE";

    public static void write(JsonGenerator jg, IomObject[] objs, TransferDescription td) throws IOException {
        if (objs.length == 1) {
            Iox2json.writeRaw(jg, objs[0], td);
        } else {
            jg.writeStartArray();
            for (IomObject obj : objs) {
                Iox2json.writeRaw(jg, obj, td);
            }
            jg.writeEndArray();
        }
    }

    public static void writeRaw(JsonGenerator jg, IomObject[] objs) throws IOException {
        if (objs.length == 1) {
            Iox2json.writeRaw(jg, objs[0], null);
        } else {
            jg.writeStartArray();
            for (IomObject obj : objs) {
                Iox2json.writeRaw(jg, obj, null);
            }
            jg.writeEndArray();
        }
    }

    public static void writeRaw(JsonGenerator jg, IomObject obj, TransferDescription td) throws IOException {
        String refoid;
        String refbid;
        int op;
        jg.writeStartObject();
        String className = obj.getobjecttag();
        jg.writeStringField(TYPE, className);
        String oid = obj.getobjectoid();
        if (oid != null) {
            jg.writeStringField(TID, oid);
        }
        if ((op = obj.getobjectoperation()) == 2) {
            jg.writeStringField(OPERATION, OPERATION_DELETE);
        } else if (op == 1) {
            jg.writeStringField(OPERATION, OPERATION_UPDATE);
        }
        int consistency = obj.getobjectconsistency();
        if (consistency == 2) {
            jg.writeStringField(CONSISTENCY, CONSISTENCY_INCONSISTENT);
        } else if (consistency == 1) {
            jg.writeStringField(CONSISTENCY, CONSISTENCY_INCOMPLETE);
        } else if (consistency == 3) {
            jg.writeStringField(CONSISTENCY, CONSISTENCY_ADAPTED);
        }
        long orderpos = obj.getobjectreforderpos();
        if (orderpos != 0L) {
            jg.writeNumberField(ORDERPOS, orderpos);
        }
        if ((refbid = obj.getobjectrefbid()) != null) {
            jg.writeStringField(REFBID, refbid);
        }
        if ((refoid = obj.getobjectrefoid()) != null) {
            jg.writeStringField(REF, refoid);
        }
        Viewable aclass = null;
        if (td != null) {
            aclass = (Viewable)td.getElement(className);
        }
        if (aclass != null) {
            Iterator attri = aclass.getAttributesAndRoles2();
            while (attri.hasNext()) {
                String propName;
                ViewableTransferElement propDef = (ViewableTransferElement)attri.next();
                if (propDef.obj instanceof AttributeDef) {
                    Type proxyType;
                    AttributeDef attr = (AttributeDef)propDef.obj;
                    if (attr.isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType) continue;
                    propName = attr.getName();
                    if (attr.isDomainBoolean()) {
                        String value = obj.getattrprim(propName, 0);
                        if (value == null) continue;
                        if (value.equals("true")) {
                            jg.writeBooleanField(propName, true);
                            continue;
                        }
                        jg.writeBooleanField(propName, false);
                        continue;
                    }
                    Type type = attr.getDomainResolvingAll();
                    if (type instanceof CompositionType) {
                        int propc = obj.getattrvaluecount(propName);
                        if (propc <= 0) continue;
                        jg.writeFieldName(propName);
                        if (propc > 1) {
                            jg.writeStartArray();
                        }
                        for (int propi = 0; propi < propc; ++propi) {
                            IomObject structvalue = obj.getattrobj(propName, propi);
                            Iox2json.writeRaw(jg, structvalue, td);
                        }
                        if (propc <= 1) continue;
                        jg.writeEndArray();
                        continue;
                    }
                    if (type instanceof NumericType) {
                        String value = obj.getattrprim(propName, 0);
                        if (value == null) continue;
                        jg.writeFieldName(propName);
                        jg.writeNumber(value);
                        continue;
                    }
                    if (type instanceof CoordType) {
                        IomObject structvalue = obj.getattrobj(propName, 0);
                        if (structvalue == null) continue;
                        jg.writeFieldName(propName);
                        Iox2json.writeRaw(jg, structvalue, td);
                        continue;
                    }
                    if (type instanceof LineType) {
                        IomObject structvalue = obj.getattrobj(propName, 0);
                        if (structvalue == null) continue;
                        jg.writeFieldName(propName);
                        Iox2json.writeRaw(jg, structvalue, td);
                        continue;
                    }
                    String value = obj.getattrprim(propName, 0);
                    if (value == null) continue;
                    jg.writeStringField(propName, value);
                    continue;
                }
                if (propDef.obj instanceof RoleDef) {
                    IomObject structvalue;
                    RoleDef role = (RoleDef)propDef.obj;
                    AssociationDef roleOwner = (AssociationDef)role.getContainer();
                    if (roleOwner.getDerivedFrom() != null || (structvalue = obj.getattrobj(propName = role.getName(), 0)) == null) continue;
                    jg.writeFieldName(propName);
                    Iox2json.writeRaw(jg, structvalue, td);
                    continue;
                }
                throw new IllegalStateException("unexpected property " + propDef.obj);
            }
        } else {
            int i;
            boolean isNumeric = false;
            if (className.equals("COORD") || className.equals("ARC")) {
                isNumeric = true;
            }
            int attrc = obj.getattrcount();
            Object[] propNames = new String[attrc];
            for (i = 0; i < attrc; ++i) {
                propNames[i] = obj.getattrname(i);
            }
            Arrays.sort(propNames);
            for (i = 0; i < attrc; ++i) {
                Object propName = propNames[i];
                int propc = obj.getattrvaluecount((String)propName);
                if (propc <= 0) continue;
                jg.writeFieldName((String)propName);
                if (propc > 1) {
                    jg.writeStartArray();
                }
                for (int propi = 0; propi < propc; ++propi) {
                    String value = obj.getattrprim((String)propName, propi);
                    if (value != null) {
                        if (isNumeric) {
                            jg.writeNumber(value);
                            continue;
                        }
                        jg.writeString(value);
                        continue;
                    }
                    IomObject structvalue = obj.getattrobj((String)propName, propi);
                    Iox2json.writeRaw(jg, structvalue, td);
                }
                if (propc <= 1) continue;
                jg.writeEndArray();
            }
        }
        jg.writeEndObject();
    }

    public static void writeArray(JsonGenerator jg, String[] iomValues, AttributeDef attr, boolean isEnumInt) throws IOException {
        jg.writeStartArray();
        for (String value : iomValues) {
            if (value == null) {
                jg.writeNull();
                continue;
            }
            if (attr.isDomainBoolean()) {
                if (value.equals("true")) {
                    jg.writeBoolean(true);
                    continue;
                }
                jg.writeBoolean(false);
                continue;
            }
            Type type = attr.getDomainResolvingAll();
            if (type instanceof NumericType) {
                jg.writeNumber(value);
                continue;
            }
            if (type instanceof EnumerationType && isEnumInt) {
                jg.writeNumber(value);
                continue;
            }
            jg.writeString(value);
        }
        jg.writeEndArray();
    }

    public static IomObject[] read(JsonParser jg) throws IOException {
        JsonToken current = jg.currentToken();
        if (current == null && (current = jg.nextToken()) == null) {
            return null;
        }
        IomObject[] ret = null;
        if (current == JsonToken.START_OBJECT) {
            IomObject structEle = Iox2json.readOneObject(jg);
            ret = new IomObject[]{structEle};
        } else if (current == JsonToken.START_ARRAY) {
            ArrayList<IomObject> objs = new ArrayList<IomObject>();
            current = jg.nextToken();
            while (current == JsonToken.START_OBJECT) {
                IomObject structEle = Iox2json.readOneObject(jg);
                objs.add(structEle);
                current = jg.nextToken();
            }
            if (current != JsonToken.END_ARRAY) {
                throw new IOException("unexpected json token " + jg.currentToken().toString() + "; ']' expected");
            }
            current = jg.nextToken();
            ret = objs.toArray(new IomObject[objs.size()]);
        } else {
            throw new IOException("unexpected json token " + current.toString() + "; '{' or '[' expected");
        }
        return ret;
    }

    public static IomObject readOneObject(JsonParser jg) throws IOException {
        JsonToken current = jg.currentToken();
        if (current == null && (current = jg.nextToken()) == null) {
            return null;
        }
        if (current != JsonToken.START_OBJECT) {
            throw new IOException("unexpected json token " + current.toString() + "; '{' expected");
        }
        current = jg.nextToken();
        Iom_jObject ret = new Iom_jObject("TAG", null);
        while (current == JsonToken.FIELD_NAME) {
            IomObject structEle;
            String propName = jg.getCurrentName();
            current = jg.nextToken();
            String propValue = null;
            if (current == JsonToken.VALUE_TRUE) {
                propValue = "true";
                current = jg.nextToken();
            } else if (current == JsonToken.VALUE_FALSE) {
                propValue = "false";
                current = jg.nextToken();
            } else if (current == JsonToken.VALUE_NULL) {
                current = jg.nextToken();
            } else if (current == JsonToken.VALUE_NUMBER_FLOAT || current == JsonToken.VALUE_NUMBER_INT || current == JsonToken.VALUE_STRING) {
                propValue = jg.getValueAsString();
                current = jg.nextToken();
            } else if (current == JsonToken.START_OBJECT) {
                structEle = Iox2json.readOneObject(jg);
                ret.addattrobj(propName, structEle);
            } else if (current == JsonToken.START_ARRAY) {
                current = jg.nextToken();
                while (current == JsonToken.START_OBJECT) {
                    structEle = Iox2json.readOneObject(jg);
                    ret.addattrobj(propName, structEle);
                    current = jg.nextToken();
                }
                if (current != JsonToken.END_ARRAY) {
                    throw new IOException("unexpected json token " + jg.currentToken().toString() + "; ']' expected");
                }
                current = jg.nextToken();
            } else {
                throw new IOException("unexpected json token " + jg.currentToken().toString());
            }
            if (propValue == null) continue;
            if (propName.equals(CONSISTENCY)) {
                if (propValue.equals(CONSISTENCY_ADAPTED)) {
                    ret.setobjectconsistency(3);
                    continue;
                }
                if (propValue.equals(CONSISTENCY_INCOMPLETE)) {
                    ret.setobjectconsistency(1);
                    continue;
                }
                if (propValue.equals(CONSISTENCY_INCONSISTENT)) {
                    ret.setobjectconsistency(2);
                    continue;
                }
                throw new IOException("unexpected consistency value " + propValue);
            }
            if (propName.equals(OPERATION)) {
                if (propValue.equals(OPERATION_DELETE)) {
                    ret.setobjectoperation(2);
                    continue;
                }
                if (propValue.equals(OPERATION_UPDATE)) {
                    ret.setobjectoperation(1);
                    continue;
                }
                throw new IOException("unexpected operation value " + propValue);
            }
            if (propName.equals(ORDERPOS)) {
                ret.setobjectreforderpos(Long.parseLong(propValue));
                continue;
            }
            if (propName.equals(REF)) {
                ret.setobjectrefoid(propValue);
                continue;
            }
            if (propName.equals(REFBID)) {
                ret.setobjectrefbid(propValue);
                continue;
            }
            if (propName.equals(TID)) {
                ret.setobjectoid(propValue);
                continue;
            }
            if (propName.equals(TYPE)) {
                ret.setobjecttag(propValue);
                continue;
            }
            ret.setattrvalue(propName, propValue);
        }
        if (current != JsonToken.END_OBJECT) {
            throw new IOException("unexpected json token " + jg.currentToken().toString() + "; '}' expected");
        }
        return ret;
    }

    public static String[] readArray(JsonParser jg) throws IOException {
        JsonToken current = jg.currentToken();
        if (current == null && (current = jg.nextToken()) == null) {
            return null;
        }
        if (current != JsonToken.START_ARRAY) {
            throw new IOException("unexpected json token " + jg.currentToken().toString() + "; '[' expected");
        }
        ArrayList<String> values = new ArrayList<String>();
        current = jg.nextToken();
        while (current != null && current != JsonToken.END_ARRAY) {
            if (current == JsonToken.VALUE_TRUE) {
                values.add("true");
                current = jg.nextToken();
                continue;
            }
            if (current == JsonToken.VALUE_FALSE) {
                values.add("false");
                current = jg.nextToken();
                continue;
            }
            if (current == JsonToken.VALUE_NULL) {
                values.add(null);
                current = jg.nextToken();
                continue;
            }
            if (current == JsonToken.VALUE_NUMBER_FLOAT || current == JsonToken.VALUE_NUMBER_INT || current == JsonToken.VALUE_STRING) {
                values.add(jg.getValueAsString());
                current = jg.nextToken();
                continue;
            }
            throw new IOException("unexpected json token " + jg.currentToken().toString());
        }
        return values.toArray(new String[values.size()]);
    }
}

