/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl.jtsext.operation.polygonize;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.iom_j.itf.impl.jtsext.algorithm.CurveSegmentIntersector;
import ch.interlis.iom_j.itf.impl.jtsext.geom.ArcSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.StraightSegment;
import ch.interlis.iom_j.itf.impl.jtsext.noding.Intersection;
import ch.interlis.iom_j.itf.impl.jtsext.operation.polygonize.EdgeRing;
import ch.interlis.iom_j.itf.impl.jtsext.operation.polygonize.PolygonizeDirectedEdge;
import ch.interlis.iom_j.itf.impl.jtsext.operation.polygonize.PolygonizeEdge;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.planargraph.DirectedEdgeStar;
import com.vividsolutions.jts.planargraph.Node;
import com.vividsolutions.jts.planargraph.PlanarGraph;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

class PolygonizeGraph
extends PlanarGraph {
    final boolean doDetailTrace = false;
    private GeometryFactory factory;

    private static int getDegreeNonDeleted(Node node) {
        List edges = node.getOutEdges().getEdges();
        int degree = 0;
        for (PolygonizeDirectedEdge de : edges) {
            if (de.isMarked()) continue;
            ++degree;
        }
        return degree;
    }

    private static int getDegree(Node node, long label) {
        List edges = node.getOutEdges().getEdges();
        int degree = 0;
        for (PolygonizeDirectedEdge de : edges) {
            if (de.getLabel() != label) continue;
            ++degree;
        }
        return degree;
    }

    public static void deleteAllEdges(Node node) {
        List edges = node.getOutEdges().getEdges();
        for (PolygonizeDirectedEdge de : edges) {
            de.setMarked(true);
            PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)de.getSym();
            if (sym == null) continue;
            sym.setMarked(true);
        }
    }

    public PolygonizeGraph(GeometryFactory factory) {
        this.factory = factory;
    }

    public void addEdge(LineString line) {
        if (line.isEmpty()) {
            return;
        }
        Coordinate[] linePts = CoordinateArrays.removeRepeatedPoints((Coordinate[])line.getCoordinates());
        if (linePts.length < 2) {
            return;
        }
        Coordinate startPt = line.getStartPoint().getCoordinate();
        Coordinate endPt = line.getEndPoint().getCoordinate();
        Node nStart = this.getNode(startPt);
        Node nEnd = this.getNode(endPt);
        double maxOverlap = 0.0;
        PolygonizeDirectedEdge de0 = new PolygonizeDirectedEdge(nStart, nEnd, CompoundCurve.getDirectionPt(line, true, 0.0), true);
        PolygonizeDirectedEdge de1 = new PolygonizeDirectedEdge(nEnd, nStart, CompoundCurve.getDirectionPt(line, false, 0.0), false);
        PolygonizeEdge edge = new PolygonizeEdge(line);
        edge.setDirectedEdges(de0, de1);
        this.add(edge);
    }

    private Node getNode(Coordinate pt) {
        Node node = this.findNode(pt);
        if (node == null) {
            node = new Node(pt);
            this.add(node);
        }
        return node;
    }

    private void computeNextCWEdges() {
        Iterator iNode = this.nodeIterator();
        while (iNode.hasNext()) {
            Node node = (Node)iNode.next();
            PolygonizeGraph.computeNextCWEdges(node);
        }
    }

    private void convertMaximalToMinimalEdgeRings(List ringEdges) {
        for (PolygonizeDirectedEdge de : ringEdges) {
            long label;
            List intNodes = PolygonizeGraph.findIntersectionNodes(de, label = de.getLabel());
            if (intNodes == null) continue;
            for (Node node : intNodes) {
                PolygonizeGraph.computeNextCCWEdges(node, label);
            }
        }
    }

    private static List findIntersectionNodes(PolygonizeDirectedEdge startDE, long label) {
        PolygonizeDirectedEdge de = startDE;
        ArrayList<Node> intNodes = null;
        do {
            Node node;
            if (PolygonizeGraph.getDegree(node = de.getFromNode(), label) > 1) {
                if (intNodes == null) {
                    intNodes = new ArrayList<Node>();
                }
                intNodes.add(node);
            }
            Assert.isTrue(((de = de.getNext()) != null ? 1 : 0) != 0, (String)"found null DE in ring");
            Assert.isTrue((de == startDE || !de.isInRing() ? 1 : 0) != 0, (String)"found DE already in ring");
        } while (de != startDE);
        return intNodes;
    }

    public void removeOverlaps(double newVertexOffset) {
        CurveSegmentIntersector li = new CurveSegmentIntersector();
        Iterator iNode = this.nodeIterator();
        while (iNode.hasNext()) {
            Node node = (Node)iNode.next();
            DirectedEdgeStar deStar = node.getOutEdges();
            boolean overlapRemoved = false;
            do {
                PolygonizeDirectedEdge currentDE2;
                int i;
                overlapRemoved = false;
                PolygonizeDirectedEdge startDE = null;
                PolygonizeDirectedEdge prevDE = null;
                List<PolygonizeDirectedEdge> edges = this.getActiveOutgoingEdges(deStar);
                int edgec = edges.size();
                double maxDist = 0.0;
                for (i = 0; i < edgec; ++i) {
                    currentDE2 = edges.get(i);
                    for (int j = i + 1; j < edgec; ++j) {
                        double dist;
                        Coordinate is;
                        PolygonizeDirectedEdge nextDE = edges.get(j);
                        if ((currentDE2.isArc() || nextDE.isArc()) && Math.abs(currentDE2.getAngle() - nextDE.getAngle()) < 1.0E-4) {
                            maxDist = 2.0 * newVertexOffset;
                        }
                        if ((is = this.getIntersection(li, node.getCoordinate(), currentDE2, nextDE)) == null || !((dist = CurveSegment.dist(node.getCoordinate(), is)) > maxDist)) continue;
                        maxDist = dist;
                    }
                }
                if (maxDist > 0.0) {
                    maxDist *= 1.1;
                    for (i = 0; i < edgec; ++i) {
                        currentDE2 = edges.get(i);
                        currentDE2.adjustDirectionPt(maxDist);
                    }
                    Collections.sort(deStar.getEdges());
                    edges = this.getActiveOutgoingEdges(deStar);
                }
                for (PolygonizeDirectedEdge currentDE2 : deStar.getEdges()) {
                    if (currentDE2.isMarked()) continue;
                    if (startDE == null) {
                        startDE = currentDE2;
                    }
                    if (prevDE != null) {
                        boolean removed = this.removeOverlap(li, node.getCoordinate(), prevDE, currentDE2, newVertexOffset);
                        overlapRemoved = overlapRemoved || removed;
                    }
                    prevDE = currentDE2;
                }
                if (prevDE != null) {
                    boolean removed = this.removeOverlap(li, node.getCoordinate(), prevDE, startDE, newVertexOffset);
                    boolean bl = overlapRemoved = overlapRemoved || removed;
                }
                if (!overlapRemoved) continue;
            } while (overlapRemoved);
        }
    }

    void printEdges(String tag, List<PolygonizeDirectedEdge> edges) {
        System.out.print(tag);
        int edgec = edges.size();
        for (int i = 0; i < edgec; ++i) {
            PolygonizeDirectedEdge currentDE = edges.get(i);
            System.out.print(((PolygonizeEdge)currentDE.getEdge()).getLine().getUserData() + "{a " + currentDE.getAngle() + "}, ");
        }
        System.out.println();
        System.out.flush();
    }

    private List<PolygonizeDirectedEdge> getActiveOutgoingEdges(DirectedEdgeStar deStar) {
        ArrayList<PolygonizeDirectedEdge> edges = new ArrayList<PolygonizeDirectedEdge>();
        for (PolygonizeDirectedEdge currentDE : deStar.getEdges()) {
            if (currentDE.isMarked()) continue;
            edges.add(currentDE);
        }
        return edges;
    }

    private boolean removeOverlap(CurveSegmentIntersector li, Coordinate node, PolygonizeDirectedEdge de0, PolygonizeDirectedEdge de1, double newVertexOffset) {
        boolean overlapRemoved = false;
        PolygonizeEdge edge0 = (PolygonizeEdge)de0.getEdge();
        CompoundCurve line0 = (CompoundCurve)edge0.getLine();
        CurveSegment s0 = null;
        int s0idx = 0;
        s0idx = de0.getEdgeDirection() ? 0 : line0.getNumSegments() - 1;
        s0 = line0.getSegments().get(s0idx);
        boolean line0AtStart = false;
        if (s0.getStartPoint().equals2D(node)) {
            line0AtStart = true;
        }
        PolygonizeEdge edge1 = (PolygonizeEdge)de1.getEdge();
        CompoundCurve line1 = (CompoundCurve)edge1.getLine();
        CurveSegment s1 = null;
        int s1idx = 0;
        s1idx = de1.getEdgeDirection() ? 0 : line1.getNumSegments() - 1;
        s1 = line1.getSegments().get(s1idx);
        boolean line1AtStart = false;
        if (s1.getStartPoint().equals2D(node)) {
            line1AtStart = true;
        }
        if (!(s0 instanceof StraightSegment && s1 instanceof StraightSegment || s0.getStartPoint().equals2D(s1.getStartPoint()) && s0.getEndPoint().equals2D(s1.getEndPoint()) || s0.getStartPoint().equals2D(s1.getEndPoint()) && s0.getEndPoint().equals2D(s1.getStartPoint()))) {
            li.computeIntersection(s0, s1);
            if (li.hasIntersection()) {
                Intersection is = null;
                if (li.getIntersectionNum() == 1) {
                    if (!li.isIntersection(node)) {
                        throw new IllegalStateException("unexpected overlap tid1 " + is.getCurve1().getUserData() + ", tid2 " + is.getCurve2().getUserData() + ", coord " + is.getPt()[0].toString() + (is.getPt().length == 2 ? ", coord2 " + is.getPt()[1].toString() : ""));
                    }
                } else {
                    li.isOverlay();
                    Coordinate is0 = li.getIntersection(0);
                    Coordinate is1 = li.getIntersection(1);
                    if (is0.equals2D(node)) {
                        is = new Intersection(is1, line0, line1, s0, s1, li.getOverlap());
                    } else if (is1.equals2D(node)) {
                        is = new Intersection(is0, line0, line1, s0, s1, li.getOverlap());
                    } else {
                        throw new IllegalStateException("unexpected overlap " + is.toString());
                    }
                    if (is != null) {
                        EhiLogger.traceState((String)("valoverlap " + is.toString()));
                    }
                    if (s0 instanceof StraightSegment) {
                        if (line1.removeOverlap((ArcSegment)s1, s0, newVertexOffset)) {
                            de1.adjustDirectionPt();
                            overlapRemoved = true;
                        }
                    } else if (s1 instanceof StraightSegment) {
                        if (line0.removeOverlap((ArcSegment)s0, s1, newVertexOffset)) {
                            de0.adjustDirectionPt();
                            overlapRemoved = true;
                        }
                    } else if (((ArcSegment)s0).getRadius() > ((ArcSegment)s1).getRadius()) {
                        if (line1.removeOverlap((ArcSegment)s1, s0, newVertexOffset)) {
                            de1.adjustDirectionPt();
                            overlapRemoved = true;
                        }
                    } else if (line0.removeOverlap((ArcSegment)s0, s1, newVertexOffset)) {
                        de0.adjustDirectionPt();
                        overlapRemoved = true;
                    }
                }
            }
        }
        return overlapRemoved;
    }

    private Coordinate getIntersection(CurveSegmentIntersector li, Coordinate node, PolygonizeDirectedEdge de0, PolygonizeDirectedEdge de1) {
        PolygonizeEdge edge0 = (PolygonizeEdge)de0.getEdge();
        CompoundCurve line0 = (CompoundCurve)edge0.getLine();
        CurveSegment s0 = null;
        int s0idx = 0;
        s0idx = de0.getEdgeDirection() ? 0 : line0.getNumSegments() - 1;
        s0 = line0.getSegments().get(s0idx);
        PolygonizeEdge edge1 = (PolygonizeEdge)de1.getEdge();
        CompoundCurve line1 = (CompoundCurve)edge1.getLine();
        CurveSegment s1 = null;
        int s1idx = 0;
        s1idx = de1.getEdgeDirection() ? 0 : line1.getNumSegments() - 1;
        s1 = line1.getSegments().get(s1idx);
        if (!(s0 instanceof StraightSegment && s1 instanceof StraightSegment || s0.getStartPoint().equals2D(s1.getStartPoint()) && s0.getEndPoint().equals2D(s1.getEndPoint()) || s0.getStartPoint().equals2D(s1.getEndPoint()) && s0.getEndPoint().equals2D(s1.getStartPoint()))) {
            li.computeIntersection(s0, s1);
            if (li.hasIntersection()) {
                if (li.getIntersectionNum() == 1) {
                    if (!li.isIntersection(node)) {
                        throw new IllegalStateException("unexpected overlap");
                    }
                } else {
                    li.isOverlay();
                    Coordinate is0 = li.getIntersection(0);
                    Coordinate is1 = li.getIntersection(1);
                    if (is0.equals2D(node)) {
                        return is1;
                    }
                    if (is1.equals2D(node)) {
                        return is0;
                    }
                    throw new IllegalStateException("unexpected overlap");
                }
            }
        }
        return null;
    }

    public List getEdgeRings() {
        this.computeNextCWEdges();
        PolygonizeGraph.label(this.dirEdges, -1L);
        List maximalRings = this.findLabeledEdgeRings(this.dirEdges);
        this.convertMaximalToMinimalEdgeRings(maximalRings);
        ArrayList<EdgeRing> edgeRingList = new ArrayList<EdgeRing>();
        for (PolygonizeDirectedEdge de : this.dirEdges) {
            if (de.isMarked() || de.isInRing()) continue;
            EdgeRing er = this.findEdgeRing(de);
            edgeRingList.add(er);
        }
        return edgeRingList;
    }

    private List findLabeledEdgeRings(Collection dirEdges) {
        ArrayList<PolygonizeDirectedEdge> edgeRingStarts = new ArrayList<PolygonizeDirectedEdge>();
        long currLabel = 1L;
        for (PolygonizeDirectedEdge de : dirEdges) {
            if (de.isMarked() || de.getLabel() >= 0L) continue;
            edgeRingStarts.add(de);
            List edges = PolygonizeGraph.findDirEdgesInRing(de);
            PolygonizeGraph.label(edges, currLabel);
            ++currLabel;
        }
        return edgeRingStarts;
    }

    public List deleteCutEdges() {
        this.computeNextCWEdges();
        this.findLabeledEdgeRings(this.dirEdges);
        ArrayList<LineString> cutLines = new ArrayList<LineString>();
        for (PolygonizeDirectedEdge de : this.dirEdges) {
            if (de.isMarked()) continue;
            PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)de.getSym();
            if (de.getLabel() != sym.getLabel()) continue;
            de.setMarked(true);
            sym.setMarked(true);
            PolygonizeEdge e = (PolygonizeEdge)de.getEdge();
            cutLines.add(e.getLine());
        }
        return cutLines;
    }

    private static void label(Collection dirEdges, long label) {
        for (PolygonizeDirectedEdge de : dirEdges) {
            de.setLabel(label);
        }
    }

    private static void computeNextCWEdges(Node node) {
        DirectedEdgeStar deStar = node.getOutEdges();
        PolygonizeDirectedEdge startDE = null;
        PolygonizeDirectedEdge prevDE = null;
        for (PolygonizeDirectedEdge outDE : deStar.getEdges()) {
            if (outDE.isMarked()) continue;
            if (startDE == null) {
                startDE = outDE;
            }
            if (prevDE != null) {
                PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)prevDE.getSym();
                sym.setNext(outDE);
            }
            prevDE = outDE;
        }
        if (prevDE != null) {
            PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)prevDE.getSym();
            sym.setNext(startDE);
        }
    }

    private static void computeNextCCWEdges(Node node, long label) {
        DirectedEdgeStar deStar = node.getOutEdges();
        PolygonizeDirectedEdge firstOutDE = null;
        PolygonizeDirectedEdge prevInDE = null;
        List edges = deStar.getEdges();
        for (int i = edges.size() - 1; i >= 0; --i) {
            PolygonizeDirectedEdge de = (PolygonizeDirectedEdge)((Object)edges.get(i));
            PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)de.getSym();
            PolygonizeDirectedEdge outDE = null;
            if (de.getLabel() == label) {
                outDE = de;
            }
            PolygonizeDirectedEdge inDE = null;
            if (sym.getLabel() == label) {
                inDE = sym;
            }
            if (outDE == null && inDE == null) continue;
            if (inDE != null) {
                prevInDE = inDE;
            }
            if (outDE == null) continue;
            if (prevInDE != null) {
                prevInDE.setNext(outDE);
                prevInDE = null;
            }
            if (firstOutDE != null) continue;
            firstOutDE = outDE;
        }
        if (prevInDE != null) {
            Assert.isTrue((firstOutDE != null ? 1 : 0) != 0);
            prevInDE.setNext(firstOutDE);
        }
    }

    private static List findDirEdgesInRing(PolygonizeDirectedEdge startDE) {
        PolygonizeDirectedEdge de = startDE;
        ArrayList<PolygonizeDirectedEdge> edges = new ArrayList<PolygonizeDirectedEdge>();
        do {
            edges.add(de);
            de = de.getNext();
            Assert.isTrue((de != null ? 1 : 0) != 0, (String)"found null DE in ring");
            Assert.isTrue((de == startDE || !de.isInRing() ? 1 : 0) != 0, (String)"found DE already in ring");
        } while (de != startDE);
        return edges;
    }

    private EdgeRing findEdgeRing(PolygonizeDirectedEdge startDE) {
        PolygonizeDirectedEdge de = startDE;
        EdgeRing er = new EdgeRing(this.factory);
        do {
            er.add(de);
            de.setRing(er);
            de = de.getNext();
            Assert.isTrue((de != null ? 1 : 0) != 0, (String)"found null DE in ring");
            Assert.isTrue((de == startDE || !de.isInRing() ? 1 : 0) != 0, (String)"found DE already in ring");
        } while (de != startDE);
        return er;
    }

    public Collection deleteDangles() {
        List nodesToRemove = this.findNodesOfDegree(1);
        HashSet<LineString> dangleLines = new HashSet<LineString>();
        Stack nodeStack = new Stack();
        Iterator i = nodesToRemove.iterator();
        while (i.hasNext()) {
            nodeStack.push(i.next());
        }
        while (!nodeStack.isEmpty()) {
            Node node = (Node)nodeStack.pop();
            PolygonizeGraph.deleteAllEdges(node);
            List nodeOutEdges = node.getOutEdges().getEdges();
            for (PolygonizeDirectedEdge de : nodeOutEdges) {
                de.setMarked(true);
                PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)de.getSym();
                if (sym != null) {
                    sym.setMarked(true);
                }
                PolygonizeEdge e = (PolygonizeEdge)de.getEdge();
                dangleLines.add(e.getLine());
                Node toNode = de.getToNode();
                if (PolygonizeGraph.getDegreeNonDeleted(toNode) != 1) continue;
                nodeStack.push(toNode);
            }
        }
        return dangleLines;
    }

    public void computeDepthParity() {
        PolygonizeDirectedEdge de;
        while ((de = null) != null) {
            this.computeDepthParity(de);
        }
        return;
    }

    private void computeDepthParity(PolygonizeDirectedEdge de) {
    }
}

