/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.BaseType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.FormattedTypeBaseAttrRef;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormattedType
extends BaseType {
    private Domain baseDomain = null;
    private Table baseClass = null;
    private String minimum = null;
    private String maximum = null;
    private ArrayList<FormattedTypeBaseAttrRef> baseAttrRef;
    private String prefix = null;

    public Table getDefinedBaseStruct() {
        return this.baseClass;
    }

    public Table getBaseStruct() {
        Table baseStruct = null;
        if (this.getDefinedBaseDomain() != null) {
            Domain baseDomain = this.getDefinedBaseDomain();
            FormattedType structFormatType = (FormattedType)baseDomain.getType();
            return structFormatType.getBaseStruct();
        }
        baseStruct = this.getDefinedBaseStruct();
        if (baseStruct == null) {
            baseStruct = ((FormattedType)this.getExtending()).getBaseStruct();
        }
        return baseStruct;
    }

    public void setBaseStruct(Table baseClass) {
        this.baseClass = baseClass;
    }

    public Domain getDefinedBaseDomain() {
        return this.baseDomain;
    }

    public void setBaseDomain(Domain baseDomain) {
        this.baseDomain = baseDomain;
    }

    public String getDefinedMaximum() {
        return this.maximum;
    }

    public String getMaximum() {
        if (this.maximum != null) {
            return this.maximum;
        }
        if (this.getDefinedBaseDomain() != null) {
            Domain baseDomain = this.getDefinedBaseDomain();
            FormattedType structFormatType = (FormattedType)baseDomain.getType();
            return structFormatType.getMaximum();
        }
        String max = null;
        for (FormattedType baseFormatType = (FormattedType)this.getExtending(); baseFormatType != null && (max = baseFormatType.maximum) == null; baseFormatType = (FormattedType)baseFormatType.getExtending()) {
        }
        if (max == null) {
            StringBuilder fmt = new StringBuilder();
            FormattedType lastParent = null;
            Iterator<FormattedTypeBaseAttrRef> baseAttri = this.iteratorBaseAttrRef();
            while (baseAttri.hasNext()) {
                String prefix;
                FormattedTypeBaseAttrRef baseAttrRef = baseAttri.next();
                if (lastParent != baseAttrRef.getParent() && (prefix = (lastParent = baseAttrRef.getParent()).getDefinedPrefix()) != null) {
                    fmt.append(prefix);
                }
                if (baseAttrRef.getFormatted() != null) {
                    fmt.append(((FormattedType)baseAttrRef.getFormatted().getType()).getMaximum());
                } else {
                    fmt.append(((NumericType)baseAttrRef.getAttr().getDomainResolvingAliases()).getMaximum().toString());
                }
                if (baseAttrRef.getPostfix() == null) continue;
                fmt.append(baseAttrRef.getPostfix());
            }
            max = fmt.toString();
        }
        return max;
    }

    public void setMaximum(String maximum) {
        this.maximum = maximum;
    }

    public String getDefinedMinimum() {
        return this.minimum;
    }

    public String getMinimum() {
        if (this.minimum != null) {
            return this.minimum;
        }
        if (this.getDefinedBaseDomain() != null) {
            Domain baseDomain = this.getDefinedBaseDomain();
            FormattedType structFormatType = (FormattedType)baseDomain.getType();
            return structFormatType.getMinimum();
        }
        String min = null;
        for (FormattedType baseFormatType = (FormattedType)this.getExtending(); baseFormatType != null && (min = baseFormatType.minimum) == null; baseFormatType = (FormattedType)baseFormatType.getExtending()) {
        }
        if (min == null) {
            StringBuilder fmt = new StringBuilder();
            FormattedType lastParent = null;
            Iterator<FormattedTypeBaseAttrRef> baseAttri = this.iteratorBaseAttrRef();
            while (baseAttri.hasNext()) {
                String prefix;
                FormattedTypeBaseAttrRef baseAttrRef = baseAttri.next();
                if (lastParent != baseAttrRef.getParent() && (prefix = (lastParent = baseAttrRef.getParent()).getDefinedPrefix()) != null) {
                    fmt.append(prefix);
                }
                if (baseAttrRef.getFormatted() != null) {
                    fmt.append(((FormattedType)baseAttrRef.getFormatted().getType()).getMinimum());
                } else {
                    fmt.append(((NumericType)baseAttrRef.getAttr().getDomainResolvingAliases()).getMinimum().toString());
                }
                if (baseAttrRef.getPostfix() == null) continue;
                fmt.append(baseAttrRef.getPostfix());
            }
            min = fmt.toString();
        }
        return min;
    }

    public void setMinimum(String minimum) {
        this.minimum = minimum;
    }

    public PrecisionDecimal[] valueOf(String value) {
        String regexp = this.getRegExp();
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(value);
        if (!matcher.matches()) {
            throw new NumberFormatException();
        }
        PrecisionDecimal[] ret = new PrecisionDecimal[matcher.groupCount()];
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            ret[i - 1] = new PrecisionDecimal(matcher.group(i));
        }
        return ret;
    }

    public String getRegExp() {
        FormattedType format = this;
        if (this.getDefinedBaseDomain() != null) {
            Domain baseDomain = this.getDefinedBaseDomain();
            format = (FormattedType)baseDomain.getType();
        }
        StringBuilder fmt = new StringBuilder();
        FormattedType lastParent = null;
        Iterator<FormattedTypeBaseAttrRef> baseAttri = format.iteratorBaseAttrRef();
        while (baseAttri.hasNext()) {
            String prefix;
            FormattedTypeBaseAttrRef baseAttrRef = baseAttri.next();
            if (lastParent != baseAttrRef.getParent() && (prefix = (lastParent = baseAttrRef.getParent()).getDefinedPrefix()) != null) {
                fmt.append(prefix);
            }
            if (baseAttrRef.getFormatted() != null) {
                fmt.append(((FormattedType)baseAttrRef.getFormatted().getType()).getRegExp());
            } else {
                fmt.append("([\\+\\-0-9\\.]+)");
            }
            if (baseAttrRef.getPostfix() == null) continue;
            fmt.append(baseAttrRef.getPostfix());
        }
        return fmt.toString();
    }

    public boolean isValueInRange(String value) {
        PrecisionDecimal[] minimum = this.valueOf(this.getMinimum());
        PrecisionDecimal[] maximum = this.valueOf(this.getMaximum());
        PrecisionDecimal[] val = this.valueOf(value);
        ArrayList<FormattedTypeBaseAttrRef> bases = new ArrayList<FormattedTypeBaseAttrRef>();
        Iterator<FormattedTypeBaseAttrRef> basei = this.iteratorBaseAttrRef();
        while (basei.hasNext()) {
            FormattedTypeBaseAttrRef base = basei.next();
            bases.add(base);
        }
        boolean isMin = true;
        boolean isMax = true;
        for (int i = 0; i < val.length; ++i) {
            int maxCompare;
            int minCompare;
            if (!isMin) {
                minCompare = val[i].compareTo(((NumericType)((FormattedTypeBaseAttrRef)bases.get(i)).getAttr().getDomainResolvingAliases()).getMinimum());
                if (minCompare == -1) {
                    return false;
                }
            } else {
                minCompare = val[i].compareTo(minimum[i]);
                if (minCompare == -1) {
                    return false;
                }
                isMin = minCompare == 0;
            }
            if (!isMax) {
                maxCompare = val[i].compareTo(((NumericType)((FormattedTypeBaseAttrRef)bases.get(i)).getAttr().getDomainResolvingAliases()).getMaximum());
                if (maxCompare != 1) continue;
                return false;
            }
            maxCompare = val[i].compareTo(maximum[i]);
            if (maxCompare == 1) {
                return false;
            }
            isMax = maxCompare == 0;
        }
        return true;
    }

    @Override
    public boolean checkStructuralEquivalence(Element with) {
        return super.checkStructuralEquivalence(with);
    }

    public void addBaseAttrRef(FormattedTypeBaseAttrRef ref) {
        if (this.baseAttrRef == null) {
            this.baseAttrRef = new ArrayList();
        }
        this.baseAttrRef.add(ref);
    }

    public Iterator<FormattedTypeBaseAttrRef> iteratorDefinedBaseAttrRef() {
        if (this.baseAttrRef == null) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        return this.baseAttrRef.iterator();
    }

    public Iterator<FormattedTypeBaseAttrRef> iteratorBaseAttrRef() {
        if (this.getDefinedBaseDomain() != null) {
            Domain baseDomain = this.getDefinedBaseDomain();
            FormattedType structFormatType = (FormattedType)baseDomain.getType();
            return structFormatType.iteratorBaseAttrRef();
        }
        ArrayList<FormattedTypeBaseAttrRef> ret = new ArrayList<FormattedTypeBaseAttrRef>();
        if (this.baseAttrRef != null) {
            ret.addAll(this.baseAttrRef);
        }
        for (FormattedType baseFormatType = (FormattedType)this.getExtending(); baseFormatType != null; baseFormatType = (FormattedType)baseFormatType.getExtending()) {
            if (baseFormatType.baseAttrRef == null) continue;
            ret.addAll(0, baseFormatType.baseAttrRef);
        }
        return ret.iterator();
    }

    public String getDefinedPrefix() {
        return this.prefix;
    }

    public String getPrefix() {
        if (this.prefix != null) {
            return this.prefix;
        }
        if (this.getDefinedBaseDomain() != null) {
            Domain baseDomain = this.getDefinedBaseDomain();
            FormattedType structFormatType = (FormattedType)baseDomain.getType();
            return structFormatType.getPrefix();
        }
        FormattedType baseFormatType = (FormattedType)this.getExtending();
        if (baseFormatType == null) {
            return null;
        }
        return baseFormatType.getPrefix();
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getFormat() {
        StringBuilder fmt = new StringBuilder();
        FormattedType lastParent = null;
        Iterator<FormattedTypeBaseAttrRef> baseAttri = this.iteratorBaseAttrRef();
        while (baseAttri.hasNext()) {
            String prefix;
            FormattedTypeBaseAttrRef baseAttrRef = baseAttri.next();
            if (lastParent != baseAttrRef.getParent() && (prefix = (lastParent = baseAttrRef.getParent()).getDefinedPrefix()) != null) {
                fmt.append("\"" + prefix + "\"");
            }
            fmt.append(baseAttrRef.getAttr().getName());
            if (baseAttrRef.getFormatted() != null) {
                fmt.append("/");
                fmt.append(baseAttrRef.getFormatted().getScopedName(null));
            } else if (baseAttrRef.getIntPos() > 0) {
                fmt.append("/");
                fmt.append(baseAttrRef.getIntPos());
            }
            if (baseAttrRef.getPostfix() == null) continue;
            fmt.append("\"" + baseAttrRef.getPostfix() + "\"");
        }
        return fmt.toString();
    }

    @Override
    void checkTypeExtension(Type wantToExtend) {
        if (wantToExtend == null || (wantToExtend = wantToExtend.resolveAliases()) == null) {
            return;
        }
        if (!wantToExtend.getClass().equals(this.getClass())) {
            throw new Ili2cSemanticException(rsrc.getString("err_type_ExtOther"));
        }
        this.checkCardinalityExtension(wantToExtend);
    }

    @Override
    public FormattedType clone() {
        FormattedType cloned = (FormattedType)super.clone();
        if (this.baseAttrRef != null) {
            int sz = this.baseAttrRef.size();
            cloned.baseAttrRef = new ArrayList(sz);
            for (int i = 0; i < sz; ++i) {
                cloned.baseAttrRef.add(this.baseAttrRef.get(i).newParent(cloned));
            }
        }
        return cloned;
    }

    @Override
    protected void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) {
        super.checkTranslationOf(errs, name, baseName);
        FormattedType origin = (FormattedType)this.getTranslationOf();
        if (origin == null) {
            return;
        }
        if (this.minimum != null || origin.minimum != null) {
            if (this.minimum == null || origin.minimum == null) {
                throw new Ili2cSemanticException();
            }
            if (!this.minimum.equals(origin.minimum)) {
                throw new Ili2cSemanticException();
            }
        }
        if (this.maximum != null || origin.maximum != null) {
            if (this.maximum == null || origin.maximum == null) {
                throw new Ili2cSemanticException();
            }
            if (!this.maximum.equals(origin.maximum)) {
                throw new Ili2cSemanticException();
            }
        }
        if (this.prefix != null || origin.prefix != null) {
            if (this.prefix == null || origin.prefix == null) {
                throw new Ili2cSemanticException();
            }
            if (!this.prefix.equals(origin.prefix)) {
                throw new Ili2cSemanticException();
            }
        }
        if (!Element.equalElementRef(this.baseDomain, origin.baseDomain)) {
            throw new Ili2cSemanticException();
        }
        if (!Element.equalElementRef(this.baseClass, origin.baseClass)) {
            throw new Ili2cSemanticException();
        }
        if (this.baseAttrRef != null || origin.baseAttrRef != null) {
            if (this.baseAttrRef == null || origin.baseAttrRef == null) {
                throw new Ili2cSemanticException();
            }
            if (this.baseAttrRef.size() != origin.baseAttrRef.size()) {
                throw new Ili2cSemanticException();
            }
            for (int i = 0; i < this.baseAttrRef.size(); ++i) {
                FormattedTypeBaseAttrRef attr = this.baseAttrRef.get(i);
                FormattedTypeBaseAttrRef originAttr = origin.baseAttrRef.get(i);
                if (!Element.equalElementRef(attr.getAttr(), originAttr.getAttr())) {
                    throw new Ili2cSemanticException();
                }
                if (!Element.equalElementRef(attr.getFormatted(), originAttr.getFormatted())) {
                    throw new Ili2cSemanticException();
                }
                if (attr.getIntPos() != originAttr.getIntPos()) {
                    throw new Ili2cSemanticException();
                }
                if (attr.getPostfix() == null && originAttr.getPostfix() == null) continue;
                if (attr.getPostfix() == null || originAttr.getPostfix() == null) {
                    throw new Ili2cSemanticException();
                }
                if (attr.getPostfix().equals(originAttr.getPostfix())) continue;
                throw new Ili2cSemanticException();
            }
        }
    }
}

