/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.gui;

import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.basics.view.FileChooser;
import ch.ehi.basics.view.GenericFileFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class ImportPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel xtffileLbl = null;
    private JRadioButton autoModelUi = null;
    private JRadioButton selectModelUi = null;
    private ButtonGroup modelGroup = new ButtonGroup();
    private JLabel iliFileLbl = null;
    private JTextField xtfFileUi = null;
    private JTextField iliFileUi = null;
    private JButton xtfFileButton = null;
    private JButton iliFileButton = null;
    private Settings settings = null;

    public ImportPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 2;
        gridBagConstraints7.gridy = 3;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 2;
        gridBagConstraints6.gridy = 0;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 3;
        gridBagConstraints5.gridy = 3;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.gridx = 1;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 3;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridx = 1;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 3;
        this.iliFileLbl = new JLabel();
        this.iliFileLbl.setText("iliFile");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridy = 2;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.anchor = 18;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.xtffileLbl = new JLabel();
        this.xtffileLbl.setText("xtffile");
        this.setSize(300, 200);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.xtffileLbl, gridBagConstraints);
        this.add((Component)this.getAutoModelUi(), gridBagConstraints1);
        this.add((Component)this.getSelectModelUi(), gridBagConstraints2);
        this.add((Component)this.iliFileLbl, gridBagConstraints3);
        this.add((Component)this.getXtfFileUi(), gridBagConstraints4);
        this.add((Component)this.getIliFileUi(), gridBagConstraints5);
        this.add((Component)this.getXtfFileButton(), gridBagConstraints6);
        this.add((Component)this.getIliFileButton(), gridBagConstraints7);
    }

    private JRadioButton getAutoModelUi() {
        if (this.autoModelUi == null) {
            this.autoModelUi = new JRadioButton();
            this.autoModelUi.setText("autoModel");
            this.autoModelUi.setSelected(true);
            this.modelGroup.add(this.autoModelUi);
        }
        return this.autoModelUi;
    }

    private JRadioButton getSelectModelUi() {
        if (this.selectModelUi == null) {
            this.selectModelUi = new JRadioButton();
            this.selectModelUi.setText("selectModel");
            this.selectModelUi.setSelected(false);
            this.selectModelUi.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        ImportPanel.this.getIliFileUi().setEnabled(false);
                    } else if (e.getStateChange() == 1) {
                        ImportPanel.this.getIliFileUi().setEnabled(true);
                    }
                }
            });
            this.modelGroup.add(this.selectModelUi);
        }
        return this.selectModelUi;
    }

    private JTextField getXtfFileUi() {
        if (this.xtfFileUi == null) {
            this.xtfFileUi = new JTextField();
            this.xtfFileUi.setColumns(40);
        }
        return this.xtfFileUi;
    }

    private JTextField getIliFileUi() {
        if (this.iliFileUi == null) {
            this.iliFileUi = new JTextField();
            this.iliFileUi.setColumns(40);
            this.iliFileUi.setEnabled(false);
        }
        return this.iliFileUi;
    }

    private JButton getXtfFileButton() {
        if (this.xtfFileButton == null) {
            this.xtfFileButton = new JButton();
            this.xtfFileButton.setText("...");
            this.xtfFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileChooser openDialog = new FileChooser();
                    if (ImportPanel.this.settings.getValue("ch.ehi.ili2db.dirused") != null) {
                        openDialog.setCurrentDirectory(new File(ImportPanel.this.settings.getValue("ch.ehi.ili2db.dirused")));
                    }
                    openDialog.addChoosableFileFilter((FileFilter)GenericFileFilter.createXmlFilter());
                    openDialog.addChoosableFileFilter((FileFilter)new GenericFileFilter("INTERLIS 2-Transfer (*.xtf)", "xtf"));
                    openDialog.addChoosableFileFilter((FileFilter)new GenericFileFilter("INTERLIS 1-Transfer (*.itf)", "itf"));
                    openDialog.addChoosableFileFilter((FileFilter)new GenericFileFilter("ZIP-Archive (*.zip)", "zip"));
                    if (openDialog.showOpenDialog((Component)ImportPanel.this) == 0) {
                        ImportPanel.this.settings.setValue("ch.ehi.ili2db.dirused", openDialog.getCurrentDirectory().getAbsolutePath());
                        ImportPanel.this.setXtffile(openDialog.getSelectedFile().getAbsolutePath());
                    }
                }
            });
        }
        return this.xtfFileButton;
    }

    private JButton getIliFileButton() {
        if (this.iliFileButton == null) {
            this.iliFileButton = new JButton();
            this.iliFileButton.setText("...");
            this.iliFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileChooser openDialog = new FileChooser();
                    if (ImportPanel.this.settings.getValue("ch.ehi.ili2db.dirused") != null) {
                        openDialog.setCurrentDirectory(new File(ImportPanel.this.settings.getValue("ch.ehi.ili2db.dirused")));
                    }
                    openDialog.addChoosableFileFilter((FileFilter)new GenericFileFilter("INTERLIS-Model (*.ili)", "ili"));
                    if (openDialog.showOpenDialog((Component)ImportPanel.this) == 0) {
                        ImportPanel.this.settings.setValue("ch.ehi.ili2db.dirused", openDialog.getCurrentDirectory().getAbsolutePath());
                        ImportPanel.this.setModels(openDialog.getSelectedFile().getAbsolutePath());
                    }
                }
            });
        }
        return this.iliFileButton;
    }

    public String getXtffile() {
        return ImportPanel.strip(this.getXtfFileUi().getText());
    }

    public void setXtffile(String file) {
        this.getXtfFileUi().setText(file);
    }

    public void setMappingconfig(String configfile) {
    }

    public String getMappingconfig() {
        return null;
    }

    public String getModeldir() {
        return null;
    }

    public void setModeldir(String modeldir) {
    }

    public String getModels() {
        if (this.getAutoModelUi().isSelected()) {
            return "%XTF";
        }
        return ImportPanel.strip(this.getIliFileUi().getText());
    }

    public void setModels(String models) {
        if (models == null || models.equals("%XTF")) {
            this.getAutoModelUi().setSelected(true);
            return;
        }
        this.getSelectModelUi().setSelected(true);
        this.getIliFileUi().setText(models);
    }

    public String getDropscript() {
        return null;
    }

    public void setDropscript(String dropscript) {
    }

    public String getCreatescript() {
        return null;
    }

    public void setCreatescript(String createscript) {
    }

    private static String strip(String value) {
        return StringUtility.purge((String)value);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }
}

