/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.sqlgen.generator;

import ch.ehi.basics.settings.Settings;
import ch.ehi.sqlgen.generator.Generator;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbConstraint;
import ch.ehi.sqlgen.repository.DbEnumEle;
import ch.ehi.sqlgen.repository.DbIndex;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTable;
import java.io.IOException;
import java.util.Iterator;

public class GeneratorDriver {
    private Generator gen = null;

    public GeneratorDriver(Generator generator) {
        this.gen = generator;
    }

    public void visitSchema(Settings config, DbSchema schema) throws IOException {
        DbTable tab;
        this.gen.visitSchemaBegin(config, schema);
        this.gen.visit1Begin();
        Iterator tabi = schema.iteratorTable();
        while (tabi.hasNext()) {
            tab = (DbTable)tabi.next();
            this.visit1Table(tab);
        }
        this.gen.visit1End();
        this.gen.visit2Begin();
        tabi = schema.iteratorTable();
        while (tabi.hasNext()) {
            tab = (DbTable)tabi.next();
            this.visit2Table(tab);
        }
        this.gen.visit2End();
        this.gen.visitSchemaEnd(schema);
    }

    private void visit1Table(DbTable table) throws IOException {
        this.gen.visit1TableBegin(table);
        this.gen.visitTableBeginColumn(table);
        Iterator coli = table.iteratorColumn();
        while (coli.hasNext()) {
            DbColumn col = (DbColumn)coli.next();
            this.gen.visitColumn(table, col);
        }
        this.gen.visitTableEndColumn(table);
        this.gen.visit1TableEnd(table);
    }

    private void visit2Table(DbTable table) throws IOException {
        this.gen.visit2TableBegin(table);
        this.gen.visitTableBeginIndex(table);
        Iterator idxi = table.iteratorIndex();
        while (idxi.hasNext()) {
            DbIndex idx = (DbIndex)idxi.next();
            this.gen.visitIndex(idx);
        }
        this.gen.visitTableEndIndex(table);
        this.gen.visitTableBeginConstraint(table);
        Iterator cnstri = table.iteratorConstraint();
        while (cnstri.hasNext()) {
            DbConstraint cnstr = (DbConstraint)cnstri.next();
            this.gen.visitConstraint(cnstr);
        }
        this.gen.visitTableEndConstraint(table);
        this.gen.visitTableBeginEnumEle(table);
        Iterator elei = table.iteratorEnumEle();
        while (elei.hasNext()) {
            DbEnumEle ele = (DbEnumEle)elei.next();
            this.gen.visitEnumEle(ele);
        }
        this.gen.visitTableEndEnumEle(table);
        this.gen.visit2TableEnd(table);
    }
}

