/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AbstractLeafElement;
import ch.interlis.ili2c.metamodel.AbstractPatternDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CombiningIterator;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.ExtendableContainer;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.ViewableAlias;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class Viewable<E extends Element>
extends ExtendableContainer<E> {
    protected String name = "";
    protected List<LocalAttribute> attributes = new ArrayList<LocalAttribute>();
    protected List<Constraint> constraints = new LinkedList<Constraint>();

    @Override
    public String getName() {
        if (this.isAlias()) {
            return this.getAlias();
        }
        return this.name;
    }

    public void setName(String name) throws PropertyVetoException {
        if (this.isAlias()) {
            this.setAlias(name);
            return;
        }
        String oldValue = this.name;
        String newValue = name;
        Viewable.checkNameSanity(newValue, false);
        this.checkNameUniqueness(newValue, Viewable.class, this.getRealExtending(), "err_duplicateViewName");
        this.fireVetoableChange("name", oldValue, newValue);
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    public String getScopedName(Container scope) {
        AbstractPatternDef scopeTopic;
        Model scopeModel;
        Model enclosingModel = (Model)this.getContainer(Model.class);
        AbstractPatternDef enclosingTopic = (AbstractPatternDef)this.getContainer(AbstractPatternDef.class);
        if (enclosingModel == null) {
            return this.getName();
        }
        if (scope != null) {
            scopeModel = (Model)scope.getContainerOrSame(Model.class);
            scopeTopic = (AbstractPatternDef)scope.getContainerOrSame(AbstractPatternDef.class);
        } else {
            scopeModel = null;
            scopeTopic = null;
        }
        if (enclosingModel == scopeModel && enclosingTopic == scopeTopic) {
            return this.getName();
        }
        if (enclosingTopic == null) {
            return enclosingModel.getName() + "." + this.getName();
        }
        return enclosingModel.getName() + "." + enclosingTopic.getName() + "." + this.getName();
    }

    public Iterator<LocalAttribute> getDefinedAttributes() {
        return this.attributes.iterator();
    }

    public Iterator<Extendable> getAttributes() {
        if (this.isAlias()) {
            return ((Viewable)this.getReal()).getAttributes();
        }
        LinkedList result = new LinkedList();
        HashMap<Extendable, Extendable> mostDerived = new HashMap<Extendable, Extendable>();
        for (Viewable v = this; v != null; v = (Viewable)v.getRealExtending()) {
            LinkedList attrsOfV_reversed = new LinkedList();
            for (Object obj : v) {
                Extendable attr;
                if (!(obj instanceof AttributeDef)) continue;
                Extendable leastDerived = attr = (Extendable)obj;
                Extendable leastDerivedParent = null;
                while ((leastDerivedParent = (Extendable)((Object)leastDerived.getRealExtending())) != null) {
                    leastDerived = leastDerivedParent;
                }
                if (!mostDerived.containsKey(leastDerived)) {
                    mostDerived.put(leastDerived, attr);
                }
                if (attr != leastDerived) continue;
                attrsOfV_reversed.add(0, mostDerived.get(attr));
            }
            Iterator attrsOfV_iter = attrsOfV_reversed.iterator();
            while (attrsOfV_iter.hasNext()) {
                result.add(0, attrsOfV_iter.next());
            }
        }
        return result.iterator();
    }

    public Iterator<Element> getAttributesAndRoles() {
        if (this.isAlias()) {
            return ((Viewable)this.getReal()).getAttributesAndRoles();
        }
        ArrayList<AbstractLeafElement> result = new ArrayList<AbstractLeafElement>();
        ArrayList<Viewable> baseviewv = new ArrayList<Viewable>();
        for (Viewable v = this; v != null; v = (Viewable)v.getRealExtending()) {
            baseviewv.add(0, v);
        }
        for (Viewable v : baseviewv) {
            for (Object obj : v) {
                boolean found;
                int idx;
                if (obj instanceof AttributeDef) {
                    AttributeDef attr = (AttributeDef)obj;
                    idx = 0;
                    found = false;
                    for (Object e : result) {
                        if (e instanceof AttributeDef && ((AttributeDef)e).getName().equals(attr.getName())) {
                            found = true;
                            result.set(idx, attr);
                            break;
                        }
                        ++idx;
                    }
                    if (found) continue;
                    result.add(attr);
                    continue;
                }
                if (!(obj instanceof RoleDef)) continue;
                RoleDef role = (RoleDef)obj;
                idx = 0;
                found = false;
                for (Object e : result) {
                    if (e instanceof RoleDef && ((RoleDef)e).getName().equals(role.getName())) {
                        found = true;
                        result.set(idx, role);
                        break;
                    }
                    ++idx;
                }
                if (found) continue;
                result.add(role);
            }
        }
        return result.iterator();
    }

    public Iterator<ViewableTransferElement> getAttributesAndRoles2() {
        if (this.isAlias()) {
            return ((Viewable)this.getReal()).getAttributesAndRoles2();
        }
        ArrayList<ViewableTransferElement> result = new ArrayList<ViewableTransferElement>();
        ArrayList<Viewable> baseviewv = new ArrayList<Viewable>();
        for (Viewable v = this; v != null; v = (Viewable)v.getRealExtending()) {
            baseviewv.add(0, v);
        }
        for (Viewable v : baseviewv) {
            Iterator[] it = new Iterator[]{v.getRolesIterator(), v.attributes.iterator()};
            Iterator<Object> attri = new CombiningIterator(it);
            while (attri.hasNext()) {
                ViewableTransferElement ele;
                boolean found;
                int idx;
                Object obj = attri.next();
                if (obj instanceof AttributeDef) {
                    AttributeDef attr = (AttributeDef)obj;
                    idx = 0;
                    found = false;
                    for (Object e : result) {
                        if (((ViewableTransferElement)e).obj instanceof AttributeDef && ((AttributeDef)((ViewableTransferElement)e).obj).getName().equals(attr.getName())) {
                            found = true;
                            ele = (ViewableTransferElement)result.get(idx);
                            ele.obj = attr;
                            break;
                        }
                        ++idx;
                    }
                    if (found) continue;
                    result.add(new ViewableTransferElement(obj));
                    continue;
                }
                if (!(obj instanceof RoleDef)) continue;
                RoleDef role = (RoleDef)obj;
                idx = 0;
                found = false;
                for (Object e : result) {
                    if (((ViewableTransferElement)e).obj instanceof RoleDef && ((RoleDef)((ViewableTransferElement)e).obj).getName().equals(role.getName())) {
                        found = true;
                        ele = (ViewableTransferElement)result.get(idx);
                        ele.obj = role;
                        break;
                    }
                    ++idx;
                }
                if (found) continue;
                result.add(new ViewableTransferElement(obj));
            }
            if (!(v instanceof AbstractClassDef)) continue;
            List<RoleDef> embv = ((AbstractClassDef)v).getDefinedLightweightAssociations();
            Collections.sort(embv, new Comparator(){

                public int compare(Object o1, Object o2) {
                    RoleDef role1 = ((RoleDef)o1).getOppEnd();
                    RoleDef role2 = ((RoleDef)o2).getOppEnd();
                    return role1.getName().compareTo(role2.getName());
                }
            });
            for (RoleDef role : embv) {
                role = Viewable.getSpecificRoleDef(baseviewv, role);
                RoleDef oppend = role.getOppEnd();
                result.add(new ViewableTransferElement(oppend, true));
            }
        }
        return result.iterator();
    }

    private static RoleDef getSpecificRoleDef(List<Viewable> baseviewv, RoleDef roleDef) {
        for (int idx = baseviewv.size(); idx > 0; --idx) {
            Viewable v = baseviewv.get(idx - 1);
            if (!(v instanceof AbstractClassDef)) continue;
            AbstractClassDef aclass = (AbstractClassDef)v;
            for (RoleDef extRoleDef : roleDef.getExtensions()) {
                Iterator<AbstractClassDef> targetIt = extRoleDef.iteratorDestination();
                while (targetIt.hasNext()) {
                    AbstractClassDef target = targetIt.next();
                    if (target != aclass) continue;
                    return extRoleDef;
                }
            }
        }
        return roleDef;
    }

    public Iterator<ViewableTransferElement> getDefinedAttributesAndRoles2() {
        if (this.isAlias()) {
            return ((Viewable)this.getReal()).getDefinedAttributesAndRoles2();
        }
        ArrayList<ViewableTransferElement> result = new ArrayList<ViewableTransferElement>();
        Viewable v = this;
        Iterator[] it = new Iterator[]{v.getRolesIterator(), v.attributes.iterator()};
        Iterator<Object> attri = new CombiningIterator(it);
        while (attri.hasNext()) {
            Object obj = attri.next();
            if (obj instanceof AttributeDef) {
                AttributeDef attr = (AttributeDef)obj;
                result.add(new ViewableTransferElement(obj));
                continue;
            }
            if (!(obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)obj;
            result.add(new ViewableTransferElement(obj));
        }
        if (v instanceof AbstractClassDef) {
            List<RoleDef> embv = ((AbstractClassDef)v).getDefinedLightweightAssociations();
            Collections.sort(embv, new Comparator(){

                public int compare(Object o1, Object o2) {
                    RoleDef role1 = ((RoleDef)o1).getOppEnd();
                    RoleDef role2 = ((RoleDef)o2).getOppEnd();
                    return role1.getName().compareTo(role2.getName());
                }
            });
            for (RoleDef role : embv) {
                RoleDef oppend = role.getOppEnd();
                result.add(new ViewableTransferElement(oppend, true));
            }
        }
        return result.iterator();
    }

    public Iterator getRolesIterator() {
        return null;
    }

    public ViewableAlias resolveBaseAlias(String alias) {
        if (this.isAlias()) {
            return ((Viewable)this.getReal()).resolveBaseAlias(alias);
        }
        if (this.getName().equals(alias)) {
            return new ViewableAlias(alias, this);
        }
        return null;
    }

    @Override
    public void checkIntegrity(List<Ili2cSemanticException> errs) throws IllegalStateException {
        if (this.isAlias()) {
            ((Viewable)this.getReal()).checkIntegrity(errs);
            return;
        }
        super.checkIntegrity(errs);
        boolean myAbstractness = this.isAbstract();
        Iterator<Extendable> attrs = this.getAttributes();
        while (attrs.hasNext()) {
            AttributeDef attr = (AttributeDef)attrs.next();
            if (myAbstractness || !attr.isAbstract()) continue;
            boolean skip = false;
            Model model = (Model)attr.getContainer(Model.class);
            if (model instanceof PredefinedModel) {
                PredefinedModel pd = (PredefinedModel)model;
                if (pd.LINE_SEGMENT == attr.getContainer(Table.class)) {
                    skip = true;
                }
            }
            if (skip) continue;
            throw new IllegalStateException(Viewable.formatMessage("err_viewable_inheritedAttrAbstract", attr.getName(), this.toString(), attr.getContainer(Container.class).toString()));
        }
    }

    public Collection<Table> getReferencableTables() {
        if (this.isAlias()) {
            return ((Viewable)this.getReal()).getReferencableTables();
        }
        HashSet<Table> coll = new HashSet<Table>(5);
        this.determineReferencableTables(coll);
        return coll;
    }

    void determineReferencableTables(Collection<Table> coll) {
        if (this.isAlias()) {
            ((Viewable)this.getReal()).determineReferencableTables(coll);
            return;
        }
        Iterator<Extendable> iter = this.getAttributes();
        while (iter.hasNext()) {
            Extendable obj = iter.next();
            Viewable targetTable = null;
            if (targetTable == null || !coll.add((Table)targetTable)) continue;
            targetTable.determineReferencableTables(coll);
        }
    }

    public Set<Viewable> getPossibleComponents(AttributeDef startAttribute) {
        if (this.isAlias()) {
            return ((Viewable)this.getReal()).getPossibleComponents(startAttribute);
        }
        HashSet<Viewable> theResult = new HashSet<Viewable>();
        CompositionType ct = (CompositionType)Type.findReal(startAttribute.getDomain());
        if (ct != null && ct.getComponentType() != null) {
            this.calcCompositionClosure(ct.getComponentType(), theResult);
        }
        return theResult;
    }

    void calcCompositionClosure(Viewable v, Set<Viewable> s) {
        if (this.isAlias()) {
            ((Viewable)this.getReal()).calcCompositionClosure(v, s);
            return;
        }
        if (v == null) {
            return;
        }
        if (s.contains(v)) {
            return;
        }
        Model vModel = (Model)v.getContainerOrSame(Model.class);
        Model myModel = (Model)this.getContainerOrSame(Model.class);
        if (vModel == null || myModel == null) {
            return;
        }
        if (vModel != myModel && !myModel.isImporting(vModel)) {
            return;
        }
        if (!v.isDeclaredBefore(this)) {
            return;
        }
        s.add(v);
        Iterator<Extendable> attrs = v.getAttributes();
        while (attrs.hasNext()) {
            Table table;
            AttributeDef theAttrib = (AttributeDef)attrs.next();
            Type theType = Type.findReal(theAttrib.getDomain());
            if (!(theType instanceof CompositionType) || (table = ((CompositionType)theType).getComponentType()) == null) continue;
            this.calcCompositionClosure(table, s);
        }
        Set<ExtendableContainer<Viewable>> extensions = v.getExtensions();
        extensions.add(v);
        for (Viewable viewable : extensions) {
            this.calcCompositionClosure(viewable, s);
        }
    }

    @Override
    public Viewable<E> getRHSNameSpace() {
        if (this.isAlias()) {
            return ((Viewable)this.getReal()).getRHSNameSpace();
        }
        return this;
    }
}

