/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.wkb;

import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.itf.impl.jtsext.geom.ArcSegment;
import ch.interlis.iox_j.wkb.ByteArrayOutputStream;
import ch.interlis.iox_j.wkb.Iox2wkbException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Iox2wkb {
    private int outputDimension = 2;
    private ByteArrayOutputStream os = null;
    private boolean asEWKB = true;

    private Iox2wkb() {
    }

    public Iox2wkb(int outputDimension) {
        this(outputDimension, ByteOrder.BIG_ENDIAN, true);
    }

    public Iox2wkb(int outputDimension, ByteOrder byteOrder) {
        this(outputDimension, byteOrder, true);
    }

    public Iox2wkb(int outputDimension, ByteOrder byteOrder, boolean asEWKB) {
        this.outputDimension = outputDimension;
        this.asEWKB = asEWKB;
        this.os = new ByteArrayOutputStream(byteOrder);
        if (outputDimension < 2 || outputDimension > 3) {
            throw new IllegalArgumentException("Output dimension must be 2 or 3");
        }
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            buf.append(Iox2wkb.toHexDigit(b >> 4 & 0xF));
            buf.append(Iox2wkb.toHexDigit(b & 0xF));
        }
        return buf.toString();
    }

    private static char toHexDigit(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("Nibble value out of range: " + n);
        }
        if (n <= 9) {
            return (char)(48 + n);
        }
        return (char)(65 + (n - 10));
    }

    public byte[] coord2wkb(IomObject value) throws Iox2wkbException {
        if (value == null) {
            return null;
        }
        try {
            this.os.reset();
            this.writeByteOrder();
            this.writeGeometryType(1);
            this.writeCoord(value);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IO exception: " + ex.getMessage());
        }
        return this.os.toByteArray();
    }

    public byte[] multicoord2wkb(IomObject obj) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        try {
            this.writeByteOrder();
            this.writeGeometryType(4);
            int coordc = obj.getattrvaluecount("coord");
            this.os.writeInt(coordc);
            for (int coordi = 0; coordi < coordc; ++coordi) {
                IomObject coord = obj.getattrobj("coord", coordi);
                Iox2wkb helper = new Iox2wkb(this.outputDimension, this.os.order(), this.asEWKB);
                this.os.write(helper.coord2wkb(coord));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    private void writeCoord(IomObject value) throws Iox2wkbException {
        double yCoord;
        double xCoord;
        String c1 = value.getattrvalue("C1");
        String c2 = value.getattrvalue("C2");
        String c3 = value.getattrvalue("C3");
        try {
            xCoord = Double.parseDouble(c1);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C1 <" + c1 + ">", ex);
        }
        try {
            yCoord = Double.parseDouble(c2);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C2 <" + c2 + ">", ex);
        }
        double zCoord = 0.0;
        if (this.outputDimension == 3) {
            if (c3 != null) {
                try {
                    zCoord = Double.parseDouble(c3);
                }
                catch (Exception ex) {
                    throw new Iox2wkbException("failed to read C3 <" + c3 + ">", ex);
                }
            } else {
                throw new Iox2wkbException("missing C3");
            }
        }
        this.writeCoord(xCoord, yCoord, zCoord);
    }

    private static void arc2JTS(CoordinateList ret, IomObject value, double p) throws Iox2wkbException {
        if (value != null) {
            double arcPt_ho;
            double arcPt_re;
            double pt2_ho;
            double pt2_re;
            String c1 = value.getattrvalue("C1");
            String c2 = value.getattrvalue("C2");
            String c3 = value.getattrvalue("C3");
            String a1 = value.getattrvalue("A1");
            String a2 = value.getattrvalue("A2");
            try {
                pt2_re = Double.parseDouble(c1);
            }
            catch (Exception ex) {
                throw new Iox2wkbException("failed to read C1 <" + c1 + ">", ex);
            }
            try {
                pt2_ho = Double.parseDouble(c2);
            }
            catch (Exception ex) {
                throw new Iox2wkbException("failed to read C2 <" + c2 + ">", ex);
            }
            try {
                arcPt_re = Double.parseDouble(a1);
            }
            catch (Exception ex) {
                throw new Iox2wkbException("failed to read A1 <" + a1 + ">", ex);
            }
            try {
                arcPt_ho = Double.parseDouble(a2);
            }
            catch (Exception ex) {
                throw new Iox2wkbException("failed to read A2 <" + a2 + ">", ex);
            }
            if (p == 0.0) {
                ret.add((Object)new Coordinate(arcPt_re, arcPt_ho));
                ret.add((Object)new Coordinate(pt2_re, pt2_ho));
                return;
            }
            int lastCoord = ret.size();
            Coordinate p1 = null;
            p1 = ret.getCoordinate(lastCoord - 1);
            ArcSegment arc = new ArcSegment(p1, new Coordinate(arcPt_re, arcPt_ho), new Coordinate(pt2_re, pt2_ho), p);
            Coordinate[] coords = arc.getCoordinates();
            for (int i = 1; i < coords.length; ++i) {
                ret.add((Object)coords[i]);
            }
        }
    }

    private int arc2JTS(IomObject startPt, IomObject value, double p) throws Iox2wkbException {
        double pt1_ho;
        double pt1_re;
        double arcPt_ho;
        double arcPt_re;
        double pt2_ho;
        double pt2_re;
        if (value == null) {
            return 0;
        }
        int pointc = 0;
        String c1 = value.getattrvalue("C1");
        String c2 = value.getattrvalue("C2");
        String c3 = value.getattrvalue("C3");
        String a1 = value.getattrvalue("A1");
        String a2 = value.getattrvalue("A2");
        try {
            pt2_re = Double.parseDouble(c1);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C1 <" + c1 + ">", ex);
        }
        try {
            pt2_ho = Double.parseDouble(c2);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C2 <" + c2 + ">", ex);
        }
        double pt2_z = 0.0;
        if (c3 != null) {
            try {
                pt2_z = Double.parseDouble(c3);
            }
            catch (Exception ex) {
                throw new Iox2wkbException("failed to read C3 <" + c3 + ">", ex);
            }
        }
        try {
            arcPt_re = Double.parseDouble(a1);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read A1 <" + a1 + ">", ex);
        }
        try {
            arcPt_ho = Double.parseDouble(a2);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read A2 <" + a2 + ">", ex);
        }
        if (p == 0.0) {
            throw new Iox2wkbException("illegal p");
        }
        String p1c1 = startPt.getattrvalue("C1");
        String p1c2 = startPt.getattrvalue("C2");
        String p1c3 = startPt.getattrvalue("C3");
        try {
            pt1_re = Double.parseDouble(p1c1);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C1 <" + p1c1 + ">", ex);
        }
        try {
            pt1_ho = Double.parseDouble(p1c2);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C2 <" + p1c2 + ">", ex);
        }
        double pt1_z = 0.0;
        if (p1c3 != null) {
            try {
                pt1_z = Double.parseDouble(p1c3);
            }
            catch (Exception ex) {
                throw new Iox2wkbException("failed to read C3 <" + p1c3 + ">", ex);
            }
        }
        ArcSegment arc = new ArcSegment(new Coordinate(pt1_re, pt1_ho), new Coordinate(arcPt_re, arcPt_ho), new Coordinate(pt2_re, pt2_ho), p);
        Coordinate[] coords = arc.getCoordinates();
        for (int i = 1; i < coords.length; ++i) {
            this.writeCoord(coords[i].x, coords[i].y, 0.0);
            ++pointc;
        }
        return pointc;
    }

    private static Coordinate coord2JTS(IomObject value) throws Iox2wkbException {
        double yCoord;
        double xCoord;
        if (value == null) {
            return null;
        }
        String c1 = value.getattrvalue("C1");
        String c2 = value.getattrvalue("C2");
        String c3 = value.getattrvalue("C3");
        try {
            xCoord = Double.parseDouble(c1);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C1 <" + c1 + ">", ex);
        }
        try {
            yCoord = Double.parseDouble(c2);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C2 <" + c2 + ">", ex);
        }
        Coordinate coord = null;
        if (c3 == null) {
            coord = new Coordinate(xCoord, yCoord);
        } else {
            double zCoord;
            try {
                zCoord = Double.parseDouble(c3);
            }
            catch (Exception ex) {
                throw new Iox2wkbException("failed to read C3 <" + c3 + ">", ex);
            }
            coord = new Coordinate(xCoord, yCoord, zCoord);
        }
        return coord;
    }

    public byte[] polyline2wkb(IomObject polylineObj, boolean isSurfaceOrArea, boolean asCompoundCurve, double p) throws Iox2wkbException {
        if (polylineObj == null) {
            return null;
        }
        IomObject[] polylineObjs = new IomObject[]{polylineObj};
        return this.polyline2wkb(polylineObjs, isSurfaceOrArea, asCompoundCurve, p);
    }

    public byte[] polyline2wkb(IomObject[] polylineObjs, boolean isSurfaceOrArea, boolean asCompoundCurve, double p) throws Iox2wkbException {
        if (polylineObjs == null) {
            return null;
        }
        byte[] ret = null;
        try {
            this.os.reset();
            this.writeByteOrder();
            if (asCompoundCurve) {
                this.writeGeometryType(9);
            } else {
                this.writeGeometryType(2);
            }
            int sizePos = this.os.size();
            int size = 0;
            this.os.writeInt(0);
            ArrayList<Integer> patches = new ArrayList<Integer>();
            int coordc = 0;
            int coordcPos = 0;
            int currentComponent = 0;
            IomObject arcStartPt = null;
            for (IomObject polylineObj : polylineObjs) {
                boolean clipped;
                IomObject lineattr;
                if (polylineObj == null) continue;
                if (isSurfaceOrArea && (lineattr = polylineObj.getattrobj("lineattr", 0)) != null) {
                    throw new Iox2wkbException("Lineattributes not supported");
                }
                boolean bl = clipped = polylineObj.getobjectconsistency() == 1;
                if (clipped) {
                    throw new Iox2wkbException("clipped polyline not supported");
                }
                for (int sequencei = 0; sequencei < polylineObj.getattrvaluecount("sequence"); ++sequencei) {
                    if (!clipped && sequencei > 0) {
                        throw new Iox2wkbException("unclipped polyline with multi 'sequence' elements");
                    }
                    IomObject sequence = polylineObj.getattrobj("sequence", sequencei);
                    int segmentc = sequence.getattrvaluecount("segment");
                    for (int segmenti = 0; segmenti < segmentc; ++segmenti) {
                        IomObject segment = sequence.getattrobj("segment", segmenti);
                        if (segment.getobjecttag().equals("COORD")) {
                            if (currentComponent == 0 || segmenti != 0) {
                                if (asCompoundCurve) {
                                    if (segmenti != 0 || segmentc < 2 || !sequence.getattrobj("segment", segmenti + 1).getobjecttag().equals("ARC")) {
                                        if (currentComponent != 2) {
                                            if (currentComponent != 0) {
                                                patches.add(coordcPos);
                                                patches.add(coordc);
                                            }
                                            this.writeByteOrder();
                                            this.writeGeometryType(2);
                                            coordcPos = this.os.size();
                                            coordc = 0;
                                            this.os.writeInt(0);
                                            currentComponent = 2;
                                            ++size;
                                            if (arcStartPt != null) {
                                                this.writeCoord(arcStartPt);
                                                ++coordc;
                                            }
                                        }
                                        this.writeCoord(segment);
                                        ++coordc;
                                    }
                                } else {
                                    this.writeCoord(segment);
                                    ++coordc;
                                }
                            }
                        } else if (segment.getobjecttag().equals("ARC")) {
                            if (asCompoundCurve) {
                                double arcPt_ho;
                                double arcPt_re;
                                if (currentComponent != 8) {
                                    if (currentComponent != 0) {
                                        patches.add(coordcPos);
                                        patches.add(coordc);
                                    }
                                    this.writeByteOrder();
                                    this.writeGeometryType(8);
                                    coordcPos = this.os.size();
                                    coordc = 0;
                                    this.os.writeInt(0);
                                    currentComponent = 8;
                                    ++size;
                                    this.writeCoord(arcStartPt);
                                    ++coordc;
                                }
                                String a1 = segment.getattrvalue("A1");
                                String a2 = segment.getattrvalue("A2");
                                try {
                                    arcPt_re = Double.parseDouble(a1);
                                }
                                catch (Exception ex) {
                                    throw new Iox2wkbException("failed to read A1 <" + a1 + ">", ex);
                                }
                                try {
                                    arcPt_ho = Double.parseDouble(a2);
                                }
                                catch (Exception ex) {
                                    throw new Iox2wkbException("failed to read A2 <" + a2 + ">", ex);
                                }
                                this.writeCoord(arcPt_re, arcPt_ho, 0.0);
                                ++coordc;
                                this.writeCoord(segment);
                                ++coordc;
                            } else {
                                int pointc = this.arc2JTS(arcStartPt, segment, p);
                                coordc += pointc;
                            }
                        } else {
                            throw new Iox2wkbException("custom line form not supported");
                        }
                        arcStartPt = segment;
                    }
                    if (clipped) {
                        // empty if block
                    }
                    if (asCompoundCurve) {
                        patches.add(coordcPos);
                        patches.add(coordc);
                        continue;
                    }
                    size += coordc;
                }
            }
            ret = this.os.toByteArray();
            Iterator patchi = patches.iterator();
            while (patchi.hasNext()) {
                int patchPos = (Integer)patchi.next();
                int value = (Integer)patchi.next();
                this.patchInt(ret, patchPos, value);
            }
            this.patchInt(ret, sizePos, size);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        return ret;
    }

    void patchInt(byte[] ret, int patchPos, int patchValue) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(this.os.order());
        buf.rewind();
        buf.putInt(patchValue);
        System.arraycopy(buf.array(), 0, ret, patchPos, buf.position());
    }

    private static CoordinateList polyline2coordlist(IomObject polylineObj, boolean isSurfaceOrArea, double p) throws Iox2wkbException {
        boolean clipped;
        IomObject lineattr;
        if (polylineObj == null) {
            return null;
        }
        CoordinateList ret = new CoordinateList();
        if (isSurfaceOrArea && (lineattr = polylineObj.getattrobj("lineattr", 0)) != null) {
            throw new Iox2wkbException("Lineattributes not supported");
        }
        boolean bl = clipped = polylineObj.getobjectconsistency() == 1;
        if (clipped) {
            throw new Iox2wkbException("clipped polyline not supported");
        }
        for (int sequencei = 0; sequencei < polylineObj.getattrvaluecount("sequence"); ++sequencei) {
            if (!clipped && sequencei > 0) {
                throw new Iox2wkbException("unclipped polyline with multi 'sequence' elements");
            }
            IomObject sequence = polylineObj.getattrobj("sequence", sequencei);
            for (int segmenti = 0; segmenti < sequence.getattrvaluecount("segment"); ++segmenti) {
                IomObject segment = sequence.getattrobj("segment", segmenti);
                if (segment.getobjecttag().equals("COORD")) {
                    ret.add((Object)Iox2wkb.coord2JTS(segment));
                    continue;
                }
                if (segment.getobjecttag().equals("ARC")) {
                    Iox2wkb.arc2JTS(ret, segment, p);
                    continue;
                }
                throw new Iox2wkbException("custom line form not supported");
            }
            if (!clipped) continue;
        }
        return ret;
    }

    public byte[] surface2wkb(IomObject obj, boolean asCurvePolygon, double strokeP) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        try {
            boolean clipped;
            this.writeByteOrder();
            if (asCurvePolygon) {
                this.writeGeometryType(10);
            } else {
                this.writeGeometryType(3);
            }
            boolean bl = clipped = obj.getobjectconsistency() == 1;
            if (clipped) {
                throw new Iox2wkbException("clipped surface not supported");
            }
            for (int surfacei = 0; surfacei < obj.getattrvaluecount("surface"); ++surfacei) {
                if (!clipped && surfacei > 0) {
                    throw new Iox2wkbException("unclipped surface with multi 'surface' elements");
                }
                IomObject surface = obj.getattrobj("surface", surfacei);
                int boundaryc = surface.getattrvaluecount("boundary");
                this.os.writeInt(boundaryc);
                for (int boundaryi = 0; boundaryi < boundaryc; ++boundaryi) {
                    IomObject boundary = surface.getattrobj("boundary", boundaryi);
                    int polylinec = boundary.getattrvaluecount("polyline");
                    if (asCurvePolygon) {
                        Iox2wkb helper = new Iox2wkb(this.outputDimension, this.os.order(), this.asEWKB);
                        if (polylinec == 1) {
                            IomObject polyline = boundary.getattrobj("polyline", 0);
                            this.os.write(helper.polyline2wkb(polyline, true, asCurvePolygon, strokeP));
                            continue;
                        }
                        IomObject[] polylines = new IomObject[polylinec];
                        for (int polylinei = 0; polylinei < polylinec; ++polylinei) {
                            IomObject polyline;
                            polylines[polylinei] = polyline = boundary.getattrobj("polyline", polylinei);
                        }
                        this.os.write(helper.polyline2wkb(polylines, true, asCurvePolygon, strokeP));
                        continue;
                    }
                    CoordinateList jtsLine = new CoordinateList();
                    for (int polylinei = 0; polylinei < polylinec; ++polylinei) {
                        IomObject polyline = boundary.getattrobj("polyline", polylinei);
                        jtsLine.addAll((Collection)Iox2wkb.polyline2coordlist(polyline, true, strokeP));
                    }
                    jtsLine.closeRing();
                    this.os.writeInt(jtsLine.size());
                    for (Coordinate coord : jtsLine) {
                        this.os.writeDouble(coord.x);
                        this.os.writeDouble(coord.y);
                        if (this.outputDimension != 3) continue;
                        this.os.writeDouble(coord.z);
                    }
                }
                if (!clipped) continue;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    public byte[] multisurface2wkb(IomObject obj, boolean asCurvePolygon, double strokeP) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        try {
            this.writeByteOrder();
            if (asCurvePolygon) {
                this.writeGeometryType(12);
            } else {
                this.writeGeometryType(6);
            }
            int surfacec = obj.getattrvaluecount("surface");
            this.os.writeInt(surfacec);
            for (int surfacei = 0; surfacei < surfacec; ++surfacei) {
                IomObject surface = obj.getattrobj("surface", surfacei);
                Iom_jObject iomSurfaceClone = new Iom_jObject("MULTISURFACE", null);
                iomSurfaceClone.addattrobj("surface", surface);
                Iox2wkb helper = new Iox2wkb(this.outputDimension, this.os.order(), this.asEWKB);
                this.os.write(helper.surface2wkb(iomSurfaceClone, asCurvePolygon, strokeP));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    public byte[] multiline2wkb(IomObject obj, boolean asCurve, double strokeP) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        try {
            this.writeByteOrder();
            if (asCurve) {
                this.writeGeometryType(11);
            } else {
                this.writeGeometryType(5);
            }
            int polylinec = obj.getattrvaluecount("polyline");
            this.os.writeInt(polylinec);
            for (int polylinei = 0; polylinei < polylinec; ++polylinei) {
                IomObject polyline = obj.getattrobj("polyline", polylinei);
                Iox2wkb helper = new Iox2wkb(this.outputDimension, this.os.order(), this.asEWKB);
                this.os.write(helper.polyline2wkb(polyline, false, asCurve, strokeP));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    private void writeByteOrder() throws IOException {
        if (this.os.order().equals(ByteOrder.LITTLE_ENDIAN)) {
            this.os.write(1);
        } else {
            this.os.write(0);
        }
    }

    private void writeGeometryType(int geometryType) throws IOException {
        int flagIncludeZ = this.asEWKB ? Integer.MIN_VALUE : 1000;
        int flag3D = this.outputDimension == 3 ? flagIncludeZ : 0;
        int typeInt = geometryType + flag3D;
        this.os.writeInt(typeInt);
    }

    private void writeCoord(double xCoord, double yCoord, double zCoord) {
        this.os.writeDouble(xCoord);
        this.os.writeDouble(yCoord);
        if (this.outputDimension == 3) {
            this.os.writeDouble(zCoord);
        }
    }
}

