/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.base;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.OIDType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.Viewable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Ili2cUtility {
    private static Set<String> illegalOidNames = new HashSet<String>();

    public static boolean isViewableWithExtension(Viewable def) {
        return def.getExtensions().size() > 1;
    }

    public static boolean isBoolean(TransferDescription td, Type type) {
        while (type instanceof TypeAlias) {
            if (((TypeAlias)type).getAliasing() == td.INTERLIS.BOOLEAN) {
                return true;
            }
            type = ((TypeAlias)type).getAliasing().getType();
        }
        return false;
    }

    public static boolean isUuidOid(TransferDescription td, Type type) {
        while (type instanceof TypeAlias) {
            if (((TypeAlias)type).getAliasing() == td.INTERLIS.UUIDOID) {
                return true;
            }
            type = ((TypeAlias)type).getAliasing().getType();
        }
        return false;
    }

    public static boolean isViewableWithOid(Viewable def) {
        if (!(def instanceof AbstractClassDef)) {
            return false;
        }
        if (def instanceof Table && !((Table)def).isIdentifiable()) {
            return false;
        }
        AbstractClassDef aclass = (AbstractClassDef)def;
        if (aclass.getOid() != null) {
            return true;
        }
        if (Ili2cUtility.getOidDomainFromMetaAttr(aclass) != null) {
            return true;
        }
        for (Object exto : aclass.getExtensions()) {
            AbstractClassDef ext = (AbstractClassDef)exto;
            if (ext.getOid() != null) {
                return true;
            }
            if (Ili2cUtility.getOidDomainFromMetaAttr(ext) == null) continue;
            return true;
        }
        return false;
    }

    public static Viewable getRootViewable(Viewable def) {
        Viewable root = (Viewable)def.getRootExtending();
        if (root == null) {
            root = def;
        }
        return root;
    }

    public static boolean isChbaseCatalogueItem(TransferDescription td, Viewable aclass) {
        Viewable root = Ili2cUtility.getRootViewable(aclass);
        return root.getScopedName().equals("CatalogueObjects_V1.Catalogues.Item");
    }

    public static boolean isPureChbaseCatalogueRef(TransferDescription td, AttributeDef attr) {
        Type typeo = attr.getDomain();
        if (typeo instanceof CompositionType) {
            CompositionType type = (CompositionType)typeo;
            Table struct = type.getComponentType();
            Table root = (Table)struct.getRootExtending();
            if (root == null) {
                root = struct;
            }
            if (root.getContainer().getScopedName(null).equals("CatalogueObjects_V1.Catalogues") && (root.getName().equals("CatalogueReference") || root.getName().equals("MandatoryCatalogueReference"))) {
                Iterator it = struct.getAttributesAndRoles2();
                int c = 0;
                while (it.hasNext()) {
                    it.next();
                    ++c;
                }
                if (c == 1) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isPureChbaseMultiSuface(TransferDescription td, AttributeDef attr) {
        Type typeo = attr.getDomain();
        if (typeo instanceof CompositionType) {
            String containerQName;
            CompositionType type = (CompositionType)typeo;
            Table struct = type.getComponentType();
            Table root = (Table)struct.getRootExtending();
            if (root == null) {
                root = struct;
            }
            if (((containerQName = root.getContainer().getScopedName(null)).equals("GeometryCHLV03_V1") || containerQName.equals("GeometryCHLV95_V1")) && root.getName().equals("MultiSurface")) {
                Iterator it = struct.getAttributesAndRoles2();
                int c = 0;
                while (it.hasNext()) {
                    it.next();
                    ++c;
                }
                if (c == 1) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isPureChbaseMultiLine(TransferDescription td, AttributeDef attr) {
        Type typeo = attr.getDomain();
        if (typeo instanceof CompositionType) {
            String containerQName;
            CompositionType type = (CompositionType)typeo;
            Table struct = type.getComponentType();
            Table root = (Table)struct.getRootExtending();
            if (root == null) {
                root = struct;
            }
            if (((containerQName = root.getContainer().getScopedName(null)).equals("GeometryCHLV03_V1") || containerQName.equals("GeometryCHLV95_V1")) && (root.getName().equals("MultiLine") || root.getName().equals("MultiDirectedLine"))) {
                Iterator it = struct.getAttributesAndRoles2();
                int c = 0;
                while (it.hasNext()) {
                    it.next();
                    ++c;
                }
                if (c == 1) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isLocalisedMTextAttr(TransferDescription td, AttributeDef attr) {
        CompositionType type;
        Type typeo = attr.getDomain();
        if (typeo instanceof CompositionType && (type = (CompositionType)attr.getDomain()).getCardinality().getMaximum() == 1L) {
            if (Ili2cUtility.isPureChbaseLocalisedMText(td, attr)) {
                return true;
            }
            Table struct = type.getComponentType();
            if ("Localised".equals(struct.getMetaValue("ili2db.mapping"))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPureChbaseLocalisedMText(TransferDescription td, AttributeDef attr) {
        return Ili2cUtility.isPureChbaseLocalisedText(td, attr, "LocalisedMText");
    }

    public static boolean isLocalisedTextAttr(TransferDescription td, AttributeDef attr) {
        CompositionType type;
        Type typeo = attr.getDomain();
        if (typeo instanceof CompositionType && (type = (CompositionType)attr.getDomain()).getCardinality().getMaximum() == 1L) {
            if (Ili2cUtility.isPureChbaseLocalisedText(td, attr)) {
                return true;
            }
            Table struct = type.getComponentType();
            if ("Localised".equals(struct.getMetaValue("ili2db.mapping"))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPureChbaseLocalisedText(TransferDescription td, AttributeDef attr) {
        return Ili2cUtility.isPureChbaseLocalisedText(td, attr, "LocalisedText");
    }

    private static boolean isPureChbaseLocalisedText(TransferDescription td, AttributeDef attr, String textType) {
        Type typeo = attr.getDomain();
        if (typeo instanceof CompositionType) {
            CompositionType type = (CompositionType)typeo;
            Table struct = type.getComponentType();
            Table base = null;
            if (struct.getContainer().getScopedName(null).equals("LocalisationCH_V1")) {
                base = struct;
            } else {
                base = (Table)struct.getExtending();
                if (base == null) {
                    base = struct;
                }
                while (base != null && !base.getContainer().getScopedName(null).equals("LocalisationCH_V1")) {
                    base = (Table)base.getExtending();
                }
            }
            if (base == null) {
                return false;
            }
            if (base.getName().equals(textType)) {
                Iterator it = struct.getAttributesAndRoles2();
                int c = 0;
                while (it.hasNext()) {
                    it.next();
                    ++c;
                }
                if (c == 2) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isMultilingualTextAttr(TransferDescription td, AttributeDef attr) {
        CompositionType type;
        Type typeo = attr.getDomain();
        if (typeo instanceof CompositionType && (type = (CompositionType)attr.getDomain()).getCardinality().getMaximum() == 1L) {
            if (Ili2cUtility.isPureChbaseMultilingualText(td, attr)) {
                return true;
            }
            Table struct = type.getComponentType();
            if ("Multilingual".equals(struct.getMetaValue("ili2db.mapping"))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPureChbaseMultilingualText(TransferDescription td, AttributeDef attr) {
        return Ili2cUtility.isPureChbaseMultilingualText(td, attr, "MultilingualText");
    }

    public static boolean isMultilingualMTextAttr(TransferDescription td, AttributeDef attr) {
        CompositionType type;
        Type typeo = attr.getDomain();
        if (typeo instanceof CompositionType && (type = (CompositionType)attr.getDomain()).getCardinality().getMaximum() == 1L) {
            if (Ili2cUtility.isPureChbaseMultilingualMText(td, attr)) {
                return true;
            }
            Table struct = type.getComponentType();
            if ("Multilingual".equals(struct.getMetaValue("ili2db.mapping"))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPureChbaseMultilingualMText(TransferDescription td, AttributeDef attr) {
        return Ili2cUtility.isPureChbaseMultilingualText(td, attr, "MultilingualMText");
    }

    private static boolean isPureChbaseMultilingualText(TransferDescription td, AttributeDef attr, String textType) {
        Type typeo = attr.getDomain();
        if (typeo instanceof CompositionType) {
            CompositionType type = (CompositionType)typeo;
            Table struct = type.getComponentType();
            Table base = null;
            if (struct.getContainer().getScopedName(null).equals("LocalisationCH_V1")) {
                base = struct;
            } else {
                base = (Table)struct.getExtending();
                if (base == null) {
                    base = struct;
                }
                while (base != null && !base.getContainer().getScopedName(null).equals("LocalisationCH_V1")) {
                    base = (Table)base.getExtending();
                }
            }
            if (base == null) {
                return false;
            }
            if (base.getName().equals(textType)) {
                Iterator it = struct.getAttributesAndRoles2();
                int c = 0;
                while (it.hasNext()) {
                    it.next();
                    ++c;
                }
                if (c == 1) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isMultiSurfaceAttr(TransferDescription td, AttributeDef attr) {
        CompositionType type;
        Type typeo = attr.getDomain();
        if (typeo instanceof CompositionType && (type = (CompositionType)attr.getDomain()).getCardinality().getMaximum() == 1L) {
            if (Ili2cUtility.isPureChbaseMultiSuface(td, attr)) {
                return true;
            }
            Table struct = type.getComponentType();
            if ("MultiSurface".equals(struct.getMetaValue("ili2db.mapping"))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMultiLineAttr(TransferDescription td, AttributeDef attr) {
        CompositionType type;
        Type typeo = attr.getDomain();
        if (typeo instanceof CompositionType && (type = (CompositionType)attr.getDomain()).getCardinality().getMaximum() == 1L) {
            if (Ili2cUtility.isPureChbaseMultiLine(td, attr)) {
                return true;
            }
            Table struct = type.getComponentType();
            if ("MultiLine".equals(struct.getMetaValue("ili2db.mapping"))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMultiPointAttr(TransferDescription td, AttributeDef attr) {
        Table struct;
        CompositionType type;
        Type typeo = attr.getDomain();
        return typeo instanceof CompositionType && (type = (CompositionType)attr.getDomain()).getCardinality().getMaximum() == 1L && "MultiPoint".equals((struct = type.getComponentType()).getMetaValue("ili2db.mapping"));
    }

    public static boolean isArrayAttr(TransferDescription td, AttributeDef attr) {
        Type typeo = attr.getDomain();
        return typeo instanceof CompositionType && "ARRAY".equals(attr.getMetaValue("ili2db.mapping"));
    }

    public static boolean isJsonAttr(TransferDescription td, AttributeDef attr) {
        Type typeo = attr.getDomain();
        return typeo instanceof CompositionType && "JSON".equals(attr.getMetaValue("ili2db.mapping"));
    }

    public static Domain getRootBaseDomain(Domain domain) {
        Domain base = domain.getExtending();
        while (base != null) {
            domain = base;
            base = domain.getExtending();
        }
        return domain;
    }

    public static AttributeDef getRootBaseAttr(AttributeDef attr) {
        AttributeDef base = (AttributeDef)attr.getExtending();
        while (base != null) {
            attr = base;
            base = (AttributeDef)attr.getExtending();
        }
        return attr;
    }

    public static RoleDef getRootBaseRole(RoleDef role) {
        RoleDef base = (RoleDef)role.getExtending();
        while (base != null) {
            role = base;
            base = (RoleDef)role.getExtending();
        }
        return role;
    }

    public static Domain getOidDomainFromMetaAttr(AbstractClassDef aclass) {
        String metaOidName = aclass.getMetaValue("ili2db.oid");
        if (metaOidName != null) {
            TransferDescription td = (TransferDescription)aclass.getContainer(TransferDescription.class);
            Element ele = td.getElement(metaOidName);
            if (ele == null) {
                if (!illegalOidNames.contains(metaOidName)) {
                    EhiLogger.logAdaption((String)("Unknown OID domain <" + metaOidName + "> at <" + aclass.getScopedName() + "> ignored"));
                    illegalOidNames.add(metaOidName);
                }
                return null;
            }
            if (!(ele instanceof Domain)) {
                if (!illegalOidNames.contains(metaOidName)) {
                    EhiLogger.logAdaption((String)("Element <" + metaOidName + "> at <" + aclass.getScopedName() + "> is not a domain; ignored"));
                    illegalOidNames.add(metaOidName);
                }
                return null;
            }
            if (!(((Domain)ele).getType() instanceof OIDType)) {
                if (!illegalOidNames.contains(metaOidName)) {
                    EhiLogger.logAdaption((String)("Domain <" + metaOidName + "> at <" + aclass.getScopedName() + "> is not an OID domain; ignored"));
                    illegalOidNames.add(metaOidName);
                }
                return null;
            }
            return (Domain)ele;
        }
        return null;
    }
}

