/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.plugins;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.iox_j.plugins.IoxPlugin;
import ch.interlis.iox_j.plugins.JARClassLoader;
import ch.interlis.iox_j.validator.InterlisFunction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PluginLoader {
    public static final String IOX_PLUGIN = "IoxPlugin";
    private ArrayList<JARClassLoader.JAR> jars = new ArrayList();

    public void loadPlugins(File dir) {
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] plugins = dir.listFiles();
        if (plugins == null) {
            return;
        }
        for (int i = 0; i < plugins.length; ++i) {
            File plugin = plugins[i];
            if (!plugin.getName().toLowerCase().endsWith(".jar")) continue;
            String path = plugin.getAbsolutePath();
            try {
                JARClassLoader loader = new JARClassLoader(path, this);
                loader.loadAllPlugins();
                continue;
            }
            catch (IOException io) {
                EhiLogger.logError((String)("Cannot load plugin " + path), (Throwable)io);
            }
        }
    }

    public List<IoxPlugin> getAllPlugins() {
        ArrayList<IoxPlugin> ret = new ArrayList<IoxPlugin>();
        for (int i = 0; i < this.jars.size(); ++i) {
            ret.addAll(Arrays.asList(this.jars.get(i).getPlugins()));
        }
        return ret;
    }

    public static Map<String, Class> getInterlisFunctions(List<IoxPlugin> plugins) {
        HashMap<String, Class> funcs = new HashMap<String, Class>();
        for (IoxPlugin plugin : plugins) {
            if (!(plugin instanceof InterlisFunction)) continue;
            funcs.put(((InterlisFunction)plugin).getQualifiedIliName(), plugin.getClass());
        }
        return funcs;
    }

    protected void addPluginJAR(JARClassLoader.JAR jar) {
        this.jars.add(jar);
    }
}

