/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.logging;

import ch.ehi.basics.logging.AbstractStdListener;
import ch.ehi.basics.logging.LogEvent;
import ch.ehi.basics.logging.LogListener;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.xtf.XtfModel;
import ch.interlis.iom_j.xtf.XtfWriterBase;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxLogEvent;
import ch.interlis.iox.IoxWriter;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.StartTransferEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.interlis2.validator.models.ILIVERRORS;
import org.interlis2.validator.models.IliVErrors.ErrorLog.Error;
import org.interlis2.validator.models.IliVErrors.ErrorLog.Error_Type;

public class XtfErrorsLogger
implements LogListener {
    private static final String UNDEFINED_MESSAGE = "UNDEFINED MESSAGE";
    IoxWriter out = null;
    private int objc = 1;

    public XtfErrorsLogger(File logFile, String sender) {
        try {
            this.out = new XtfWriterBase(logFile, ILIVERRORS.getIoxMapping(), "2.3");
            ((XtfWriterBase)this.out).setModels(new XtfModel[]{ILIVERRORS.getXtfModel()});
            StartTransferEvent startTransferEvent = new StartTransferEvent();
            startTransferEvent.setSender(sender);
            this.out.write((IoxEvent)startTransferEvent);
            StartBasketEvent startBasketEvent = new StartBasketEvent("IliVErrors.ErrorLog", "b1");
            this.out.write((IoxEvent)startBasketEvent);
        }
        catch (IoxException e) {
            throw new IllegalStateException(e);
        }
    }

    public void logEvent(LogEvent event) {
        Throwable ex;
        Error iomObj = new Error("o" + this.objc++);
        String msg = event.getEventMsg();
        if (msg == null && (ex = event.getException()) != null) {
            msg = ex.getLocalizedMessage();
            if (msg != null && (msg = msg.trim()).length() == 0) {
                msg = null;
            }
            if (msg == null) {
                msg = ex.getClass().getName();
            }
        }
        if (msg != null) {
            iomObj.setMessage(msg);
        } else {
            iomObj.setMessage(UNDEFINED_MESSAGE);
        }
        switch (event.getEventKind()) {
            case 7: {
                iomObj.setType(Error_Type.Error);
                break;
            }
            case 6: {
                iomObj.setType(Error_Type.Warning);
                break;
            }
            case 5: {
                iomObj.setType(Error_Type.Info);
                break;
            }
            default: {
                iomObj.setType(Error_Type.DetailInfo);
            }
        }
        if (event instanceof IoxLogEvent) {
            Integer sourceLineNr;
            String dataSource;
            String modelEleQName;
            String sourceObjectUsrId;
            String sourceObjectTechId;
            String sourceObjectXtfId;
            IoxLogEvent ioxEvent = (IoxLogEvent)event;
            String sourceObjectTag = ioxEvent.getSourceObjectTag();
            if (sourceObjectTag != null) {
                iomObj.setObjTag(sourceObjectTag);
            }
            if ((sourceObjectXtfId = ioxEvent.getSourceObjectXtfId()) != null) {
                iomObj.setTid(sourceObjectXtfId);
            }
            if ((sourceObjectTechId = ioxEvent.getSourceObjectTechId()) != null) {
                iomObj.setTechId(sourceObjectTechId);
            }
            if ((sourceObjectUsrId = ioxEvent.getSourceObjectUsrId()) != null) {
                iomObj.setUserId(sourceObjectUsrId);
            }
            if ((modelEleQName = ioxEvent.getModelEleQName()) != null) {
                iomObj.setIliQName(modelEleQName);
            }
            if ((dataSource = ioxEvent.getDataSource()) != null) {
                iomObj.setDataSource(dataSource);
            }
            if ((sourceLineNr = ioxEvent.getSourceLineNr()) != null) {
                iomObj.setLine(sourceLineNr);
            }
            if (ioxEvent.getGeomC1() != null && ioxEvent.getGeomC2() != null) {
                Iom_jObject iomCoord = new Iom_jObject("COORD", null);
                iomCoord.setattrvalue("C1", ioxEvent.getGeomC1().toString());
                iomCoord.setattrvalue("C2", ioxEvent.getGeomC2().toString());
                iomObj.addattrobj("Geometry", iomCoord);
            }
        }
        if (event.getException() != null) {
            StringBuffer details = new StringBuffer();
            XtfErrorsLogger.logThrowable(details, "", event.getException(), true);
            iomObj.setTechDetails(details.toString());
        } else if (event.getOrigin() != null) {
            iomObj.setTechDetails(AbstractStdListener.fmtOriginMsg((StackTraceElement)event.getOrigin(), (String)""));
        }
        try {
            this.out.write((IoxEvent)new ObjectEvent(iomObj));
        }
        catch (IoxException e) {
            throw new IllegalStateException(e);
        }
    }

    public void close() {
        if (this.out != null) {
            try {
                this.out.write((IoxEvent)new EndBasketEvent());
                this.out.write((IoxEvent)new EndTransferEvent());
                this.out.flush();
                this.out.close();
            }
            catch (IoxException e) {
                throw new IllegalStateException(e);
            }
            this.out = null;
        }
    }

    private static void logThrowable(StringBuffer out, String ind, Throwable ex, boolean doStacktrace) {
        SQLException exTarget;
        Throwable exTarget2;
        Throwable ex2;
        String msg = ex.getLocalizedMessage();
        if (msg != null && (msg = msg.trim()).length() == 0) {
            msg = null;
        }
        if (msg == null) {
            msg = ex.getClass().getName();
        }
        out.append(ind + msg + "\n");
        if (doStacktrace) {
            StackTraceElement[] stackv = ex.getStackTrace();
            for (int i = 0; i < stackv.length; ++i) {
                out.append(ind + "    " + stackv[i].toString() + "\n");
            }
        }
        if ((ex2 = ex.getCause()) != null) {
            XtfErrorsLogger.logThrowable(out, ind + "  ", ex2, doStacktrace);
        }
        if (ex instanceof SQLException && (exTarget2 = (exTarget = (SQLException)ex).getNextException()) != null) {
            XtfErrorsLogger.logThrowable(out, ind + "  ", exTarget2, doStacktrace);
        }
        if (ex instanceof InvocationTargetException && (exTarget2 = (exTarget = (InvocationTargetException)ex).getTargetException()) != null) {
            XtfErrorsLogger.logThrowable(out, ind + "  ", exTarget2, doStacktrace);
        }
    }
}

