/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j;

import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iox.IoxException;
import java.util.ArrayList;
import java.util.Collections;

public class IoxInvalidDataException
extends IoxException {
    private IomObject geom = null;
    private String tid = null;
    private String iliqname = null;
    private String rawMessage = null;

    public IoxInvalidDataException() {
    }

    public IoxInvalidDataException(String message) {
        super(message);
        this.rawMessage = message;
    }

    public IoxInvalidDataException(Throwable cause) {
        super(cause);
    }

    public IoxInvalidDataException(int lineNumber, String message) {
        super(lineNumber, message);
        this.rawMessage = message;
    }

    public IoxInvalidDataException(int lineNumber, Throwable cause) {
        super(lineNumber, cause);
    }

    public IoxInvalidDataException(String message, Throwable cause) {
        super(message, cause);
        this.rawMessage = message;
    }

    public IoxInvalidDataException(int lineNumber, String message, Throwable cause) {
        super(lineNumber, message, cause);
        this.rawMessage = message;
    }

    public IoxInvalidDataException(String message, String iliqname1, String tid1, IomObject geom1) {
        super(message);
        this.rawMessage = message;
        this.tid = tid1;
        this.geom = geom1;
        this.iliqname = iliqname1;
    }

    public IoxInvalidDataException(String message, String iliqname1, IomObject geom1) {
        super(message);
        this.rawMessage = message;
        this.geom = geom1;
        this.iliqname = iliqname1;
    }

    public String getMessage() {
        StringBuilder ret = new StringBuilder();
        if (this.iliqname != null) {
            ret.append(this.iliqname);
            ret.append(": ");
        }
        ret.append(super.getMessage());
        if (this.geom != null) {
            // empty if block
        }
        return ret.toString();
    }

    public static String formatTids(String[] tids) {
        StringBuilder ret = new StringBuilder();
        if (tids != null) {
            ArrayList<String> tidv = new ArrayList<String>();
            for (String tid : tids) {
                if (tid == null || tid.length() <= 0) continue;
                tidv.add(tid);
            }
            if (tidv.size() > 0) {
                if (tidv.size() > 1) {
                    ret.append("tids ");
                } else {
                    ret.append("tid ");
                }
                Collections.sort(tidv);
                String sep = "";
                for (String tid : tidv) {
                    ret.append(sep);
                    ret.append(tid);
                    sep = ", ";
                }
            }
        }
        return ret.toString();
    }

    public static String formatTids(CompoundCurve curve) {
        String[] tids = curve.getSegmentTids();
        if (tids == null || tids.length == 0) {
            StringBuilder ret = new StringBuilder();
            Object tid = curve.getUserData();
            if (tid != null) {
                ret.append("tid ");
                ret.append(tid);
            }
            return ret.toString();
        }
        return IoxInvalidDataException.formatTids(tids);
    }

    public IomObject getGeom() {
        return this.geom;
    }

    public String getTid() {
        return this.tid;
    }

    public String getIliqname() {
        return this.iliqname;
    }

    public String getRawMessage() {
        if (this.rawMessage != null) {
            return this.rawMessage;
        }
        return super.getMessage();
    }
}

